/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

public final class Bmp {
    private static final boolean debugDoubleCheck = true;

    public static final int[] allocateBitmap(int count) {
        return new int[count + 31 >> 5];
    }

    public static final int[] allocateSetAllBits(int count) {
        int i = count + 31 >> 5;
        int[] bitmap = new int[i];
        int fractionalBitCount = count & 0x1F;
        if (fractionalBitCount != 0) {
            bitmap[--i] = Integer.MIN_VALUE >> fractionalBitCount - 1 >>> 32 - fractionalBitCount;
        }
        while (--i >= 0) {
            bitmap[i] = -1;
        }
        return bitmap;
    }

    public static final int[] growBitmap(int[] bitmap, int count) {
        if (count < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (bitmap == null) {
            return count == 0 ? null : Bmp.allocateBitmap(count);
        }
        int minLength = count + 31 >> 5;
        if (bitmap.length >= minLength) {
            return bitmap;
        }
        int[] newBitmap = new int[minLength];
        int i = bitmap.length;
        while (--i >= 0) {
            newBitmap[i] = bitmap[i];
        }
        return newBitmap;
    }

    public static final void setBit(int[] bitmap, int i) {
        int index;
        int n = index = i >> 5;
        bitmap[n] = bitmap[n] | 1 << (i & 0x1F);
    }

    public static final int[] setBitGrow(int[] bitmap, int i) {
        if ((bitmap = Bmp.growBitmap(bitmap, i + 1)) != null) {
            int n = i >> 5;
            bitmap[n] = bitmap[n] | 1 << (i & 0x1F);
        }
        return bitmap;
    }

    public static final void clearBit(int[] bitmap, int i) {
        int index = i >> 5;
        if (index < bitmap.length) {
            int n = i >> 5;
            bitmap[n] = bitmap[n] & ~(1 << (i & 0x1F));
        }
    }

    public static final boolean getBit(int[] bitmap, int i) {
        int index = i >> 5;
        if (index >= bitmap.length) {
            return false;
        }
        return (bitmap[index] & 1 << (i & 0x1F)) != 0;
    }

    public static final void setAllBits(int[] bitmap, int count) {
        int fractionalBitCount;
        int i = count + 31 >> 5;
        if (bitmap.length != i) {
            if (bitmap.length < i) {
                throw new IndexOutOfBoundsException();
            }
            int j = bitmap.length;
            while (--j >= i) {
                bitmap[j] = 0;
            }
        }
        if ((fractionalBitCount = count & 0x1F) != 0) {
            bitmap[--i] = Integer.MIN_VALUE >> fractionalBitCount - 1 >>> 32 - fractionalBitCount;
        }
        while (--i >= 0) {
            bitmap[i] = -1;
        }
    }

    public static final void orInto(int[] bmDestination, int[] bmSource) {
        int minLength;
        int i = minLength = bmDestination.length < bmSource.length ? bmDestination.length : bmSource.length;
        while (--i >= 0) {
            int n = i;
            bmDestination[n] = bmDestination[n] | bmSource[i];
        }
    }

    public static final int[] allocMinimalCopy(int[] bitmap) {
        int indexLast = bitmap.length;
        while (--indexLast >= 0 && bitmap[indexLast] == 0) {
        }
        int[] map = null;
        if (indexLast >= 0) {
            int count = indexLast + 1;
            map = new int[count];
            int j = count;
            while (--j >= 0) {
                map[j] = bitmap[j];
            }
        }
        return map;
    }

    public static final int countBits(int map) {
        map -= (map & 0xAAAAAAAA) >>> 1;
        map = (map & 0x33333333) + (map >>> 2 & 0x33333333);
        map = map + (map >>> 4) & 0xF0F0F0F;
        map += map >>> 8;
        map += map >>> 16;
        return map & 0xFF;
    }

    public static final int countBits(int[] bitmap) {
        int count = 0;
        int i = bitmap.length;
        while (--i >= 0) {
            int bits = bitmap[i];
            if (bits == 0) continue;
            count += Bmp.countBits(bits);
        }
        return count;
    }

    public static final void clearBitmap(int[] bitmap) {
        int i = bitmap.length;
        while (--i >= 0) {
            bitmap[i] = 0;
        }
    }

    public static final int getMaxMappedBit(int[] bitmap) {
        if (bitmap == null) {
            return 0;
        }
        int answer1 = 0;
        answer1 = bitmap.length * 32;
        while (--answer1 >= 0 && !Bmp.getBit(bitmap, answer1)) {
        }
        ++answer1;
        int maxMapped = bitmap.length << 5;
        int map = 0;
        int i = bitmap.length;
        while (--i >= 0 && (map = bitmap[i]) == 0) {
            maxMapped -= 32;
        }
        if (i >= 0) {
            if ((map & 0xFFFF0000) == 0) {
                map <<= 16;
                maxMapped -= 16;
            }
            if ((map & 0xFF000000) == 0) {
                map <<= 8;
                maxMapped -= 8;
            }
            if ((map & 0xF0000000) == 0) {
                map <<= 4;
                maxMapped -= 4;
            }
            if ((map & 0xC0000000) == 0) {
                map <<= 2;
                maxMapped -= 2;
            }
            if (map >= 0) {
                --maxMapped;
            }
        }
        if (answer1 != maxMapped) {
            System.out.println("answer1=" + answer1 + " maxMapped=" + maxMapped);
            System.out.println("bitmap.length=" + bitmap.length);
            for (int j = 0; j < bitmap.length; ++j) {
                System.out.println("bitmap[" + j + "]=" + Integer.toBinaryString(bitmap[j]));
            }
            throw new NullPointerException();
        }
        return maxMapped;
    }

    public static final int getMinMappedBit(int[] bitmap) {
        int i;
        int answer1;
        if (bitmap == null) {
            return -1;
        }
        int mapLength = bitmap.length;
        int maxMapped = mapLength << 5;
        for (answer1 = 0; answer1 < maxMapped && !Bmp.getBit(bitmap, answer1); ++answer1) {
        }
        if (answer1 == maxMapped) {
            answer1 = -1;
        }
        int map = 0;
        int minMapped = 0;
        for (i = 0; i < mapLength && (map = bitmap[i]) == 0; ++i) {
            minMapped += 32;
        }
        if (i == mapLength) {
            minMapped = -1;
        } else {
            if ((map & 0xFFFF) == 0) {
                map >>= 16;
                minMapped += 16;
            }
            if ((map & 0xFF) == 0) {
                map >>= 8;
                minMapped += 8;
            }
            if ((map & 0xF) == 0) {
                map >>= 4;
                minMapped += 4;
            }
            if ((map & 3) == 0) {
                map >>= 2;
                minMapped += 2;
            }
            if ((map & 1) == 0) {
                ++minMapped;
            }
        }
        if (answer1 != minMapped) {
            System.out.println("answer1=" + answer1 + " minMapped=" + minMapped);
            System.out.println("bitmap.length=" + bitmap.length);
            for (int j = 0; j < bitmap.length; ++j) {
                System.out.println("bitmap[" + j + "]=" + Integer.toBinaryString(bitmap[j]));
            }
            throw new NullPointerException();
        }
        return minMapped;
    }

    public static final int nextSetBit(int[] bitmap, int iStart) {
        if (bitmap == null) {
            return -1;
        }
        int mapLength = bitmap.length;
        if (iStart >= mapLength << 5) {
            return -1;
        }
        int bitmapIndex = iStart >> 5;
        int bitIndexWithinWord = iStart & 0x1F;
        int map = bitmap[bitmapIndex] & Integer.MIN_VALUE >> 31 - bitIndexWithinWord;
        if ((map & 1 << bitIndexWithinWord) != 0) {
            return iStart;
        }
        while (map == 0) {
            if (++bitmapIndex == mapLength) {
                return -1;
            }
            map = bitmap[bitmapIndex];
        }
        bitIndexWithinWord = 0;
        if ((map & 0xFFFF) == 0) {
            bitIndexWithinWord += 16;
            map >>= 16;
        }
        if ((map & 0xFF) == 0) {
            bitIndexWithinWord += 8;
            map >>= 8;
        }
        if ((map & 0xF) == 0) {
            bitIndexWithinWord += 4;
            map >>= 4;
        }
        if ((map & 3) == 0) {
            bitIndexWithinWord += 2;
            map >>= 2;
        }
        if ((map & 1) == 0) {
            ++bitIndexWithinWord;
        }
        return (bitmapIndex << 5) + bitIndexWithinWord;
    }

    public static final boolean and(int[] target, int[] other) {
        int bits = 0;
        if (target != null && other != null) {
            int len;
            int i = len = target.length <= other.length ? target.length : other.length;
            while (--i >= 0) {
                int n = i;
                int n2 = target[n] & other[i];
                target[n] = n2;
                bits |= n2;
            }
        }
        return bits != 0;
    }

    public static final boolean and(int[] target, int[] bmpA, int[] bmpB) {
        int len = Math.min(bmpA == null ? 0 : bmpA.length, bmpB == null ? 0 : bmpB.length);
        int i = target.length;
        while (--i >= len) {
            target[i] = 0;
        }
        int bits = 0;
        int i2 = len;
        while (--i2 >= 0) {
            target[i2] = bmpA[i2] & bmpB[i2];
            bits |= target[i2];
        }
        return bits != 0;
    }
}

