/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import java.util.BitSet;
import javax.vecmath.Matrix3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Geodesic3D2;
import org.jmol.g3d.Graphics3D;
import org.jmol.g3d.Shade3D;
import org.jmol.util.Bmp;

class Normix3D2 {
    static final int NORMIX_GEODESIC_LEVEL = 2;
    final Graphics3D g3d;
    final Vector3f[] transformedVertexVectors;
    final Vector3f[] transformedFaceVectors;
    final byte[] intensities;
    final byte[] intensities2Sided;
    final int vertexCount;
    final int faceCount;
    final int normixCount;
    static final int[] vertexCounts = new int[]{6, 18, 66, 258};
    static final short[][] faceNormixesArrays = new short[3][];
    private static final boolean TIMINGS = false;
    private static final boolean DEBUG_WITH_SEQUENTIAL_SEARCH = true;
    private final Matrix3f rotationMatrix = new Matrix3f();
    final BitSet bsNull = new BitSet();
    final BitSet bsConsidered = new BitSet();
    short[] inverseNormixes;
    private static final boolean DEBUG_FACE_VECTORS = false;

    Normix3D2(Graphics3D g3d) {
        this.g3d = g3d;
        this.vertexCount = Geodesic3D2.getVertexCount(2);
        this.normixCount = this.faceCount = Geodesic3D2.getFaceCount(2);
        this.intensities = new byte[this.faceCount];
        this.intensities2Sided = new byte[this.faceCount];
        this.transformedFaceVectors = new Vector3f[this.faceCount];
        int i = this.faceCount;
        while (--i >= 0) {
            this.transformedFaceVectors[i] = new Vector3f();
        }
        this.transformedVertexVectors = new Vector3f[this.vertexCount];
        i = this.vertexCount;
        while (--i >= 0) {
            this.transformedVertexVectors[i] = new Vector3f();
        }
    }

    short getNormix(Vector3f v) {
        return this.getNormix(v.x, v.y, v.z, 2);
    }

    short getNormix(double x, double y, double z, int geodesicLevel) {
        double t;
        short champion;
        if (z >= 0.0) {
            champion = 1;
            t = z - 1.0;
        } else {
            champion = 3;
            t = z - -1.0;
        }
        this.bsConsidered.and(this.bsNull);
        this.bsConsidered.set(champion);
        double championDist2 = x * x + y * y + t * t;
        for (int lvl = 0; lvl <= geodesicLevel; ++lvl) {
            short[] neighborVertexes = Geodesic3D2.neighborVertexesArrays[lvl];
            int offsetNeighbors = 6 * champion;
            int i = offsetNeighbors + (champion < 12 ? 5 : 6);
            while (--i >= offsetNeighbors) {
                short challenger = neighborVertexes[i];
                if (this.bsConsidered.get(challenger)) continue;
                this.bsConsidered.set(challenger);
                Vector3f v = Geodesic3D2.vertexVectors[challenger];
                double d = (double)v.x - x;
                double d2 = d * d;
                if (d2 >= championDist2 || (d2 += (d = (double)v.y - y) * d) >= championDist2 || (d2 += (d = (double)v.z - z) * d) >= championDist2) continue;
                champion = challenger;
                championDist2 = d2;
            }
        }
        int champSeq = 0;
        double champSeqD2 = Normix3D2.dist2(Geodesic3D2.vertexVectors[champSeq], x, y, z);
        int k = vertexCounts[geodesicLevel];
        while (--k > 0) {
            double challengerD2 = Normix3D2.dist2(Geodesic3D2.vertexVectors[k], x, y, z);
            if (!(challengerD2 < champSeqD2)) continue;
            champSeq = k;
            champSeqD2 = challengerD2;
        }
        if (champion != champSeq && champSeqD2 + 0.01 < championDist2) {
            System.out.println("?que? getNormix is messed up?");
            boolean considered = this.bsConsidered.get(champSeq);
            System.out.println("Was the sequential winner considered? " + considered);
            System.out.println("champion " + champion + " @ " + championDist2 + " sequential champ " + champSeq + " @ " + champSeqD2 + "\n");
            return (short)champSeq;
        }
        return champion;
    }

    void calculateInverseNormixes() {
        this.inverseNormixes = new short[this.normixCount];
        int n = this.normixCount;
        while (--n >= 0) {
            Vector3f v = Geodesic3D2.vertexVectors[n];
            this.inverseNormixes[n] = this.getNormix(-v.x, -v.y, -v.z, 2);
        }
        n = this.normixCount;
        while (--n >= 0) {
            if (this.inverseNormixes[this.inverseNormixes[n]] == n) continue;
            throw new NullPointerException();
        }
    }

    byte getIntensity(short normix) {
        if (normix < 0) {
            return this.intensities2Sided[~normix];
        }
        return this.intensities[normix];
    }

    void setRotationMatrix(Matrix3f rotationMatrix) {
        this.rotationMatrix.set(rotationMatrix);
        for (int i = 0; i < this.vertexCount; ++i) {
            Vector3f tv = this.transformedVertexVectors[i];
            rotationMatrix.transform((Tuple3f)Geodesic3D2.vertexVectors[i], (Tuple3f)tv);
        }
        Vector3f[] faceVectors = Geodesic3D2.getFaceVectors(2);
        for (int i = 0; i < this.faceCount; ++i) {
            byte intensity;
            Vector3f tv = this.transformedFaceVectors[i];
            rotationMatrix.transform((Tuple3f)faceVectors[i], (Tuple3f)tv);
            float x = tv.x;
            float y = -tv.y;
            float z = tv.z;
            this.intensities[i] = intensity = Shade3D.calcIntensityNormalized(x, y, z);
            this.intensities2Sided[i] = z >= 0.0f ? intensity : Shade3D.calcIntensityNormalized(-x, -y, -z);
        }
    }

    Vector3f[] getTransformedFaceVectors() {
        return this.transformedFaceVectors;
    }

    Vector3f[] getTransformedVertexVectors() {
        return this.transformedVertexVectors;
    }

    short[] getFaceNormixes(int level) {
        short[] faceNormixes = faceNormixesArrays[level];
        if (faceNormixes != null) {
            return faceNormixes;
        }
        return this.calcFaceNormixes(level);
    }

    static double dist2(Vector3f v1, Vector3f v2) {
        double dx = v1.x - v2.x;
        double dy = v1.y - v2.y;
        double dz = v1.z - v2.z;
        return dx * dx + dy * dy + dz * dz;
    }

    static double dist2(Vector3f v1, double x, double y, double z) {
        double dx = (double)v1.x - x;
        double dy = (double)v1.y - y;
        double dz = (double)v1.z - z;
        return dx * dx + dy * dy + dz * dz;
    }

    private synchronized short[] calcFaceNormixes(int level) {
        System.out.println("calcFaceNormixes(" + level + ")");
        short[] faceNormixes = faceNormixesArrays[level];
        if (faceNormixes != null) {
            return faceNormixes;
        }
        Vector3f t = new Vector3f();
        short[] faceVertexes = Geodesic3D2.faceVertexesArrays[level];
        int j = faceVertexes.length;
        int faceCount = j / 3;
        faceNormixes = new short[faceCount];
        int i = faceCount;
        while (--i >= 0) {
            short normix;
            Vector3f vA = Geodesic3D2.vertexVectors[faceVertexes[--j]];
            Vector3f vB = Geodesic3D2.vertexVectors[faceVertexes[--j]];
            Vector3f vC = Geodesic3D2.vertexVectors[faceVertexes[--j]];
            t.add((Tuple3f)vA, (Tuple3f)vB);
            t.add((Tuple3f)vC);
            faceNormixes[i] = normix = this.getNormix(t);
        }
        Normix3D2.faceNormixesArrays[level] = faceNormixes;
        return faceNormixes;
    }

    boolean isDirectedTowardsCamera(short normix) {
        return normix < 0 || this.transformedFaceVectors[normix].z > 0.0f;
    }

    short getVisibleNormix(double x, double y, double z, int[] visibilityBitmap, int level) {
        int maxVisible;
        int minMapped = Bmp.getMinMappedBit((int[])visibilityBitmap);
        if (minMapped < 0) {
            return -1;
        }
        int maxMapped = Bmp.getMaxMappedBit((int[])visibilityBitmap);
        int max = maxMapped < (maxVisible = Geodesic3D2.vertexCounts[level]) ? maxMapped : maxVisible;
        int champion = minMapped;
        Vector3f v = Geodesic3D2.vertexVectors[champion];
        double d = x - (double)v.x;
        double championDist2 = d * d;
        d = y - (double)v.y;
        championDist2 += d * d;
        d = z - (double)v.z;
        championDist2 += d * d;
        for (int challenger = minMapped + 1; challenger < max; ++challenger) {
            double challengerDist2;
            if (!Bmp.getBit((int[])visibilityBitmap, (int)challenger) || !((challengerDist2 = Normix3D2.dist2(Geodesic3D2.vertexVectors[challenger], x, y, z)) < championDist2)) continue;
            champion = challenger;
            championDist2 = challengerDist2;
        }
        if (!Bmp.getBit((int[])visibilityBitmap, (int)champion)) {
            throw new IndexOutOfBoundsException();
        }
        return (short)champion;
    }
}

