/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.util.Int2IntHash;

class Geodesic3D2 {
    Graphics3D g3d;
    private static final boolean DUMP = true;
    static final float halfRoot5 = (float)(0.5 * Math.sqrt(5.0));
    static final float oneFifth = 1.2566371f;
    static final float oneTenth = 0.62831855f;
    static final short[] faceVertexesOctant = new short[]{0, 1, 4, 0, 5, 1, 0, 3, 5, 0, 4, 3, 2, 1, 5, 2, 5, 3, 2, 3, 4, 2, 4, 1};
    static final short[] neighborVertexesOctant = new short[]{1, 4, 3, 5, -1, -1, 0, 5, 2, 4, -1, -1, 1, 5, 3, 4, -1, -1, 0, 4, 2, 5, -1, -1, 0, 1, 2, 3, -1, -1, 0, 3, 2, 1, -1, -1};
    static final int maxLevel = 3;
    static short[] vertexCounts;
    static short[][] neighborVertexesArrays;
    static short[][] faceVertexesArrays;
    static Vector3f[][] faceVectorsArrays;
    static Vector3f[] vertexVectors;
    private static short vertexNext;
    private static Int2IntHash htVertex;
    private static final boolean VALIDATE = true;

    Geodesic3D2(Graphics3D g3d) {
        this.g3d = g3d;
        if (vertexCounts == null) {
            this.initialize();
        }
        System.out.println("vertexVectors.length=" + vertexVectors.length);
        for (int i = 0; i < vertexVectors.length; ++i) {
            System.out.println("" + i + " : " + vertexVectors[i]);
        }
    }

    private synchronized void initialize() {
        int i;
        if (vertexCounts != null) {
            return;
        }
        vertexCounts = new short[3];
        neighborVertexesArrays = new short[3][];
        faceVertexesArrays = new short[3][];
        faceVectorsArrays = new Vector3f[3][];
        Geodesic3D2.faceVertexesArrays[0] = faceVertexesOctant;
        Geodesic3D2.neighborVertexesArrays[0] = neighborVertexesOctant;
        Geodesic3D2.vertexCounts[0] = 6;
        for (i = 0; i < 2; ++i) {
            Geodesic3D2.quadruple(i);
        }
        for (i = 0; i < 3; ++i) {
            System.out.println("geodesic level " + i + " vertexCount= " + Geodesic3D2.getVertexCount(i) + " faceCount=" + Geodesic3D2.getFaceCount(i) + " edgeCount=" + Geodesic3D2.getEdgeCount(i));
        }
        for (i = 0; i < 3; ++i) {
            Geodesic3D2.faceVectorsArrays[i] = Geodesic3D2.buildFaceVectors(faceVertexesArrays[i], vertexVectors);
        }
    }

    static int getVertexCount(int level) {
        return vertexCounts[level];
    }

    static Vector3f[] getVertexVectors() {
        return vertexVectors;
    }

    static int getFaceCount(int level) {
        return faceVertexesArrays[level].length / 3;
    }

    static int getEdgeCount(int level) {
        return Geodesic3D2.getVertexCount(level) + Geodesic3D2.getFaceCount(level) - 2;
    }

    static short[] getNeighborVertexes(int level) {
        return neighborVertexesArrays[level];
    }

    static short[] getFaceVertexes(int level) {
        return faceVertexesArrays[level];
    }

    static Vector3f[] getFaceVectors(int level) {
        return faceVectorsArrays[level];
    }

    private static void quadruple(int level) {
        int i;
        System.out.println("quadruple(" + level + ")");
        htVertex = new Int2IntHash();
        int oldVertexCount = vertexVectors.length;
        short[] oldFaceVertexes = faceVertexesArrays[level];
        int oldFaceVertexesLength = oldFaceVertexes.length;
        int oldFaceCount = oldFaceVertexesLength / 3;
        int oldEdgesCount = oldVertexCount + oldFaceCount - 2;
        int newVertexCount = oldVertexCount + oldEdgesCount;
        int newFaceCount = 4 * oldFaceCount;
        Vector3f[] newVertexVectors = new Vector3f[newVertexCount];
        System.arraycopy(vertexVectors, 0, newVertexVectors, 0, oldVertexCount);
        vertexVectors = newVertexVectors;
        short[] newFacesVertexes = new short[3 * newFaceCount];
        Geodesic3D2.faceVertexesArrays[level + 1] = newFacesVertexes;
        short[] neighborVertexes = new short[6 * newVertexCount];
        Geodesic3D2.neighborVertexesArrays[level + 1] = neighborVertexes;
        int i2 = neighborVertexes.length;
        while (--i2 >= 0) {
            neighborVertexes[i2] = -1;
        }
        Geodesic3D2.vertexCounts[level + 1] = (short)newVertexCount;
        System.out.println("oldVertexCount=" + oldVertexCount + " newVertexCount=" + newVertexCount + " oldFaceCount=" + oldFaceCount + " newFaceCount=" + newFaceCount);
        vertexNext = (short)oldVertexCount;
        int iFaceNew = 0;
        int i3 = 0;
        while (i3 < oldFaceVertexesLength) {
            short iA = oldFaceVertexes[i3++];
            short iB = oldFaceVertexes[i3++];
            short iC = oldFaceVertexes[i3++];
            short iAB = Geodesic3D2.getVertex(iA, iB);
            short iBC = Geodesic3D2.getVertex(iB, iC);
            short iCA = Geodesic3D2.getVertex(iC, iA);
            newFacesVertexes[iFaceNew++] = iA;
            newFacesVertexes[iFaceNew++] = iAB;
            newFacesVertexes[iFaceNew++] = iCA;
            newFacesVertexes[iFaceNew++] = iB;
            newFacesVertexes[iFaceNew++] = iBC;
            newFacesVertexes[iFaceNew++] = iAB;
            newFacesVertexes[iFaceNew++] = iC;
            newFacesVertexes[iFaceNew++] = iCA;
            newFacesVertexes[iFaceNew++] = iBC;
            newFacesVertexes[iFaceNew++] = iCA;
            newFacesVertexes[iFaceNew++] = iAB;
            newFacesVertexes[iFaceNew++] = iBC;
            Geodesic3D2.addNeighboringVertexes(neighborVertexes, iAB, iA);
            Geodesic3D2.addNeighboringVertexes(neighborVertexes, iAB, iCA);
            Geodesic3D2.addNeighboringVertexes(neighborVertexes, iAB, iBC);
            Geodesic3D2.addNeighboringVertexes(neighborVertexes, iAB, iB);
            Geodesic3D2.addNeighboringVertexes(neighborVertexes, iBC, iB);
            Geodesic3D2.addNeighboringVertexes(neighborVertexes, iBC, iCA);
            Geodesic3D2.addNeighboringVertexes(neighborVertexes, iBC, iC);
            Geodesic3D2.addNeighboringVertexes(neighborVertexes, iCA, iC);
            Geodesic3D2.addNeighboringVertexes(neighborVertexes, iCA, iA);
        }
        int vertexCount = vertexVectors.length;
        if (iFaceNew != newFacesVertexes.length) {
            throw new NullPointerException();
        }
        if (vertexNext != newVertexCount) {
            throw new NullPointerException();
        }
        for (i = 0; i < 6; ++i) {
            for (int j = 0; j < 4; ++j) {
                short neighbor = neighborVertexes[i * 6 + j];
                if (neighbor < 0) {
                    throw new NullPointerException();
                }
                if (neighbor < vertexCount) continue;
                throw new NullPointerException();
            }
            if (neighborVertexes[i * 6 + 4] != -1) {
                throw new NullPointerException();
            }
            if (neighborVertexes[i * 6 + 5] == -1) continue;
            throw new NullPointerException();
        }
        for (i = 36; i < neighborVertexes.length; ++i) {
            short neighbor = neighborVertexes[i];
            if (neighbor < 0) {
                throw new NullPointerException();
            }
            if (neighbor < vertexCount) continue;
            throw new NullPointerException();
        }
        for (i = 0; i < newVertexCount; ++i) {
            int neighborCount = 0;
            int j = neighborVertexes.length;
            while (--j >= 0) {
                if (neighborVertexes[j] != i) continue;
                ++neighborCount;
            }
            if (i < 6 ? neighborCount != 4 : neighborCount != 6) {
                throw new NullPointerException();
            }
            int faceCount = 0;
            int j2 = newFacesVertexes.length;
            while (--j2 >= 0) {
                if (newFacesVertexes[j2] != i) continue;
                ++faceCount;
            }
            if (!(i < 6 ? faceCount != 4 : faceCount != 6)) continue;
            throw new NullPointerException();
        }
        htVertex = null;
    }

    private static void addNeighboringVertexes(short[] neighborVertexes, short v1, short v2) {
        int i;
        int iMax = i + 6;
        for (i = v1 * 6; i < iMax; ++i) {
            int j;
            if (neighborVertexes[i] == v2) {
                return;
            }
            if (neighborVertexes[i] >= 0) continue;
            neighborVertexes[i] = v2;
            int jMax = j + 6;
            for (j = v2 * 6; j < jMax; ++j) {
                if (neighborVertexes[j] == v1) {
                    return;
                }
                if (neighborVertexes[j] >= 0) continue;
                neighborVertexes[j] = v1;
                return;
            }
        }
        throw new NullPointerException();
    }

    private static short getVertex(short v1, short v2) {
        int hashKey;
        int vertex;
        if (v1 > v2) {
            short t = v1;
            v1 = v2;
            v2 = t;
        }
        if ((vertex = htVertex.get(hashKey = (v1 << 16) + v2)) != Integer.MIN_VALUE) {
            return (short)vertex;
        }
        Vector3f newVertexVector = Geodesic3D2.vertexVectors[Geodesic3D2.vertexNext] = new Vector3f();
        newVertexVector.add((Tuple3f)vertexVectors[v1], (Tuple3f)vertexVectors[v2]);
        newVertexVector.normalize();
        htVertex.put(hashKey, (int)vertexNext);
        short s = vertexNext;
        vertexNext = (short)(s + 1);
        return s;
    }

    static boolean isNeighborVertex(short vertex1, short vertex2, int level) {
        short[] neighborVertexes = neighborVertexesArrays[level];
        int offset1 = vertex1 * 6;
        int i = offset1 + (vertex1 < 6 ? 4 : 6);
        while (--i >= offset1) {
            if (neighborVertexes[i] != vertex2) continue;
            return true;
        }
        return false;
    }

    private static Vector3f[] buildFaceVectors(short[] faceVertexes, Vector3f[] vertexVectors) {
        int faceCount = faceVertexes.length / 3;
        Vector3f[] faceVectors = new Vector3f[faceCount];
        int i = 0;
        int j = 0;
        while (i < faceCount) {
            Vector3f v = faceVectors[i] = new Vector3f();
            v.add((Tuple3f)vertexVectors[faceVertexes[j]], (Tuple3f)vertexVectors[faceVertexes[j + 1]]);
            v.add((Tuple3f)vertexVectors[faceVertexes[j + 2]]);
            v.normalize();
            ++i;
            j += 3;
        }
        return faceVectors;
    }

    static {
        vertexVectors = new Vector3f[]{new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(0.0f, -1.0f, 0.0f), new Vector3f(0.0f, 0.0f, -1.0f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(-1.0f, 0.0f, 0.0f)};
    }
}

