/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.applet;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.net.MalformedURLException;
import java.net.URL;
import netscape.javascript.JSObject;
import org.jmol.adapter.smarter.SmarterJmolAdapter;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolAppletInterface;
import org.jmol.api.JmolStatusListener;
import org.jmol.api.JmolViewer;
import org.jmol.applet.JmolAppletRegistry;
import org.jmol.applet.Jvm12;
import org.jmol.appletwrapper.AppletWrapper;
import org.jmol.appletwrapper.WrappedApplet;
import org.jmol.util.GT;
import org.openscience.jmol.ui.JmolPopup;

public class Jmol
implements WrappedApplet,
JmolAppletInterface {
    JmolViewer viewer;
    boolean jvm12orGreater;
    String emulate;
    Jvm12 jvm12;
    JmolPopup jmolpopup;
    String htmlName;
    JmolAppletRegistry appletRegistry;
    MyStatusListener myStatusListener;
    AppletWrapper appletWrapper;
    JSObject jsoWindow;
    boolean mayScript;
    String animFrameCallback;
    String loadStructCallback;
    String messageCallback;
    String pauseCallback;
    String pickCallback;
    static final boolean REQUIRE_PROGRESSBAR = true;
    boolean hasProgressBar;
    int paintCounter;
    static String appletInfo = GT._((String)"Jmol Applet.  Part of the OpenScience project. See http://www.jmol.org for more information");
    static final String[] progressbarMsgs = new String[]{"Jmol developer alert!", "", "progressbar is REQUIRED ... otherwise users", "will have no indicate that the applet is loading", "", "<applet code='JmolApplet' ... >", "  <param name='progressbar' value='true' />", "  <param name='progresscolor' value='blue' />", "  <param name='boxmessage' value='your-favorite-message' />", "  <param name='boxbgcolor' value='#112233' />", "  <param name='boxfgcolor' value='#778899' />", "   ...", "</applet>"};
    public boolean showPaintTime = false;
    static int timeLast = 0;
    static int timeCount;
    static int timeTotal;
    long timeBegin;
    int lastMotionEventNumber;
    final Object[] buttonCallbackBefore = new Object[]{null, new Boolean(false)};
    final Object[] buttonCallbackAfter = new Object[]{null, new Boolean(true)};
    boolean buttonCallbackNotificationPending;
    String buttonCallback;
    String buttonName;
    JSObject buttonWindow;
    char inlineNewlineChar = (char)124;

    public String getAppletInfo() {
        return appletInfo;
    }

    public void setAppletWrapper(AppletWrapper appletWrapper) {
        this.appletWrapper = appletWrapper;
    }

    public void init() {
        this.htmlName = this.getParameter("name");
        String ms = this.getParameter("mayscript");
        this.mayScript = ms != null && !ms.equalsIgnoreCase("false");
        this.appletRegistry = new JmolAppletRegistry(this.htmlName, this.mayScript, (Applet)this.appletWrapper);
        this.initWindows();
        this.initApplication();
    }

    String getParameter(String paramName) {
        return this.appletWrapper.getParameter(paramName);
    }

    public void initWindows() {
        this.viewer = JmolViewer.allocateViewer((Component)this.appletWrapper, (JmolAdapter)new SmarterJmolAdapter(null));
        this.myStatusListener = new MyStatusListener();
        this.viewer.setJmolStatusListener(this.myStatusListener);
        this.viewer.setAppletContext(this.appletWrapper.getDocumentBase(), this.appletWrapper.getCodeBase(), this.getValue("JmolAppletProxy", null));
        this.jvm12orGreater = this.viewer.isJvm12orGreater();
        if (this.jvm12orGreater) {
            this.jvm12 = new Jvm12((Component)this.appletWrapper, this.viewer);
        }
        if (this.mayScript) {
            try {
                this.jsoWindow = JSObject.getWindow((Applet)this.appletWrapper);
                if (this.jsoWindow == null) {
                    System.out.println("jsoWindow return null ... no JavaScript callbacks :-(");
                }
            }
            catch (Exception e) {
                System.out.println("" + e);
            }
        }
    }

    boolean getBooleanValue(String propertyName, boolean defaultValue) {
        String value = this.getValue(propertyName, defaultValue ? "true" : "");
        return value.equalsIgnoreCase("true") || value.equalsIgnoreCase("on") || value.equalsIgnoreCase("yes");
    }

    String getValue(String propertyName, String defaultValue) {
        String stringValue = this.getParameter(propertyName);
        if (stringValue != null) {
            return stringValue;
        }
        return defaultValue;
    }

    String getValueLowerCase(String paramName, String defaultValue) {
        String value = this.getValue(paramName, defaultValue);
        if (value != null && (value = value.trim().toLowerCase()).length() == 0) {
            value = null;
        }
        return value;
    }

    public void initApplication() {
        this.viewer.pushHoldRepaint();
        this.hasProgressBar = this.getBooleanValue("progressbar", false);
        boolean popupMenu = this.getBooleanValue("popupMenu", true);
        if (popupMenu) {
            this.loadPopupMenuAsBackgroundTask();
        }
        this.emulate = this.getValueLowerCase("emulate", "jmol");
        if (this.emulate.equals("chime")) {
            this.viewer.setRasmolDefaults();
        } else {
            this.viewer.setJmolDefaults();
        }
        String bgcolor = this.getValue("boxbgcolor", "black");
        bgcolor = this.getValue("bgcolor", bgcolor);
        this.viewer.setColorBackground(bgcolor);
        this.loadInline(this.getValue("loadInline", null));
        this.viewer.setFrankOn(true);
        this.animFrameCallback = this.getValue("AnimFrameCallback", null);
        this.loadStructCallback = this.getValue("LoadStructCallback", null);
        this.messageCallback = this.getValue("MessageCallback", null);
        this.pauseCallback = this.getValue("PauseCallback", null);
        this.pickCallback = this.getValue("PickCallback", null);
        if (!(this.mayScript || this.animFrameCallback == null && this.loadStructCallback == null && this.messageCallback == null && this.pauseCallback == null && this.pickCallback == null)) {
            System.out.println("WARNING!! MAYSCRIPT not found");
        }
        String scriptParam = this.getValue("script", "");
        String loadParam = this.getValue("load", null);
        if (loadParam != null) {
            scriptParam = "load " + loadParam + ";" + scriptParam;
        }
        this.script(scriptParam);
        this.viewer.popHoldRepaint();
    }

    void showStatusAndConsole(String message) {
        this.appletWrapper.showStatus(message);
        this.consoleMessage(message);
    }

    void consoleMessage(String message) {
        if (this.jvm12 != null) {
            this.jvm12.consoleMessage(message);
        }
    }

    public void update(Graphics g) {
        if (this.viewer == null) {
            return;
        }
        if (this.showPaintTime) {
            this.startPaintClock();
        }
        Dimension size = this.jvm12orGreater ? this.jvm12.getSize() : this.appletWrapper.size();
        this.viewer.setScreenDimension(size);
        Rectangle rectClip = this.jvm12orGreater ? this.jvm12.getClipBounds(g) : g.getClipRect();
        ++this.paintCounter;
        if (!this.hasProgressBar && this.paintCounter < 30 && (this.paintCounter & 1) == 0) {
            this.printProgressbarMessage(g);
            this.viewer.notifyRepainted();
        } else {
            this.viewer.renderScreenImage(g, size, rectClip);
        }
        if (this.showPaintTime) {
            this.stopPaintClock();
            this.showTimes(10, 10, g);
        }
    }

    void printProgressbarMessage(Graphics g) {
        g.setColor(Color.yellow);
        g.fillRect(0, 0, 10000, 10000);
        g.setColor(Color.black);
        int i = 0;
        int y = 13;
        while (i < progressbarMsgs.length) {
            g.drawString(progressbarMsgs[i], 10, y);
            ++i;
            y += 13;
        }
    }

    public void paint(Graphics g) {
        this.update(g);
    }

    public boolean handleEvent(Event e) {
        if (this.viewer == null) {
            return false;
        }
        return this.viewer.handleOldJvm10Event(e);
    }

    void resetTimes() {
        timeTotal = 0;
        timeCount = 0;
        timeLast = -1;
    }

    void recordTime(int time) {
        if (timeLast != -1) {
            timeTotal += timeLast;
            ++timeCount;
        }
        timeLast = time;
    }

    void startPaintClock() {
        this.timeBegin = System.currentTimeMillis();
        int motionEventNumber = this.viewer.getMotionEventNumber();
        if (this.lastMotionEventNumber != motionEventNumber) {
            this.lastMotionEventNumber = motionEventNumber;
            this.resetTimes();
        }
    }

    void stopPaintClock() {
        int time = (int)(System.currentTimeMillis() - this.timeBegin);
        this.recordTime(time);
    }

    String fmt(int num) {
        if (num < 0) {
            return "---";
        }
        if (num < 10) {
            return "  " + num;
        }
        if (num < 100) {
            return " " + num;
        }
        return "" + num;
    }

    void showTimes(int x, int y, Graphics g) {
        int timeAverage = timeCount == 0 ? -1 : (timeTotal + timeCount / 2) / timeCount;
        g.setColor(Color.green);
        g.drawString(this.fmt(timeLast) + "ms : " + this.fmt(timeAverage) + "ms", x, y);
    }

    public void scriptButton(JSObject buttonWindow, String buttonName, String script, String buttonCallback) {
        System.out.println(this.htmlName + " JmolApplet.scriptButton(" + buttonWindow + "," + buttonName + "," + script + "," + buttonCallback);
        if (buttonWindow != null && buttonCallback != null) {
            System.out.println("!!!! calling back " + buttonCallback);
            this.buttonCallbackBefore[0] = buttonName;
            System.out.println("trying...");
            buttonWindow.call(buttonCallback, this.buttonCallbackBefore);
            System.out.println("made it");
            this.buttonCallbackNotificationPending = true;
            this.buttonCallback = buttonCallback;
            this.buttonWindow = buttonWindow;
            this.buttonName = buttonName;
        } else {
            this.buttonCallbackNotificationPending = false;
        }
        this.script(script);
    }

    public void script(String script) {
        String strError = this.viewer.evalString(script);
        if (strError == null) {
            strError = GT._((String)"Jmol executing script ...");
        }
        this.myStatusListener.setStatusMessage(strError);
    }

    public void loadInline(String strModel) {
        if (strModel != null) {
            if (this.inlineNewlineChar != '\u0000') {
                int i;
                int len = strModel.length();
                for (i = 0; i < len && strModel.charAt(0) == ' '; ++i) {
                }
                if (i < len && strModel.charAt(i) == this.inlineNewlineChar) {
                    strModel = strModel.substring(i + 1);
                }
                strModel = strModel.replace(this.inlineNewlineChar, '\n');
            }
            this.viewer.openStringInline(strModel);
            this.myStatusListener.setStatusMessage(this.viewer.getOpenFileError());
        }
    }

    void loadPopupMenuAsBackgroundTask() {
        if (this.viewer.getOperatingSystemName().equals("Mac OS") && this.viewer.getJavaVersion().equals("1.1.5")) {
            return;
        }
        new Thread(new LoadPopupThread()).start();
    }

    class MyStatusListener
    implements JmolStatusListener {
        MyStatusListener() {
        }

        public void notifyFileLoaded(String fullPathName, String fileName, String modelName, Object clientFile, String errorMsg) {
            if (errorMsg != null) {
                Jmol.this.showStatusAndConsole(GT._((String)"File Error:") + errorMsg);
                return;
            }
            if (fullPathName != null && Jmol.this.loadStructCallback != null && Jmol.this.jsoWindow != null) {
                Jmol.this.jsoWindow.call(Jmol.this.loadStructCallback, Jmol.this.htmlName);
            }
            if (Jmol.this.jmolpopup != null) {
                Jmol.this.jmolpopup.updateComputedMenus();
            }
        }

        public void setStatusMessage(String statusMessage) {
            if (statusMessage == null) {
                return;
            }
            if (Jmol.this.messageCallback != null && Jmol.this.jsoWindow != null) {
                Jmol.this.jsoWindow.call(Jmol.this.messageCallback, Jmol.this.htmlName, statusMessage);
            }
            Jmol.this.showStatusAndConsole(statusMessage);
        }

        public void scriptEcho(String strEcho) {
            this.scriptStatus(strEcho);
        }

        public void scriptStatus(String strStatus) {
            if (strStatus != null && Jmol.this.messageCallback != null && Jmol.this.jsoWindow != null) {
                Jmol.this.jsoWindow.call(Jmol.this.messageCallback, Jmol.this.htmlName, strStatus);
            }
            Jmol.this.consoleMessage(strStatus);
        }

        public void notifyScriptTermination(String errorMessage, int msWalltime) {
            Jmol.this.showStatusAndConsole(GT._((String)"Jmol script completed"));
            if (Jmol.this.buttonCallbackNotificationPending) {
                System.out.println("!!!! calling back " + Jmol.this.buttonCallback);
                Jmol.this.buttonCallbackAfter[0] = Jmol.this.buttonName;
                Jmol.this.buttonWindow.call(Jmol.this.buttonCallback, Jmol.this.buttonCallbackAfter);
            }
        }

        public void handlePopupMenu(int x, int y) {
            if (Jmol.this.jmolpopup != null) {
                Jmol.this.jmolpopup.show(x, y);
            }
        }

        public void measureSelection(int atomIndex) {
        }

        public void notifyMeasurementsChanged() {
        }

        public void notifyFrameChanged(int frameNo) {
            if (Jmol.this.animFrameCallback != null && Jmol.this.jsoWindow != null) {
                Jmol.this.jsoWindow.call(Jmol.this.animFrameCallback, Jmol.this.htmlName, new Integer(frameNo));
            }
        }

        public void notifyAtomPicked(int atomIndex, String strInfo) {
            Jmol.this.showStatusAndConsole(strInfo);
            if (Jmol.this.pickCallback != null && Jmol.this.jsoWindow != null) {
                Jmol.this.jsoWindow.call(Jmol.this.pickCallback, Jmol.this.htmlName, strInfo, new Integer(atomIndex));
            }
        }

        public void showUrl(String urlString) {
            System.out.println("showUrl(" + urlString + ")");
            if (urlString != null && urlString.length() > 0) {
                try {
                    URL url = new URL(urlString);
                    Jmol.this.appletWrapper.getAppletContext().showDocument(url, "_blank");
                }
                catch (MalformedURLException mue) {
                    Jmol.this.showStatusAndConsole("Malformed URL:" + urlString);
                }
            }
        }

        public void showConsole(boolean showConsole) {
            System.out.println("JmolApplet.showConsole(" + showConsole + ")");
            if (Jmol.this.jvm12 != null) {
                Jmol.this.jvm12.showConsole(showConsole);
            }
        }
    }

    class LoadPopupThread
    implements Runnable {
        LoadPopupThread() {
        }

        public void run() {
            JmolPopup popup;
            Thread.currentThread().setPriority(1);
            try {
                popup = JmolPopup.newJmolPopup((JmolViewer)Jmol.this.viewer);
            }
            catch (Exception e) {
                System.out.println("JmolPopup not loaded");
                return;
            }
            if (Jmol.this.viewer.haveFrame()) {
                popup.updateComputedMenus();
            }
            Jmol.this.jmolpopup = popup;
        }
    }
}

