/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.viewer.Atom;
import org.jmol.viewer.AtomIterator;
import org.jmol.viewer.Frame;
import org.jmol.viewer.SasCavity;
import org.jmol.viewer.Sasurface1;
import org.jmol.viewer.Util;

class SasNeighborFinder {
    final Frame frame;
    final Sasurface1 sas1;
    final Graphics3D g3d;
    final Atom[] atoms;
    private static final boolean LOG = false;
    float radiusP;
    float diameterP;
    float maxVanderwaalsRadius;
    int indexI;
    int indexJ;
    int indexK;
    Atom atomI;
    Atom atomJ;
    Atom atomK;
    Point3f centerI;
    Point3f centerJ;
    Point3f centerK;
    float radiusI;
    float radiusJ;
    float radiusK;
    float radiiIP;
    float radiiJP;
    float radiiKP;
    float radiiIP2;
    float radiiJP2;
    float radiiKP2;
    float distanceIJ;
    float distanceIK;
    float distanceJK;
    float distanceIJ2;
    float distanceIK2;
    float distanceJK2;
    int neighborCount;
    Atom[] neighborAtoms = new Atom[16];
    int[] neighborIndexes = new int[16];
    Point3f[] neighborCenters = new Point3f[16];
    float[] neighborPlusProbeRadii = new float[16];
    float[] neighborPlusProbeRadii2 = new float[16];
    int[] sortedNeighborIndexes = new int[16];
    private final Vector3f vectorIJ = new Vector3f();
    private final Vector3f vectorIK = new Vector3f();
    private final Vector3f normalIJK = new Vector3f();
    private final Point3f torusCenterIJ = new Point3f();
    private final Point3f torusCenterIK = new Point3f();
    private final Point3f torusCenterJK = new Point3f();
    private final Point3f probeBaseIJK = new Point3f();
    private final Point3f probeCenter = new Point3f();
    private final Vector3f vectorPI = new Vector3f();
    private final Vector3f vectorPJ = new Vector3f();
    private final Vector3f vectorPK = new Vector3f();
    final Vector3f vectorT = new Vector3f();
    final Vector3f v2v3 = new Vector3f();
    final Vector3f v3v1 = new Vector3f();
    final Vector3f v1v2 = new Vector3f();
    final Vector3f unitRadialVectorT = new Vector3f();
    static final Vector3f vectorZ = new Vector3f(0.0f, 0.0f, 1.0f);
    final Point3f pointT = new Point3f();

    SasNeighborFinder(Frame frame, Sasurface1 sas1, Graphics3D g3d) {
        this.sas1 = sas1;
        this.frame = frame;
        this.g3d = g3d;
        this.atoms = frame.atoms;
        this.maxVanderwaalsRadius = frame.getMaxVanderwaalsRadius();
    }

    void setProbeRadius(float radiusP) {
        if (radiusP <= 0.0f) {
            throw new NullPointerException();
        }
        this.radiusP = radiusP;
        this.diameterP = 2.0f * radiusP;
    }

    void findAbuttingNeighbors(int atomIndex, BitSet bsSelected) {
        this.setAtomI(atomIndex);
        this.getNeighbors(bsSelected);
        this.sortNeighborIndexes();
        this.calcCavitiesI();
    }

    void setAtomI(int indexI) {
        this.indexI = indexI;
        this.atomI = this.atoms[indexI];
        this.centerI = this.atomI.point3f;
        this.radiusI = this.atomI.getVanderwaalsRadiusFloat();
        this.radiiIP = this.radiusI + this.radiusP;
        this.radiiIP2 = this.radiiIP * this.radiiIP;
    }

    void setNeighborJ(int sortedNeighborIndex) {
        this.indexJ = this.neighborIndexes[sortedNeighborIndex];
        this.atomJ = this.neighborAtoms[sortedNeighborIndex];
        this.radiusJ = this.atomJ.getVanderwaalsRadiusFloat();
        this.radiiJP = this.neighborPlusProbeRadii[sortedNeighborIndex];
        this.radiiJP2 = this.neighborPlusProbeRadii2[sortedNeighborIndex];
        this.centerJ = this.neighborCenters[sortedNeighborIndex];
        this.distanceIJ2 = this.centerJ.distanceSquared(this.centerI);
        this.distanceIJ = (float)Math.sqrt(this.distanceIJ2);
    }

    void setNeighborK(int sortedNeighborIndex) {
        this.indexK = this.neighborIndexes[sortedNeighborIndex];
        this.atomK = this.neighborAtoms[sortedNeighborIndex];
        this.radiusK = this.atomK.getVanderwaalsRadiusFloat();
        this.radiiKP = this.neighborPlusProbeRadii[sortedNeighborIndex];
        this.radiiKP2 = this.neighborPlusProbeRadii2[sortedNeighborIndex];
        this.centerK = this.neighborCenters[sortedNeighborIndex];
        this.distanceIK2 = this.centerK.distanceSquared(this.centerI);
        this.distanceIK = (float)Math.sqrt(this.distanceIK2);
        this.distanceJK2 = this.centerK.distanceSquared(this.centerJ);
        this.distanceJK = (float)Math.sqrt(this.distanceJK2);
    }

    void getNeighbors(BitSet bsSelected) {
        this.neighborCount = 0;
        AtomIterator iter = this.frame.getWithinModelIterator(this.atomI, this.radiusI + this.diameterP + this.maxVanderwaalsRadius);
        while (iter.hasNext()) {
            float radii;
            Atom neighbor = iter.next();
            if (neighbor == this.atomI || !bsSelected.get(neighbor.atomIndex)) continue;
            float neighborRadius = neighbor.getVanderwaalsRadiusFloat();
            if (this.centerI.distance(neighbor.point3f) > this.radiusI + this.radiusP + this.radiusP + neighborRadius) continue;
            if (this.neighborCount == this.neighborAtoms.length) {
                this.neighborAtoms = (Atom[])Util.doubleLength(this.neighborAtoms);
                this.neighborIndexes = Util.doubleLength(this.neighborIndexes);
                this.neighborCenters = (Point3f[])Util.doubleLength(this.neighborCenters);
                this.neighborPlusProbeRadii = Util.doubleLength(this.neighborPlusProbeRadii);
                this.neighborPlusProbeRadii2 = Util.doubleLength(this.neighborPlusProbeRadii2);
            }
            this.neighborAtoms[this.neighborCount] = neighbor;
            this.neighborCenters[this.neighborCount] = neighbor.point3f;
            this.neighborIndexes[this.neighborCount] = neighbor.atomIndex;
            this.neighborPlusProbeRadii[this.neighborCount] = radii = neighborRadius + this.radiusP;
            this.neighborPlusProbeRadii2[this.neighborCount] = radii * radii;
            ++this.neighborCount;
        }
    }

    void sortNeighborIndexes() {
        this.sortedNeighborIndexes = Util.ensureLength(this.sortedNeighborIndexes, this.neighborCount);
        int i = this.neighborCount;
        while (--i >= 0) {
            this.sortedNeighborIndexes[i] = i;
        }
        i = this.neighborCount;
        while (--i >= 0) {
            int j = i;
            while (--j >= 0) {
                if (this.neighborIndexes[this.sortedNeighborIndexes[i]] <= this.neighborIndexes[this.sortedNeighborIndexes[j]]) continue;
                int t = this.sortedNeighborIndexes[i];
                this.sortedNeighborIndexes[i] = this.sortedNeighborIndexes[j];
                this.sortedNeighborIndexes[j] = t;
            }
        }
    }

    void calcCavitiesI() {
        if (this.radiusP == 0.0f) {
            return;
        }
        int iJ = this.neighborCount;
        while (--iJ >= 0) {
            int sortedIndexJ = this.sortedNeighborIndexes[iJ];
            if (this.neighborIndexes[sortedIndexJ] <= this.indexI) continue;
            this.setNeighborJ(sortedIndexJ);
            if ((double)this.distanceIJ < 0.2) continue;
            if (this.radiusI + this.distanceIJ < this.radiusJ || this.radiusJ + this.distanceIJ < this.radiusI) {
                System.out.println("embedded atom:" + this.indexI + "<->" + this.indexJ);
                continue;
            }
            this.vectorIJ.sub(this.centerJ, this.centerI);
            this.calcTorusCenter(this.centerI, this.radiiIP2, this.centerJ, this.radiiJP2, this.distanceIJ2, this.torusCenterIJ);
            int iK = this.neighborCount;
            while (--iK >= 0) {
                int sortedIndexK = this.sortedNeighborIndexes[iK];
                if (this.neighborIndexes[sortedIndexK] <= this.indexJ) continue;
                this.setNeighborK(sortedIndexK);
                if ((double)this.distanceIK < 0.1 || (double)this.distanceJK < 0.1 || this.distanceJK >= this.radiiJP + this.radiiKP) continue;
                this.getCavitiesIJK();
            }
            this.checkFullTorusIJ();
        }
        if (this.neighborCount == 0) {
            this.sas1.allocateConvexVertexBitmap(this.indexI);
        }
    }

    void calcTorusCenter(Point3f centerA, float radiiAP2, Point3f centerB, float radiiBP2, float distanceAB2, Point3f torusCenter) {
        torusCenter.sub(centerB, centerA);
        torusCenter.scale((radiiAP2 - radiiBP2) / distanceAB2);
        torusCenter.add(centerA);
        torusCenter.add(centerB);
        torusCenter.scale(0.5f);
    }

    boolean checkProbeNotIJ(Point3f probeCenter) {
        int i = this.neighborCount;
        while (--i >= 0) {
            int neighborIndex = this.neighborIndexes[i];
            if (neighborIndex == this.indexI || neighborIndex == this.indexJ || !(probeCenter.distanceSquared(this.neighborCenters[i]) < this.neighborPlusProbeRadii2[i])) continue;
            return false;
        }
        return true;
    }

    boolean checkProbeAgainstNeighborsIJK(Point3f probeCenter) {
        int i = this.neighborCount;
        while (--i >= 0) {
            int neighborIndex = this.neighborIndexes[i];
            if (neighborIndex == this.indexI || neighborIndex == this.indexJ || neighborIndex == this.indexK || !(probeCenter.distanceSquared(this.neighborCenters[i]) < this.neighborPlusProbeRadii2[i])) continue;
            return false;
        }
        return true;
    }

    boolean intersectPlanes(Vector3f v1, Point3f p1, Vector3f v2, Point3f p2, Vector3f v3, Point3f p3, Point3f intersection) {
        this.v2v3.cross(v2, v3);
        if (Float.isNaN(this.v2v3.x)) {
            return false;
        }
        this.v3v1.cross(v3, v1);
        if (Float.isNaN(this.v3v1.x)) {
            return false;
        }
        this.v1v2.cross(v1, v2);
        if (Float.isNaN(this.v1v2.x)) {
            return false;
        }
        float denominator = v1.dot(this.v2v3);
        if (denominator == 0.0f) {
            return false;
        }
        this.vectorT.set(p1);
        intersection.scale(v1.dot(this.vectorT), this.v2v3);
        this.vectorT.set(p2);
        intersection.scaleAdd(v2.dot(this.vectorT), this.v3v1, intersection);
        this.vectorT.set(p3);
        intersection.scaleAdd(v3.dot(this.vectorT), this.v1v2, intersection);
        intersection.scale(1.0f / denominator);
        return !Float.isNaN(intersection.x);
    }

    float calcProbeHeightIJK(Point3f probeBaseIJK) {
        float hypotenuse2 = this.radiiIP2;
        this.vectorT.sub(probeBaseIJK, this.centerI);
        float baseLength2 = this.vectorT.lengthSquared();
        float height2 = hypotenuse2 - baseLength2;
        if (height2 <= 0.0f) {
            return 0.0f;
        }
        return (float)Math.sqrt(height2);
    }

    void getCavitiesIJK() {
        this.vectorIK.sub(this.centerK, this.centerI);
        this.normalIJK.cross(this.vectorIJ, this.vectorIK);
        if (Float.isNaN(this.normalIJK.x)) {
            return;
        }
        this.normalIJK.normalize();
        this.calcTorusCenter(this.centerI, this.radiiIP2, this.centerK, this.radiiKP2, this.distanceIK2, this.torusCenterIK);
        if (!this.intersectPlanes(this.vectorIJ, this.torusCenterIJ, this.vectorIK, this.torusCenterIK, this.normalIJK, this.centerI, this.probeBaseIJK)) {
            return;
        }
        float probeHeight = this.calcProbeHeightIJK(this.probeBaseIJK);
        if (probeHeight <= 0.0f) {
            return;
        }
        Sasurface1.Torus torusIJ = null;
        Sasurface1.Torus torusIK = null;
        Sasurface1.Torus torusJK = null;
        for (int i = -1; i <= 1; i += 2) {
            boolean rightHanded;
            this.probeCenter.scaleAdd((float)i * probeHeight, this.normalIJK, this.probeBaseIJK);
            if (!this.checkProbeAgainstNeighborsIJK(this.probeCenter)) continue;
            SasCavity cavity = new SasCavity(this.centerI, this.centerJ, this.centerK, this.probeCenter, this.radiusP, this.probeBaseIJK, this.vectorPI, this.vectorPJ, this.vectorPK, this.vectorT, this.g3d);
            this.sas1.addCavity(this.indexI, this.indexJ, this.indexK, cavity);
            boolean bl = rightHanded = i == 1;
            if (torusIJ == null && (torusIJ = this.sas1.getTorus(this.indexI, this.indexJ)) == null) {
                torusIJ = this.sas1.createTorus(this.indexI, this.indexJ, this.torusCenterIJ, this.calcTorusRadius(this.radiusI, this.radiusJ, this.distanceIJ2), false);
            }
            if (torusIJ != null) {
                torusIJ.addCavity(cavity, rightHanded);
            }
            if (torusIK == null && (torusIK = this.sas1.getTorus(this.indexI, this.indexK)) == null) {
                torusIK = this.sas1.createTorus(this.indexI, this.indexK, this.torusCenterIK, this.calcTorusRadius(this.radiusI, this.radiusK, this.distanceIK2), false);
            }
            if (torusIK != null) {
                torusIK.addCavity(cavity, !rightHanded);
            }
            if (torusJK == null && (torusJK = this.sas1.getTorus(this.indexJ, this.indexK)) == null) {
                this.calcTorusCenter(this.centerJ, this.radiiJP2, this.centerK, this.radiiKP2, this.distanceJK2, this.torusCenterJK);
                torusJK = this.sas1.createTorus(this.indexJ, this.indexK, this.torusCenterJK, this.calcTorusRadius(this.radiusJ, this.radiusK, this.distanceJK2), false);
            }
            if (torusJK == null) continue;
            torusJK.addCavity(cavity, rightHanded);
        }
    }

    float calcTorusRadius(float radiusA, float radiusB, float distanceAB2) {
        float t1 = radiusA + radiusB + this.diameterP;
        float t2 = t1 * t1 - distanceAB2;
        float diff = radiusA - radiusB;
        float t3 = distanceAB2 - diff * diff;
        if (t2 <= 0.0f || t3 <= 0.0f || distanceAB2 == 0.0f) {
            System.out.println("calcTorusRadius\n radiusA=" + radiusA + " radiusB=" + radiusB + " distanceAB2=" + distanceAB2);
            System.out.println("distanceAB=" + Math.sqrt(distanceAB2) + " t1=" + t1 + " t2=" + t2 + " diff=" + diff + " t3=" + t3);
            throw new NullPointerException();
        }
        return (float)(0.5 * Math.sqrt(t2) * Math.sqrt(t3) / Math.sqrt(distanceAB2));
    }

    void checkFullTorusIJ() {
        if (this.sas1.getTorus(this.indexI, this.indexJ) == null) {
            if (this.vectorIJ.z == 0.0f) {
                this.unitRadialVectorT.set(vectorZ);
            } else {
                this.unitRadialVectorT.set(-this.vectorIJ.y, this.vectorIJ.x, 0.0f);
                this.unitRadialVectorT.normalize();
            }
            float torusRadiusIJ = this.calcTorusRadius(this.radiusI, this.radiusJ, this.distanceIJ2);
            if (torusRadiusIJ > this.radiusP) {
                this.pointT.scaleAdd(torusRadiusIJ, this.unitRadialVectorT, this.torusCenterIJ);
                if (this.checkProbeNotIJ(this.pointT)) {
                    this.sas1.createTorus(this.indexI, this.indexJ, this.torusCenterIJ, torusRadiusIJ, true);
                }
            }
        }
    }
}

