/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import org.jmol.viewer.Frame;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Viewer;

class PickingManager {
    Viewer viewer;
    int pickingMode = 1;
    boolean chimeStylePicking = true;
    int queuedAtomCount = 0;
    int[] queuedAtomIndexes = new int[4];
    int[] countPlusIndexes = new int[5];

    PickingManager(Viewer viewer) {
        this.viewer = viewer;
    }

    void atomPicked(int atomIndex, boolean shiftKey) {
        if (atomIndex == -1) {
            return;
        }
        Frame frame = this.viewer.getFrame();
        switch (this.pickingMode) {
            case 0: {
                break;
            }
            case 1: {
                this.viewer.notifyAtomPicked(atomIndex);
                break;
            }
            case 2: {
                if (this.queuedAtomCount >= 2) {
                    this.queuedAtomCount = 0;
                }
                this.queueAtom(atomIndex);
                if (this.queuedAtomCount < 2) break;
                float distance = frame.getDistance(this.queuedAtomIndexes[0], atomIndex);
                this.viewer.scriptStatus("Distance " + this.viewer.getAtomInfo(this.queuedAtomIndexes[0]) + " - " + this.viewer.getAtomInfo(this.queuedAtomIndexes[1]) + " : " + distance);
                break;
            }
            case 4: {
                if (this.queuedAtomCount >= 3) {
                    this.queuedAtomCount = 0;
                }
                this.queueAtom(atomIndex);
                if (this.queuedAtomCount < 3) break;
                float angle = frame.getAngle(this.queuedAtomIndexes[0], this.queuedAtomIndexes[1], atomIndex);
                this.viewer.scriptStatus("Angle " + this.viewer.getAtomInfo(this.queuedAtomIndexes[0]) + " - " + this.viewer.getAtomInfo(this.queuedAtomIndexes[1]) + " - " + this.viewer.getAtomInfo(this.queuedAtomIndexes[2]) + " : " + angle);
                break;
            }
            case 5: {
                if (this.queuedAtomCount >= 4) {
                    this.queuedAtomCount = 0;
                }
                this.queueAtom(atomIndex);
                if (this.queuedAtomCount < 4) break;
                float torsion = frame.getTorsion(this.queuedAtomIndexes[0], this.queuedAtomIndexes[1], this.queuedAtomIndexes[2], atomIndex);
                this.viewer.scriptStatus("Torsion " + this.viewer.getAtomInfo(this.queuedAtomIndexes[0]) + " - " + this.viewer.getAtomInfo(this.queuedAtomIndexes[1]) + " - " + this.viewer.getAtomInfo(this.queuedAtomIndexes[2]) + " - " + this.viewer.getAtomInfo(this.queuedAtomIndexes[3]) + " : " + torsion);
                break;
            }
            case 3: {
                if (this.queuedAtomCount >= 2) {
                    this.queuedAtomCount = 0;
                }
                this.queueAtom(atomIndex);
                if (this.queuedAtomCount < 2) break;
                this.countPlusIndexes[0] = 2;
                this.countPlusIndexes[1] = this.queuedAtomIndexes[0];
                this.countPlusIndexes[2] = this.queuedAtomIndexes[1];
                this.viewer.toggleMeasurement(this.countPlusIndexes);
                break;
            }
            case 6: {
                this.viewer.togglePickingLabel(atomIndex);
                break;
            }
            case 7: {
                this.viewer.setCenter(frame.getAtomPoint3f(atomIndex));
                break;
            }
            case 10: {
                if (shiftKey | this.chimeStylePicking) {
                    this.viewer.toggleSelection(atomIndex);
                } else {
                    this.viewer.setSelection(atomIndex);
                }
                this.reportSelection();
                break;
            }
            case 11: {
                BitSet bsGroup = frame.getGroupBitSet(atomIndex);
                if (shiftKey | this.chimeStylePicking) {
                    this.viewer.toggleSelectionSet(bsGroup);
                } else {
                    this.viewer.setSelectionSet(bsGroup);
                }
                this.viewer.clearClickCount();
                this.reportSelection();
                break;
            }
            case 12: {
                BitSet bsChain = frame.getChainBitSet(atomIndex);
                if (shiftKey | this.chimeStylePicking) {
                    this.viewer.toggleSelectionSet(bsChain);
                } else {
                    this.viewer.setSelectionSet(bsChain);
                }
                this.viewer.clearClickCount();
                this.reportSelection();
            }
        }
    }

    void reportSelection() {
        this.viewer.scriptStatus("" + this.viewer.getSelectionCount() + " atoms selected");
    }

    void setPickingMode(int pickingMode) {
        this.pickingMode = pickingMode;
        this.queuedAtomCount = 0;
        System.out.println("setPickingMode(" + pickingMode + ":" + JmolConstants.pickingModeNames[pickingMode] + ")");
    }

    void queueAtom(int atomIndex) {
        this.queuedAtomIndexes[this.queuedAtomCount++] = atomIndex;
        this.viewer.scriptStatus("Atom #" + this.queuedAtomCount + ":" + this.viewer.getAtomInfo(atomIndex));
    }
}

