/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.viewer.Atom;
import org.jmol.viewer.Closest;
import org.jmol.viewer.Mmset;
import org.jmol.viewer.Model;
import org.jmol.viewer.Monomer;
import org.jmol.viewer.Polymer;
import org.jmol.viewer.Shape;

abstract class Mps
extends Shape {
    Mmset mmset;
    Mpsmodel[] mpsmodels;

    Mps() {
    }

    final void initShape() {
        this.mmset = this.frame.mmset;
    }

    void setSize(int size, BitSet bsSelected) {
        short mad = (short)size;
        this.initialize();
        int m = this.mpsmodels.length;
        while (--m >= 0) {
            this.mpsmodels[m].setMad(mad, bsSelected);
        }
    }

    void setProperty(String propertyName, Object value, BitSet bs) {
        this.initialize();
        if ("color" == propertyName) {
            String palette = null;
            short colix = Graphics3D.getColix(value);
            if (colix == 3) {
                palette = (String)value;
            }
            int m = this.mpsmodels.length;
            while (--m >= 0) {
                this.mpsmodels[m].setColix(colix, palette, bs);
            }
            return;
        }
        if ("translucency" == propertyName) {
            boolean isTranslucent = "translucent" == value;
            int m = this.mpsmodels.length;
            while (--m >= 0) {
                this.mpsmodels[m].setTranslucent(isTranslucent, bs);
            }
        }
    }

    abstract Mpspolymer allocateMpspolymer(Polymer var1);

    void initialize() {
        if (this.mpsmodels == null) {
            int modelCount = this.mmset == null ? 0 : this.mmset.getModelCount();
            Model[] models = this.mmset.getModels();
            this.mpsmodels = new Mpsmodel[modelCount];
            int i = modelCount;
            while (--i >= 0) {
                this.mpsmodels[i] = new Mpsmodel(models[i]);
            }
        }
    }

    int getMpsmodelCount() {
        return this.mpsmodels.length;
    }

    Mpsmodel getMpsmodel(int i) {
        return this.mpsmodels[i];
    }

    void findNearestAtomIndex(int xMouse, int yMouse, Closest closest) {
        int i = this.mpsmodels.length;
        while (--i >= 0) {
            this.mpsmodels[i].findNearestAtomIndex(xMouse, yMouse, closest);
        }
    }

    abstract class Mpspolymer {
        Polymer polymer;
        short madOn;
        short madHelixSheet;
        short madTurnRandom;
        short madDnaRna;
        int monomerCount;
        Monomer[] monomers;
        short[] colixes;
        short[] mads;
        Point3f[] leadMidpoints;
        Vector3f[] wingVectors;
        boolean hasBfactorRange = false;
        int bfactorMin;
        int bfactorMax;
        int range;
        float floatRange;
        private static final double eightPiSquared100 = 7895.6835208714865;

        Mpspolymer(Polymer polymer, int madOn, int madHelixSheet, int madTurnRandom, int madDnaRna) {
            this.polymer = polymer;
            this.madOn = (short)madOn;
            this.madHelixSheet = (short)madHelixSheet;
            this.madTurnRandom = (short)madTurnRandom;
            this.madDnaRna = (short)madDnaRna;
            int n = this.monomerCount = polymer == null ? 0 : polymer.monomerCount;
            if (this.monomerCount > 0) {
                this.colixes = new short[this.monomerCount];
                this.mads = new short[this.monomerCount + 1];
                this.monomers = polymer.monomers;
                this.leadMidpoints = polymer.getLeadMidpoints();
                this.wingVectors = polymer.getWingVectors();
            }
        }

        short getMadSpecial(short mad, int groupIndex) {
            switch (mad) {
                case -1: {
                    if (this.madOn >= 0) {
                        return this.madOn;
                    }
                    if (this.madOn != -2) {
                        System.out.println("not supported?");
                        return 0;
                    }
                }
                case -2: {
                    switch (this.monomers[groupIndex].getProteinStructureType()) {
                        case 2: 
                        case 3: {
                            return this.madHelixSheet;
                        }
                        case 4: 
                        case 5: {
                            return this.madDnaRna;
                        }
                    }
                    return this.madTurnRandom;
                }
                case -3: {
                    if (!this.hasBfactorRange) {
                        this.calcBfactorRange();
                    }
                    Atom atom = this.monomers[groupIndex].getLeadAtom();
                    int bfactor100 = atom.getBfactor100();
                    int scaled = bfactor100 - this.bfactorMin;
                    if (this.range == 0) {
                        return 0;
                    }
                    float percentile = (float)scaled / this.floatRange;
                    if (percentile < 0.0f || percentile > 1.0f) {
                        System.out.println("Que ha ocurrido? " + percentile);
                    }
                    return (short)(1750.0f * percentile + 250.0f);
                }
                case -4: {
                    Atom atom = this.monomers[groupIndex].getLeadAtom();
                    return (short)(2 * this.calcMeanPositionalDisplacement(atom.getBfactor100()));
                }
            }
            System.out.println("unrecognized Mps.getSpecial(" + mad + ")");
            return 0;
        }

        void calcBfactorRange() {
            this.bfactorMin = this.bfactorMax = this.monomers[0].getLeadAtom().getBfactor100();
            int i = this.monomerCount;
            while (--i > 0) {
                int bfactor = this.monomers[i].getLeadAtom().getBfactor100();
                if (bfactor < this.bfactorMin) {
                    this.bfactorMin = bfactor;
                    continue;
                }
                if (bfactor <= this.bfactorMax) continue;
                this.bfactorMax = bfactor;
            }
            this.range = this.bfactorMax - this.bfactorMin;
            this.floatRange = this.range;
            System.out.println("bfactor range=" + this.range);
            this.hasBfactorRange = true;
        }

        void setMad(short mad, BitSet bsSelected) {
            int[] atomIndices = this.polymer.getLeadAtomIndices();
            int i = this.monomerCount;
            while (--i >= 0) {
                if (!bsSelected.get(atomIndices[i])) continue;
                this.mads[i] = mad >= 0 ? mad : this.getMadSpecial(mad, i);
            }
            if (this.monomerCount > 1) {
                this.mads[this.monomerCount] = this.mads[this.monomerCount - 1];
            }
        }

        void setColix(short colix, String palette, BitSet bsSelected) {
            int[] atomIndices = this.polymer.getLeadAtomIndices();
            int i = this.monomerCount;
            while (--i >= 0) {
                int atomIndex = atomIndices[i];
                if (!bsSelected.get(atomIndex)) continue;
                this.colixes[i] = colix != 3 ? colix : Mps.this.viewer.getColixAtomPalette(Mps.this.frame.getAtomAt(atomIndex), palette);
            }
        }

        void setTranslucent(boolean isTranslucent, BitSet bsSelected) {
            int[] atomIndices = this.polymer.getLeadAtomIndices();
            int i = this.monomerCount;
            while (--i >= 0) {
                int atomIndex = atomIndices[i];
                if (!bsSelected.get(atomIndex)) continue;
                this.colixes[i] = Graphics3D.setTranslucent(this.colixes[i], isTranslucent);
            }
        }

        short calcMeanPositionalDisplacement(int bFactor100) {
            return (short)(Math.sqrt((double)bFactor100 / 7895.6835208714865) * 1000.0);
        }

        void findNearestAtomIndex(int xMouse, int yMouse, Closest closest) {
            this.polymer.findNearestAtomIndex(xMouse, yMouse, closest, this.mads);
        }
    }

    class Mpsmodel {
        Mpspolymer[] mpspolymers;
        int modelIndex;

        Mpsmodel(Model model) {
            this.mpspolymers = new Mpspolymer[model.getPolymerCount()];
            this.modelIndex = model.modelIndex;
            int i = this.mpspolymers.length;
            while (--i >= 0) {
                this.mpspolymers[i] = Mps.this.allocateMpspolymer(model.getPolymer(i));
            }
        }

        void setMad(short mad, BitSet bsSelected) {
            int i = this.mpspolymers.length;
            while (--i >= 0) {
                Mpspolymer polymer = this.mpspolymers[i];
                if (polymer.monomerCount <= 0) continue;
                polymer.setMad(mad, bsSelected);
            }
        }

        void setColix(short colix, String palette, BitSet bsSelected) {
            int i = this.mpspolymers.length;
            while (--i >= 0) {
                Mpspolymer polymer = this.mpspolymers[i];
                if (polymer.monomerCount <= 0) continue;
                polymer.setColix(colix, palette, bsSelected);
            }
        }

        void setTranslucent(boolean isTranslucent, BitSet bsSelected) {
            int i = this.mpspolymers.length;
            while (--i >= 0) {
                Mpspolymer polymer = this.mpspolymers[i];
                if (polymer.monomerCount <= 0) continue;
                polymer.setTranslucent(isTranslucent, bsSelected);
            }
        }

        int getMpspolymerCount() {
            return this.mpspolymers.length;
        }

        Mpspolymer getMpspolymer(int i) {
            return this.mpspolymers[i];
        }

        void findNearestAtomIndex(int xMouse, int yMouse, Closest closest) {
            int i = this.mpspolymers.length;
            while (--i >= 0) {
                this.mpspolymers[i].findNearestAtomIndex(xMouse, yMouse, closest);
            }
        }
    }
}

