/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jmol.api.JmolViewer;
import org.jmol.util.GT;
import org.openscience.jmol.app.ConsoleTextPane;
import org.openscience.jmol.app.EnterListener;
import org.openscience.jmol.app.HelpDialog;

public final class ScriptWindow
extends JDialog
implements ActionListener,
EnterListener {
    private ConsoleTextPane console;
    private JButton closeButton;
    private JButton runButton;
    private JButton haltButton;
    private JButton clearButton;
    private JButton helpButton;
    JmolViewer viewer;

    public ScriptWindow(JmolViewer viewer, JFrame frame) {
        super(frame, GT._("Rasmol Scripts"), false);
        this.viewer = viewer;
        this.layoutWindow(this.getContentPane());
        this.setSize(500, 400);
        this.setLocationRelativeTo(frame);
    }

    void layoutWindow(Container container) {
        container.setLayout(new BorderLayout());
        this.console = new ConsoleTextPane(this);
        this.console.setPrompt();
        container.add((Component)new JScrollPane(this.console), "Center");
        JPanel buttonPanel = new JPanel();
        container.add((Component)buttonPanel, "South");
        this.closeButton = new JButton(GT._("Close"));
        this.closeButton.addActionListener(this);
        buttonPanel.add(this.closeButton);
        this.runButton = new JButton(GT._("Run"));
        this.runButton.addActionListener(this);
        buttonPanel.add(this.runButton);
        this.haltButton = new JButton(GT._("Halt"));
        this.haltButton.addActionListener(this);
        buttonPanel.add(this.haltButton);
        this.haltButton.setEnabled(false);
        this.clearButton = new JButton(GT._("Clear"));
        this.clearButton.addActionListener(this);
        buttonPanel.add(this.clearButton);
        this.helpButton = new JButton(GT._("Help"));
        this.helpButton.addActionListener(this);
        buttonPanel.add(this.helpButton);
    }

    public void scriptEcho(String strEcho) {
        if (strEcho != null) {
            this.console.outputEcho(strEcho);
        }
    }

    public void scriptStatus(String strStatus) {
        if (strStatus != null) {
            this.console.outputStatus(strStatus);
        }
    }

    public void notifyScriptTermination(String strMsg, int msWalltime) {
        if (strMsg != null) {
            this.console.outputError(strMsg);
        }
        this.runButton.setEnabled(true);
        this.haltButton.setEnabled(false);
    }

    public void enterPressed() {
        this.runButton.doClick(100);
    }

    void executeCommand() {
        String strCommand = this.console.getCommandString().trim();
        this.console.appendNewline();
        this.console.setPrompt();
        if (strCommand.length() > 0) {
            String strErrorMessage = this.viewer.evalString(strCommand);
            if (strErrorMessage != null) {
                this.console.outputError(strErrorMessage);
            } else {
                this.runButton.setEnabled(false);
                this.haltButton.setEnabled(true);
            }
        }
        this.console.grabFocus();
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.closeButton) {
            this.hide();
        } else if (source == this.runButton) {
            this.executeCommand();
        } else if (source == this.clearButton) {
            System.out.println("clearing content of script window.");
            this.console.clearContent();
        } else if (source == this.haltButton) {
            System.out.println("calling viewer.haltScriptExecution();");
            this.viewer.haltScriptExecution();
        } else if (source == this.helpButton) {
            URL url = this.getClass().getClassLoader().getResource("org/openscience/jmol/Data/guide/ch04.html");
            HelpDialog hd = new HelpDialog(null, url);
            hd.show();
        }
        this.console.grabFocus();
    }
}

