/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import org.jmol.api.JmolViewer;

public class PovraySaver {
    BufferedWriter bw;
    JmolViewer viewer;
    boolean allModels;
    int screenWidth;
    int screenHeight;
    Matrix4f transformMatrix;
    Point3f point1 = new Point3f();
    Point3f point2 = new Point3f();
    Point3f pointC = new Point3f();

    public PovraySaver(JmolViewer viewer, OutputStream out, boolean allModels, int width, int height) {
        this.bw = new BufferedWriter(new OutputStreamWriter(out), 8192);
        this.viewer = viewer;
        this.allModels = allModels;
        this.screenWidth = width;
        this.screenHeight = height;
    }

    void out(String str) throws IOException {
        this.bw.write(str);
    }

    public void writeFrame() throws IOException {
        int i;
        int i2;
        int m;
        float zoom = this.viewer.getRotationRadius() * 2.0f;
        zoom *= 1.1f;
        zoom /= (float)this.viewer.getZoomPercent() / 100.0f;
        this.transformMatrix = this.viewer.getUnscaledTransformMatrix();
        if (this.screenWidth <= 0 || this.screenHeight <= 0) {
            this.screenWidth = this.viewer.getScreenWidth();
            this.screenHeight = this.viewer.getScreenHeight();
        }
        int minScreenDimension = this.screenWidth < this.screenHeight ? this.screenWidth : this.screenHeight;
        Date now = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("EEE, MMMM dd, yyyy 'at' h:mm aaa");
        String now_st = sdf.format(now);
        this.out("//******************************************************\n");
        this.out("// Jmol generated povray script.\n");
        this.out("//\n");
        this.out("// This script was generated on :\n");
        this.out("// " + now_st + "\n");
        this.out("//******************************************************\n");
        this.out("\n");
        this.out("\n");
        this.out("//******************************************************\n");
        this.out("// Declare the resolution, camera, and light sources.\n");
        this.out("//******************************************************\n");
        this.out("\n");
        this.out("// NOTE: if you plan to render at a different resolution,\n");
        this.out("// be sure to update the following two lines to maintain\n");
        this.out("// the correct aspect ratio.\n\n");
        this.out("#declare Width = " + this.screenWidth + ";\n");
        this.out("#declare Height = " + this.screenHeight + ";\n");
        this.out("#declare minScreenDimension = " + minScreenDimension + ";\n");
        this.out("#declare Ratio = Width / Height;\n");
        this.out("#declare zoom = " + zoom + ";\n");
        this.out("#declare showAtoms = true;\n");
        this.out("#declare showBonds = true;\n");
        this.out("#declare showPolymers = false;\n");
        this.out("camera{\n");
        this.out("  location < 0, 0, zoom>\n\n");
        this.out("  // Ratio is negative to switch povray to\n");
        this.out("  // a right hand coordinate system.\n");
        this.out("\n");
        this.out("  right < -Ratio , 0, 0>\n");
        this.out("  look_at < 0, 0, 0 >\n");
        this.out("}\n");
        this.out("\n");
        this.out("background { color " + this.povrayColor(this.viewer.getColorBackground()) + " }\n");
        this.out("\n");
        this.out("light_source { < 0, 0, zoom>  rgb <1.0,1.0,1.0> }\n");
        this.out("light_source { < -zoom, zoom, zoom>  rgb <1.0,1.0,1.0> }\n");
        this.out("\n");
        this.out("\n");
        this.out("//***********************************************\n");
        this.out("// macros for common shapes\n");
        this.out("//***********************************************\n");
        this.out("\n");
        this.writeMacros();
        this.out("//***********************************************\n");
        this.out("// List of all of the atoms\n");
        this.out("//***********************************************\n");
        this.out("\n");
        this.out("#if (showAtoms)\n");
        if (this.allModels) {
            this.out("#switch (clock)\n");
            for (m = 0; m < this.viewer.getModelCount(); ++m) {
                this.out("#range (" + ((double)m + 0.9) + "," + ((double)m + 1.1) + ")\n");
                for (i2 = 0; i2 < this.viewer.getAtomCount(); ++i2) {
                    this.writeAtom(m, i2);
                }
                this.out("#break\n");
            }
            this.out("#end\n");
        } else {
            for (i = 0; i < this.viewer.getAtomCount(); ++i) {
                this.writeAtom(this.viewer.getDisplayModelIndex(), i);
            }
        }
        this.out("#end\n");
        this.out("\n");
        this.out("//***********************************************\n");
        this.out("// The list of bonds\n");
        this.out("//***********************************************\n");
        this.out("\n");
        this.out("#if (showBonds)\n");
        if (this.allModels) {
            this.out("#switch (clock)\n");
            for (m = 0; m < this.viewer.getModelCount(); ++m) {
                this.out("#range (" + ((double)m + 0.9) + "," + ((double)m + 1.1) + ")\n");
                for (i2 = 0; i2 < this.viewer.getBondCount(); ++i2) {
                    this.writeBond(m, i2);
                }
                this.out("#break\n");
            }
            this.out("#end\n");
        } else {
            for (i = 0; i < this.viewer.getBondCount(); ++i) {
                this.writeBond(this.viewer.getDisplayModelIndex(), i);
            }
        }
        this.out("#end\n");
        this.out("\n");
        this.out("//***********************************************\n");
        this.out("// The list of polymers\n");
        this.out("//***********************************************\n");
        this.out("\n");
        this.out("#if (showPolymers)\n");
        if (this.allModels) {
            this.out("#switch (clock)\n");
            for (m = 0; m < this.viewer.getModelCount(); ++m) {
                this.out("#range (" + ((double)m + 0.9) + "," + ((double)m + 1.1) + ")\n");
                for (i2 = 0; i2 < this.viewer.getPolymerCountInModel(m); ++i2) {
                    this.writePolymer(m, i2);
                }
                this.out("#break\n");
            }
            this.out("#end\n");
        } else {
            for (i = 0; i < this.viewer.getPolymerCountInModel(this.viewer.getDisplayModelIndex()); ++i) {
                this.writePolymer(this.viewer.getDisplayModelIndex(), i);
            }
        }
        this.out("#end\n");
    }

    public synchronized void writeFile() {
        try {
            this.writeFrame();
            this.bw.close();
        }
        catch (IOException e) {
            System.out.println("Got IOException " + e + " trying to write frame.");
        }
    }

    protected String povrayColor(Color color) {
        return "rgb<" + (float)color.getRed() / 255.0f + "," + (float)color.getGreen() / 255.0f + "," + (float)color.getBlue() / 255.0f + ">";
    }

    void writeMacros() throws IOException {
        this.out("#default { finish {\n ambient .2 diffuse .6 specular 1 roughness .001 metallic}}\n\n");
        this.writeMacrosAtom();
        this.writeMacrosBond();
        this.writeMacrosDoubleBond();
        this.writeMacrosTripleBond();
        this.writeMacrosHydrogenBond();
        this.writeMacrosAromaticBond();
    }

    void writeMacrosAtom() throws IOException {
        this.out("#macro atom(X,Y,Z,RADIUS,R,G,B)\n sphere{<X,Y,Z>,RADIUS\n  pigment{rgb<R,G,B>}}\n#end\n\n");
    }

    void writeMacrosRing() throws IOException {
        this.out("#macro ring(X,Y,Z,RADIUS,R,G,B)\n torus{RADIUS,wireRadius pigment{rgb<R,G,B>} translate<X,Z,-Y> rotate<90,0,0>}\n#end\n\n");
    }

    void writeMacrosBond() throws IOException {
        this.out("#macro bond1(X1,Y1,Z1,X2,Y2,Z2,RADIUS,R,G,B)\n cylinder{<X1,Y1,Z1>,<X2,Y2,Z2>,RADIUS\n  pigment{rgb<R,G,B>}}\n sphere{<X1,Y1,Z1>,RADIUS\n  pigment{rgb<R,G,B>}}\n sphere{<X2,Y2,Z2>,RADIUS\n  pigment{rgb<R,G,B>}}\n#end\n\n");
        this.out("#macro bond2(X1,Y1,Z1,X2,Y2,Z2,RADIUS,R1,G1,B1,R2,G2,B2)\n#local xc = (X1 + X2) / 2;\n#local yc = (Y1 + Y2) / 2;\n#local zc = (Z1 + Z2) / 2;\n cylinder{<X1,Y1,Z1>,<xc,yc,zc>,RADIUS\n  pigment{rgb<R1,G1,B1>}}\n cylinder{<xc,yc,zc>,<X2,Y2,Z2>,RADIUS\n  pigment{rgb<R2,G2,B2>}}\n sphere{<X1,Y1,Z1>,RADIUS\n  pigment{rgb<R1,G1,B1>}}\n sphere{<X2,Y2,Z2>,RADIUS\n  pigment{rgb<R2,G2,B2>}}\n#end\n\n");
    }

    void writeMacrosDoubleBond() throws IOException {
        this.out("#macro dblbond1(X1,Y1,Z1,X2,Y2,Z2,RADIUS,R,G,B)\n#local dx = X2 - X1;\n#local dy = Y2 - Y1;\n#local mag2d = sqrt(dx*dx + dy*dy);\n#local separation = 3/2 * RADIUS;\n#if (dx + dy)\n #local offX = separation * dy / mag2d;\n #local offY = separation * -dx / mag2d;\n#else\n #local offX = 0;\n #local offY = separation;\n#end\nbond1(X1+offX,Y1+offY,Z1,X2+offX,Y2+offY,Z2,RADIUS,R,G,B)\nbond1(X1-offX,Y1-offY,Z1,X2-offX,Y2-offY,Z2,RADIUS,R,G,B)\n#end\n\n");
        this.out("#macro dblbond2(X1,Y1,Z1,X2,Y2,Z2,RADIUS,R1,G1,B1,R2,G2,B2)\n#local dx = X2 - X1;\n#local dy = Y2 - Y1;\n#local mag2d = sqrt(dx*dx + dy*dy);\n#local separation = 3/2 * RADIUS;\n#if (dx + dy)\n #local offX = separation * dy / mag2d;\n #local offY = separation * -dx / mag2d;\n#else\n #local offX = 0;\n #local offY = separation;\n#end\nbond2(X1+offX,Y1+offY,Z1,X2+offX,Y2+offY,Z2,\n      RADIUS,R1,G1,B1,R2,G2,B2)\nbond2(X1-offX,Y1-offY,Z1,X2-offX,Y2-offY,Z2,\n      RADIUS,R1,G1,B1,R2,G2,B2)\n#end\n\n");
    }

    void writeMacrosTripleBond() throws IOException {
        this.out("#macro trpbond1(X1,Y1,Z1,X2,Y2,Z2,RADIUS,R,G,B)\n#local dx = X2 - X1;\n#local dy = Y2 - Y1;\n#local mag2d = sqrt(dx*dx + dy*dy);\n#local separation = 5/2 * RADIUS;\n#if (dx + dy)\n #local offX = separation * dy / mag2d;\n #local offY = separation * -dx / mag2d;\n#else\n #local offX = 0;\n #local offY = separation;\n#end\nbond1(X1+offX,Y1+offY,Z1,X2+offX,Y2+offY,Z2,RADIUS,R,G,B)\nbond1(X1     ,Y1     ,Z1,X2     ,Y2     ,Z2,RADIUS,R,G,B)\nbond1(X1-offX,Y1-offY,Z1,X2-offX,Y2-offY,Z2,RADIUS,R,G,B)\n#end\n\n");
        this.out("#macro trpbond2(X1,Y1,Z1,X2,Y2,Z2,RADIUS,R1,G1,B1,R2,G2,B2)\n#local dx = X2 - X1;\n#local dy = Y2 - Y1;\n#local mag2d = sqrt(dx*dx + dy*dy);\n#local separation = 5/2 * RADIUS;\n#if (dx + dy)\n #local offX = separation * dy / mag2d;\n #local offY = separation * -dx / mag2d;\n#else\n #local offX = 0;\n #local offY = separation;\n#end\nbond2(X1+offX,Y1+offY,Z1,X2+offX,Y2+offY,Z2,\n      RADIUS,R1,G1,B1,R2,G2,B2)\nbond2(X1     ,Y1     ,Z1,X2     ,Y2     ,Z2,\n      RADIUS,R1,G1,B1,R2,G2,B2)\nbond2(X1-offX,Y1-offY,Z1,X2-offX,Y2-offY,Z2,\n      RADIUS,R1,G1,B1,R2,G2,B2)\n#end\n\n");
    }

    void writeMacrosHydrogenBond() throws IOException {
        this.out("#macro hbond1(X1,Y1,Z1,X2,Y2,Z2,RADIUS,R,G,B)\n#local dx = (X2 - X1) / 10;\n#local dy = (Y2 - Y1) / 10;\n#local dz = (Z2 - Z1) / 10;\n cylinder{<X1+dx  ,Y1+dy  ,Z1+dz  >,<X1+3*dx,Y1+3*dy,Z1+3*dz>,RADIUS\n  pigment{rgb<R,G,B>}}\n cylinder{<X1+4*dx,Y1+4*dy,Z1+4*dz>,<X2-4*dx,Y2-4*dy,Z2-4*dz>,RADIUS\n  pigment{rgb<R,G,B>}}\n cylinder{<X2-3*dx,Y2-3*dy,Z2-3*dz>,<X2-dx  ,Y2-dy  ,Z2-dz  >,RADIUS\n  pigment{rgb<R,G,B>}}\n#end\n\n");
        this.out("#macro hbond2(X1,Y1,Z1,X2,Y2,Z2,RADIUS,R1,G1,B1,R2,G2,B2)\n#local dx = (X2 - X1) / 10;\n#local dy = (Y2 - Y1) / 10;\n#local dz = (Z2 - Z1) / 10;\n#local xc = (X1 + X2) / 2;\n#local yc = (Y1 + Y2) / 2;\n#local zc = (Z1 + Z2) / 2;\n cylinder{<X1+dx  ,Y1+dy  ,Z1+dz  >,<X1+3*dx,Y1+3*dy,Z1+3*dz>,RADIUS\n  pigment{rgb<R1,G1,B1>}}\n cylinder{<X1+4*dx,Y1+4*dy,Z1+4*dz>,<xc     ,yc     ,zc     >,RADIUS\n  pigment{rgb<R1,G1,B1>}}\n cylinder{<xc     ,yc     ,zc     >,<X2-4*dx,Y2-4*dy,Z2-4*dz>,RADIUS\n  pigment{rgb<R2,G2,B2>}}\n cylinder{<X2-3*dx,Y2-3*dy,Z2-3*dz>,<X2-dx  ,Y2-dy  ,Z2-dz  >,RADIUS\n  pigment{rgb<R2,G2,B2>}}\n#end\n\n");
    }

    void writeMacrosAromaticBond() throws IOException {
        this.out("#macro abond1(X1,Y1,Z1,X2,Y2,Z2,RADIUS,R,G,B)\n#local dx = (X2 - X1) / 12;\n#local dy = (Y2 - Y1) / 12;\n#local dz = (Z2 - Z1) / 12;\n#local mag2d = sqrt(dx*dx + dy*dy);\n#local separation = 3/2 * RADIUS;\n#if (dx + dy)\n #local offX = separation * dy / mag2d;\n #local offY = separation * -dx / mag2d;\n#else\n #local offX = 0;\n #local offY = separation;\n#end\n bond1(X1+offX,Y1+offY,Z1,X2+offX,Y2+offY,Z2,RADIUS,R,G,B)\n cylinder{<X1-offX+2*dx,Y1-offY+2*dy,Z1+2*dz>,<X1-offX+5*dx,Y1-offY+5*dy,Z1+5*dz>,RADIUS\n  pigment{rgb<R,G,B>}} cylinder{<X2-offX-2*dx,Y2-offY-2*dy,Z2-2*dz>,<X2-offX-5*dx,Y2-offY-5*dy,Z2-5*dz>,RADIUS\n  pigment{rgb<R,G,B>}}#end\n\n");
        this.out("#macro abond2(X1,Y1,Z1,X2,Y2,Z2,RADIUS,R1,G1,B1,R2,G2,B2)\n#local dx = (X2 - X1) / 12;\n#local dy = (Y2 - Y1) / 12;\n#local dz = (Z2 - Z1) / 12;\n#local mag2d = sqrt(dx*dx + dy*dy);\n#local separation = 3/2 * RADIUS;\n#if (dx + dy)\n #local offX = separation * dy / mag2d;\n #local offY = separation * -dx / mag2d;\n#else\n #local offX = 0;\n #local offY = separation;\n#end\n bond2(X1+offX,Y1+offY,Z1,X2+offX,Y2+offY,Z2,RADIUS,R1,G1,B1,R2,G2,B2)\n cylinder{<X1-offX+2*dx,Y1-offY+2*dy,Z1+2*dz>,<X1-offX+3.5*dx,Y1-offY+3.5*dy,Z1+3.5*dz>,RADIUS\n  pigment{rgb<R1,G1,B1>}} cylinder{<X1-offX+5*dx,Y1-offY+5*dy,Z1+5*dz>,<X1-offX+3.5*dx,Y1-offY+3.5*dy,Z1+3.5*dz>,RADIUS\n  pigment{rgb<R2,G2,B2>}} cylinder{<X2-offX-5*dx,Y2-offY-5*dy,Z2-5*dz>,<X2-offX-3.5*dx,Y2-offY-3.5*dy,Z2-3.5*dz>,RADIUS\n  pigment{rgb<R1,G1,B1>}} cylinder{<X2-offX-2*dx,Y2-offY-2*dy,Z2-2*dz>,<X2-offX-3.5*dx,Y2-offY-3.5*dy,Z2-3.5*dz>,RADIUS\n  pigment{rgb<R2,G2,B2>}}#end\n\n");
    }

    void writeMacrosWire() throws IOException {
        this.out("#macro wire1(X1,Y1,Z1,X2,Y2,Z2,RADIUS,R,G,B)\n cylinder{<X1,Y1,Z1>,<X2,Y2,Z2>,wireRadius\n  pigment{rgb<R,G,B>}}\n#end\n\n");
        this.out("#macro wire2(X1,Y1,Z1,X2,Y2,Z2,RADIUS,R1,G1,B1,R2,G2,B2)\n#local xc = (X1 + X2) / 2;\n#local yc = (Y1 + Y2) / 2;\n#local zc = (Z1 + Z2) / 2;\n cylinder{<X1,Y1,Z1>,<xc,yc,zc>,wireRadius\n  pigment{rgb<R1,G1,B1>}}\n cylinder{<xc,yc,zc>,<X2,Y2,Z2>,wireRadius\n  pigment{rgb<R2,G2,B2>}}\n#end\n\n");
    }

    void writeMacrosDoubleWire() throws IOException {
        this.out("#macro dblwire1(X1,Y1,Z1,X2,Y2,Z2,RADIUS,R,G,B)\n#local dx = X2 - X1;\n#local dy = Y2 - Y1;\n#local mag2d = sqrt(dx*dx + dy*dy);\n#local separation = 3/2 * RADIUS;\n#if (dx + dy)\n #local offX = separation * dy / mag2d;\n #local offY = separation * -dx / mag2d;\n#else\n #local offX = 0;\n #local offY = separation;\n#end\nwire1(X1+offX,Y1+offY,Z1,X2+offX,Y2+offY,Z2,RADIUS,R,G,B)\nwire1(X1-offX,Y1-offY,Z1,X2-offX,Y2-offY,Z2,RADIUS,R,G,B)\n#end\n\n");
        this.out("#macro dblwire2(X1,Y1,Z1,X2,Y2,Z2,RADIUS,R1,G1,B1,R2,G2,B2)\n#local dx = X2 - X1;\n#local dy = Y2 - Y1;\n#local mag2d = sqrt(dx*dx + dy*dy);\n#local separation = 3/2 * RADIUS;\n#if (dx + dy)\n #local offX = separation * dy / mag2d;\n #local offY = separation * -dx / mag2d;\n#else\n #local offX = 0;\n #local offY = separation;\n#end\nwire2(X1+offX,Y1+offY,Z1,X2+offX,Y2+offY,Z2,\n      RADIUS,R1,G1,B1,R2,G2,B2)\nwire2(X1-offX,Y1-offY,Z1,X2-offX,Y2-offY,Z2,\n      RADIUS,R1,G1,B1,R2,G2,B2)\n#end\n\n");
    }

    void writeMacrosTripleWire() throws IOException {
        this.out("#macro trpwire1(X1,Y1,Z1,X2,Y2,Z2,RADIUS,R,G,B)\n#local dx = X2 - X1;\n#local dy = Y2 - Y1;\n#local mag2d = sqrt(dx*dx + dy*dy);\n#local separation = 5/2 * RADIUS;\n#if (dx + dy)\n #local offX = separation * dy / mag2d;\n #local offY = separation * -dx / mag2d;\n#else\n #local offX = 0;\n #local offY = separation;\n#end\nwire1(X1+offX,Y1+offY,Z1,X2+offX,Y2+offY,Z2,RADIUS,R,G,B)\nwire1(X1     ,Y1     ,Z1,X2     ,Y2     ,Z2,RADIUS,R,G,B)\nwire1(X1-offX,Y1-offY,Z1,X2-offX,Y2-offY,Z2,RADIUS,R,G,B)\n#end\n\n");
        this.out("#macro trpwire2(X1,Y1,Z1,X2,Y2,Z2,RADIUS,R1,G1,B1,R2,G2,B2)\n#local dx = X2 - X1;\n#local dy = Y2 - Y1;\n#local mag2d = sqrt(dx*dx + dy*dy);\n#local separation = 5/2 * RADIUS;\n#if (dx + dy)\n #local offX = separation * dy / mag2d;\n #local offY = separation * -dx / mag2d;\n#else\n #local offX = 0;\n #local offY = separation;\n#end\nwire2(X1+offX,Y1+offY,Z1,X2+offX,Y2+offY,Z2,\n      RADIUS,R1,G1,B1,R2,G2,B2)\nwire2(X1     ,Y1     ,Z1,X2     ,Y2     ,Z2,\n      RADIUS,R1,G1,B1,R2,G2,B2)\nwire2(X1-offX,Y1-offY,Z1,X2-offX,Y2-offY,Z2,\n      RADIUS,R1,G1,B1,R2,G2,B2)\n#end\n\n");
    }

    void writeAtom(int modelIndex, int i) throws IOException {
        int model = this.viewer.getAtomModelIndex(i);
        if (model != modelIndex) {
            return;
        }
        float radius = this.viewer.getAtomRadius(i);
        if (radius == 0.0f) {
            return;
        }
        this.transformMatrix.transform(this.viewer.getAtomPoint3f(i), this.point1);
        float x = this.point1.x;
        float y = this.point1.y;
        float z = this.point1.z;
        Color color = this.viewer.getAtomColor(i);
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b = (float)color.getBlue() / 255.0f;
        this.out("atom(" + x + "," + y + "," + z + "," + radius + "," + r + "," + g + "," + b + ")\n");
    }

    void writeBond(int modelIndex, int i) throws IOException {
        int model = this.viewer.getBondModelIndex(i);
        if (model != modelIndex) {
            return;
        }
        float radius = this.viewer.getBondRadius(i);
        if (radius == 0.0f) {
            return;
        }
        this.transformMatrix.transform(this.viewer.getBondPoint3f1(i), this.point1);
        float x1 = this.point1.x;
        float y1 = this.point1.y;
        float z1 = this.point1.z;
        this.transformMatrix.transform(this.viewer.getBondPoint3f2(i), this.point2);
        float x2 = this.point2.x;
        float y2 = this.point2.y;
        float z2 = this.point2.z;
        Color color1 = this.viewer.getBondColor1(i);
        Color color2 = this.viewer.getBondColor2(i);
        float r1 = (float)color1.getRed() / 255.0f;
        float g1 = (float)color1.getGreen() / 255.0f;
        float b1 = (float)color1.getBlue() / 255.0f;
        short order = this.viewer.getBondOrder(i);
        switch (order) {
            case 1: {
                this.out("bond");
                break;
            }
            case 2: {
                this.out("dblbond");
                break;
            }
            case 3: {
                this.out("trpbond");
                break;
            }
            case 5: {
                this.out("abond");
                break;
            }
            default: {
                if ((order & 0x3C0) != 0) {
                    this.out("hbond");
                    break;
                }
                return;
            }
        }
        this.out(color1.equals(color2) ? "1" : "2");
        this.out("(");
        this.out(x1 + "," + y1 + "," + z1 + ",");
        this.out(x2 + "," + y2 + "," + z2 + ",");
        this.out(radius + ",");
        this.out(r1 + "," + g1 + "," + b1);
        if (!color1.equals(color2)) {
            float r2 = (float)color2.getRed() / 255.0f;
            float g2 = (float)color2.getGreen() / 255.0f;
            float b2 = (float)color2.getBlue() / 255.0f;
            this.out("," + r2 + "," + g2 + "," + b2);
        }
        this.out(")\n");
    }

    void writePolymer(int modelIndex, int i) throws IOException {
        Point3f[] points = this.viewer.getPolymerLeadMidPoints(modelIndex, i);
        Point3f[] controls = this.computeControlPoints(points);
        if (controls != null) {
            this.out("sphere_sweep {\n");
            this.out(" b_spline\n");
            this.out(" " + controls.length + "\n");
            for (int j = 0; j < controls.length; ++j) {
                Point3f point = controls[j];
                this.transformMatrix.transform(point, this.point1);
                double d = 0.2;
                this.out(" <" + this.point1.x + "," + this.point1.y + "," + this.point1.z + ">," + d + "\n");
            }
            Color color = Color.BLUE;
            float r = (float)color.getRed() / 255.0f;
            float g = (float)color.getGreen() / 255.0f;
            float b = (float)color.getBlue() / 255.0f;
            this.out(" pigment{rgb<" + r + "," + g + "," + b + ">}\n");
            this.out("}\n");
        }
    }

    Point3f[] computeControlPoints(Point3f[] path) {
        Point3f[] controls = null;
        if (path != null && path.length >= 2) {
            boolean loop;
            int length = path.length;
            boolean bl = loop = path[0].x == path[length - 1].x && path[0].y == path[length - 1].y && path[0].z == path[length - 1].z;
            if (!loop) {
                if (length > 2) {
                    int i;
                    Point3d[] values = new Point3d[length + 2];
                    Point3d[] results1 = new Point3d[length + 2];
                    Point3d[] results2 = new Point3d[length + 2];
                    values[0] = new Point3d(path[0]);
                    for (i = 0; i < length; ++i) {
                        values[i + 1] = new Point3d(6.0f * path[i].x, 6.0f * path[i].y, 6.0f * path[i].z);
                    }
                    values[length + 1] = new Point3d(values[length].x / 6.0, values[length].y / 6.0, values[length].z / 6.0);
                    for (i = 0; i < length + 2; ++i) {
                        results1[i] = new Point3d(0.0, 0.0, 0.0);
                        results2[i] = new Point3d(0.0, 0.0, 0.0);
                    }
                    results2[0].set(1.0, 1.0, 1.0);
                    results1[1].set(values[0]);
                    for (i = 2; i < length + 2; ++i) {
                        results1[i].x = values[i - 1].x - 4.0 * results1[i - 1].x - results1[i - 2].x;
                        results1[i].y = values[i - 1].y - 4.0 * results1[i - 1].y - results1[i - 2].y;
                        results1[i].z = values[i - 1].z - 4.0 * results1[i - 1].z - results1[i - 2].z;
                        results2[i].x = -4.0 * results2[i - 1].x - results2[i - 2].x;
                        results2[i].y = -4.0 * results2[i - 1].y - results2[i - 2].y;
                        results2[i].z = -4.0 * results2[i - 1].z - results2[i - 2].z;
                    }
                    double xA = (values[length + 1].x - results1[length].x) / results2[length].x;
                    double yA = (values[length + 1].y - results1[length].y) / results2[length].y;
                    double zA = (values[length + 1].z - results1[length].z) / results2[length].z;
                    Point3f[] points = new Point3f[length + 2];
                    for (int i2 = 0; i2 < length + 2; ++i2) {
                        points[i2] = new Point3f((float)(results1[i2].x + xA * results2[i2].x), (float)(results1[i2].y + yA * results2[i2].y), (float)(results1[i2].z + zA * results2[i2].z));
                    }
                    controls = points;
                } else {
                    Point3f[] points = new Point3f[length + 2];
                    points[0] = new Point3f(2.0f * path[0].x - path[1].x, 2.0f * path[0].y - path[1].y, 2.0f * path[0].z - path[1].z);
                    points[1] = new Point3f(path[0]);
                    points[2] = new Point3f(path[1]);
                    points[3] = new Point3f(2.0f * path[1].x - path[0].x, 2.0f * path[1].y - path[0].y, 2.0f * path[1].z - path[0].z);
                    controls = points;
                }
            } else if (length > 3) {
                int i;
                Point3d[] values = new Point3d[length + 2];
                Point3d[] results1 = new Point3d[length + 2];
                Point3d[] results2 = new Point3d[length + 2];
                Point3d[] results3 = new Point3d[length + 2];
                Point3f[] points = new Point3f[length + 2];
                for (i = 0; i < length - 1; ++i) {
                    values[i] = new Point3d(6.0f * path[i].x, 6.0f * path[i].y, 6.0f * path[i].z);
                    points[i] = new Point3f(0.0f, 0.0f, 0.0f);
                    results1[i] = new Point3d(0.0, 0.0, 0.0);
                    results2[i] = new Point3d(0.0, 0.0, 0.0);
                    results3[i] = new Point3d(0.0, 0.0, 0.0);
                }
                results2[0].set(1.0, 1.0, 1.0);
                results3[0].set(1.0, 1.0, 1.0);
                for (i = 2; i < length - 1; ++i) {
                    results1[i].x = values[i - 2].x - results1[i - 2].x - 4.0 * results1[i - 1].x;
                    results1[i].y = values[i - 2].y - results1[i - 2].y - 4.0 * results1[i - 1].y;
                    results1[i].z = values[i - 2].z - results1[i - 2].z - 4.0 * results1[i - 1].z;
                    results2[i].x = -results2[i - 2].x - 4.0 * results2[i - 1].x;
                    results2[i].y = -results2[i - 2].y - 4.0 * results2[i - 1].y;
                    results2[i].z = -results2[i - 2].z - 4.0 * results2[i - 1].z;
                    results3[i].x = -results3[i - 2].x - 4.0 * results3[i - 1].x;
                    results3[i].y = -results3[i - 2].y - 4.0 * results3[i - 1].y;
                    results3[i].z = -results3[i - 2].z - 4.0 * results3[i - 1].z;
                }
                double ax1 = 1.0 + results2[length - 3].x + 4.0 * results2[length - 2].x;
                double ay1 = 1.0 + results2[length - 3].y + 4.0 * results2[length - 2].y;
                double az1 = 1.0 + results2[length - 3].z + 4.0 * results2[length - 2].z;
                double ax2 = 4.0 + results2[length - 2].x;
                double ay2 = 4.0 + results2[length - 2].y;
                double az2 = 4.0 + results2[length - 2].z;
                double bx1 = 1.0 + results3[length - 3].x + 4.0 * results3[length - 2].x;
                double by1 = 1.0 + results3[length - 3].y + 4.0 * results3[length - 2].y;
                double bz1 = 1.0 + results3[length - 3].z + 4.0 * results3[length - 2].z;
                double bx2 = 1.0 + results3[length - 2].x;
                double by2 = 1.0 + results3[length - 2].y;
                double bz2 = 1.0 + results3[length - 2].z;
                double cx1 = values[length - 3].x - results1[length - 3].x - 4.0 * results1[length - 2].x;
                double cy1 = values[length - 3].y - results1[length - 3].y - 4.0 * results1[length - 2].y;
                double cz1 = values[length - 3].z - results1[length - 3].z - 4.0 * results1[length - 2].z;
                double cx2 = values[length - 2].x - results1[length - 2].x;
                double cy2 = values[length - 2].y - results1[length - 2].y;
                double cz2 = values[length - 2].z - results1[length - 2].z;
                points[0].set((float)((cx1 * bx2 - cx2 * bx1) / (ax1 * bx2 - ax2 * bx1)), (float)((cy1 * by2 - cy2 * by1) / (ay1 * by2 - ay2 * by1)), (float)((cz1 * bz2 - cz2 * bz1) / (az1 * bz2 - az2 * bz1)));
                points[1].set((float)((cx1 * ax2 - cx2 * ax1) / (ax2 * bx1 - ax1 * bx2)), (float)((cy1 * ay2 - cy2 * ay1) / (ay2 * by1 - ay1 * by2)), (float)((cz1 * az2 - cz2 * az1) / (az2 * bz1 - az1 * bz2)));
                for (int i3 = 2; i3 < length - 1; ++i3) {
                    points[i3].set((float)(results1[i3].x + results2[i3].x * (double)points[0].x + results3[i3].x * (double)points[1].x), (float)(results1[i3].y + results2[i3].y * (double)points[0].y + results3[i3].y * (double)points[1].y), (float)(results1[i3].z + results2[i3].z * (double)points[0].z + results3[i3].z * (double)points[1].z));
                }
                points[length - 1] = new Point3f(points[0]);
                points[length] = new Point3f(points[1]);
                points[length + 1] = new Point3f(points[2]);
                controls = points;
            } else {
                Point3f[] points = new Point3f[]{new Point3f(2.0f * path[0].x - path[1].x, 2.0f * path[0].y - path[1].y, 2.0f * path[0].z - path[1].z), new Point3f(path[0]), new Point3f(path[1]), new Point3f(2.0f * path[1].x - path[0].x, 2.0f * path[1].y - path[0].y, 2.0f * path[1].z - path[0].z)};
                controls = points;
            }
        }
        return controls;
    }
}

