/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.jmol.api.JmolViewer;
import org.jmol.util.GT;
import org.openscience.jmol.app.Jmol;
import org.openscience.jmol.app.PovraySaver;

public class PovrayDialog
extends JDialog {
    private JmolViewer viewer;
    protected JButton povrayPathButton;
    protected JTextField commandLineField;
    protected JButton goButton;
    protected JTextField saveField;
    protected JTextField savePathLabel;
    private int outputWidth = -1;
    private int outputHeight = -1;
    protected JTextField povrayPathLabel;
    protected JCheckBox runPovCheck;
    protected JCheckBox useIniCheck;
    protected JCheckBox allFramesCheck;
    protected JCheckBox antiAliasCheck;
    protected JCheckBox displayWhileRenderingCheck;
    private JCheckBox imageSizeCheck;
    private JLabel imageSizeWidth;
    private JFormattedTextField imageSizeTextWidth;
    private JLabel imageSizeHeight;
    private JFormattedTextField imageSizeTextHeight;
    private JCheckBox imageSizeRatioBox;
    private JComboBox imageSizeRatioCombo;
    private JCheckBox outputFormatCheck;
    private JComboBox outputFormatCombo;
    private JCheckBox outputAlphaCheck;
    private JCheckBox mosaicPreviewCheck;
    private JLabel mosaicPreviewStart;
    private JComboBox mosaicPreviewComboStart;
    private JLabel mosaicPreviewEnd;
    private JComboBox mosaicPreviewComboEnd;
    private ActionListener updateActionListener = null;
    private InputVerifier updateInputVerifier = null;
    private ItemListener updateItemListener = null;

    public PovrayDialog(JFrame f, JmolViewer viewer) {
        super(f, GT._("Render in POV-Ray"), true);
        int power;
        this.viewer = viewer;
        String text = null;
        int screenWidth = viewer.getScreenWidth();
        int screenHeight = viewer.getScreenHeight();
        this.setImageDimensions(screenWidth, screenHeight);
        this.updateActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PovrayDialog.this.updateScreen();
            }
        };
        this.updateInputVerifier = new InputVerifier(){

            public boolean verify(JComponent component) {
                PovrayDialog.this.updateScreen();
                return true;
            }
        };
        this.updateItemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                PovrayDialog.this.updateScreen();
            }
        };
        Box windowBox = Box.createVerticalBox();
        this.getContentPane().add(windowBox);
        Box mainBox = Box.createVerticalBox();
        Box justSavingBox = Box.createVerticalBox();
        text = GT._("Jmol-to-POV-Ray Conversion");
        justSavingBox.setBorder(new TitledBorder(text));
        Box saveBox = Box.createHorizontalBox();
        text = GT._("Filename Stem");
        saveBox.setBorder(new TitledBorder(text));
        text = GT._("Single frame: eg 'caffine' -> 'caffine.pov'; Multiple frame: eg 'caffine' -> 'caffine_1.pov', 'caffine_2.pov'");
        saveBox.setToolTipText(text);
        this.saveField = new JTextField("jmol", 20);
        this.saveField.addActionListener(this.updateActionListener);
        this.saveField.setInputVerifier(this.updateInputVerifier);
        saveBox.add(this.saveField);
        justSavingBox.add(saveBox);
        Box savePathBox = Box.createHorizontalBox();
        text = GT._("Working Directory");
        savePathBox.setBorder(new TitledBorder(text));
        text = GT._("Where the .pov files will be saved");
        savePathBox.setToolTipText(text);
        this.savePathLabel = new JTextField("");
        this.savePathLabel.setEditable(false);
        this.savePathLabel.setBorder(null);
        savePathBox.add(this.savePathLabel);
        text = GT._("Select");
        JButton savePathButton = new JButton(text);
        savePathButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PovrayDialog.this.showSavePathDialog();
            }
        });
        savePathBox.add(savePathButton);
        justSavingBox.add(savePathBox);
        mainBox.add(justSavingBox);
        Box povOptionsBox = Box.createVerticalBox();
        text = GT._("POV-Ray Runtime Options");
        povOptionsBox.setBorder(new TitledBorder(text));
        Box runPovBox = Box.createHorizontalBox();
        text = GT._("Run POV-Ray directly");
        this.runPovCheck = new JCheckBox(text, true);
        text = GT._("Launch povray from within Jmol");
        this.runPovCheck.setToolTipText(text);
        this.runPovCheck.addItemListener(this.updateItemListener);
        runPovBox.add(this.runPovCheck);
        runPovBox.add(Box.createGlue());
        povOptionsBox.add(runPovBox);
        Box useIniBox = Box.createHorizontalBox();
        text = GT._("Use .ini file");
        this.useIniCheck = new JCheckBox(text, true);
        text = GT._("Save options in a .ini file");
        this.useIniCheck.setToolTipText(text);
        this.useIniCheck.addItemListener(this.updateItemListener);
        useIniBox.add(this.useIniCheck);
        useIniBox.add(Box.createGlue());
        povOptionsBox.add(useIniBox);
        Box allFramesBox = Box.createHorizontalBox();
        text = GT._("Render all frames");
        this.allFramesCheck = new JCheckBox(text, false);
        text = GT._("Render each model (not only the currently displayed one)");
        this.allFramesCheck.setToolTipText(text);
        this.allFramesCheck.addItemListener(this.updateItemListener);
        allFramesBox.add(this.allFramesCheck);
        allFramesBox.add(Box.createGlue());
        povOptionsBox.add(allFramesBox);
        Box antiAliasBox = Box.createHorizontalBox();
        text = GT._("Turn on POV-Ray anti-aliasing");
        this.antiAliasCheck = new JCheckBox(text, true);
        text = GT._("Use povray's slower but higher quality anti-aliasing mode");
        this.antiAliasCheck.setToolTipText(text);
        this.antiAliasCheck.addItemListener(this.updateItemListener);
        antiAliasBox.add(this.antiAliasCheck);
        antiAliasBox.add(Box.createGlue());
        povOptionsBox.add(antiAliasBox);
        Box displayBox = Box.createHorizontalBox();
        text = GT._("Display While Rendering");
        this.displayWhileRenderingCheck = new JCheckBox(text, true);
        text = GT._("Should povray attempt to display while rendering?");
        this.displayWhileRenderingCheck.setToolTipText(text);
        this.displayWhileRenderingCheck.addItemListener(this.updateItemListener);
        displayBox.add(this.displayWhileRenderingCheck);
        displayBox.add(Box.createGlue());
        povOptionsBox.add(displayBox);
        Box imageBox = Box.createHorizontalBox();
        text = GT._("Image size");
        this.imageSizeCheck = new JCheckBox(text, false);
        text = GT._("Image size");
        this.imageSizeCheck.setToolTipText(text);
        this.imageSizeCheck.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                PovrayDialog.this.imageSizeChanged();
                PovrayDialog.this.updateCommandLine();
            }
        });
        imageBox.add(this.imageSizeCheck);
        imageBox.add(Box.createHorizontalStrut(10));
        Box imageSizeDetailBox = Box.createVerticalBox();
        Box imageSizeXYBox = Box.createHorizontalBox();
        text = GT._("Width : ");
        this.imageSizeWidth = new JLabel(text);
        text = GT._("Image width");
        this.imageSizeWidth.setToolTipText(text);
        imageSizeXYBox.add(this.imageSizeWidth);
        this.imageSizeTextWidth = new JFormattedTextField();
        this.imageSizeTextWidth.setValue(new Integer(this.outputWidth));
        this.imageSizeTextWidth.addPropertyChangeListener("value", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                PovrayDialog.this.imageSizeChanged();
                PovrayDialog.this.updateCommandLine();
            }
        });
        imageSizeXYBox.add(this.imageSizeTextWidth);
        imageSizeXYBox.add(Box.createHorizontalStrut(10));
        text = GT._("Height : ");
        this.imageSizeHeight = new JLabel(text);
        text = GT._("Image height");
        this.imageSizeHeight.setToolTipText(text);
        imageSizeXYBox.add(this.imageSizeHeight);
        this.imageSizeTextHeight = new JFormattedTextField();
        this.imageSizeTextHeight.setValue(new Integer(this.outputHeight));
        this.imageSizeTextHeight.addPropertyChangeListener("value", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                PovrayDialog.this.imageSizeChanged();
                PovrayDialog.this.updateCommandLine();
            }
        });
        imageSizeXYBox.add(this.imageSizeTextHeight);
        imageSizeXYBox.add(Box.createGlue());
        imageSizeDetailBox.add(imageSizeXYBox);
        Box imageSizeBox = Box.createHorizontalBox();
        text = GT._("Fixed ratio : ");
        this.imageSizeRatioBox = new JCheckBox(text, true);
        text = GT._("Use a fixed ratio for width:height");
        this.imageSizeRatioBox.setToolTipText(text);
        this.imageSizeRatioBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                PovrayDialog.this.imageSizeChanged();
                PovrayDialog.this.updateCommandLine();
            }
        });
        imageSizeBox.add(this.imageSizeRatioBox);
        imageSizeBox.add(Box.createHorizontalStrut(10));
        this.imageSizeRatioCombo = new JComboBox();
        text = GT._("User defined");
        this.imageSizeRatioCombo.addItem(text);
        text = GT._("Keep ratio of Jmol window");
        this.imageSizeRatioCombo.addItem(text);
        text = "4:3";
        this.imageSizeRatioCombo.addItem(text);
        text = "16:9";
        this.imageSizeRatioCombo.addItem(text);
        this.imageSizeRatioCombo.setSelectedIndex(1);
        this.imageSizeRatioCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PovrayDialog.this.imageSizeChanged();
                PovrayDialog.this.updateCommandLine();
            }
        });
        imageSizeBox.add(this.imageSizeRatioCombo);
        imageSizeBox.add(Box.createGlue());
        imageSizeDetailBox.add(imageSizeBox);
        imageSizeDetailBox.add(Box.createGlue());
        imageBox.add(imageSizeDetailBox);
        imageBox.add(Box.createGlue());
        povOptionsBox.add(imageBox);
        this.imageSizeChanged();
        Box outputBox = Box.createHorizontalBox();
        text = GT._("Output format : ");
        this.outputFormatCheck = new JCheckBox(text, false);
        text = GT._("Select the file format of the output file");
        this.outputFormatCheck.setToolTipText(text);
        this.outputFormatCheck.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                PovrayDialog.this.outputFormatChanged();
                PovrayDialog.this.updateCommandLine();
            }
        });
        outputBox.add(this.outputFormatCheck);
        this.outputFormatCombo = new JComboBox();
        text = GT._("C - Compressed Targa-24");
        this.outputFormatCombo.addItem(text);
        text = GT._("N - PNG");
        this.outputFormatCombo.addItem(text);
        text = GT._("P - PPM");
        this.outputFormatCombo.addItem(text);
        text = GT._("T - Uncompressed Targa-24");
        this.outputFormatCombo.addItem(text);
        this.outputFormatCombo.setSelectedIndex(3);
        this.outputFormatCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PovrayDialog.this.outputFormatChanged();
                PovrayDialog.this.updateCommandLine();
            }
        });
        outputBox.add(this.outputFormatCombo);
        outputBox.add(Box.createGlue());
        povOptionsBox.add(outputBox);
        this.outputFormatChanged();
        Box alphaBox = Box.createHorizontalBox();
        text = GT._("Alpha transparency");
        this.outputAlphaCheck = new JCheckBox(text, false);
        text = GT._("Output Alpha transparency data");
        this.outputAlphaCheck.setToolTipText(text);
        this.outputAlphaCheck.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                PovrayDialog.this.updateCommandLine();
            }
        });
        alphaBox.add(this.outputAlphaCheck);
        alphaBox.add(Box.createGlue());
        povOptionsBox.add(alphaBox);
        Box mosaicBox = Box.createHorizontalBox();
        text = GT._("Mosaic preview");
        this.mosaicPreviewCheck = new JCheckBox(text, false);
        text = GT._("Render the image in several passes");
        this.mosaicPreviewCheck.setToolTipText(text);
        this.mosaicPreviewCheck.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                PovrayDialog.this.mosaicPreviewChanged();
                PovrayDialog.this.updateCommandLine();
            }
        });
        mosaicBox.add(this.mosaicPreviewCheck);
        mosaicBox.add(Box.createHorizontalStrut(10));
        text = GT._("Start size : ");
        this.mosaicPreviewStart = new JLabel(text);
        text = GT._("Inital size of the tiles");
        this.mosaicPreviewStart.setToolTipText(text);
        mosaicBox.add(this.mosaicPreviewStart);
        this.mosaicPreviewComboStart = new JComboBox();
        for (power = 0; power < 8; ++power) {
            this.mosaicPreviewComboStart.addItem(Integer.toString((int)Math.pow(2.0, power)));
        }
        this.mosaicPreviewComboStart.setSelectedIndex(3);
        this.mosaicPreviewComboStart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PovrayDialog.this.mosaicPreviewChanged();
                PovrayDialog.this.updateCommandLine();
            }
        });
        mosaicBox.add(this.mosaicPreviewComboStart);
        mosaicBox.add(Box.createHorizontalStrut(10));
        text = GT._("End size : ");
        this.mosaicPreviewEnd = new JLabel(text);
        text = GT._("Final size of the tiles");
        this.mosaicPreviewEnd.setToolTipText(text);
        mosaicBox.add(this.mosaicPreviewEnd);
        this.mosaicPreviewComboEnd = new JComboBox();
        for (power = 0; power < 8; ++power) {
            this.mosaicPreviewComboEnd.addItem(Integer.toString((int)Math.pow(2.0, power)));
        }
        this.mosaicPreviewComboEnd.setSelectedIndex(0);
        this.mosaicPreviewComboEnd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PovrayDialog.this.mosaicPreviewChanged();
                PovrayDialog.this.updateCommandLine();
            }
        });
        mosaicBox.add(this.mosaicPreviewComboEnd);
        mosaicBox.add(Box.createGlue());
        povOptionsBox.add(mosaicBox);
        this.mosaicPreviewChanged();
        Box povrayPathBox = Box.createHorizontalBox();
        text = GT._("POV-Ray Executable Location");
        povrayPathBox.setBorder(new TitledBorder(text));
        text = GT._("Location of the povray Executable");
        povrayPathBox.setToolTipText(text);
        this.povrayPathLabel = new JTextField("");
        this.povrayPathLabel.setEditable(false);
        this.povrayPathLabel.setBorder(null);
        povrayPathBox.add(this.povrayPathLabel);
        text = GT._("Select");
        this.povrayPathButton = new JButton(text);
        this.povrayPathButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PovrayDialog.this.showPovrayPathDialog();
            }
        });
        povrayPathBox.add(this.povrayPathButton);
        povOptionsBox.add(povrayPathBox);
        Box commandLineBox = Box.createVerticalBox();
        text = GT._("Command Line to Execute");
        commandLineBox.setBorder(new TitledBorder(text));
        text = GT._("The actual command which will be executed");
        commandLineBox.setToolTipText(text);
        this.commandLineField = new JTextField(30);
        text = GT._("The actual command which will be executed");
        this.commandLineField.setToolTipText(text);
        this.commandLineField.addActionListener(this.updateActionListener);
        commandLineBox.add(this.commandLineField);
        povOptionsBox.add(commandLineBox);
        mainBox.add(povOptionsBox);
        Box buttonBox = Box.createHorizontalBox();
        buttonBox.add(Box.createGlue());
        text = GT._("Go!");
        this.goButton = new JButton(text);
        text = GT._("Save file and possibly launch povray");
        this.goButton.setToolTipText(text);
        this.goButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PovrayDialog.this.goPressed();
            }
        });
        buttonBox.add(this.goButton);
        text = GT._("Cancel");
        JButton cancelButton = new JButton(text);
        text = GT._("Cancel this dialog without saving");
        cancelButton.setToolTipText(text);
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PovrayDialog.this.cancelPressed();
            }
        });
        buttonBox.add(cancelButton);
        windowBox.add(mainBox);
        windowBox.add(buttonBox);
        this.getPathHistory();
        this.updateScreen();
        this.pack();
        this.centerDialog();
        this.setVisible(true);
    }

    public void setImageDimensions(int imageWidth, int imageHeight) {
        this.outputWidth = imageWidth;
        this.outputHeight = imageHeight;
        this.updateCommandLine();
    }

    void goPressed() {
        boolean callPovray;
        boolean useIniFile;
        String basename = this.saveField.getText();
        String filename = basename + ".pov";
        String savePath = this.savePathLabel.getText();
        File theFile = new File(savePath, filename);
        if (theFile != null) {
            try {
                FileOutputStream os = new FileOutputStream(theFile);
                boolean allFrames = false;
                if (this.allFramesCheck != null) {
                    allFrames = this.allFramesCheck.isSelected();
                }
                int width = this.outputWidth;
                int height = this.outputHeight;
                if (this.imageSizeCheck != null && this.imageSizeCheck.isSelected()) {
                    height = Integer.parseInt(this.imageSizeTextHeight.getText());
                    width = Integer.parseInt(this.imageSizeTextWidth.getText());
                }
                PovraySaver povs = new PovraySaver(this.viewer, os, allFrames, width, height);
                povs.writeFile();
            }
            catch (FileNotFoundException fnf) {
                System.out.println("Povray Dialog FileNotFoundException:" + theFile);
                return;
            }
        }
        if (useIniFile = this.useIniCheck.isSelected()) {
            filename = basename + ".ini";
            theFile = new File(savePath, filename);
            try {
                FileWriter os = new FileWriter(theFile);
                this.saveIni(os);
                os.close();
            }
            catch (FileNotFoundException fnf) {
                System.out.println("Povray Dialog FileNotFoundException:" + theFile);
                return;
            }
            catch (IOException ioe) {
                System.out.println("Povray Dialog IOException:" + theFile);
                return;
            }
        }
        if (callPovray = this.runPovCheck.isSelected()) {
            String[] commandLineArgs = null;
            if (useIniFile) {
                if (!savePath.endsWith(File.separator)) {
                    savePath = savePath + File.separator;
                }
                commandLineArgs = new String[]{this.povrayPathLabel.getText(), savePath + filename};
            } else {
                commandLineArgs = this.getCommandLineArgs();
            }
            try {
                Runtime.getRuntime().exec(commandLineArgs);
            }
            catch (IOException e) {
                System.out.println("Caught IOException in povray exec: " + e);
                System.out.println("CmdLine:");
                for (int i = 0; i < commandLineArgs.length; ++i) {
                    System.out.println("  <" + commandLineArgs[i] + ">");
                }
            }
        }
        this.setVisible(false);
        this.saveHistory();
        this.dispose();
    }

    void cancelPressed() {
        this.setVisible(false);
        this.dispose();
    }

    void showSavePathDialog() {
        JFileChooser myChooser = new JFileChooser();
        myChooser.setFileSelectionMode(1);
        int button = myChooser.showDialog(this, GT._("Select"));
        if (button == 0) {
            File newFile = myChooser.getSelectedFile();
            String savePath = newFile.isDirectory() ? newFile.toString() : newFile.getParent().toString();
            this.savePathLabel.setText(savePath);
            this.updateCommandLine();
            this.pack();
        }
    }

    void showPovrayPathDialog() {
        JFileChooser myChooser = new JFileChooser();
        int button = myChooser.showDialog(this, GT._("Select"));
        if (button == 0) {
            File newFile = myChooser.getSelectedFile();
            this.povrayPathLabel.setText(newFile.toString());
            this.updateCommandLine();
            this.pack();
        }
    }

    void imageSizeChanged() {
        if (this.imageSizeCheck != null) {
            boolean selected = this.imageSizeCheck.isSelected();
            boolean enabled = this.runPovCheck.isSelected() || this.useIniCheck.isSelected();
            boolean ratioSelected = false;
            this.imageSizeCheck.setEnabled(enabled);
            if (this.imageSizeRatioBox != null) {
                ratioSelected = this.imageSizeRatioBox.isSelected();
                this.imageSizeRatioBox.setEnabled(selected && enabled);
            }
            if (this.imageSizeWidth != null) {
                this.imageSizeWidth.setEnabled(selected && enabled);
            }
            if (this.imageSizeTextWidth != null) {
                this.imageSizeTextWidth.setEnabled(selected && enabled);
            }
            if (this.imageSizeHeight != null) {
                this.imageSizeHeight.setEnabled(selected && !ratioSelected && enabled);
            }
            if (this.imageSizeTextHeight != null) {
                this.imageSizeTextHeight.setEnabled(selected && !ratioSelected && enabled);
            }
            if (this.imageSizeRatioCombo != null) {
                this.imageSizeRatioCombo.setEnabled(selected && ratioSelected && enabled);
                if (this.imageSizeTextWidth != null && this.imageSizeTextHeight != null) {
                    int width = Integer.parseInt(this.imageSizeTextWidth.getValue().toString());
                    switch (this.imageSizeRatioCombo.getSelectedIndex()) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            int height = (int)((double)width * (double)this.outputHeight / (double)this.outputWidth);
                            this.imageSizeTextHeight.setValue(new Integer(height));
                            break;
                        }
                        case 2: {
                            int height = (int)((double)width * 3.0 / 4.0);
                            this.imageSizeTextHeight.setValue(new Integer(height));
                            break;
                        }
                        case 3: {
                            int height = (int)((double)width * 9.0 / 16.0);
                            this.imageSizeTextHeight.setValue(new Integer(height));
                        }
                    }
                }
            }
        }
    }

    void outputFormatChanged() {
        if (this.outputFormatCheck != null) {
            boolean selected = this.outputFormatCheck.isSelected();
            boolean enabled = this.runPovCheck.isSelected() || this.useIniCheck.isSelected();
            this.outputFormatCheck.setEnabled(enabled);
            if (this.outputFormatCombo != null) {
                this.outputFormatCombo.setEnabled(selected && enabled);
            }
        }
    }

    void mosaicPreviewChanged() {
        if (this.mosaicPreviewCheck != null) {
            boolean selected = this.mosaicPreviewCheck.isSelected();
            boolean enabled = this.runPovCheck.isSelected() || this.useIniCheck.isSelected();
            this.mosaicPreviewCheck.setEnabled(enabled);
            if (this.mosaicPreviewStart != null) {
                this.mosaicPreviewStart.setEnabled(selected && enabled);
            }
            if (this.mosaicPreviewComboStart != null) {
                this.mosaicPreviewComboStart.setEnabled(selected && enabled);
            }
            if (this.mosaicPreviewEnd != null) {
                this.mosaicPreviewEnd.setEnabled(selected && enabled);
            }
            if (this.mosaicPreviewComboEnd != null) {
                this.mosaicPreviewComboEnd.setEnabled(selected && enabled);
            }
        }
    }

    protected void updateScreen() {
        boolean callPovray = false;
        if (this.runPovCheck != null) {
            callPovray = this.runPovCheck.isSelected();
        }
        String text = null;
        text = callPovray ? GT._("Go!") : GT._("Save");
        if (this.goButton != null) {
            this.goButton.setText(text);
        }
        boolean useIni = false;
        if (this.useIniCheck != null) {
            useIni = this.useIniCheck.isSelected();
        }
        if (this.antiAliasCheck != null) {
            this.antiAliasCheck.setEnabled(callPovray || useIni);
        }
        if (this.povrayPathButton != null) {
            this.povrayPathButton.setEnabled(callPovray || useIni);
        }
        if (this.displayWhileRenderingCheck != null) {
            this.displayWhileRenderingCheck.setEnabled(callPovray || useIni);
        }
        if (this.antiAliasCheck != null) {
            this.antiAliasCheck.setEnabled(callPovray || useIni);
        }
        if (this.commandLineField != null) {
            this.commandLineField.setEnabled(callPovray && !useIni);
        }
        this.imageSizeChanged();
        this.outputFormatChanged();
        this.mosaicPreviewChanged();
        this.updateCommandLine();
    }

    protected void updateCommandLine() {
        String basename = null;
        if (this.saveField != null) {
            basename = this.saveField.getText();
        }
        String savePath = null;
        if (this.savePathLabel != null) {
            savePath = this.savePathLabel.getText();
        }
        String povrayPath = null;
        if (this.povrayPathLabel != null) {
            povrayPath = this.povrayPathLabel.getText();
        }
        if (savePath == null || povrayPath == null || basename == null) {
            if (this.commandLineField != null) {
                this.commandLineField.setText(GT._("null component string"));
            }
            return;
        }
        if (!savePath.endsWith(File.separator)) {
            savePath = savePath + File.separator;
        }
        String commandLine = this.doubleQuoteIfContainsSpace(povrayPath) + " +I" + this.simpleQuoteIfContainsSpace(savePath + basename + ".pov");
        String outputExtension = ".tga";
        String outputFileType = " +FT";
        if (this.outputFormatCheck != null && this.outputFormatCheck.isSelected()) {
            switch (this.outputFormatCombo.getSelectedIndex()) {
                case 0: {
                    outputFileType = " +FC";
                    break;
                }
                case 1: {
                    outputExtension = ".png";
                    outputFileType = " +FN";
                    break;
                }
                case 2: {
                    outputExtension = ".ppm";
                    outputFileType = " +FP";
                    break;
                }
            }
        }
        commandLine = commandLine + " +O" + this.simpleQuoteIfContainsSpace(savePath + basename + outputExtension) + outputFileType;
        if (this.outputAlphaCheck != null && this.outputAlphaCheck.isSelected()) {
            commandLine = commandLine + " +UA";
        }
        if (this.imageSizeCheck != null && this.imageSizeCheck.isSelected()) {
            commandLine = commandLine + " +H" + this.imageSizeTextHeight.getValue() + " +W" + this.imageSizeTextWidth.getValue();
        } else if (this.outputWidth > 0 && this.outputHeight > 0) {
            commandLine = commandLine + " +H" + this.outputHeight + " +W" + this.outputWidth;
        }
        if (this.antiAliasCheck != null && this.antiAliasCheck.isSelected()) {
            commandLine = commandLine + " +A0.1";
        }
        if (this.displayWhileRenderingCheck != null && this.displayWhileRenderingCheck.isSelected()) {
            commandLine = commandLine + " +D +P";
        }
        if (this.allFramesCheck != null && this.allFramesCheck.isSelected()) {
            commandLine = commandLine + " +KFI1";
            commandLine = commandLine + " +KFF" + this.viewer.getModelCount();
            commandLine = commandLine + " +KI1";
            commandLine = commandLine + " +KF" + this.viewer.getModelCount();
        }
        if (this.mosaicPreviewCheck != null && this.mosaicPreviewCheck.isSelected()) {
            commandLine = commandLine + " +SP" + this.mosaicPreviewComboStart.getSelectedItem() + " +EP" + this.mosaicPreviewComboEnd.getSelectedItem();
        }
        commandLine = commandLine + " -V";
        if (this.commandLineField != null) {
            this.commandLineField.setText(commandLine);
        }
    }

    private void saveIni(FileWriter os) throws IOException {
        if (os == null) {
            return;
        }
        String savePath = this.savePathLabel.getText();
        if (!savePath.endsWith(File.separator)) {
            savePath = savePath + File.separator;
        }
        String basename = this.saveField.getText();
        os.write("Input_File_Name=" + savePath + basename + ".pov\n");
        String outputExtension = ".tga";
        String outputFileType = "T";
        if (this.outputFormatCheck != null && this.outputFormatCheck.isSelected()) {
            switch (this.outputFormatCombo.getSelectedIndex()) {
                case 0: {
                    outputFileType = "C";
                    break;
                }
                case 1: {
                    outputExtension = ".png";
                    outputFileType = "N";
                    break;
                }
                case 2: {
                    outputExtension = ".ppm";
                    outputFileType = "P";
                    break;
                }
            }
        }
        os.write("Output_to_File=true\n");
        os.write("Output_File_Type=" + outputFileType + "\n");
        os.write("Output_File_Name=" + savePath + basename + outputExtension + "\n");
        if (this.outputAlphaCheck != null && this.outputAlphaCheck.isSelected()) {
            os.write("Output_Alpha=true\n");
        }
        if (this.imageSizeCheck != null && this.imageSizeCheck.isSelected()) {
            os.write("Height=" + this.imageSizeTextHeight.getValue() + "\n");
            os.write("Width=" + this.imageSizeTextWidth.getValue() + "\n");
        } else if (this.outputWidth > 0 && this.outputHeight > 0) {
            os.write("Height=" + this.outputHeight + "\n");
            os.write("Width=" + this.outputWidth + "\n");
        }
        if (this.antiAliasCheck != null && this.antiAliasCheck.isSelected()) {
            os.write("Antialias=true\n");
            os.write("Antialias_Threshold=0.1\n");
        }
        if (this.displayWhileRenderingCheck != null && this.displayWhileRenderingCheck.isSelected()) {
            os.write("Display=true\n");
            os.write("Pause_When_Done=true\n");
        }
        if (this.allFramesCheck != null && this.allFramesCheck.isSelected()) {
            os.write("Initial_Frame=1\n");
            os.write("Final_Frame=" + this.viewer.getModelCount() + "\n");
            os.write("Initial_Clock=1\n");
            os.write("Final_Clock=" + this.viewer.getModelCount() + "\n");
        }
        if (this.mosaicPreviewCheck != null && this.mosaicPreviewCheck.isSelected()) {
            os.write("Preview_Start_Size=" + this.mosaicPreviewComboStart.getSelectedItem() + "\n");
            os.write("Preview_End_Size=" + this.mosaicPreviewComboEnd.getSelectedItem() + "\n");
        }
        os.write("Verbose=false\n");
    }

    private String[] getCommandLineArgs() {
        int end;
        String commandLine = this.commandLineField.getText();
        Vector<String> vector = new Vector<String>();
        int begin = 0;
        int doubleQuoteCount = 0;
        for (end = 0; end < commandLine.length(); ++end) {
            if (commandLine.charAt(end) == '\"') {
                ++doubleQuoteCount;
            }
            if (!Character.isSpaceChar(commandLine.charAt(end))) continue;
            while (begin < end && Character.isSpaceChar(commandLine.charAt(begin))) {
                ++begin;
            }
            if (end <= begin + 1 || doubleQuoteCount % 2 != 0) continue;
            vector.add(commandLine.substring(begin, end));
            begin = end;
        }
        while (begin < end && Character.isSpaceChar(commandLine.charAt(begin))) {
            ++begin;
        }
        if (end > begin + 1) {
            vector.add(commandLine.substring(begin, end));
        }
        String[] args = new String[vector.size()];
        for (int pos = 0; pos < vector.size(); ++pos) {
            args[pos] = vector.get(pos).toString();
            if (args[pos].charAt(0) != '\"' || args[pos].charAt(args[pos].length() - 1) != '\"') continue;
            args[pos] = args[pos].substring(1, args[pos].length() - 1);
        }
        return args;
    }

    protected void centerDialog() {
        Dimension screenSize = this.getToolkit().getScreenSize();
        Dimension size = this.getSize();
        screenSize.height /= 2;
        screenSize.width /= 2;
        size.height /= 2;
        size.width /= 2;
        int y = screenSize.height - size.height;
        int x = screenSize.width - size.width;
        this.setLocation(x, y);
    }

    private void getPathHistory() {
        String savePath;
        String povrayPath;
        Properties props = Jmol.getHistoryFile().getProperties();
        if (this.povrayPathLabel != null && (povrayPath = props.getProperty("povrayPath", System.getProperty("user.home"))) != null) {
            this.povrayPathLabel.setText(povrayPath);
        }
        if (this.savePathLabel != null && (savePath = props.getProperty("povraySavePath", System.getProperty("user.home"))) != null) {
            this.savePathLabel.setText(savePath);
        }
    }

    private void saveHistory() {
        Properties props = new Properties();
        props.setProperty("povrayPath", this.povrayPathLabel.getText());
        props.setProperty("povraySavePath", this.savePathLabel.getText());
        Jmol.getHistoryFile().addProperties(props);
    }

    String doubleQuoteIfContainsSpace(String str) {
        int i = str.length();
        while (--i >= 0) {
            if (str.charAt(i) != ' ') continue;
            return "\"" + str + "\"";
        }
        return str;
    }

    String simpleQuoteIfContainsSpace(String str) {
        int i = str.length();
        while (--i >= 0) {
            if (str.charAt(i) != ' ') continue;
            return "'" + str + "'";
        }
        return str;
    }

    class PovrayWindowListener
    extends WindowAdapter {
        PovrayWindowListener() {
        }

        public void windowClosing(WindowEvent e) {
            PovrayDialog.this.cancelPressed();
            PovrayDialog.this.setVisible(false);
            PovrayDialog.this.dispose();
        }
    }
}

