/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import org.jmol.api.JmolViewer;
import org.jmol.util.GT;

public class MeasurementTable
extends JDialog {
    JmolViewer viewer;
    private JTable measurementTable;
    private MeasurementTableModel measurementTableModel;
    private ListSelectionModel measurementSelection;
    int selectedMeasurementRow = -1;
    JButton deleteButton;
    private JButton deleteAllButton;
    final Class stringClass = "".getClass();

    public MeasurementTable(JmolViewer viewer, JFrame parentFrame) {
        super(parentFrame, GT._("Measurements..."), false);
        this.viewer = viewer;
        JPanel container = new JPanel();
        container.setLayout(new BorderLayout());
        container.add((Component)this.constructMeasurementTable(), "Center");
        JPanel foo = new JPanel();
        foo.setLayout(new BorderLayout());
        foo.add((Component)this.constructMeasurementButtonPanel(), "West");
        foo.add((Component)this.constructDismissButtonPanel(), "East");
        container.add((Component)foo, "South");
        this.addWindowListener(new MeasurementListWindowListener());
        this.getContentPane().add(container);
        this.pack();
        this.centerDialog();
    }

    JComponent constructMeasurementTable() {
        this.measurementTableModel = new MeasurementTableModel();
        this.measurementTable = new JTable(this.measurementTableModel);
        this.measurementTable.setPreferredScrollableViewportSize(new Dimension(300, 100));
        this.measurementTable.getColumnModel().getColumn(0).setPreferredWidth(50);
        int i = 5;
        while (--i > 0) {
            this.measurementTable.getColumnModel().getColumn(i).setPreferredWidth(15);
        }
        this.measurementTable.setSelectionMode(0);
        this.measurementTable.setRowSelectionAllowed(true);
        this.measurementTable.setColumnSelectionAllowed(false);
        this.measurementSelection = this.measurementTable.getSelectionModel();
        this.measurementSelection.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (lsm.isSelectionEmpty()) {
                    MeasurementTable.this.selectedMeasurementRow = -1;
                    MeasurementTable.this.deleteButton.setEnabled(false);
                } else {
                    MeasurementTable.this.selectedMeasurementRow = lsm.getMinSelectionIndex();
                    MeasurementTable.this.deleteButton.setEnabled(true);
                }
            }
        });
        return new JScrollPane(this.measurementTable);
    }

    JComponent constructMeasurementButtonPanel() {
        JPanel measurementButtonPanel = new JPanel();
        measurementButtonPanel.setLayout(new FlowLayout(0));
        this.deleteButton = new JButton(GT._("Delete"));
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MeasurementTable.this.viewer.deleteMeasurement(MeasurementTable.this.selectedMeasurementRow);
                MeasurementTable.this.updateMeasurementTableData();
            }
        });
        this.deleteButton.setEnabled(false);
        this.deleteAllButton = new JButton(GT._("DeleteAll"));
        this.deleteAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MeasurementTable.this.viewer.clearMeasurements();
                MeasurementTable.this.updateMeasurementTableData();
            }
        });
        this.deleteAllButton.setEnabled(false);
        measurementButtonPanel.add(this.deleteAllButton);
        measurementButtonPanel.add(this.deleteButton);
        return measurementButtonPanel;
    }

    JComponent constructDismissButtonPanel() {
        JPanel dismissButtonPanel = new JPanel();
        dismissButtonPanel.setLayout(new FlowLayout(2));
        JButton dismissButton = new JButton(GT._("Dismiss"));
        dismissButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MeasurementTable.this.close();
            }
        });
        dismissButtonPanel.add(dismissButton);
        this.getRootPane().setDefaultButton(dismissButton);
        return dismissButtonPanel;
    }

    protected void centerDialog() {
        Dimension screenSize = this.getToolkit().getScreenSize();
        Dimension size = this.getSize();
        screenSize.height /= 2;
        screenSize.width /= 2;
        size.height /= 2;
        size.width /= 2;
        int y = screenSize.height - size.height;
        int x = screenSize.width - size.width;
        this.setLocation(x, y);
    }

    public void close() {
        this.setVisible(false);
    }

    public void activate() {
        this.updateMeasurementTableData();
        this.show();
    }

    void updateMeasurementTableData() {
        this.deleteAllButton.setEnabled(this.viewer.getMeasurementCount() > 0);
        this.measurementTableModel.fireTableDataChanged();
    }

    public void updateTables() {
        this.updateMeasurementTableData();
    }

    class MeasurementTableModel
    extends AbstractTableModel {
        final String[] measurementHeaders = new String[]{GT._("Value"), "a", "b", "c", "d"};

        MeasurementTableModel() {
        }

        public String getColumnName(int col) {
            return this.measurementHeaders[col];
        }

        public int getRowCount() {
            return MeasurementTable.this.viewer.getMeasurementCount();
        }

        public int getColumnCount() {
            return 5;
        }

        public Class getColumnClass(int col) {
            return MeasurementTable.this.stringClass;
        }

        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return MeasurementTable.this.viewer.getMeasurementStringValue(row);
            }
            int[] countPlusIndices = MeasurementTable.this.viewer.getMeasurementCountPlusIndices(row);
            if (col >= countPlusIndices.length) {
                return null;
            }
            int atomIndex = countPlusIndices[col];
            return "" + MeasurementTable.this.viewer.getAtomNumber(atomIndex) + " " + MeasurementTable.this.viewer.getAtomName(atomIndex);
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }

    class MeasurementListWindowListener
    extends WindowAdapter {
        MeasurementListWindowListener() {
        }

        public void windowClosing(WindowEvent e) {
            MeasurementTable.this.close();
        }
    }
}

