/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app;

import java.io.IOException;
import java.io.Reader;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import org.jmol.api.JmolViewer;
import org.openscience.cdk.Atom;
import org.openscience.cdk.ChemSequence;
import org.openscience.cdk.Molecule;
import org.openscience.cdk.SetOfMolecules;
import org.openscience.cdk.applications.plugin.CDKEditBus;
import org.openscience.cdk.config.AtomTypeFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.geometry.CrystalGeometryTools;
import org.openscience.cdk.geometry.GeometryTools;
import org.openscience.cdk.interfaces.AtomContainer;
import org.openscience.cdk.interfaces.ChemFile;
import org.openscience.cdk.interfaces.ChemModel;
import org.openscience.cdk.tools.manipulator.ChemFileManipulator;

public class JmolEditBus
implements CDKEditBus {
    private static final String APIVersion = "1.8";
    private JmolViewer viewer = null;

    public JmolEditBus(JmolViewer viewer) {
        this.viewer = viewer;
    }

    public String getAPIVersion() {
        return APIVersion;
    }

    public void runScript(String mimeType, String script) {
        if ("chemical/x-rasmol".equals(mimeType)) {
            this.viewer.evalString(script);
        } else {
            System.out.println("Ignoring script with unknown MIME type: " + mimeType);
        }
    }

    public void showChemFile(Reader file) {
        this.viewer.openReader("", "", file);
    }

    public void showChemFile(ChemFile file) {
        AtomContainer atomContainer = ChemFileManipulator.getAllInOneContainer((ChemFile)file);
        org.openscience.cdk.interfaces.Atom[] atoms = atomContainer.getAtoms();
        if (atoms.length == 0) {
            System.err.println("ChemFile does not contain atoms.");
            return;
        }
        if (!GeometryTools.has3DCoordinates(atomContainer) && !CrystalGeometryTools.hasCrystalCoordinates(atomContainer)) {
            System.err.println("Cannot display chemistry without 3D coordinates");
            return;
        }
        try {
            AtomTypeFactory factory = AtomTypeFactory.getInstance("org/openscience/cdk/config/data/jmol_atomtypes.txt");
            for (int i = 0; i < atoms.length; ++i) {
                try {
                    factory.configure(atoms[i]);
                    continue;
                }
                catch (CDKException exception) {
                    System.out.println("Could not configure atom: " + atoms[i]);
                }
            }
        }
        catch (ClassNotFoundException exception) {
            System.err.println(exception.getMessage());
            exception.printStackTrace();
        }
        catch (IOException exception) {
            System.err.println(exception.getMessage());
            exception.printStackTrace();
        }
        this.viewer.openClientFile("", "", file);
    }

    public void showChemModel(ChemModel model) {
        org.openscience.cdk.ChemFile file = new org.openscience.cdk.ChemFile();
        ChemSequence sequence = new ChemSequence();
        sequence.addChemModel(model);
        file.addChemSequence(sequence);
        this.showChemFile(file);
    }

    public ChemModel getChemModel() {
        int i;
        if (this.viewer.getModelCount() != 1) {
            return null;
        }
        org.openscience.cdk.ChemModel model = new org.openscience.cdk.ChemModel();
        SetOfMolecules moleculeSet = new SetOfMolecules();
        Molecule molecule = new Molecule();
        Point3f[] atomPoints = new Point3f[this.viewer.getAtomCount()];
        for (i = 0; i < this.viewer.getAtomCount(); ++i) {
            Atom atom = new Atom(this.viewer.getAtomName(i));
            atomPoints[i] = this.viewer.getAtomPoint3f(i);
            atom.setPoint3d(new Point3d(atomPoints[i]));
            molecule.addAtom(atom);
        }
        for (i = 0; i < this.viewer.getBondCount(); ++i) {
            int j;
            int atomNumber1 = -1;
            int atomNumber2 = -1;
            Point3f atomCoord = this.viewer.getBondPoint3f1(i);
            for (j = 0; j < atomPoints.length; ++j) {
                if (!((double)atomCoord.distance(atomPoints[j]) < 0.01)) continue;
                atomNumber1 = j;
                j = atomPoints.length;
            }
            atomCoord = this.viewer.getBondPoint3f2(i);
            for (j = 0; j < atomPoints.length; ++j) {
                if (!((double)atomCoord.distance(atomPoints[j]) < 0.01)) continue;
                atomNumber2 = j;
                j = atomPoints.length;
            }
            molecule.addBond(atomNumber1, atomNumber2, this.viewer.getBondOrder(i));
        }
        moleculeSet.addMolecule(molecule);
        model.setSetOfMolecules(moleculeSet);
        return model;
    }

    public ChemFile getChemFile() {
        org.openscience.cdk.ChemFile file = new org.openscience.cdk.ChemFile();
        ChemSequence sequence = new ChemSequence();
        sequence.addChemModel(this.getChemModel());
        file.addChemSequence(sequence);
        return file;
    }
}

