/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;
import org.jmol.util.GT;
import org.openscience.jmol.app.JmolResourceHandler;

public class HelpDialog
extends JDialog
implements HyperlinkListener {
    JEditorPane html;

    public HelpDialog(JFrame fr) {
        this(fr, null);
    }

    public HelpDialog(JFrame fr, URL url) {
        super(fr, GT._("Jmol Help"), false);
        try {
            URL helpURL = url;
            if (url == null) {
                helpURL = this.getClass().getClassLoader().getResource(JmolResourceHandler.getStringX("Help.helpURL"));
            }
            this.html = helpURL != null ? new JEditorPane(helpURL) : new JEditorPane("text/plain", GT._("Unable to find url \"{0}\".", new Object[]{JmolResourceHandler.getStringX("Help.helpURL")}));
            this.html.setEditable(false);
            this.html.addHyperlinkListener(this);
        }
        catch (MalformedURLException e) {
            System.out.println("Malformed URL: " + e);
        }
        catch (IOException e) {
            System.out.println("IOException: " + e);
        }
        JScrollPane scroller = new JScrollPane(){

            public Dimension getPreferredSize() {
                return new Dimension(300, 300);
            }

            public float getAlignmentX() {
                return 0.0f;
            }
        };
        scroller.getViewport().add(this.html);
        JPanel htmlWrapper = new JPanel(new BorderLayout());
        htmlWrapper.setAlignmentX(0.0f);
        htmlWrapper.add((Component)scroller, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        JButton ok = new JButton(GT._("OK"));
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HelpDialog.this.OKPressed();
            }
        });
        buttonPanel.add(ok);
        this.getRootPane().setDefaultButton(ok);
        JPanel container = new JPanel();
        container.setLayout(new BorderLayout());
        container.add((Component)htmlWrapper, "Center");
        container.add((Component)buttonPanel, "South");
        this.getContentPane().add(container);
        this.pack();
        this.centerDialog();
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.linkActivated(e.getURL());
        }
    }

    protected void linkActivated(URL u) {
        Cursor c = this.html.getCursor();
        Cursor waitCursor = Cursor.getPredefinedCursor(3);
        this.html.setCursor(waitCursor);
        SwingUtilities.invokeLater(new PageLoader(u, c));
    }

    protected void centerDialog() {
        Dimension screenSize = this.getToolkit().getScreenSize();
        Dimension size = this.getSize();
        screenSize.height /= 2;
        screenSize.width /= 2;
        size.height /= 2;
        size.width /= 2;
        int y = screenSize.height - size.height;
        int x = screenSize.width - size.width;
        this.setLocation(x, y);
    }

    public void OKPressed() {
        this.setVisible(false);
    }

    class PageLoader
    implements Runnable {
        URL url;
        Cursor cursor;

        PageLoader(URL u, Cursor c) {
            this.url = u;
            this.cursor = c;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (this.url == null) {
                HelpDialog.this.html.setCursor(this.cursor);
                Container parent = HelpDialog.this.html.getParent();
                parent.repaint();
            } else {
                Document doc = HelpDialog.this.html.getDocument();
                try {
                    HelpDialog.this.html.setPage(this.url);
                }
                catch (IOException ioe) {
                    HelpDialog.this.html.setDocument(doc);
                    HelpDialog.this.getToolkit().beep();
                }
                finally {
                    this.url = null;
                    SwingUtilities.invokeLater(this);
                }
            }
        }
    }
}

