/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdkplugin.dirbrowser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openscience.cdk.ChemFile;
import org.openscience.cdk.ChemModel;
import org.openscience.cdk.applications.APIVersionTester;
import org.openscience.cdk.applications.plugin.CDKEditBus;
import org.openscience.cdk.applications.plugin.CDKPluginInterface;
import org.openscience.cdk.applications.swing.SortedTableModel;
import org.openscience.cdk.event.ChemObjectChangeEvent;
import org.openscience.cdk.internet.DADMLReader;
import org.openscience.cdk.internet.DADMLResult;
import org.openscience.cdk.io.ChemObjectReader;
import org.openscience.cdk.io.ReaderFactory;
import org.openscience.cdk.tools.LoggingTool;
import org.openscience.cdkplugin.dirbrowser.ResultsContentModel;

public class DadmlBrowserPlugin
implements CDKPluginInterface {
    private final String implementedCDKPluginAPIVersion = "1.11";
    private final String pluginVersion = "0.2";
    private String superdb = "http://jmol.sf.net/super.xml";
    private CDKEditBus editBus = null;
    private ResultsContentModel channelContent = null;
    private SortedTableModel sortedContent = null;
    private JPanel pluginPanel = null;
    private JTextField textField;
    private ReaderFactory readerFactory = null;
    private LoggingTool logger = new LoggingTool(this);
    private JTextField valueText;
    private JComboBox typesBox;
    private Vector indices = new Vector();

    public DadmlBrowserPlugin() {
        this.indices.addElement("CAS-NUMBER");
        this.indices.addElement("pdbid");
    }

    public void start() {
        this.readerFactory = new ReaderFactory(5000);
    }

    public void stop() {
    }

    public void setEditBus(CDKEditBus editBus) {
        this.editBus = editBus;
    }

    public String getName() {
        return "DadmlBrowser";
    }

    public String getAPIVersion() {
        return "1.11";
    }

    public String getPluginVersion() {
        return "0.2";
    }

    public String getPluginLicense() {
        return "GPL";
    }

    public void setPropertyDirectory(String dir) {
        Properties props = this.readProperties(dir);
    }

    public JPanel getPluginPanel() {
        if (this.pluginPanel == null) {
            this.pluginPanel = this.createPanel();
        }
        return this.pluginPanel;
    }

    public void stateChanged(ChemObjectChangeEvent event) {
    }

    private JPanel createPanel() {
        JPanel viewerPanel = new JPanel(new BorderLayout());
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add("Index", this.createBasicPanel());
        tabbedPane.add("URI", this.createURIPanel());
        viewerPanel.add((Component)tabbedPane, "North");
        viewerPanel.add((Component)this.createResultPanel(), "Center");
        viewerPanel.validate();
        return viewerPanel;
    }

    private JPanel createBasicPanel() {
        JPanel basicPanel = new JPanel(new BorderLayout());
        JPanel northPanel = new JPanel();
        this.typesBox = new JComboBox(this.indices);
        JLabel typesLabel = new JLabel("Index: ");
        northPanel.add(typesLabel);
        northPanel.add(this.typesBox);
        JLabel valueLabel = new JLabel("Value: ");
        this.valueText = new JTextField(20);
        this.valueText.addActionListener(new EditAction());
        northPanel.add(valueLabel);
        northPanel.add(this.valueText);
        JButton openButton = new JButton("Search");
        openButton.addActionListener(new OpenAction());
        northPanel.add(openButton);
        basicPanel.add((Component)northPanel, "North");
        return basicPanel;
    }

    private JPanel createURIPanel() {
        JPanel dirPanel = new JPanel();
        dirPanel.setLayout(new FlowLayout(2));
        JButton searchButton = new JButton("Search");
        searchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DadmlBrowserPlugin.this.channelContent.cleanTable();
                DADMLReader reader = new DADMLReader(DadmlBrowserPlugin.this.superdb);
                try {
                    URI uri = new URI(DadmlBrowserPlugin.this.textField.getText());
                    Enumeration links = reader.resolveLinks(uri).elements();
                    while (links.hasMoreElements()) {
                        DADMLResult resource = (DADMLResult)links.nextElement();
                        if (DadmlBrowserPlugin.this.channelContent == null) continue;
                        ChemModel model = new ChemModel();
                        model.setProperty("org.openscience.cdk.internet.DADMLResult", resource);
                        DadmlBrowserPlugin.this.channelContent.addChemModel(model);
                    }
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, "Exception: " + exception.getMessage());
                    DadmlBrowserPlugin.this.logger.debug(exception);
                }
            }
        });
        dirPanel.add(new JLabel("DADML URL:"));
        this.textField = new JTextField();
        this.textField.setColumns(40);
        this.textField.setText("dadml://");
        dirPanel.add(this.textField);
        dirPanel.add(searchButton);
        dirPanel.validate();
        return dirPanel;
    }

    private JPanel createResultPanel() {
        JPanel browserPanel = new JPanel(new BorderLayout());
        this.channelContent = new ResultsContentModel();
        this.sortedContent = new SortedTableModel(this.channelContent);
        JTable channelTable = new JTable(this.sortedContent);
        this.sortedContent.addMouseListenerToHeaderInTable(channelTable);
        channelTable.setSelectionMode(0);
        ListSelectionModel rowSM = channelTable.getSelectionModel();
        rowSM.addListSelectionListener(new ItemsTableListener(this.sortedContent, this.channelContent));
        channelTable.validate();
        JScrollPane contentPane = new JScrollPane(channelTable);
        contentPane.validate();
        browserPanel.add((Component)contentPane, "Center");
        browserPanel.validate();
        return browserPanel;
    }

    public JPanel getPluginConfigPanel() {
        return null;
    }

    public JMenu getMenu() {
        return null;
    }

    private Properties readProperties(String directory) {
        Properties props = null;
        File uhome = new File(System.getProperty("user.home"));
        File propsFile = new File(directory + "/dirbrowser.props");
        this.logger.debug("User plugin dir: " + propsFile);
        this.logger.debug("         exists: " + propsFile.exists());
        if (propsFile.exists()) {
            try {
                FileInputStream fis = new FileInputStream(propsFile);
                props = new Properties();
                props.load(fis);
                fis.close();
            }
            catch (Exception exception) {
                this.logger.error("Error while reading dirbrowser props: " + exception.toString());
            }
        }
        return props;
    }

    class EditAction
    extends AbstractAction {
        EditAction() {
            super("Edit");
            DadmlBrowserPlugin.this.logger.debug("edit action defined");
        }

        public void actionPerformed(ActionEvent e) {
            DadmlBrowserPlugin.this.logger.debug("edit action performed");
        }
    }

    class OpenAction
    extends AbstractAction {
        OpenAction() {
            super("Open");
            DadmlBrowserPlugin.this.logger.debug("open defined");
        }

        public void actionPerformed(ActionEvent event) {
            DadmlBrowserPlugin.this.logger.debug("open action performed");
            DadmlBrowserPlugin.this.channelContent.cleanTable();
            String index = (String)DadmlBrowserPlugin.this.typesBox.getSelectedItem();
            String value = DadmlBrowserPlugin.this.valueText.getText();
            DADMLReader reader = new DADMLReader(DadmlBrowserPlugin.this.superdb);
            try {
                URI uri = new URI("dadml://any/" + index + "?" + value);
                Enumeration links = reader.resolveLinks(uri).elements();
                while (links.hasMoreElements()) {
                    DADMLResult resource = (DADMLResult)links.nextElement();
                    if (DadmlBrowserPlugin.this.channelContent == null) continue;
                    ChemModel model = new ChemModel();
                    model.setProperty("org.openscience.cdk.internet.DADMLResult", resource);
                    DadmlBrowserPlugin.this.channelContent.addChemModel(model);
                }
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, "Exception: " + exception.getMessage());
                DadmlBrowserPlugin.this.logger.debug(exception);
            }
        }
    }

    class ItemsTableListener
    implements ListSelectionListener {
        private SortedTableModel sortedModelContent = null;
        private ResultsContentModel modelContent = null;

        public ItemsTableListener(SortedTableModel sortedModelContent, ResultsContentModel modelContent) {
            this.modelContent = modelContent;
            this.sortedModelContent = sortedModelContent;
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            if (!lsm.isSelectionEmpty()) {
                int selectedRow = lsm.getMinSelectionIndex();
                ChemModel model = this.modelContent.getValueAt(this.sortedModelContent.getSortedIndex(selectedRow));
                DADMLResult resource = (DADMLResult)model.getProperty("org.openscience.cdk.internet.DADMLResult");
                URL url = resource.getURL();
                try {
                    URLConnection connection = url.openConnection();
                    InputStreamReader input = new InputStreamReader(connection.getInputStream());
                    if (APIVersionTester.isBiggerOrEqual("1.8", DadmlBrowserPlugin.this.editBus.getAPIVersion())) {
                        try {
                            DadmlBrowserPlugin.this.editBus.showChemFile(input);
                            return;
                        }
                        catch (Exception exception) {
                            DadmlBrowserPlugin.this.logger.error((Object)"EditBus error: ", exception.getMessage());
                            DadmlBrowserPlugin.this.logger.debug(exception);
                        }
                    }
                    ChemObjectReader reader = DadmlBrowserPlugin.this.readerFactory.createReader(input);
                    ChemFile chemFile = (ChemFile)reader.read(new ChemFile());
                    DadmlBrowserPlugin.this.editBus.showChemFile(chemFile);
                }
                catch (FileNotFoundException exception) {
                    String error = "Resource not found: " + url;
                    DadmlBrowserPlugin.this.logger.error(error);
                    JOptionPane.showMessageDialog(null, error);
                    return;
                }
                catch (Exception exception) {
                    String error = "Error while reading file: " + exception.getMessage();
                    DadmlBrowserPlugin.this.logger.error(error);
                    DadmlBrowserPlugin.this.logger.debug(exception);
                    JOptionPane.showMessageDialog(null, error);
                    return;
                }
                DadmlBrowserPlugin.this.logger.warn("Not displaying model with unknown content");
            }
        }
    }
}

