/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.manipulator;

import java.util.Vector;
import org.openscience.cdk.Atom;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.Bond;
import org.openscience.cdk.ElectronContainer;
import org.openscience.cdk.Reaction;
import org.openscience.cdk.SetOfMolecules;
import org.openscience.cdk.SetOfReactions;
import org.openscience.cdk.tools.manipulator.ReactionManipulator;
import org.openscience.cdk.tools.manipulator.SetOfMoleculesManipulator;

public class SetOfReactionsManipulator {
    public static void removeAtomAndConnectedElectronContainers(SetOfReactions set, Atom atom) {
        int i = 0;
        Reaction[] reactions = set.getReactions();
        if (i < reactions.length) {
            Reaction reaction = reactions[i];
            ReactionManipulator.removeAtomAndConnectedElectronContainers(reaction, atom);
            return;
        }
    }

    public static void removeElectronContainer(SetOfReactions set, ElectronContainer electrons) {
        int i = 0;
        Reaction[] reactions = set.getReactions();
        if (i < reactions.length) {
            Reaction reaction = reactions[i];
            ReactionManipulator.removeElectronContainer(reaction, electrons);
            return;
        }
    }

    public static AtomContainer getAllInOneContainer(SetOfReactions set) {
        AtomContainer container = new AtomContainer();
        Reaction[] reactions = set.getReactions();
        for (int i = 0; i < reactions.length; ++i) {
            Reaction reaction = reactions[i];
            container.add(ReactionManipulator.getAllInOneContainer(reaction));
        }
        return container;
    }

    public static SetOfMolecules getAllMolecules(SetOfReactions set) {
        SetOfMolecules moleculeSet = new SetOfMolecules();
        Reaction[] reactions = set.getReactions();
        for (int i = 0; i < reactions.length; ++i) {
            Reaction reaction = reactions[i];
            moleculeSet.add(ReactionManipulator.getAllMolecules(reaction));
        }
        return moleculeSet;
    }

    public static Vector getAllIDs(SetOfReactions set) {
        Vector IDlist = new Vector();
        Reaction[] reactions = set.getReactions();
        for (int i = 0; i < reactions.length; ++i) {
            Reaction reaction = reactions[i];
            IDlist.addAll(ReactionManipulator.getAllIDs(reaction));
        }
        return IDlist;
    }

    public static AtomContainer[] getAllAtomContainers(SetOfReactions set) {
        return SetOfMoleculesManipulator.getAllAtomContainers(SetOfReactionsManipulator.getAllMolecules(set));
    }

    public static Reaction getRelevantReaction(SetOfReactions set, Atom atom) {
        Reaction[] reactions = set.getReactions();
        for (int i = 0; i < reactions.length; ++i) {
            Reaction reaction = reactions[i];
            AtomContainer container = ReactionManipulator.getRelevantAtomContainer(reaction, atom);
            if (container == null) continue;
            return reaction;
        }
        return null;
    }

    public static Reaction getRelevantReaction(SetOfReactions set, Bond bond) {
        Reaction[] reactions = set.getReactions();
        for (int i = 0; i < reactions.length; ++i) {
            Reaction reaction = reactions[i];
            AtomContainer container = ReactionManipulator.getRelevantAtomContainer(reaction, bond);
            if (container == null) continue;
            return reaction;
        }
        return null;
    }

    public static AtomContainer getRelevantAtomContainer(SetOfReactions set, Atom atom) {
        Reaction[] reactions = set.getReactions();
        for (int i = 0; i < reactions.length; ++i) {
            Reaction reaction = reactions[i];
            AtomContainer container = ReactionManipulator.getRelevantAtomContainer(reaction, atom);
            if (container == null) continue;
            return container;
        }
        return null;
    }

    public static AtomContainer getRelevantAtomContainer(SetOfReactions set, Bond bond) {
        Reaction[] reactions = set.getReactions();
        for (int i = 0; i < reactions.length; ++i) {
            Reaction reaction = reactions[i];
            AtomContainer container = ReactionManipulator.getRelevantAtomContainer(reaction, bond);
            if (container == null) continue;
            return container;
        }
        return null;
    }

    public static void setAtomProperties(SetOfReactions set, Object propKey, Object propVal) {
        Reaction[] reactions = set.getReactions();
        for (int i = 0; i < reactions.length; ++i) {
            Reaction reaction = reactions[i];
            ReactionManipulator.setAtomProperties(reaction, propKey, propVal);
        }
    }
}

