/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.manipulator;

import java.util.Vector;
import org.openscience.cdk.Atom;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.Bond;
import org.openscience.cdk.ElectronContainer;
import org.openscience.cdk.SetOfAtomContainers;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class SetOfAtomContainersManipulator {
    public static void removeAtomAndConnectedElectronContainers(SetOfAtomContainers set, Atom atom) {
        AtomContainer[] acs = set.getAtomContainers();
        for (int i = 0; i < acs.length; ++i) {
            AtomContainer container = acs[i];
            if (!container.contains(atom)) continue;
            container.removeAtomAndConnectedElectronContainers(atom);
            return;
        }
    }

    public static void removeElectronContainer(SetOfAtomContainers set, ElectronContainer electrons) {
        AtomContainer[] acs = set.getAtomContainers();
        for (int i = 0; i < acs.length; ++i) {
            AtomContainer container = acs[i];
            if (!container.contains(electrons)) continue;
            container.removeElectronContainer(electrons);
            return;
        }
    }

    public static AtomContainer getAllInOneContainer(SetOfAtomContainers set) {
        AtomContainer container = new AtomContainer();
        AtomContainer[] acs = set.getAtomContainers();
        for (int i = 0; i < acs.length; ++i) {
            container.add(acs[i]);
        }
        return container;
    }

    public static AtomContainer[] getAllAtomContainers(SetOfAtomContainers set) {
        return set.getAtomContainers();
    }

    public static double getTotalCharge(SetOfAtomContainers set) {
        double charge = 0.0;
        for (int i = 0; i < set.getAtomContainerCount(); ++i) {
            int thisCharge = AtomContainerManipulator.getTotalFormalCharge((AtomContainer)set.getAtomContainer(i));
            double stoich = set.getMultiplier(i);
            charge += stoich * (double)thisCharge;
        }
        return charge;
    }

    public static double getTotalFormalCharge(SetOfAtomContainers set) {
        int charge = 0;
        for (int i = 0; i < set.getAtomContainerCount(); ++i) {
            int thisCharge = AtomContainerManipulator.getTotalFormalCharge((AtomContainer)set.getAtomContainer(i));
            double stoich = set.getMultiplier(i);
            charge = (int)((double)charge + stoich * (double)thisCharge);
        }
        return charge;
    }

    public static int getTotalHydrogenCount(SetOfAtomContainers set) {
        int hCount = 0;
        for (int i = 0; i < set.getAtomContainerCount(); ++i) {
            hCount += AtomContainerManipulator.getTotalHydrogenCount((AtomContainer)set.getAtomContainer(i));
        }
        return hCount;
    }

    public static Vector getAllIDs(SetOfAtomContainers set) {
        Vector<Object> idList = new Vector<Object>();
        if (set != null) {
            if (set.getID() != null) {
                idList.addElement(set.getID());
            }
            for (int i = 0; i < set.getAtomContainerCount(); ++i) {
                idList.add(AtomContainerManipulator.getAllIDs((AtomContainer)set.getAtomContainer(i)));
            }
        }
        return idList;
    }

    public static void setAtomProperties(SetOfAtomContainers set, Object propKey, Object propVal) {
        if (set != null) {
            for (int i = 0; i < set.getAtomContainerCount(); ++i) {
                AtomContainerManipulator.setAtomProperties((AtomContainer)set.getAtomContainer(i), propKey, propVal);
            }
        }
    }

    public static AtomContainer getRelevantAtomContainer(SetOfAtomContainers containerSet, Atom atom) {
        AtomContainer[] containers = containerSet.getAtomContainers();
        for (int i = 0; i < containers.length; ++i) {
            if (!containers[i].contains(atom)) continue;
            return containers[i];
        }
        return null;
    }

    public static AtomContainer getRelevantAtomContainer(SetOfAtomContainers containerSet, Bond bond) {
        AtomContainer[] containers = containerSet.getAtomContainers();
        for (int i = 0; i < containers.length; ++i) {
            if (!containers[i].contains(bond)) continue;
            return containers[i];
        }
        return null;
    }
}

