/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.manipulator;

import java.util.Collections;
import java.util.Vector;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.Bond;
import org.openscience.cdk.Ring;
import org.openscience.cdk.RingSet;
import org.openscience.cdk.interfaces.Atom;
import org.openscience.cdk.tools.manipulator.RingSizeComparator;

public class RingSetManipulator {
    public static AtomContainer getAllInOneContainer(RingSet ringSet) {
        AtomContainer container = new AtomContainer();
        for (int i = 0; i < ringSet.size(); ++i) {
            container.add((Ring)ringSet.elementAt(i));
        }
        return container;
    }

    public static void sort(RingSet ringSet) {
        Collections.sort(ringSet, new RingSizeComparator(1));
    }

    public static Ring getHeaviestRing(RingSet ringSet, Bond bond) {
        Vector rings = ringSet.getRings(bond);
        Ring ring = null;
        int maxOrderSum = 0;
        for (int i = 0; i < rings.size(); ++i) {
            if (maxOrderSum >= ((Ring)rings.elementAt(i)).getOrderSum()) continue;
            ring = (Ring)rings.elementAt(i);
            maxOrderSum = ring.getOrderSum();
        }
        return ring;
    }

    public static Ring getMostComplexRing(RingSet ringSet) {
        int i;
        int[] neighbors = new int[ringSet.size()];
        int mostComplex = 0;
        int mostComplexPosition = 0;
        for (i = 0; i < ringSet.size(); ++i) {
            Ring ring1 = (Ring)ringSet.elementAt(i);
            for (int j = 0; j < ring1.getAtomCount(); ++j) {
                Atom atom1 = ring1.getAtomAt(j);
                block2: for (int k = i + 1; k < ringSet.size(); ++k) {
                    Ring ring2 = (Ring)ringSet.elementAt(k);
                    if (ring1 == ring2) continue;
                    for (int l = 0; l < ring2.getAtomCount(); ++l) {
                        Atom atom2 = ring2.getAtomAt(l);
                        if (atom1 != atom2) continue;
                        int n = i;
                        neighbors[n] = neighbors[n] + 1;
                        int n2 = k;
                        neighbors[n2] = neighbors[n2] + 1;
                        continue block2;
                    }
                }
            }
        }
        for (i = 0; i < neighbors.length; ++i) {
            if (neighbors[i] <= mostComplex) continue;
            mostComplex = neighbors[i];
            mostComplexPosition = i;
        }
        return (Ring)ringSet.elementAt(mostComplexPosition);
    }
}

