/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.manipulator;

import java.util.Vector;
import org.openscience.cdk.Atom;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.Bond;
import org.openscience.cdk.ElectronContainer;
import org.openscience.cdk.Molecule;
import org.openscience.cdk.Reaction;
import org.openscience.cdk.SetOfMolecules;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.SetOfMoleculesManipulator;

public class ReactionManipulator {
    public static void removeAtomAndConnectedElectronContainers(Reaction reaction, Atom atom) {
        Molecule[] reactants = reaction.getReactants().getMolecules();
        for (int i = 0; i < reactants.length; ++i) {
            Molecule mol = reactants[i];
            if (!mol.contains(atom)) continue;
            mol.removeAtomAndConnectedElectronContainers(atom);
        }
        Molecule[] products = reaction.getProducts().getMolecules();
        for (int i = 0; i < products.length; ++i) {
            Molecule mol = products[i];
            if (!mol.contains(atom)) continue;
            mol.removeAtomAndConnectedElectronContainers(atom);
        }
    }

    public static void removeElectronContainer(Reaction reaction, ElectronContainer electrons) {
        Molecule[] reactants = reaction.getReactants().getMolecules();
        for (int i = 0; i < reactants.length; ++i) {
            Molecule mol = reactants[i];
            if (!mol.contains(electrons)) continue;
            mol.removeElectronContainer(electrons);
        }
        Molecule[] products = reaction.getProducts().getMolecules();
        for (int i = 0; i < products.length; ++i) {
            Molecule mol = products[i];
            if (!mol.contains(electrons)) continue;
            mol.removeElectronContainer(electrons);
        }
    }

    public static AtomContainer getAllInOneContainer(Reaction reaction) {
        AtomContainer container = new AtomContainer();
        if (reaction == null) {
            return container;
        }
        Molecule[] reactants = reaction.getReactants().getMolecules();
        for (int i = 0; i < reactants.length; ++i) {
            Molecule molecule = reactants[i];
            container.add(molecule);
        }
        Molecule[] products = reaction.getProducts().getMolecules();
        for (int i = 0; i < products.length; ++i) {
            Molecule molecule = products[i];
            container.add(molecule);
        }
        return container;
    }

    public static SetOfMolecules getAllMolecules(Reaction reaction) {
        SetOfMolecules moleculeSet = new SetOfMolecules();
        Molecule[] reactants = reaction.getReactants().getMolecules();
        for (int i = 0; i < reactants.length; ++i) {
            moleculeSet.addMolecule(reactants[i]);
        }
        Molecule[] products = reaction.getProducts().getMolecules();
        for (int i = 0; i < products.length; ++i) {
            moleculeSet.addMolecule(products[i]);
        }
        return moleculeSet;
    }

    public static Reaction reverse(Reaction reaction) {
        Reaction reversedReaction = new Reaction();
        if (reaction.getDirection() == 3) {
            reversedReaction.setDirection(3);
        } else if (reaction.getDirection() == 1) {
            reversedReaction.setDirection(2);
        } else if (reaction.getDirection() == 2) {
            reversedReaction.setDirection(1);
        }
        Molecule[] reactants = reaction.getReactants().getMolecules();
        for (int i = 0; i < reactants.length; ++i) {
            double coefficient = reaction.getReactantCoefficient(reactants[i]);
            reversedReaction.addProduct(reactants[i], coefficient);
        }
        Molecule[] products = reaction.getProducts().getMolecules();
        for (int i = 0; i < products.length; ++i) {
            double coefficient = reaction.getProductCoefficient(products[i]);
            reversedReaction.addReactant(products[i], coefficient);
        }
        return reversedReaction;
    }

    public static AtomContainer[] getAllAtomContainers(Reaction reaction) {
        return SetOfMoleculesManipulator.getAllAtomContainers(ReactionManipulator.getAllMolecules(reaction));
    }

    public static Vector getAllIDs(Reaction reaction) {
        Vector<String> idList = new Vector<String>();
        if (reaction.getID() != null) {
            idList.addElement(reaction.getID());
        }
        Molecule[] reactants = reaction.getReactants().getMolecules();
        for (int i = 0; i < reactants.length; ++i) {
            Molecule mol = reactants[i];
            idList.addAll(AtomContainerManipulator.getAllIDs(mol));
        }
        Molecule[] products = reaction.getProducts().getMolecules();
        for (int i = 0; i < products.length; ++i) {
            Molecule mol = products[i];
            idList.addAll(AtomContainerManipulator.getAllIDs(mol));
        }
        return idList;
    }

    public static AtomContainer getRelevantAtomContainer(Reaction reaction, Atom atom) {
        AtomContainer result = SetOfMoleculesManipulator.getRelevantAtomContainer((SetOfMolecules)reaction.getReactants(), atom);
        if (result != null) {
            return result;
        }
        return SetOfMoleculesManipulator.getRelevantAtomContainer((SetOfMolecules)reaction.getProducts(), atom);
    }

    public static AtomContainer getRelevantAtomContainer(Reaction reaction, Bond bond) {
        AtomContainer result = SetOfMoleculesManipulator.getRelevantAtomContainer((SetOfMolecules)reaction.getReactants(), bond);
        if (result != null) {
            return result;
        }
        return SetOfMoleculesManipulator.getRelevantAtomContainer((SetOfMolecules)reaction.getProducts(), bond);
    }

    public static void setAtomProperties(Reaction reaction, Object propKey, Object propVal) {
        Molecule[] reactants = reaction.getReactants().getMolecules();
        for (int j = 0; j < reactants.length; ++j) {
            AtomContainerManipulator.setAtomProperties(reactants[j], propKey, propVal);
        }
        Molecule[] products = reaction.getProducts().getMolecules();
        for (int j = 0; j < products.length; ++j) {
            AtomContainerManipulator.setAtomProperties(products[j], propKey, propVal);
        }
    }
}

