/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.manipulator;

import org.openscience.cdk.Atom;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.Bond;
import org.openscience.cdk.ChemModel;
import org.openscience.cdk.ElectronContainer;
import org.openscience.cdk.Molecule;
import org.openscience.cdk.Reaction;
import org.openscience.cdk.SetOfMolecules;
import org.openscience.cdk.SetOfReactions;
import org.openscience.cdk.interfaces.Crystal;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.SetOfMoleculesManipulator;
import org.openscience.cdk.tools.manipulator.SetOfReactionsManipulator;

public class ChemModelManipulator {
    public static void removeAtomAndConnectedElectronContainers(ChemModel chemModel, Atom atom) {
        org.openscience.cdk.interfaces.SetOfReactions reactionSet;
        Crystal crystal = chemModel.getCrystal();
        if (crystal != null) {
            if (crystal.contains(atom)) {
                crystal.removeAtomAndConnectedElectronContainers(atom);
            }
            return;
        }
        org.openscience.cdk.interfaces.SetOfMolecules moleculeSet = chemModel.getSetOfMolecules();
        if (moleculeSet != null) {
            SetOfMoleculesManipulator.removeAtomAndConnectedElectronContainers((SetOfMolecules)moleculeSet, atom);
        }
        if ((reactionSet = chemModel.getSetOfReactions()) != null) {
            SetOfReactionsManipulator.removeAtomAndConnectedElectronContainers((SetOfReactions)reactionSet, atom);
        }
    }

    public static void removeElectronContainer(ChemModel chemModel, ElectronContainer electrons) {
        org.openscience.cdk.interfaces.SetOfReactions reactionSet;
        Crystal crystal = chemModel.getCrystal();
        if (crystal != null) {
            if (crystal.contains(electrons)) {
                crystal.removeElectronContainer(electrons);
            }
            return;
        }
        org.openscience.cdk.interfaces.SetOfMolecules moleculeSet = chemModel.getSetOfMolecules();
        if (moleculeSet != null) {
            SetOfMoleculesManipulator.removeElectronContainer((SetOfMolecules)moleculeSet, electrons);
        }
        if ((reactionSet = chemModel.getSetOfReactions()) != null) {
            SetOfReactionsManipulator.removeElectronContainer((SetOfReactions)reactionSet, electrons);
        }
    }

    public static AtomContainer getAllInOneContainer(ChemModel chemModel) {
        org.openscience.cdk.interfaces.SetOfReactions reactionSet;
        org.openscience.cdk.interfaces.SetOfMolecules moleculeSet;
        AtomContainer container = new AtomContainer();
        Crystal crystal = chemModel.getCrystal();
        if (crystal != null) {
            container.add((AtomContainer)((Object)crystal));
        }
        if ((moleculeSet = chemModel.getSetOfMolecules()) != null) {
            container.add(SetOfMoleculesManipulator.getAllInOneContainer((SetOfMolecules)moleculeSet));
        }
        if ((reactionSet = chemModel.getSetOfReactions()) != null) {
            container.add(SetOfReactionsManipulator.getAllInOneContainer((SetOfReactions)reactionSet));
        }
        return container;
    }

    public static AtomContainer createNewMolecule(ChemModel chemModel) {
        Molecule molecule = new Molecule();
        if (chemModel.getSetOfMolecules() != null) {
            org.openscience.cdk.interfaces.SetOfMolecules moleculeSet = chemModel.getSetOfMolecules();
            moleculeSet.addMolecule(molecule);
        } else {
            SetOfMolecules moleculeSet = new SetOfMolecules();
            moleculeSet.addMolecule(molecule);
            chemModel.setSetOfMolecules(moleculeSet);
        }
        return molecule;
    }

    public static AtomContainer getRelevantAtomContainer(ChemModel chemModel, Atom atom) {
        org.openscience.cdk.interfaces.SetOfMolecules moleculeSet;
        AtomContainer result = null;
        if (chemModel.getSetOfMolecules() != null && (result = SetOfMoleculesManipulator.getRelevantAtomContainer((SetOfMolecules)(moleculeSet = chemModel.getSetOfMolecules()), atom)) != null) {
            return result;
        }
        if (chemModel.getSetOfReactions() != null) {
            org.openscience.cdk.interfaces.SetOfReactions reactionSet = chemModel.getSetOfReactions();
            return SetOfReactionsManipulator.getRelevantAtomContainer((SetOfReactions)reactionSet, atom);
        }
        return null;
    }

    public static AtomContainer getRelevantAtomContainer(ChemModel chemModel, Bond bond) {
        org.openscience.cdk.interfaces.SetOfMolecules moleculeSet;
        AtomContainer result = null;
        if (chemModel.getSetOfMolecules() != null && (result = SetOfMoleculesManipulator.getRelevantAtomContainer((SetOfMolecules)(moleculeSet = chemModel.getSetOfMolecules()), bond)) != null) {
            return result;
        }
        if (chemModel.getSetOfReactions() != null) {
            org.openscience.cdk.interfaces.SetOfReactions reactionSet = chemModel.getSetOfReactions();
            return SetOfReactionsManipulator.getRelevantAtomContainer((SetOfReactions)reactionSet, bond);
        }
        return null;
    }

    public static Reaction getRelevantReaction(ChemModel chemModel, Atom atom) {
        Reaction reaction = null;
        if (chemModel.getSetOfReactions() != null) {
            org.openscience.cdk.interfaces.SetOfReactions reactionSet = chemModel.getSetOfReactions();
            reaction = SetOfReactionsManipulator.getRelevantReaction((SetOfReactions)reactionSet, atom);
        }
        return reaction;
    }

    public static AtomContainer[] getAllAtomContainers(ChemModel chemModel) {
        SetOfMolecules moleculeSet = new SetOfMolecules();
        if (chemModel.getSetOfMolecules() != null) {
            moleculeSet.add((SetOfMolecules)chemModel.getSetOfMolecules());
        }
        if (chemModel.getSetOfReactions() != null) {
            moleculeSet.add(SetOfReactionsManipulator.getAllMolecules((SetOfReactions)chemModel.getSetOfReactions()));
        }
        return SetOfMoleculesManipulator.getAllAtomContainers(moleculeSet);
    }

    public static void setAtomProperties(ChemModel chemModel, Object propKey, Object propVal) {
        if (chemModel.getSetOfMolecules() != null) {
            SetOfMoleculesManipulator.setAtomProperties((SetOfMolecules)chemModel.getSetOfMolecules(), propKey, propVal);
        }
        if (chemModel.getSetOfReactions() != null) {
            SetOfReactionsManipulator.setAtomProperties((SetOfReactions)chemModel.getSetOfReactions(), propKey, propVal);
        }
        if (chemModel.getCrystal() != null) {
            AtomContainerManipulator.setAtomProperties((AtomContainer)((Object)chemModel.getCrystal()), propKey, propVal);
        }
    }
}

