/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.manipulator;

import java.util.Enumeration;
import java.util.Vector;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.ChemFile;
import org.openscience.cdk.ChemModel;
import org.openscience.cdk.ChemSequence;
import org.openscience.cdk.tools.manipulator.ChemSequenceManipulator;

public class ChemFileManipulator {
    public static AtomContainer getAllInOneContainer(ChemFile file) {
        AtomContainer container = new AtomContainer();
        for (int i = 0; i < file.getChemSequenceCount(); ++i) {
            org.openscience.cdk.interfaces.ChemSequence sequence = file.getChemSequence(i);
            container.add(ChemSequenceManipulator.getAllInOneContainer((ChemSequence)sequence));
        }
        return container;
    }

    public static AtomContainer[] getAllAtomContainers(ChemFile file) {
        ChemSequence[] sequences = file.getChemSequences();
        int acCount = 0;
        Vector<AtomContainer[]> acArrays = new Vector<AtomContainer[]>();
        for (int i = 0; i < sequences.length; ++i) {
            AtomContainer[] sequenceContainers = ChemSequenceManipulator.getAllAtomContainers(sequences[i]);
            acArrays.addElement(sequenceContainers);
            acCount += sequenceContainers.length;
        }
        AtomContainer[] containers = new AtomContainer[acCount];
        int arrayOffset = 0;
        Enumeration acArraysElements = acArrays.elements();
        while (acArraysElements.hasMoreElements()) {
            AtomContainer[] modelContainers = (AtomContainer[])acArraysElements.nextElement();
            System.arraycopy(modelContainers, 0, containers, arrayOffset, modelContainers.length);
            arrayOffset += modelContainers.length;
        }
        return containers;
    }

    public static ChemModel[] getAllChemModels(ChemFile file) {
        ChemSequence[] sequences = file.getChemSequences();
        int modelCounter = 0;
        int counter = 0;
        ChemModel[] tempModels = null;
        for (int f = 0; f < sequences.length; ++f) {
            modelCounter += sequences[f].getChemModelCount();
        }
        ChemModel[] models = new ChemModel[modelCounter];
        for (int f = 0; f < sequences.length; ++f) {
            tempModels = sequences[f].getChemModels();
            for (int g = 0; g < tempModels.length; ++g) {
                models[counter] = tempModels[g];
                ++counter;
            }
        }
        return models;
    }
}

