/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.manipulator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.openscience.cdk.Atom;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.AtomType;
import org.openscience.cdk.Bond;
import org.openscience.cdk.ChemObjectListener;
import org.openscience.cdk.ElectronContainer;
import org.openscience.cdk.Element;
import org.openscience.cdk.LonePair;
import org.openscience.cdk.Molecule;

public class AtomContainerManipulator {
    public static void replaceAtomByAtom(AtomContainer container, Atom atom, Atom newAtom) {
        if (!container.contains(atom)) {
            return;
        }
        container.setAtomAt(container.getAtomNumber(atom), newAtom);
        ElectronContainer[] electronContainers = container.getElectronContainers();
        for (int i = 0; i < electronContainers.length; ++i) {
            LonePair lonePair;
            if (electronContainers[i] instanceof Bond) {
                Bond bond = (Bond)electronContainers[i];
                if (!bond.contains(atom)) continue;
                for (int j = 0; j < bond.getAtomCount(); ++j) {
                    if (!atom.equals(bond.getAtomAt(j))) continue;
                    bond.setAtomAt(newAtom, j);
                }
                continue;
            }
            if (!(electronContainers[i] instanceof LonePair) || !atom.equals((lonePair = (LonePair)electronContainers[i]).getAtom())) continue;
            lonePair.setAtom(newAtom);
        }
    }

    public static double getTotalCharge(AtomContainer atomContainer) {
        double charge = 0.0;
        for (int i = 0; i < atomContainer.getAtomCount(); ++i) {
            charge += ((Atom)atomContainer.getAtomAt(i)).getCharge();
        }
        return charge;
    }

    public static int getTotalFormalCharge(AtomContainer atomContainer) {
        int charge = 0;
        for (int i = 0; i < atomContainer.getAtomCount(); ++i) {
            charge += ((AtomType)((Object)atomContainer.getAtomAt(i))).getFormalCharge();
        }
        return charge;
    }

    public static int getTotalHydrogenCount(AtomContainer atomContainer) {
        int hCount = 0;
        for (int i = 0; i < atomContainer.getAtomCount(); ++i) {
            hCount += ((Atom)atomContainer.getAtomAt(i)).getHydrogenCount();
        }
        return hCount;
    }

    public static Vector getAllIDs(AtomContainer mol) {
        Vector<String> idList = new Vector<String>();
        if (mol != null) {
            if (mol.getID() != null) {
                idList.addElement(mol.getID());
            }
            Atom[] atoms = mol.getAtoms();
            for (int i = 0; i < atoms.length; ++i) {
                Atom atom = atoms[i];
                if (atom.getID() == null) continue;
                idList.addElement(atom.getID());
            }
            Bond[] bonds = mol.getBonds();
            for (int i = 0; i < bonds.length; ++i) {
                Bond bond = bonds[i];
                if (bond.getID() == null) continue;
                idList.addElement(bond.getID());
            }
        }
        return idList;
    }

    public static AtomContainer removeHydrogens(AtomContainer atomContainer) {
        int i;
        HashMap<org.openscience.cdk.interfaces.Atom, Atom> map = new HashMap<org.openscience.cdk.interfaces.Atom, Atom>();
        ArrayList<org.openscience.cdk.interfaces.Atom> remove = new ArrayList<org.openscience.cdk.interfaces.Atom>();
        Molecule mol = new Molecule();
        int count = atomContainer.getAtomCount();
        for (i = 0; i < count; ++i) {
            org.openscience.cdk.interfaces.Atom atom = atomContainer.getAtomAt(i);
            if (!((Element)((Object)atom)).getSymbol().equals("H")) {
                Atom clonedAtom = (Atom)((Atom)atom).clone();
                clonedAtom.setHydrogenCount(0);
                mol.addAtom(clonedAtom);
                map.put(atom, clonedAtom);
                continue;
            }
            remove.add(atom);
        }
        count = atomContainer.getBondCount();
        for (i = 0; i < count; ++i) {
            org.openscience.cdk.interfaces.Bond bond = atomContainer.getBondAt(i);
            Atom[] atoms = bond.getAtoms();
            boolean removedBond = false;
            int length = atoms.length;
            for (int k = 0; k < length; ++k) {
                if (!remove.contains(atoms[k])) continue;
                removedBond = true;
                break;
            }
            if (removedBond) continue;
            Bond clone = (Bond)((Bond)atomContainer.getBondAt(i)).clone();
            clone.setAtoms(new Atom[]{(Atom)map.get(atoms[0]), (Atom)map.get(atoms[1])});
            mol.addBond(clone);
        }
        Iterator i2 = remove.iterator();
        while (i2.hasNext()) {
            Iterator n = atomContainer.getConnectedAtomsVector((Atom)i2.next()).iterator();
            while (n.hasNext()) {
                Atom neighb = (Atom)map.get(n.next());
                neighb.setHydrogenCount(neighb.getHydrogenCount() + 1);
            }
        }
        mol.setProperties(atomContainer.getProperties());
        mol.setFlags(atomContainer.getFlags());
        return mol;
    }

    public static void setAtomProperties(AtomContainer container, Object propKey, Object propVal) {
        if (container != null) {
            Atom[] atoms = container.getAtoms();
            for (int i = 0; i < atoms.length; ++i) {
                Atom atom = atoms[i];
                atom.setProperty(propKey, propVal);
            }
        }
    }

    public static void unregisterElectronContainerListeners(AtomContainer container) {
        for (int f = 0; f < container.getElectronContainerCount(); ++f) {
            container.getElectronContainerAt(f).removeListener((ChemObjectListener)container);
        }
    }

    public static void unregisterAtomListeners(AtomContainer container) {
        for (int f = 0; f < container.getAtomCount(); ++f) {
            container.getAtomAt(f).removeListener((ChemObjectListener)container);
        }
    }
}

