/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools;

import java.io.IOException;
import org.openscience.cdk.Atom;
import org.openscience.cdk.AtomType;
import org.openscience.cdk.PseudoAtom;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.tools.ValencyChecker;

public class ValencyHybridChecker
extends ValencyChecker {
    public ValencyHybridChecker() throws IOException, ClassNotFoundException {
        super("org/openscience/cdk/config/data/hybridization_atomtypes.xml");
    }

    public boolean couldMatchAtomType(Atom atom, double bondOrderSum, double maxBondOrder, AtomType type) {
        this.logger.debug("   ... matching atom ", atom, " vs ", type);
        int hcount = atom.getHydrogenCount();
        int charge = atom.getFormalCharge();
        if (charge == type.getFormalCharge() && atom.getHybridization() == type.getHybridization() && bondOrderSum + (double)hcount <= type.getBondOrderSum() && maxBondOrder <= type.getMaxBondOrder()) {
            this.logger.debug("    We have a match!");
            return true;
        }
        this.logger.debug("    No Match");
        return false;
    }

    public int calculateMissingHydrogen(Atom atom, double bondOrderSum, double maxBondOrder, int neighbourCount) throws CDKException {
        int missingHydrogens = 0;
        if (atom instanceof PseudoAtom) {
            this.logger.debug("don't figure it out... it simply does not lack H's");
            return 0;
        }
        this.logger.debug("Calculating number of missing hydrogen atoms");
        AtomType[] atomTypes = this.structgenATF.getAtomTypes(atom.getSymbol());
        if (atomTypes.length == 0) {
            this.logger.warn((Object)"Element not found in configuration file: ", atom);
            return 0;
        }
        int hcount = atom.getHydrogenCount();
        int charge = atom.getFormalCharge();
        this.logger.debug((Object)"Found atomtypes: ", atomTypes.length);
        for (int f = 0; f < atomTypes.length; ++f) {
            AtomType type = atomTypes[f];
            if (!this.couldMatchAtomType(atom, bondOrderSum, maxBondOrder, type)) continue;
            this.logger.debug((Object)"This type matches: ", type);
            int formalNeighbourCount = type.getFormalNeighbourCount();
            if (type.getHybridization() == 0) {
                missingHydrogens = (int)(type.getBondOrderSum() - bondOrderSum);
                break;
            }
            switch (atom.getHybridization()) {
                case 3: {
                    missingHydrogens = formalNeighbourCount - neighbourCount;
                    break;
                }
                case 2: {
                    missingHydrogens = formalNeighbourCount - neighbourCount;
                    break;
                }
                case 1: {
                    missingHydrogens = formalNeighbourCount - neighbourCount;
                    break;
                }
                default: {
                    missingHydrogens = (int)(type.getBondOrderSum() - bondOrderSum);
                    break;
                }
            }
            break;
        }
        this.logger.debug((Object)"missing hydrogens: ", missingHydrogens);
        return missingHydrogens;
    }
}

