/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools;

import java.io.IOException;
import org.openscience.cdk.Atom;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.AtomType;
import org.openscience.cdk.Bond;
import org.openscience.cdk.PseudoAtom;
import org.openscience.cdk.config.AtomTypeFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.tools.LoggingTool;
import org.openscience.cdk.tools.ValencyCheckerInterface;

public class ValencyChecker
implements ValencyCheckerInterface {
    protected AtomTypeFactory structgenATF;
    protected LoggingTool logger;

    public ValencyChecker() throws IOException, ClassNotFoundException {
        this("org/openscience/cdk/config/data/valency_atomtypes.xml");
    }

    public ValencyChecker(String atomTypeList) throws IOException, ClassNotFoundException {
        this.structgenATF = AtomTypeFactory.getInstance(atomTypeList);
        this.logger = new LoggingTool(this);
        this.logger.info((Object)"Using configuration file: ", atomTypeList);
    }

    public boolean isSaturated(Atom atom, AtomContainer container) throws CDKException {
        if (atom instanceof PseudoAtom) {
            this.logger.debug("don't figure it out... it simply does not lack H's");
            return true;
        }
        AtomType[] atomTypes = this.structgenATF.getAtomTypes(atom.getSymbol());
        if (atomTypes.length == 0) {
            this.logger.warn((Object)"Missing entry in atom type list for ", atom.getSymbol());
            return true;
        }
        double bondOrderSum = container.getBondOrderSum(atom);
        double maxBondOrder = container.getMaximumBondOrder(atom);
        int hcount = atom.getHydrogenCount();
        int charge = atom.getFormalCharge();
        this.logger.debug((Object)"Checking saturation of atom ", atom.getSymbol());
        this.logger.debug((Object)"bondOrderSum: ", bondOrderSum);
        this.logger.debug((Object)"maxBondOrder: ", maxBondOrder);
        this.logger.debug((Object)"hcount: ", hcount);
        this.logger.debug((Object)"charge: ", charge);
        boolean elementPlusChargeMatches = false;
        for (int f = 0; f < atomTypes.length; ++f) {
            AtomType type = atomTypes[f];
            if (!this.couldMatchAtomType(atom, bondOrderSum, maxBondOrder, type)) continue;
            if (bondOrderSum + (double)hcount == type.getBondOrderSum() && maxBondOrder <= type.getMaxBondOrder()) {
                this.logger.debug((Object)"We have a match: ", type);
                this.logger.debug((Object)"Atom is saturated: ", atom.getSymbol());
                return true;
            }
            elementPlusChargeMatches = true;
        }
        if (elementPlusChargeMatches) {
            this.logger.debug("No, atom is not saturated.");
            return false;
        }
        throw new CDKException("The atom with element " + atom.getSymbol() + " and charge " + charge + " is not found.");
    }

    public boolean couldMatchAtomType(AtomContainer container, Atom atom, AtomType type) {
        double bondOrderSum = container.getBondOrderSum(atom);
        double maxBondOrder = container.getMaximumBondOrder(atom);
        return this.couldMatchAtomType(atom, bondOrderSum, maxBondOrder, type);
    }

    public boolean couldMatchAtomType(Atom atom, double bondOrderSum, double maxBondOrder, AtomType type) {
        this.logger.debug("   ... matching atom ", atom.getSymbol(), " vs ", type);
        int hcount = atom.getHydrogenCount();
        int charge = atom.getFormalCharge();
        if (charge == type.getFormalCharge() && bondOrderSum + (double)hcount <= type.getBondOrderSum() && maxBondOrder <= type.getMaxBondOrder()) {
            this.logger.debug("    We have a match!");
            return true;
        }
        this.logger.debug("    No Match");
        return false;
    }

    public int calculateMissingHydrogen(Atom atom, AtomContainer container) throws CDKException {
        return this.calculateMissingHydrogen(atom, container.getBondOrderSum(atom), container.getMaximumBondOrder(atom), container.getConnectedAtoms(atom).length);
    }

    public int calculateMissingHydrogen(Atom atom) throws CDKException {
        return this.calculateMissingHydrogen(atom, 0.0, 0.0, 0);
    }

    public int calculateMissingHydrogen(Atom atom, double bondOrderSum, double maxBondOrder, int neighbourCount) throws CDKException {
        int missingHydrogen = 0;
        if (atom instanceof PseudoAtom) {
            this.logger.debug("don't figure it out... it simply does not lack H's");
            return 0;
        }
        this.logger.debug("Calculating number of missing hydrogen atoms");
        AtomType[] atomTypes = this.structgenATF.getAtomTypes(atom.getSymbol());
        if (atomTypes.length == 0) {
            this.logger.warn((Object)"Element not found in configuration file: ", atom);
            return 0;
        }
        int hcount = atom.getHydrogenCount();
        int charge = atom.getFormalCharge();
        this.logger.debug((Object)"Found atomtypes: ", atomTypes.length);
        for (int f = 0; f < atomTypes.length; ++f) {
            AtomType type = atomTypes[f];
            if (!this.couldMatchAtomType(atom, bondOrderSum, maxBondOrder, type)) continue;
            this.logger.debug((Object)"This type matches: ", type);
            missingHydrogen = (int)(type.getBondOrderSum() - bondOrderSum);
            break;
        }
        this.logger.debug((Object)"missing hydrogens: ", missingHydrogen);
        return missingHydrogen;
    }

    public void saturate(AtomContainer atomContainer) throws CDKException {
        this.logger.info("Saturating atomContainer by adjusting bond orders...");
        boolean allSaturated = this.allSaturated(atomContainer);
        if (!allSaturated) {
            this.logger.info("Saturating bond orders is needed...");
            boolean succeeded = this.saturate(atomContainer.getBonds(), atomContainer);
            if (!succeeded) {
                throw new CDKException("Could not saturate this atomContainer!");
            }
        }
    }

    public boolean saturate(Bond[] bonds, AtomContainer atomContainer) throws CDKException {
        this.logger.debug((Object)"Saturating bond set of size: ", bonds.length);
        boolean bondsAreFullySaturated = false;
        if (bonds.length > 0) {
            Bond bond = bonds[0];
            int leftBondCount = bonds.length - 1;
            Bond[] leftBonds = new Bond[leftBondCount];
            System.arraycopy(bonds, 1, leftBonds, 0, leftBondCount);
            this.logger.debug((Object)"Examining this bond: ", bond);
            if (this.isSaturated(bond, atomContainer)) {
                this.logger.debug("OK, bond is saturated, now try to saturate remaining bonds (if needed)");
                bondsAreFullySaturated = this.saturate(leftBonds, atomContainer);
            } else if (this.isUnsaturated(bond, atomContainer)) {
                this.logger.debug("Ok, this bond is unsaturated, and can be saturated");
                this.logger.debug("Option 1: Saturating this bond directly, then trying to saturate rest");
                double increment = 1.0;
                boolean bondOrderIncreased = this.saturateByIncreasingBondOrder(bond, atomContainer, increment);
                boolean bl = bondsAreFullySaturated = bondOrderIncreased && this.saturate(bonds, atomContainer);
                if (bondsAreFullySaturated) {
                    this.logger.debug("Option 1: worked");
                } else {
                    this.logger.debug("Option 1: failed. Trying option 2.");
                    this.logger.debug("Option 2: Saturing this bond by saturating the rest");
                    if (bondOrderIncreased) {
                        this.unsaturateByDecreasingBondOrder(bond, increment);
                    }
                    boolean bl2 = bondsAreFullySaturated = this.saturate(leftBonds, atomContainer) && this.isSaturated(bond, atomContainer);
                    if (!bondsAreFullySaturated) {
                        this.logger.debug("Option 2: failed");
                    }
                }
            } else {
                this.logger.debug("Ok, this bond is unsaturated, but cannot be saturated");
                bondsAreFullySaturated = this.saturate(leftBonds, atomContainer) && this.isSaturated(bond, atomContainer);
            }
        } else {
            bondsAreFullySaturated = true;
        }
        return bondsAreFullySaturated;
    }

    public boolean saturateByIncreasingBondOrder(Bond bond, AtomContainer atomContainer, double increment) throws CDKException {
        Atom[] atoms = bond.getAtoms();
        Atom atom = atoms[0];
        Atom partner = atoms[1];
        this.logger.debug("  saturating bond: ", atom.getSymbol(), "-", partner.getSymbol());
        AtomType[] atomTypes1 = this.structgenATF.getAtomTypes(atom.getSymbol());
        AtomType[] atomTypes2 = this.structgenATF.getAtomTypes(partner.getSymbol());
        for (int atCounter1 = 0; atCounter1 < atomTypes1.length; ++atCounter1) {
            AtomType aType1 = atomTypes1[atCounter1];
            this.logger.debug((Object)"  condidering atom type: ", aType1);
            if (!this.couldMatchAtomType(atomContainer, atom, aType1)) continue;
            this.logger.debug((Object)"  trying atom type: ", aType1);
            for (int atCounter2 = 0; atCounter2 < atomTypes2.length; ++atCounter2) {
                AtomType aType2 = atomTypes2[atCounter2];
                this.logger.debug((Object)"  condidering partner type: ", aType1);
                if (!this.couldMatchAtomType(atomContainer, partner, atomTypes2[atCounter2])) continue;
                this.logger.debug((Object)"    with atom type: ", aType2);
                if (!(bond.getOrder() < aType2.getMaxBondOrder()) || !(bond.getOrder() < aType1.getMaxBondOrder())) continue;
                bond.setOrder(bond.getOrder() + increment);
                this.logger.debug((Object)"Bond order now ", bond.getOrder());
                return true;
            }
        }
        return false;
    }

    public boolean saturate(Bond bond, AtomContainer atomContainer) throws CDKException {
        Atom[] atoms = bond.getAtoms();
        Atom atom = atoms[0];
        Atom partner = atoms[1];
        this.logger.debug("  saturating bond: ", atom.getSymbol(), "-", partner.getSymbol());
        boolean bondOrderIncreased = true;
        while (bondOrderIncreased && this.isUnsaturated(bond, atomContainer)) {
            this.logger.debug("Can increase bond order");
            bondOrderIncreased = this.saturateByIncreasingBondOrder(bond, atomContainer, 1.0);
        }
        return this.isSaturated(bond, atomContainer);
    }

    public boolean isSaturated(AtomContainer container) throws CDKException {
        return this.allSaturated(container);
    }

    public boolean allSaturated(AtomContainer ac) throws CDKException {
        this.logger.debug("Are all atoms saturated?");
        for (int f = 0; f < ac.getAtomCount(); ++f) {
            if (this.isSaturated((Atom)ac.getAtomAt(f), ac)) continue;
            return false;
        }
        return true;
    }

    public boolean isUnsaturated(Bond bond, AtomContainer atomContainer) throws CDKException {
        this.logger.debug((Object)"isBondUnsaturated?: ", bond);
        Atom[] atoms = bond.getAtoms();
        boolean isUnsaturated = true;
        for (int i = 0; i < atoms.length && isUnsaturated; ++i) {
            isUnsaturated = isUnsaturated && !this.isSaturated(atoms[i], atomContainer);
        }
        this.logger.debug((Object)"Bond is unsaturated?: ", isUnsaturated);
        return isUnsaturated;
    }

    public boolean isSaturated(Bond bond, AtomContainer atomContainer) throws CDKException {
        this.logger.debug((Object)"isBondSaturated?: ", bond);
        Atom[] atoms = bond.getAtoms();
        boolean isSaturated = true;
        for (int i = 0; i < atoms.length; ++i) {
            this.logger.debug((Object)"isSaturated(Bond, AC): atom I=", i);
            isSaturated = isSaturated && this.isSaturated(atoms[i], atomContainer);
        }
        this.logger.debug((Object)"isSaturated(Bond, AC): result=", isSaturated);
        return isSaturated;
    }

    public void unsaturate(AtomContainer atomContainer) {
        this.unsaturate(atomContainer.getBonds());
    }

    public void unsaturate(Bond[] bonds) {
        for (int i = 1; i < bonds.length; ++i) {
            bonds[i].setOrder(1.0);
        }
    }

    public boolean unsaturateByDecreasingBondOrder(Bond bond, double decrement) {
        if (bond.getOrder() > decrement) {
            bond.setOrder(bond.getOrder() - decrement);
            return true;
        }
        return false;
    }
}

