/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools;

import java.io.IOException;
import java.util.Vector;
import org.openscience.cdk.Atom;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.AtomType;
import org.openscience.cdk.Bond;
import org.openscience.cdk.ChemObject;
import org.openscience.cdk.Element;
import org.openscience.cdk.Molecule;
import org.openscience.cdk.PseudoAtom;
import org.openscience.cdk.RingSet;
import org.openscience.cdk.config.AtomTypeFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.ringsearch.RingPartitioner;
import org.openscience.cdk.ringsearch.SSSRFinder;
import org.openscience.cdk.tools.LoggingTool;
import org.openscience.cdk.tools.ValencyCheckerInterface;
import org.openscience.cdk.tools.manipulator.RingSetManipulator;

public class SaturationChecker
implements ValencyCheckerInterface {
    AtomTypeFactory structgenATF = AtomTypeFactory.getInstance("org/openscience/cdk/config/data/structgen_atomtypes.xml");
    private LoggingTool logger = new LoggingTool(this);

    public boolean hasPerfectConfiguration(Atom atom, AtomContainer ac) throws CDKException {
        double bondOrderSum = ac.getBondOrderSum(atom);
        double maxBondOrder = ac.getMaximumBondOrder(atom);
        AtomType[] atomTypes = this.structgenATF.getAtomTypes(atom.getSymbol());
        if (atomTypes.length == 0) {
            return true;
        }
        this.logger.debug("*** Checking for perfect configuration ***");
        try {
            this.logger.debug("Checking configuration of atom " + ac.getAtomNumber(atom));
            this.logger.debug("Atom has bondOrderSum = " + bondOrderSum);
            this.logger.debug("Atom has max = " + bondOrderSum);
        }
        catch (Exception exc) {
            // empty catch block
        }
        for (int f = 0; f < atomTypes.length; ++f) {
            if (bondOrderSum != atomTypes[f].getBondOrderSum() || maxBondOrder != atomTypes[f].getMaxBondOrder()) continue;
            try {
                this.logger.debug("Atom " + ac.getAtomNumber(atom) + " has perfect configuration");
            }
            catch (Exception exc) {
                // empty catch block
            }
            return true;
        }
        try {
            this.logger.debug("*** Atom " + ac.getAtomNumber(atom) + " has imperfect configuration ***");
        }
        catch (Exception exc) {
            // empty catch block
        }
        return false;
    }

    public boolean isSaturated(AtomContainer container) throws CDKException {
        return this.allSaturated(container);
    }

    public boolean allSaturated(AtomContainer ac) throws CDKException {
        this.logger.debug("Are all atoms saturated?");
        for (int f = 0; f < ac.getAtomCount(); ++f) {
            if (this.isSaturated((Atom)ac.getAtomAt(f), ac)) continue;
            return false;
        }
        return true;
    }

    public boolean isUnsaturated(Bond bond, AtomContainer atomContainer) throws CDKException {
        Atom[] atoms = bond.getAtoms();
        boolean isUnsaturated = true;
        for (int i = 0; i < atoms.length; ++i) {
            isUnsaturated = isUnsaturated && !this.isSaturated(atoms[i], atomContainer);
        }
        return isUnsaturated;
    }

    public boolean isSaturated(Bond bond, AtomContainer atomContainer) throws CDKException {
        Atom[] atoms = bond.getAtoms();
        boolean isSaturated = true;
        for (int i = 0; i < atoms.length; ++i) {
            isSaturated = isSaturated && this.isSaturated(atoms[i], atomContainer);
        }
        return isSaturated;
    }

    public boolean isSaturated(Atom atom, AtomContainer ac) throws CDKException {
        AtomType[] atomTypes = this.structgenATF.getAtomTypes(atom.getSymbol());
        if (atomTypes.length == 0) {
            return true;
        }
        double bondOrderSum = ac.getBondOrderSum(atom);
        double maxBondOrder = ac.getMaximumBondOrder(atom);
        int hcount = atom.getHydrogenCount();
        int charge = atom.getFormalCharge();
        try {
            this.logger.debug("*** Checking saturation of atom ", atom.getSymbol(), "" + ac.getAtomNumber(atom) + " ***");
            this.logger.debug("bondOrderSum: " + bondOrderSum);
            this.logger.debug("maxBondOrder: " + maxBondOrder);
            this.logger.debug("hcount: " + hcount);
        }
        catch (Exception exc) {
            this.logger.debug(exc);
        }
        for (int f = 0; f < atomTypes.length; ++f) {
            if (bondOrderSum - (double)charge + (double)hcount != atomTypes[f].getBondOrderSum() || !(maxBondOrder <= atomTypes[f].getMaxBondOrder())) continue;
            this.logger.debug("*** Good ! ***");
            return true;
        }
        this.logger.debug("*** Bad ! ***");
        return false;
    }

    public boolean isOverSaturated(Atom atom, AtomContainer ac) throws CDKException {
        AtomType[] atomTypes = this.structgenATF.getAtomTypes(atom.getSymbol());
        if (atomTypes.length == 0) {
            return false;
        }
        double bondOrderSum = ac.getBondOrderSum(atom);
        double maxBondOrder = ac.getMaximumBondOrder(atom);
        int hcount = atom.getHydrogenCount();
        int charge = atom.getFormalCharge();
        try {
            this.logger.debug("*** Checking saturation of atom " + ac.getAtomNumber(atom) + " ***");
            this.logger.debug("bondOrderSum: " + bondOrderSum);
            this.logger.debug("maxBondOrder: " + maxBondOrder);
            this.logger.debug("hcount: " + hcount);
        }
        catch (Exception exc) {
            // empty catch block
        }
        for (int f = 0; f < atomTypes.length; ++f) {
            if (!(bondOrderSum - (double)charge + (double)hcount > atomTypes[f].getBondOrderSum())) continue;
            this.logger.debug("*** Good ! ***");
            return true;
        }
        this.logger.debug("*** Bad ! ***");
        return false;
    }

    public double getCurrentMaxBondOrder(Atom atom, AtomContainer ac) throws CDKException {
        AtomType[] atomTypes = this.structgenATF.getAtomTypes(atom.getSymbol());
        if (atomTypes.length == 0) {
            return 0.0;
        }
        double bondOrderSum = ac.getBondOrderSum(atom);
        int hcount = atom.getHydrogenCount();
        double max = 0.0;
        double current = 0.0;
        for (int f = 0; f < atomTypes.length; ++f) {
            current = (double)hcount + bondOrderSum;
            if (!(atomTypes[f].getBondOrderSum() - current > max)) continue;
            max = atomTypes[f].getBondOrderSum() - current;
        }
        return max;
    }

    public void unsaturate(AtomContainer atomContainer) {
        this.unsaturate(atomContainer.getBonds());
    }

    public void unsaturate(Bond[] bonds) {
        for (int i = 1; i < bonds.length; ++i) {
            bonds[i].setOrder(1.0);
        }
    }

    public void newSaturate(AtomContainer atomContainer) throws CDKException {
        boolean succeeded;
        this.logger.info("Saturating atomContainer by adjusting bond orders...");
        boolean allSaturated = this.allSaturated(atomContainer);
        if (!allSaturated && !(succeeded = this.newSaturate(atomContainer.getBonds(), atomContainer))) {
            throw new CDKException("Could not saturate this atomContainer!");
        }
    }

    public boolean newSaturate(Bond[] bonds, AtomContainer atomContainer) throws CDKException {
        this.logger.debug("Saturating bond set of size: " + bonds.length);
        boolean bondsAreFullySaturated = true;
        if (bonds.length > 0) {
            Bond bond = bonds[0];
            int leftBondCount = bonds.length - 1;
            Bond[] leftBonds = new Bond[leftBondCount];
            System.arraycopy(bonds, 1, leftBonds, 0, leftBondCount);
            if (this.isUnsaturated(bond, atomContainer)) {
                if (leftBondCount > 0) {
                    this.logger.debug("Recursing with unsaturated bond with #bonds: " + leftBondCount);
                    bondsAreFullySaturated = this.newSaturate(leftBonds, atomContainer) && !this.isUnsaturated(bond, atomContainer);
                } else {
                    bondsAreFullySaturated = false;
                }
                if (!bondsAreFullySaturated) {
                    this.logger.debug("First try did not work...");
                    boolean couldSaturate = this.newSaturate(bond, atomContainer);
                    if (couldSaturate) {
                        if (leftBondCount > 0) {
                            this.logger.debug("Recursing with saturated bond with #bonds: " + leftBondCount);
                            bondsAreFullySaturated = this.newSaturate(leftBonds, atomContainer);
                        } else {
                            bondsAreFullySaturated = true;
                        }
                    } else {
                        bondsAreFullySaturated = false;
                    }
                }
            } else if (this.isSaturated(bond, atomContainer)) {
                this.logger.debug("This bond is already saturated.");
                if (leftBondCount > 0) {
                    this.logger.debug("Recursing with #bonds: " + leftBondCount);
                    bondsAreFullySaturated = this.newSaturate(leftBonds, atomContainer);
                } else {
                    bondsAreFullySaturated = true;
                }
            } else {
                this.logger.debug("Cannot saturate this bond");
                if (leftBondCount > 0) {
                    this.logger.debug("Recursing with saturated bond with #bonds: " + leftBondCount);
                    bondsAreFullySaturated = this.newSaturate(leftBonds, atomContainer) && !this.isUnsaturated(bond, atomContainer);
                } else {
                    bondsAreFullySaturated = !this.isUnsaturated(bond, atomContainer);
                }
            }
        }
        this.logger.debug("Is bond set fully saturated?: " + bondsAreFullySaturated);
        this.logger.debug("Returning to level: " + (bonds.length + 1));
        return bondsAreFullySaturated;
    }

    public boolean newSaturate(Bond bond, AtomContainer atomContainer) throws CDKException {
        Atom[] atoms = bond.getAtoms();
        Atom atom = atoms[0];
        Atom partner = atoms[1];
        this.logger.debug("  saturating bond: ", atom.getSymbol(), "-", partner.getSymbol());
        AtomType[] atomTypes1 = this.structgenATF.getAtomTypes(atom.getSymbol());
        AtomType[] atomTypes2 = this.structgenATF.getAtomTypes(partner.getSymbol());
        boolean bondOrderIncreased = true;
        while (bondOrderIncreased && !this.isSaturated(bond, atomContainer)) {
            this.logger.debug("Can increase bond order");
            bondOrderIncreased = false;
            for (int atCounter1 = 0; atCounter1 < atomTypes1.length && !bondOrderIncreased; ++atCounter1) {
                AtomType aType1 = atomTypes1[atCounter1];
                this.logger.debug((Object)"  condidering atom type: ", aType1);
                if (!this.couldMatchAtomType(atomContainer, atom, aType1)) continue;
                this.logger.debug((Object)"  trying atom type: ", aType1);
                for (int atCounter2 = 0; atCounter2 < atomTypes2.length && !bondOrderIncreased; ++atCounter2) {
                    AtomType aType2 = atomTypes2[atCounter2];
                    this.logger.debug((Object)"  condidering partner type: ", aType1);
                    if (!this.couldMatchAtomType(atomContainer, partner, atomTypes2[atCounter2])) continue;
                    this.logger.debug((Object)"    with atom type: ", aType2);
                    if (bond.getOrder() >= aType2.getMaxBondOrder() || bond.getOrder() >= aType1.getMaxBondOrder()) {
                        this.logger.debug("Bond order not increased: atoms has reached (or exceeded) maximum bond order for this atom type");
                        continue;
                    }
                    if (!(bond.getOrder() < aType2.getMaxBondOrder()) || !(bond.getOrder() < aType1.getMaxBondOrder())) continue;
                    bond.setOrder(bond.getOrder() + 1.0);
                    this.logger.debug("Bond order now " + bond.getOrder());
                    bondOrderIncreased = true;
                }
            }
        }
        return this.isSaturated(bond, atomContainer);
    }

    public boolean couldMatchAtomType(AtomContainer atomContainer, Atom atom, AtomType atomType) {
        this.logger.debug("   ... matching atom ", atom.getSymbol(), " vs ", atomType);
        int neighbours = atomContainer.getConnectedAtoms(atom).length;
        if (atomContainer.getBondOrderSum(atom) + (double)atom.getHydrogenCount() < atomType.getBondOrderSum()) {
            this.logger.debug("    Match!");
            return true;
        }
        this.logger.debug("    No Match");
        return false;
    }

    public void saturate(AtomContainer atomContainer) throws CDKException {
        Atom partner = null;
        org.openscience.cdk.interfaces.Atom atom = null;
        Atom[] partners = null;
        AtomType[] atomTypes1 = null;
        AtomType[] atomTypes2 = null;
        Bond bond = null;
        for (int i = 1; i < 4; ++i) {
            block1: for (int f = 0; f < atomContainer.getAtomCount(); ++f) {
                int g;
                atom = atomContainer.getAtomAt(f);
                this.logger.debug((Object)"symbol: ", ((Element)((Object)atom)).getSymbol());
                atomTypes1 = this.structgenATF.getAtomTypes(((Element)((Object)atom)).getSymbol());
                if (atomTypes1.length <= 0) continue;
                this.logger.debug((Object)"first atom type: ", atomTypes1[0]);
                if (atomContainer.getBondCount((Atom)atom) != i) continue;
                if (((ChemObject)((Object)atom)).getFlag(4) && atomContainer.getBondOrderSum((Atom)atom) < atomTypes1[0].getBondOrderSum() - (double)((Atom)atom).getHydrogenCount()) {
                    partners = atomContainer.getConnectedAtoms((Atom)atom);
                    for (g = 0; g < partners.length; ++g) {
                        partner = partners[g];
                        this.logger.debug("Atom has " + partners.length + " partners");
                        atomTypes2 = this.structgenATF.getAtomTypes(partner.getSymbol());
                        if (atomTypes2.length == 0) {
                            return;
                        }
                        if (!atomContainer.getBond(partner, (Atom)atom).getFlag(4) || !(atomContainer.getBondOrderSum(partner) < atomTypes2[0].getBondOrderSum() - (double)partner.getHydrogenCount())) continue;
                        this.logger.debug("Partner has " + atomContainer.getBondOrderSum(partner) + ", may have: " + atomTypes2[0].getBondOrderSum());
                        bond = atomContainer.getBond((Atom)atom, partner);
                        this.logger.debug("Bond order was " + bond.getOrder());
                        bond.setOrder(bond.getOrder() + 1.0);
                        this.logger.debug("Bond order now " + bond.getOrder());
                        break;
                    }
                }
                if (!(atomContainer.getBondOrderSum((Atom)atom) < atomTypes1[0].getBondOrderSum() - (double)((Atom)atom).getHydrogenCount())) continue;
                this.logger.debug("Atom has " + atomContainer.getBondOrderSum((Atom)atom) + ", may have: " + atomTypes1[0].getBondOrderSum());
                partners = atomContainer.getConnectedAtoms((Atom)atom);
                for (g = 0; g < partners.length; ++g) {
                    partner = partners[g];
                    this.logger.debug("Atom has " + partners.length + " partners");
                    atomTypes2 = this.structgenATF.getAtomTypes(partner.getSymbol());
                    if (atomTypes2.length == 0) {
                        return;
                    }
                    if (!(atomContainer.getBondOrderSum(partner) < atomTypes2[0].getBondOrderSum() - (double)partner.getHydrogenCount())) continue;
                    this.logger.debug("Partner has " + atomContainer.getBondOrderSum(partner) + ", may have: " + atomTypes2[0].getBondOrderSum());
                    bond = atomContainer.getBond((Atom)atom, partner);
                    this.logger.debug("Bond order was " + bond.getOrder());
                    bond.setOrder(bond.getOrder() + 1.0);
                    this.logger.debug("Bond order now " + bond.getOrder());
                    continue block1;
                }
            }
        }
    }

    public void saturateRingSystems(AtomContainer atomContainer) throws CDKException {
        RingSet rs = new SSSRFinder(new Molecule(atomContainer)).findSSSR();
        Vector ringSets = RingPartitioner.partitionRings((RingSet)rs);
        AtomContainer ac = null;
        org.openscience.cdk.interfaces.Atom atom = null;
        for (int f = 0; f < ringSets.size(); ++f) {
            int g;
            rs = (RingSet)ringSets.elementAt(f);
            ac = RingSetManipulator.getAllInOneContainer(rs);
            int[] temp = new int[ac.getAtomCount()];
            for (g = 0; g < ac.getAtomCount(); ++g) {
                atom = ac.getAtomAt(g);
                temp[g] = ((Atom)atom).getHydrogenCount();
                ((Atom)atom).setHydrogenCount(atomContainer.getBondCount((Atom)atom) - ac.getBondCount((Atom)atom) - temp[g]);
            }
            this.saturate(ac);
            for (g = 0; g < ac.getAtomCount(); ++g) {
                atom = ac.getAtomAt(g);
                ((Atom)atom).setHydrogenCount(temp[g]);
            }
        }
    }

    public int calculateMissingHydrogen(Atom atom, AtomContainer container) throws CDKException {
        return this.calculateMissingHydrogen(atom, container, false);
    }

    public int calculateMissingHydrogen(Atom atom) throws CDKException {
        Bond[] bonds = new Bond[]{};
        return this.calculateMissingHydrogen(atom, 0.0, bonds, false);
    }

    public int calculateMissingHydrogen(Atom atom, AtomContainer container, boolean throwExceptionForUnknowAtom) throws CDKException {
        return this.calculateMissingHydrogen(atom, container.getBondOrderSum(atom), container.getConnectedBonds(atom), throwExceptionForUnknowAtom);
    }

    public int calculateMissingHydrogen(Atom atom, double bondOrderSum, Bond[] connectedBonds, boolean throwExceptionForUnknowAtom) throws CDKException {
        int missingHydrogen = 0;
        if (!(atom instanceof PseudoAtom)) {
            if (atom.getAtomicNumber() == 1 || atom.getSymbol().equals("H")) {
                missingHydrogen = (int)(1.0 - bondOrderSum - (double)atom.getFormalCharge());
            } else {
                this.logger.info("Calculating number of missing hydrogen atoms");
                AtomType[] atomTypes = this.structgenATF.getAtomTypes(atom.getSymbol());
                if (atomTypes.length == 0 && throwExceptionForUnknowAtom) {
                    return 0;
                }
                this.logger.debug("Found atomtypes: " + atomTypes.length);
                if (atomTypes.length > 0) {
                    AtomType defaultAtom = atomTypes[0];
                    this.logger.debug((Object)"DefAtom: ", defaultAtom);
                    missingHydrogen = (int)(defaultAtom.getBondOrderSum() - bondOrderSum + (double)atom.getFormalCharge());
                    if (atom.getFlag(4)) {
                        boolean subtractOne = true;
                        for (int i = 0; i < connectedBonds.length; ++i) {
                            if (connectedBonds[i].getOrder() != 2.0 && connectedBonds[i].getOrder() != 1.5) continue;
                            subtractOne = false;
                        }
                        if (subtractOne) {
                            --missingHydrogen;
                        }
                    }
                    this.logger.debug((Object)"Atom: ", atom.getSymbol());
                    this.logger.debug("  max bond order: " + defaultAtom.getBondOrderSum());
                    this.logger.debug("  bond order sum: " + bondOrderSum);
                    this.logger.debug("  charge        : " + atom.getFormalCharge());
                } else {
                    this.logger.warn((Object)"Could not find atom type for ", atom.getSymbol());
                }
            }
        }
        return missingHydrogen;
    }
}

