/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools;

import java.util.Iterator;
import java.util.List;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.AtomType;
import org.openscience.cdk.Bond;
import org.openscience.cdk.Molecule;
import org.openscience.cdk.exception.InvalidSmilesException;
import org.openscience.cdk.interfaces.Atom;
import org.openscience.cdk.isomorphism.UniversalIsomorphismTester;
import org.openscience.cdk.isomorphism.mcss.RMap;
import org.openscience.cdk.smiles.SmilesParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Normalizer {
    public static boolean normalize(AtomContainer ac, Document doc) throws InvalidSmilesException {
        NodeList nl = doc.getElementsByTagName("replace-set");
        SmilesParser sp = new SmilesParser();
        boolean change = false;
        for (int i = 0; i < nl.getLength(); ++i) {
            Element child = (Element)nl.item(i);
            NodeList replaces = child.getElementsByTagName("replace");
            NodeList replacement = child.getElementsByTagName("replacement");
            String replacementstring = replacement.item(0).getFirstChild().getNodeValue();
            if (replacementstring.indexOf("\n") > -1 || replacementstring.length() < 1) {
                replacementstring = replacement.item(0).getFirstChild().getNextSibling().getNodeValue();
            }
            Molecule replacementStructure = sp.parseSmiles(replacementstring);
            for (int k = 0; k < replaces.getLength(); ++k) {
                Element replace = (Element)replaces.item(k);
                String replacestring = replace.getFirstChild().getNodeValue();
                if (replacestring.indexOf("\n") > -1 || replacestring.length() < 1) {
                    replacestring = replace.getFirstChild().getNextSibling().getNodeValue();
                }
                Molecule replaceStructure = sp.parseSmiles(replacestring);
                List l = null;
                while ((l = UniversalIsomorphismTester.getSubgraphMap((AtomContainer)ac, (AtomContainer)replaceStructure)) != null) {
                    List l2 = UniversalIsomorphismTester.makeAtomsMapOfBondsMap((List)l, (AtomContainer)ac, (AtomContainer)replaceStructure);
                    Iterator bondit = l.iterator();
                    while (bondit.hasNext()) {
                        RMap rmap = (RMap)bondit.next();
                        org.openscience.cdk.interfaces.Bond acbond = ac.getBondAt(rmap.getId1());
                        org.openscience.cdk.interfaces.Bond replacebond = replacementStructure.getBondAt(rmap.getId2());
                        ((Bond)acbond).setOrder(((Bond)replacebond).getOrder());
                        change = true;
                    }
                    Iterator atomit = l2.iterator();
                    while (atomit.hasNext()) {
                        RMap rmap = (RMap)atomit.next();
                        Atom acatom = ac.getAtomAt(rmap.getId1());
                        Atom replaceatom = replacementStructure.getAtomAt(rmap.getId2());
                        ((AtomType)((Object)acatom)).setFormalCharge(((AtomType)((Object)replaceatom)).getFormalCharge());
                        change = true;
                    }
                }
            }
        }
        return change;
    }
}

