/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import org.openscience.cdk.Atom;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.Bond;
import org.openscience.cdk.Element;
import org.openscience.cdk.Isotope;
import org.openscience.cdk.Molecule;
import org.openscience.cdk.config.IsotopeFactory;
import org.openscience.cdk.tools.ElementComparator;

public class MFAnalyser {
    private static final String H_ELEMENT_SYMBOL = "H";
    private String MF;
    private AtomContainer atomContainer;
    private int HCount = 0;

    public MFAnalyser(String MF) {
        this.MF = MF;
        this.atomContainer = this.analyseMF(MF);
    }

    public MFAnalyser(AtomContainer ac) {
        this.atomContainer = ac;
        this.MF = this.analyseAtomContainer(ac);
    }

    public AtomContainer getAtomContainer() {
        return this.atomContainer;
    }

    public String getMolecularFormula() {
        return this.MF;
    }

    public String getHTMLMolecularFormula() {
        boolean lastCharacterWasDigit = false;
        StringBuffer htmlString = new StringBuffer(this.MF);
        for (int characterCounter = 0; characterCounter <= htmlString.length(); ++characterCounter) {
            boolean currentCharacterIsDigit;
            try {
                currentCharacterIsDigit = Character.isDigit(htmlString.charAt(characterCounter));
            }
            catch (StringIndexOutOfBoundsException oobe) {
                currentCharacterIsDigit = false;
            }
            if (currentCharacterIsDigit && !lastCharacterWasDigit) {
                htmlString.insert(characterCounter, "<sub>");
                characterCounter += 5;
            } else if (lastCharacterWasDigit && !currentCharacterIsDigit) {
                htmlString.insert(characterCounter, "</sub>");
                characterCounter += 6;
            }
            lastCharacterWasDigit = currentCharacterIsDigit;
        }
        return htmlString.toString();
    }

    public float getMass() {
        float mass = 0.0f;
        IsotopeFactory si = null;
        try {
            si = IsotopeFactory.getInstance();
        }
        catch (Exception exception) {
            System.err.println("Could not instantiate the IsotopeFactory: " + exception.getMessage());
        }
        AtomContainer ac = this.getAtomContainer();
        Isotope h = si.getMajorIsotope(H_ELEMENT_SYMBOL);
        for (int f = 0; f < ac.getAtomCount(); ++f) {
            Isotope i = si.getMajorIsotope(((Element)((Object)ac.getAtomAt(f))).getSymbol());
            if (i == null) {
                return 0.0f;
            }
            mass = (float)((double)mass + i.exactMass);
            mass = (float)((double)mass + (double)((Atom)ac.getAtomAt(f)).getHydrogenCount() * h.exactMass);
        }
        return mass;
    }

    public double getNaturalMass(Element element) throws IOException, ClassNotFoundException {
        Isotope[] isotopes = IsotopeFactory.getInstance().getIsotopes(element.getSymbol());
        double summedAbundances = 0.0;
        double summedWeightedAbundances = 0.0;
        for (int i = 0; i < isotopes.length; ++i) {
            summedAbundances += isotopes[i].getNaturalAbundance();
            summedWeightedAbundances += isotopes[i].getNaturalAbundance() * isotopes[i].getExactMass();
        }
        return summedWeightedAbundances / summedAbundances;
    }

    public float getNaturalMass() throws IOException, ClassNotFoundException {
        float mass = 0.0f;
        IsotopeFactory si = null;
        try {
            si = IsotopeFactory.getInstance();
        }
        catch (Exception exception) {
            System.err.println("Could not instantiate the IsotopeFactory: " + exception.getMessage());
        }
        AtomContainer ac = this.getAtomContainer();
        Isotope h = si.getMajorIsotope(H_ELEMENT_SYMBOL);
        for (int f = 0; f < ac.getAtomCount(); ++f) {
            Element i = si.getElement(((Element)((Object)ac.getAtomAt(f))).getSymbol());
            if (i == null) {
                return 0.0f;
            }
            mass = (float)((double)mass + this.getNaturalMass(i));
            mass = (float)((double)mass + (double)((Atom)ac.getAtomAt(f)).getHydrogenCount() * this.getNaturalMass(h));
        }
        return mass;
    }

    public AtomContainer removeHydrogensPreserveMultiplyBonded() {
        AtomContainer ac = this.getAtomContainer();
        ArrayList h = new ArrayList();
        ArrayList<Atom> multi_h = new ArrayList<Atom>();
        int count = ac.getBondCount();
        for (int i = 0; i < count; ++i) {
            Atom[] atoms = ac.getBondAt(i).getAtoms();
            int length = atoms.length;
            for (int k = 0; k < length; ++k) {
                Atom atom = atoms[k];
                if (!atom.getSymbol().equals(H_ELEMENT_SYMBOL)) continue;
                (h.contains(atom) ? multi_h : h).add(atom);
            }
        }
        return this.removeHydrogens(multi_h);
    }

    private AtomContainer removeHydrogens(List preserve) {
        int i;
        AtomContainer ac = this.getAtomContainer();
        HashMap<org.openscience.cdk.interfaces.Atom, Atom> map = new HashMap<org.openscience.cdk.interfaces.Atom, Atom>();
        ArrayList<org.openscience.cdk.interfaces.Atom> remove = new ArrayList<org.openscience.cdk.interfaces.Atom>();
        Molecule mol = new Molecule();
        int count = ac.getAtomCount();
        for (i = 0; i < count; ++i) {
            org.openscience.cdk.interfaces.Atom atom = ac.getAtomAt(i);
            if (!((Element)((Object)atom)).getSymbol().equals(H_ELEMENT_SYMBOL) || preserve.contains(atom)) {
                Atom a = (Atom)((Atom)atom).clone();
                a.setHydrogenCount(0);
                mol.addAtom(a);
                map.put(atom, a);
                continue;
            }
            remove.add(atom);
        }
        count = ac.getBondCount();
        for (i = 0; i < count; ++i) {
            org.openscience.cdk.interfaces.Bond bond = ac.getBondAt(i);
            Atom[] atoms = bond.getAtoms();
            boolean remove_bond = false;
            int length = atoms.length;
            for (int k = 0; k < length; ++k) {
                if (!remove.contains(atoms[k])) continue;
                remove_bond = true;
                break;
            }
            if (remove_bond) continue;
            Bond clone = (Bond)((Bond)ac.getBondAt(i)).clone();
            clone.setAtoms(new Atom[]{(Atom)map.get(atoms[0]), (Atom)map.get(atoms[1])});
            mol.addBond(clone);
        }
        Iterator i2 = remove.iterator();
        while (i2.hasNext()) {
            Iterator n = ac.getConnectedAtomsVector((Atom)i2.next()).iterator();
            while (n.hasNext()) {
                Atom neighb = (Atom)map.get(n.next());
                neighb.setHydrogenCount(neighb.getHydrogenCount() + 1);
            }
        }
        return mol;
    }

    public List getHeavyAtoms() {
        ArrayList<org.openscience.cdk.interfaces.Atom> newAc = new ArrayList<org.openscience.cdk.interfaces.Atom>();
        AtomContainer ac = this.getAtomContainer();
        for (int f = 0; f < ac.getAtomCount(); ++f) {
            if (((Element)((Object)ac.getAtomAt(f))).getSymbol().equals(H_ELEMENT_SYMBOL)) continue;
            newAc.add(ac.getAtomAt(f));
        }
        return newAc;
    }

    private AtomContainer analyseMF(String MF) {
        AtomContainer ac = new AtomContainer();
        String RecentElementSymbol = new String();
        String RecentElementCountString = new String("0");
        if (MF.length() == 0) {
            return null;
        }
        for (int f = 0; f < MF.length(); ++f) {
            char ThisChar = MF.charAt(f);
            if (f < MF.length()) {
                if (ThisChar >= 'A' && ThisChar <= 'Z') {
                    RecentElementSymbol = String.valueOf(ThisChar);
                    RecentElementCountString = "0";
                }
                if (ThisChar >= 'a' && ThisChar <= 'z') {
                    RecentElementSymbol = RecentElementSymbol + ThisChar;
                }
                if (ThisChar >= '0' && ThisChar <= '9') {
                    RecentElementCountString = RecentElementCountString + ThisChar;
                }
            }
            if (f != MF.length() - 1 && (MF.charAt(f + 1) < 'A' || MF.charAt(f + 1) > 'Z')) continue;
            Integer RecentElementCountInteger = new Integer(RecentElementCountString);
            int RecentElementCount = RecentElementCountInteger;
            if (RecentElementCount == 0) {
                RecentElementCount = 1;
            }
            for (int g = 0; g < RecentElementCount; ++g) {
                ac.addAtom(new Atom(RecentElementSymbol));
            }
        }
        return ac;
    }

    public String analyseAtomContainer(AtomContainer ac) {
        String mf = "";
        TreeMap<String, Integer> symbols = new TreeMap<String, Integer>();
        int HCount = 0;
        org.openscience.cdk.interfaces.Atom atom = null;
        for (int f = 0; f < ac.getAtomCount(); ++f) {
            atom = ac.getAtomAt(f);
            String symbol = ((Element)((Object)atom)).getSymbol();
            if (((Atom)atom).getHydrogenCount() > 0) {
                HCount += ((Atom)atom).getHydrogenCount();
            }
            if (symbols.get(symbol) != null) {
                symbols.put(symbol, new Integer((Integer)symbols.get(symbol) + 1));
                continue;
            }
            symbols.put(symbol, new Integer(1));
        }
        mf = this.addSymbolToFormula(symbols, "C", mf);
        if (symbols.get(H_ELEMENT_SYMBOL) != null) {
            mf = this.addSymbolToFormula(symbols, H_ELEMENT_SYMBOL, mf);
        } else if (HCount > 0) {
            mf = mf + H_ELEMENT_SYMBOL;
            if (HCount > 1) {
                mf = mf + Integer.toString(HCount);
            }
        }
        mf = this.addSymbolToFormula(symbols, "N", mf);
        mf = this.addSymbolToFormula(symbols, "O", mf);
        mf = this.addSymbolToFormula(symbols, "S", mf);
        mf = this.addSymbolToFormula(symbols, "P", mf);
        Iterator it = symbols.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            if (((String)key).equals("C") || ((String)key).equals(H_ELEMENT_SYMBOL) || ((String)key).equals("N") || ((String)key).equals("O") || ((String)key).equals("S") || ((String)key).equals("P")) continue;
            mf = this.addSymbolToFormula(symbols, (String)key, mf);
        }
        this.HCount = HCount;
        return mf;
    }

    private String addSymbolToFormula(SortedMap sm, String symbol, String formula) {
        if (sm.get(symbol) != null) {
            formula = formula + symbol;
            if (!sm.get(symbol).equals(new Integer(1))) {
                formula = formula + sm.get(symbol).toString();
            }
        }
        return formula;
    }

    public int getAtomCount(String thisElement) {
        int atomCount = 0;
        if (thisElement.equals(H_ELEMENT_SYMBOL) && this.HCount > 0) {
            return this.HCount;
        }
        for (int f = 0; f < this.atomContainer.getAtomCount(); ++f) {
            if (!((Element)((Object)this.atomContainer.getAtomAt(f))).getSymbol().equals(thisElement)) continue;
            ++atomCount;
        }
        return atomCount;
    }

    public Vector getElements() {
        TreeSet<String> elements = new TreeSet<String>(new ElementComparator());
        for (int f = 0; f < this.atomContainer.getAtomCount(); ++f) {
            String symbol = ((Element)((Object)this.atomContainer.getAtomAt(f))).getSymbol();
            if (elements.contains(symbol)) continue;
            elements.add(symbol);
        }
        Vector<String> results = new Vector<String>();
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            results.add((String)iter.next());
        }
        return results;
    }

    public int getElementCount() {
        return this.getElements().size();
    }

    public static String generateElementFormula(Molecule mol, String[] elements) {
        int i;
        int num = elements.length;
        StringBuffer formula = new StringBuffer();
        int[] elementCount = new int[num];
        for (i = 0; i < mol.getAtomCount(); ++i) {
            for (int j = 0; j < num; ++j) {
                if (!elements[j].equals(((Element)((Object)mol.getAtomAt(i))).getSymbol())) continue;
                int n = j;
                elementCount[n] = elementCount[n] + 1;
            }
        }
        for (i = 0; i < num; ++i) {
            formula.append(elements[i] + elementCount[i]);
        }
        return formula.toString();
    }

    public Hashtable getFormulaHashtable() {
        Hashtable formula = new Hashtable();
        Vector elements = this.getElements();
        for (int i = 0; i < elements.size(); ++i) {
            Integer numOfAtom = new Integer(this.getAtomCount((String)elements.get(i)));
            formula.put(elements.get(i), numOfAtom);
        }
        return formula;
    }
}

