/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools;

import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import org.apache.log4j.Category;
import org.apache.log4j.PropertyConfigurator;

public class LoggingTool {
    private boolean debug = false;
    private boolean tostdout = false;
    private Category log4jLogger;
    private LoggingTool logger = this;
    private String classname;
    private int stackLength = 5;
    public final int DEFAULT_STACK_LENGTH = 5;
    static /* synthetic */ Class class$org$openscience$cdk$tools$LoggingTool;

    public LoggingTool() {
        this(class$org$openscience$cdk$tools$LoggingTool == null ? (class$org$openscience$cdk$tools$LoggingTool = LoggingTool.class$("org.openscience.cdk.tools.LoggingTool")) : class$org$openscience$cdk$tools$LoggingTool);
    }

    public LoggingTool(Object object) {
        this(object.getClass());
    }

    public LoggingTool(Class classInst) {
        this.classname = classInst.getName();
        try {
            this.log4jLogger = Category.getInstance((String)this.classname);
        }
        catch (ClassNotFoundException e) {
            this.tostdout = true;
            this.logger.debug("Log4J class not found!");
        }
        catch (NoClassDefFoundError e) {
            this.tostdout = true;
            this.logger.debug("Log4J class not found!");
        }
        catch (NullPointerException e) {
            this.tostdout = true;
            this.logger.debug("Properties file not found!");
        }
        catch (Exception e) {
            this.tostdout = true;
            this.logger.debug((Object)"Unknown error occured: ", e.getMessage());
        }
        this.debug = false;
        String strJvmVersion = System.getProperty("java.version");
        if (strJvmVersion.compareTo("1.2") >= 0) {
            try {
                if (System.getProperty("cdk.debugging", "false").equals("true")) {
                    this.debug = true;
                }
                if (System.getProperty("cdk.debug.stdout", "false").equals("true")) {
                    this.tostdout = true;
                }
            }
            catch (Exception e) {
                this.logger.debug("guessed what happened: security exception thrown by applet runner");
                this.logger.debug("  therefore, do not debug");
            }
        }
    }

    public static void configureLog4j() {
        LoggingTool localLogger = new LoggingTool(class$org$openscience$cdk$tools$LoggingTool == null ? (class$org$openscience$cdk$tools$LoggingTool = LoggingTool.class$("org.openscience.cdk.tools.LoggingTool")) : class$org$openscience$cdk$tools$LoggingTool);
        try {
            PropertyConfigurator.configure((URL)(class$org$openscience$cdk$tools$LoggingTool == null ? (class$org$openscience$cdk$tools$LoggingTool = LoggingTool.class$("org.openscience.cdk.tools.LoggingTool")) : class$org$openscience$cdk$tools$LoggingTool).getResource("/org/openscience/cdk/config/data/log4j.properties"));
        }
        catch (NullPointerException e) {
            localLogger.error((Object)"Properties file not found: ", e.getMessage());
            localLogger.debug(e);
        }
        catch (Exception e) {
            localLogger.error((Object)"Unknown error occured: ", e.getMessage());
            localLogger.debug(e);
        }
    }

    public void dumpSystemProperties() {
        this.debug("os.name        : " + System.getProperty("os.name"));
        this.debug("os.version     : " + System.getProperty("os.version"));
        this.debug("os.arch        : " + System.getProperty("os.arch"));
        this.debug("java.version   : " + System.getProperty("java.version"));
        this.debug("java.vendor    : " + System.getProperty("java.vendor"));
    }

    public void setStackLength(int length) {
        this.stackLength = length;
    }

    public void dumpClasspath() {
        this.debug("java.class.path: " + System.getProperty("java.class.path"));
    }

    public void debug(Object object) {
        if (this.debug) {
            if (object instanceof Throwable) {
                this.debugThrowable((Throwable)object);
            } else {
                this.debugString("" + object.toString());
            }
        }
    }

    private void debugString(String string) {
        if (this.tostdout) {
            this.toSTDOUT("DEBUG", string);
        } else {
            this.log4jLogger.debug((Object)string);
        }
    }

    public void debug(Object object, Object object2) {
        if (this.debug) {
            this.debugString("" + object + object2);
        }
    }

    public void debug(Object object, int number) {
        if (this.debug) {
            this.debugString("" + object + number);
        }
    }

    public void debug(Object object, double number) {
        if (this.debug) {
            this.debugString("" + object + number);
        }
    }

    public void debug(Object object, boolean bool) {
        if (this.debug) {
            this.debugString("" + object + bool);
        }
    }

    public void debug(Object obj, Object obj2, Object obj3) {
        if (this.debug) {
            this.debugString("" + obj + obj2 + obj3);
        }
    }

    public void debug(Object obj, Object obj2, Object obj3, Object obj4) {
        if (this.debug) {
            this.debugString("" + obj + obj2 + obj3 + obj4);
        }
    }

    public void debug(Object obj, Object obj2, Object obj3, Object obj4, Object obj5) {
        if (this.debug) {
            this.debugString("" + obj + obj2 + obj3 + obj4 + obj5);
        }
    }

    private void debugThrowable(Throwable problem) {
        if (problem != null) {
            if (problem instanceof Error) {
                this.debug("Error: " + problem.getMessage());
            } else {
                this.debug("Exception: " + problem.getMessage());
            }
            StringWriter stackTraceWriter = new StringWriter();
            problem.printStackTrace(new PrintWriter(stackTraceWriter));
            String trace = stackTraceWriter.toString();
            try {
                BufferedReader reader = new BufferedReader(new StringReader(trace));
                if (reader.ready()) {
                    String traceLine = reader.readLine();
                    while (reader.ready() && traceLine != null) {
                        this.debug(traceLine);
                        traceLine = reader.readLine();
                    }
                }
            }
            catch (Exception ioException) {
                this.error("Serious error in LoggingTool while printing exception stack trace: " + ioException.getMessage());
                this.logger.debug(ioException);
            }
        }
    }

    public void error(Object object) {
        if (this.debug) {
            this.errorString("" + object);
        }
    }

    public void error(Object object, int number) {
        if (this.debug) {
            this.errorString("" + object + number);
        }
    }

    public void error(Object object, double number) {
        if (this.debug) {
            this.errorString("" + object + number);
        }
    }

    public void error(Object object, boolean bool) {
        if (this.debug) {
            this.errorString("" + object + bool);
        }
    }

    private void errorString(String string) {
        if (this.tostdout) {
            this.toSTDOUT("ERROR", string);
        } else {
            this.log4jLogger.error((Object)string);
        }
    }

    public void error(Object object, Object object2) {
        if (this.debug) {
            this.errorString("" + object + object2);
        }
    }

    public void error(Object obj, Object obj2, Object obj3) {
        if (this.debug) {
            this.errorString("" + obj + obj2 + obj3);
        }
    }

    public void error(Object obj, Object obj2, Object obj3, Object obj4) {
        if (this.debug) {
            this.errorString("" + obj + obj2 + obj3 + obj4);
        }
    }

    public void error(Object obj, Object obj2, Object obj3, Object obj4, Object obj5) {
        if (this.debug) {
            this.errorString("" + obj + obj2 + obj3 + obj4 + obj5);
        }
    }

    public void fatal(Object object) {
        if (this.debug) {
            if (this.tostdout) {
                this.toSTDOUT("FATAL", object.toString());
            } else {
                this.log4jLogger.fatal((Object)("" + object.toString()));
            }
        }
    }

    public void info(Object object) {
        if (this.debug) {
            this.infoString("" + object);
        }
    }

    public void info(Object object, int number) {
        if (this.debug) {
            this.infoString("" + object + number);
        }
    }

    public void info(Object object, double number) {
        if (this.debug) {
            this.infoString("" + object + number);
        }
    }

    public void info(Object object, boolean bool) {
        if (this.debug) {
            this.infoString("" + object + bool);
        }
    }

    private void infoString(String string) {
        if (this.tostdout) {
            this.toSTDOUT("INFO", string);
        } else {
            this.log4jLogger.info((Object)string);
        }
    }

    public void info(Object object, Object object2) {
        if (this.debug) {
            this.infoString("" + object + object2);
        }
    }

    public void info(Object obj, Object obj2, Object obj3) {
        if (this.debug) {
            this.infoString("" + obj + obj2 + obj3);
        }
    }

    public void info(Object obj, Object obj2, Object obj3, Object obj4) {
        if (this.debug) {
            this.infoString("" + obj + obj2 + obj3 + obj4);
        }
    }

    public void info(Object obj, Object obj2, Object obj3, Object obj4, Object obj5) {
        if (this.debug) {
            this.infoString("" + obj + obj2 + obj3 + obj4 + obj5);
        }
    }

    public void warn(Object object) {
        if (this.debug) {
            this.warnString("" + object);
        }
    }

    private void warnString(String string) {
        if (this.tostdout) {
            this.toSTDOUT("WARN", string);
        } else {
            this.log4jLogger.warn((Object)string);
        }
    }

    public void warn(Object object, int number) {
        if (this.debug) {
            this.warnString("" + object + number);
        }
    }

    public void warn(Object object, boolean bool) {
        if (this.debug) {
            this.warnString("" + object + bool);
        }
    }

    public void warn(Object object, double number) {
        if (this.debug) {
            this.warnString("" + object + number);
        }
    }

    public void warn(Object object, Object object2) {
        if (this.debug) {
            this.warnString("" + object + object2);
        }
    }

    public void warn(Object obj, Object obj2, Object obj3) {
        if (this.debug) {
            this.warnString("" + obj + obj2 + obj3);
        }
    }

    public void warn(Object obj, Object obj2, Object obj3, Object obj4) {
        if (this.debug) {
            this.warnString("" + obj + obj2 + obj3 + obj4);
        }
    }

    public void warn(Object obj, Object obj2, Object obj3, Object obj4, Object obj5) {
        if (this.debug) {
            this.warnString("" + obj + obj2 + obj3 + obj4 + obj5);
        }
    }

    public boolean isDebugEnabled() {
        return this.debug;
    }

    private void toSTDOUT(String level, String message) {
        System.out.print(this.classname);
        System.out.print(" ");
        System.out.print(level);
        System.out.print(": ");
        System.out.println(message);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

