/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools;

import java.util.Vector;
import org.openscience.cdk.Atom;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.Bond;
import org.openscience.cdk.Reaction;
import org.openscience.cdk.SetOfAtomContainers;
import org.openscience.cdk.SetOfReactions;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.ReactionManipulator;
import org.openscience.cdk.tools.manipulator.SetOfAtomContainersManipulator;

public class IDCreator {
    private Vector tabuList;
    int atomCount;
    int bondCount;
    int moleculeCount;
    int reactionCount;

    public IDCreator() {
        this.reset();
    }

    public void reset() {
        this.tabuList = null;
        this.atomCount = 0;
        this.bondCount = 0;
        this.moleculeCount = 0;
        this.reactionCount = 0;
    }

    public void createIDs(AtomContainer container) {
        if (this.tabuList == null) {
            this.tabuList = AtomContainerManipulator.getAllIDs(container);
        }
        if (container.getID() == null) {
            ++this.moleculeCount;
            while (this.tabuList.contains("m" + this.moleculeCount)) {
                ++this.moleculeCount;
            }
            container.setID("m" + this.moleculeCount);
        }
        Atom[] atoms = container.getAtoms();
        for (int i = 0; i < atoms.length; ++i) {
            Atom atom = atoms[i];
            if (atom.getID() != null) continue;
            ++this.atomCount;
            while (this.tabuList.contains("a" + this.atomCount)) {
                ++this.atomCount;
            }
            atoms[i].setID("a" + this.atomCount);
        }
        Bond[] bonds = container.getBonds();
        for (int i = 0; i < bonds.length; ++i) {
            Bond bond = bonds[i];
            if (bond.getID() != null) continue;
            ++this.bondCount;
            while (this.tabuList.contains("b" + this.bondCount)) {
                ++this.bondCount;
            }
            bonds[i].setID("b" + this.bondCount);
        }
    }

    public void createIDs(SetOfAtomContainers containerSet) {
        if (this.tabuList == null) {
            this.tabuList = SetOfAtomContainersManipulator.getAllIDs(containerSet);
        }
        if (containerSet.getID() == null) {
            ++this.moleculeCount;
            while (this.tabuList.contains("molSet" + this.moleculeCount)) {
                ++this.moleculeCount;
            }
            containerSet.setID("molSet" + this.moleculeCount);
        }
        AtomContainer[] containers = containerSet.getAtomContainers();
        for (int i = 0; i < containers.length; ++i) {
            AtomContainer container = containers[i];
            if (container.getID() != null) continue;
            this.createIDs(container);
        }
    }

    public void createIDs(Reaction reaction) {
        if (this.tabuList == null) {
            this.tabuList = ReactionManipulator.getAllIDs(reaction);
        }
        if (reaction.getID() == null) {
            ++this.reactionCount;
            while (this.tabuList.contains("r" + this.reactionCount)) {
                ++this.reactionCount;
            }
            reaction.setID("r" + this.reactionCount);
        }
        AtomContainer[] reactants = reaction.getReactants().getAtomContainers();
        for (int i = 0; i < reactants.length; ++i) {
            this.createIDs(reactants[i]);
        }
        AtomContainer[] products = reaction.getProducts().getAtomContainers();
        for (int i = 0; i < products.length; ++i) {
            this.createIDs(products[i]);
        }
    }

    public void createIDs(SetOfReactions reactionSet) {
        Reaction[] reactions = reactionSet.getReactions();
        for (int i = 0; i < reactions.length; ++i) {
            this.createIDs(reactions[i]);
        }
    }
}

