/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import org.openscience.cdk.Atom;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.Bond;
import org.openscience.cdk.ChemObject;
import org.openscience.cdk.Isotope;
import org.openscience.cdk.config.IsotopeFactory;
import org.openscience.cdk.exception.CDKException;

public class HOSECodeGenerator
implements Serializable {
    protected Vector sphereNodes = null;
    protected Vector sphereNodesWithAtoms = null;
    protected Vector nextSphereNodes = null;
    protected int sphere = 0;
    protected int maxSphere = 0;
    protected Vector[] spheres = null;
    protected Vector[] spheresWithAtoms = null;
    protected StringBuffer HOSECode = null;
    protected AtomContainer atomContainer;
    protected String[] sphereDelimiters = new String[]{"(", "/", "/", ")", "/", "/", "/", "/", "/", "/", "/", "/"};
    protected String[] bondSymbols = new String[]{"", "", "=", "%", "*"};
    protected String centerCode = null;
    public TreeNode rootNode = null;
    boolean debug = false;
    static final String[] rankedSymbols = new String[]{"C", "O", "N", "S", "P", "Si", "B", "F", "Cl", "Br", ";", "I", "#", "&", ","};
    static final int[] symbolRankings = new int[]{9000, 8900, 8800, 8700, 8600, 8500, 8400, 8300, 8200, 8100, 8000, 7900, 1200, 1100, 1000};
    static final int[] bondRankings = new int[]{0, 0, 200000, 300000, 100000};

    public HOSECodeGenerator() {
        this.sphereNodes = new Vector();
        this.sphereNodesWithAtoms = new Vector();
        this.nextSphereNodes = new Vector();
        this.HOSECode = new StringBuffer();
    }

    public Vector[] getSpheres(AtomContainer ac, Atom root, int noOfSpheres) throws CDKException {
        this.centerCode = "";
        this.atomContainer = ac;
        this.maxSphere = noOfSpheres;
        this.spheres = new Vector[noOfSpheres + 1];
        this.spheresWithAtoms = new Vector[noOfSpheres + 1];
        for (int i = 0; i < ac.getAtomCount(); ++i) {
            ((ChemObject)((Object)ac.getAtomAt(i))).setFlag(3, false);
        }
        root.setFlag(3, true);
        this.rootNode = new TreeNode(root.getSymbol(), null, root, 0.0, this.atomContainer.getBondCount(root), 0L);
        this.HOSECode = new StringBuffer();
        this.createCenterCode(root);
        this.breadthFirstSearch(root, false);
        this.createCode();
        this.fillUpSphereDelimiters();
        if (this.debug) {
            System.out.println("HOSECodeGenerator -> HOSECode: " + this.HOSECode.toString());
        }
        return this.spheresWithAtoms;
    }

    public String getHOSECode(AtomContainer ac, Atom root, int noOfSpheres) throws CDKException {
        this.centerCode = "";
        this.atomContainer = ac;
        this.maxSphere = noOfSpheres;
        this.spheres = new Vector[noOfSpheres + 1];
        for (int i = 0; i < ac.getAtomCount(); ++i) {
            ((ChemObject)((Object)ac.getAtomAt(i))).setFlag(3, false);
        }
        root.setFlag(3, true);
        this.rootNode = new TreeNode(root.getSymbol(), null, root, 0.0, this.atomContainer.getBondCount(root), 0L);
        this.HOSECode = new StringBuffer();
        this.createCenterCode(root);
        this.breadthFirstSearch(root, true);
        this.createCode();
        this.fillUpSphereDelimiters();
        if (this.debug) {
            System.out.println("HOSECodeGenerator -> HOSECode: " + this.HOSECode.toString());
        }
        return this.HOSECode.toString();
    }

    private void createCenterCode(Atom root) {
        int partnerCount = 0;
        partnerCount = this.atomContainer.getBondCount(root) + root.getHydrogenCount();
        this.centerCode = root.getSymbol() + "-" + partnerCount + this.createChargeCode(root) + ";";
    }

    private String createChargeCode(Atom atom) {
        StringBuffer tempCode = new StringBuffer();
        if (atom != null && atom.getFormalCharge() != 0) {
            if (Math.abs(atom.getFormalCharge()) == 1) {
                if (atom.getFormalCharge() < 0) {
                    tempCode.append("-");
                } else {
                    tempCode.append("+");
                }
            } else {
                tempCode.append("'");
                if (atom.getFormalCharge() > 0) {
                    tempCode.append("+");
                }
                tempCode.append(atom.getFormalCharge() + "'");
            }
        }
        return tempCode + "";
    }

    private void breadthFirstSearch(Atom root, boolean addTreeNode) throws CDKException {
        this.sphere = 0;
        TreeNode tempNode = null;
        Atom[] conAtoms = this.atomContainer.getConnectedAtoms(root);
        Bond bond = null;
        this.sphereNodes.removeAllElements();
        this.sphereNodesWithAtoms.removeAllElements();
        for (int i = 0; i < conAtoms.length; ++i) {
            try {
                Atom atom = conAtoms[i];
                bond = this.atomContainer.getBond(root, atom);
                tempNode = bond.getFlag(4) ? new TreeNode(atom.getSymbol(), new TreeNode(root.getSymbol(), null, root, 0.0, 0, 0L), atom, 4.0, this.atomContainer.getBondCount(atom), 0L) : new TreeNode(atom.getSymbol(), new TreeNode(root.getSymbol(), null, root, 0.0, 0, 0L), atom, bond.getOrder(), this.atomContainer.getBondCount(atom), 0L);
                this.sphereNodes.addElement(tempNode);
                if (!addTreeNode) {
                    this.sphereNodesWithAtoms.addElement(atom);
                }
                this.rootNode.childs.addElement(tempNode);
                atom.setFlag(3, true);
                continue;
            }
            catch (Exception exc) {
                throw new CDKException("Error in HOSECodeGenerator->breadthFirstSearch.");
            }
        }
        this.nextSphere(this.sphereNodes);
    }

    private void nextSphere(Vector sphereNodes) throws CDKException {
        this.spheres[this.sphere] = sphereNodes;
        if (this.spheresWithAtoms != null) {
            this.spheresWithAtoms[this.sphere] = this.sphereNodesWithAtoms;
        }
        Atom node = null;
        Atom toNode = null;
        Atom[] conAtoms = null;
        TreeNode treeNode = null;
        this.nextSphereNodes = new Vector();
        Bond bond = null;
        for (int i = 0; i < sphereNodes.size(); ++i) {
            treeNode = (TreeNode)sphereNodes.elementAt(i);
            if ("&;#:,".indexOf(treeNode.symbol) >= 0) continue;
            node = treeNode.atom;
            conAtoms = this.atomContainer.getConnectedAtoms(node);
            if (conAtoms.length == 1) {
                this.nextSphereNodes.addElement(new TreeNode(",", treeNode, null, 0.0, 0, treeNode.score));
                continue;
            }
            for (int j = 0; j < conAtoms.length; ++j) {
                toNode = conAtoms[j];
                if (toNode == treeNode.source.atom) continue;
                bond = this.atomContainer.getBond(node, toNode);
                if (bond.getFlag(4)) {
                    this.nextSphereNodes.addElement(new TreeNode(toNode.getSymbol(), treeNode, toNode, 4.0, this.atomContainer.getBondCount(toNode), treeNode.score));
                    continue;
                }
                this.nextSphereNodes.addElement(new TreeNode(toNode.getSymbol(), treeNode, toNode, bond.getOrder(), this.atomContainer.getBondCount(toNode), treeNode.score));
            }
        }
        if (this.sphere < this.maxSphere) {
            ++this.sphere;
            this.nextSphere(this.nextSphereNodes);
        }
    }

    public String makeBremserCompliant(String code) {
        int sepIndex = code.indexOf(";");
        if (sepIndex >= 0) {
            code = code.substring(sepIndex + 1, code.length());
        }
        return code;
    }

    private void createCode() throws CDKException {
        int f;
        int g;
        int f2;
        Vector sphereNodes = null;
        TreeNode tn = null;
        for (f2 = 0; f2 < this.atomContainer.getAtomCount(); ++f2) {
            ((ChemObject)((Object)this.atomContainer.getAtomAt(f2))).setFlag(3, false);
        }
        for (f2 = 0; f2 < this.maxSphere; ++f2) {
            sphereNodes = this.spheres[this.maxSphere - f2];
            for (g = 0; g < sphereNodes.size(); ++g) {
                tn = (TreeNode)sphereNodes.elementAt(g);
                if (tn.source == null) continue;
                tn.source.ranking += tn.degree;
            }
        }
        for (f2 = 0; f2 < this.maxSphere; ++f2) {
            sphereNodes = this.spheres[f2];
            this.calculateNodeScores(sphereNodes);
            this.sortNodesByScore(sphereNodes);
        }
        for (f2 = 0; f2 < this.maxSphere; ++f2) {
            sphereNodes = this.spheres[f2];
            for (g = 0; g < sphereNodes.size(); ++g) {
                tn = (TreeNode)sphereNodes.elementAt(g);
                tn.score += (long)tn.ranking;
            }
            this.sortNodesByScore(sphereNodes);
        }
        BigInteger big = new BigInteger("10");
        for (f = 0; f < this.maxSphere; ++f) {
            sphereNodes = this.spheres[f];
            for (int g2 = 0; g2 < sphereNodes.size(); ++g2) {
                tn = (TreeNode)sphereNodes.elementAt(g2);
                String localscore = tn.score + "";
                while (localscore.length() < 6) {
                    localscore = "0" + localscore;
                }
                tn.stringscore = tn.source.stringscore + "" + localscore;
            }
            this.sortNodesByScore(sphereNodes);
        }
        this.HOSECode.append(this.centerCode);
        for (f = 0; f < this.maxSphere; ++f) {
            this.sphere = f + 1;
            sphereNodes = this.spheres[f];
            String s = this.getSphereCode(sphereNodes);
            this.HOSECode.append(s);
        }
    }

    private String getSphereCode(Vector sphereNodes) throws CDKException {
        if (sphereNodes == null || sphereNodes.size() < 1) {
            return this.sphereDelimiters[this.sphere - 1];
        }
        Object node = null;
        TreeNode treeNode = null;
        StringBuffer code = new StringBuffer();
        Atom branch = ((TreeNode)sphereNodes.elementAt((int)0)).source.atom;
        boolean start = false;
        StringBuffer tempCode = null;
        Object nextBranch = null;
        for (int i = 0; i < sphereNodes.size(); ++i) {
            treeNode = (TreeNode)sphereNodes.elementAt(i);
            tempCode = new StringBuffer();
            if (!treeNode.source.stopper && treeNode.source.atom != branch) {
                branch = treeNode.source.atom;
                code.append(",");
            }
            if (!treeNode.source.stopper && treeNode.source.atom == branch) {
                if (treeNode.bondType <= 4.0) {
                    tempCode.append(this.bondSymbols[(int)treeNode.bondType]);
                }
                if (treeNode.atom != null && !treeNode.atom.getFlag(3)) {
                    tempCode.append(this.getElementSymbol(treeNode.symbol));
                } else if (treeNode.atom != null && treeNode.atom.getFlag(3)) {
                    tempCode.append("&");
                    treeNode.stopper = true;
                }
                code.append(tempCode + this.createChargeCode(treeNode.atom));
                treeNode.hSymbol = tempCode.toString();
            }
            if (treeNode.atom != null) {
                treeNode.atom.setFlag(3, true);
            }
            if (!treeNode.source.stopper) continue;
            treeNode.stopper = true;
        }
        code.append(this.sphereDelimiters[this.sphere - 1]);
        return code.toString();
    }

    private double getElementRank(String symbol) {
        for (int f = 0; f < rankedSymbols.length; ++f) {
            if (!rankedSymbols[f].equals(symbol)) continue;
            return symbolRankings[f];
        }
        try {
            Isotope isotope = IsotopeFactory.getInstance().getMajorIsotope(symbol);
            return 800000.0 - (double)isotope.getMassNumber();
        }
        catch (Exception exception) {
            System.err.println("Could not find major isotope for this element!!! : " + symbol);
            System.err.println("Because of this error: " + exception.getMessage());
            return 800000.0;
        }
    }

    private String getElementSymbol(String sym) {
        if (sym.equals("Si")) {
            return "Q";
        }
        if (sym.equals("Cl")) {
            return "X";
        }
        if (sym.equals("Br")) {
            return "Y";
        }
        if (sym.equals(",")) {
            return "";
        }
        return sym;
    }

    private void calculateNodeScores(Vector sphereNodes) throws CDKException {
        TreeNode treeNode = null;
        Object node = null;
        for (int i = 0; i < sphereNodes.size(); ++i) {
            treeNode = (TreeNode)sphereNodes.elementAt(i);
            treeNode.score = (long)((double)treeNode.score + this.getElementRank(treeNode.symbol));
            if (!(treeNode.bondType <= 4.0)) continue;
            treeNode.score += (long)bondRankings[(int)treeNode.bondType];
        }
    }

    private void sortNodesByScore(Vector sphereNodes) {
        boolean changed;
        if (sphereNodes.size() == 0) {
            return;
        }
        do {
            changed = false;
            for (int i = 0; i < sphereNodes.size() - 1; ++i) {
                if (((TreeNode)sphereNodes.elementAt((int)(i + 1))).stringscore.compareTo(((TreeNode)sphereNodes.elementAt((int)i)).stringscore) <= 0) continue;
                Object obj = sphereNodes.elementAt(i + 1);
                sphereNodes.removeElementAt(i + 1);
                sphereNodes.insertElementAt(obj, i);
                changed = true;
            }
        } while (changed);
        boolean counter = false;
        TreeNode root = (TreeNode)sphereNodes.elementAt(0);
        TreeNode temp = null;
        for (int i = 0; i < sphereNodes.size(); ++i) {
            temp = (TreeNode)sphereNodes.elementAt(i);
            temp.sortOrder = sphereNodes.size() - i;
        }
    }

    private void fillUpSphereDelimiters() {
        if (this.debug) {
            System.out.println("Sphere: " + this.sphere);
        }
        for (int f = this.sphere; f < 4; ++f) {
            this.HOSECode.append(this.sphereDelimiters[f]);
        }
    }

    public DefaultMutableTreeNode getRootNode() {
        DefaultMutableTreeNode top = new DefaultMutableTreeNode(this.rootNode);
        DefaultMutableTreeNode workNode = null;
        DefaultMutableTreeNode rootNode = null;
        Vector<DefaultMutableTreeNode> treeNodes = new Vector<DefaultMutableTreeNode>();
        Vector<DefaultMutableTreeNode> newTreeNodes = new Vector<DefaultMutableTreeNode>();
        Vector sphereNodes = null;
        TreeNode tn = null;
        sphereNodes = this.spheres[0];
        for (int g = 0; g < sphereNodes.size(); ++g) {
            tn = (TreeNode)sphereNodes.elementAt(g);
            workNode = new DefaultMutableTreeNode(tn);
            top.add(workNode);
            treeNodes.add(workNode);
        }
        for (int f = 1; f < this.maxSphere; ++f) {
            sphereNodes = this.spheres[f];
            for (int h = 0; h < treeNodes.size(); ++h) {
                rootNode = (DefaultMutableTreeNode)treeNodes.elementAt(h);
                for (int g = 0; g < sphereNodes.size(); ++g) {
                    tn = (TreeNode)sphereNodes.elementAt(g);
                    if (tn.source != rootNode.getUserObject()) continue;
                    workNode = new DefaultMutableTreeNode(tn);
                    rootNode.add(workNode);
                    newTreeNodes.add(workNode);
                }
            }
            treeNodes = newTreeNodes;
            newTreeNodes = new Vector();
        }
        return top;
    }

    class TreeNode {
        String symbol;
        TreeNode source;
        Atom atom;
        double bondType;
        int degree;
        long score;
        int ranking;
        int sortOrder = 1;
        Vector childs = null;
        String hSymbol = null;
        boolean stopper = false;
        String stringscore = "";

        TreeNode(String symbol, TreeNode source, Atom atom, double bondType, int degree, long score) {
            this.symbol = symbol;
            this.source = source;
            this.atom = atom;
            this.degree = degree;
            this.score = score;
            this.bondType = bondType;
            this.ranking = 0;
            this.sortOrder = 1;
            this.childs = new Vector();
        }

        public boolean equals(Object o) {
            try {
                if (this.atom == ((TreeNode)o).atom) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }

        public String toString() {
            String s = "";
            try {
                s = s + (HOSECodeGenerator.this.atomContainer.getAtomNumber(this.atom) + 1);
                s = s + " " + this.hSymbol;
                s = s + "; s=" + this.score;
                s = s + "; r=" + this.ranking;
                s = s + "; d = " + this.degree;
            }
            catch (Exception exc) {
                return exc.toString();
            }
            return s;
        }
    }
}

