/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smiles;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import org.openscience.cdk.Atom;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.Bond;
import org.openscience.cdk.ChemObject;
import org.openscience.cdk.Isotope;
import org.openscience.cdk.Molecule;
import org.openscience.cdk.PseudoAtom;
import org.openscience.cdk.Reaction;
import org.openscience.cdk.RingSet;
import org.openscience.cdk.SetOfMolecules;
import org.openscience.cdk.aromaticity.HueckelAromaticityDetector;
import org.openscience.cdk.config.IsotopeFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.graph.invariant.CanonicalLabeler;
import org.openscience.cdk.graph.invariant.MorganNumbersTools;
import org.openscience.cdk.ringsearch.AllRingsFinder;
import org.openscience.cdk.ringsearch.RingPartitioner;
import org.openscience.cdk.tools.manipulator.RingSetManipulator;

public class SmilesGenerator {
    private static boolean debug = false;
    private int ringMarker = 0;
    private Vector brokenBonds = new Vector();
    private IsotopeFactory isotopeFactory;
    private CanonicalLabeler canLabler = new CanonicalLabeler();
    private final String RING_CONFIG = "stereoconfig";
    private final String UP = "up";
    private final String DOWN = "down";

    public SmilesGenerator() {
        try {
            this.isotopeFactory = IsotopeFactory.getInstance();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public boolean isValidDoubleBondConfiguration(AtomContainer container, Bond bond) {
        Atom[] atoms = bond.getAtoms();
        Atom[] connectedAtoms = container.getConnectedAtoms(atoms[0]);
        Atom from = null;
        for (int i = 0; i < connectedAtoms.length; ++i) {
            if (connectedAtoms[i] == atoms[1]) continue;
            from = connectedAtoms[i];
        }
        boolean[] array = new boolean[container.getBonds().length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = true;
        }
        return this.isStartOfDoubleBond(container, atoms[0], from, array) && this.isEndOfDoubleBond(container, atoms[1], atoms[0], array) && !bond.getFlag(4);
    }

    public synchronized String createSMILES(Molecule molecule) {
        try {
            return this.createSMILES(molecule, false, new boolean[molecule.getBondCount()]);
        }
        catch (CDKException exception) {
            return "";
        }
    }

    public synchronized String createSMILES(Reaction reaction) throws CDKException {
        StringBuffer reactionSMILES = new StringBuffer();
        Molecule[] reactants = reaction.getReactants().getMolecules();
        for (int i = 0; i < reactants.length; ++i) {
            reactionSMILES.append(this.createSMILES(reactants[i]));
            if (i + 1 >= reactants.length) continue;
            reactionSMILES.append('.');
        }
        reactionSMILES.append('>');
        Molecule[] agents = reaction.getAgents().getMolecules();
        for (int i = 0; i < agents.length; ++i) {
            reactionSMILES.append(this.createSMILES(agents[i]));
            if (i + 1 >= agents.length) continue;
            reactionSMILES.append('.');
        }
        reactionSMILES.append('>');
        Molecule[] products = reaction.getProducts().getMolecules();
        for (int i = 0; i < products.length; ++i) {
            reactionSMILES.append(this.createSMILES(products[i]));
            if (i + 1 >= products.length) continue;
            reactionSMILES.append('.');
        }
        return reactionSMILES.toString();
    }

    public synchronized String createChiralSMILES(Molecule molecule, boolean[] doubleBondConfiguration) throws CDKException {
        return this.createSMILES(molecule, true, doubleBondConfiguration);
    }

    public synchronized String createSMILES(Molecule molecule, boolean chiral, boolean[] doubleBondConfiguration) throws CDKException {
        SetOfMolecules moleculeSet = ConnectivityChecker.partitionIntoMolecules((AtomContainer)molecule);
        if (moleculeSet.getMoleculeCount() > 1) {
            StringBuffer fullSMILES = new StringBuffer();
            Molecule[] molecules = moleculeSet.getMolecules();
            for (int i = 0; i < molecules.length; ++i) {
                Molecule molPart = molecules[i];
                fullSMILES.append(this.createSMILESWithoutCheckForMultipleMolecules(molPart, chiral, doubleBondConfiguration));
                if (i >= molecules.length - 1) continue;
                fullSMILES.append('.');
            }
            return fullSMILES.toString();
        }
        return this.createSMILESWithoutCheckForMultipleMolecules(molecule, chiral, doubleBondConfiguration);
    }

    public synchronized String createSMILESWithoutCheckForMultipleMolecules(Molecule molecule, boolean chiral, boolean[] doubleBondConfiguration) throws CDKException {
        if (molecule.getAtomCount() == 0) {
            return "";
        }
        this.canLabler.canonLabel((AtomContainer)molecule);
        this.brokenBonds.clear();
        this.ringMarker = 0;
        Atom[] all = molecule.getAtoms();
        Atom start = null;
        for (int i = 0; i < all.length; ++i) {
            Atom atom = all[i];
            if (chiral && atom.getPoint2d() == null) {
                throw new CDKException("Atom number " + i + " has no 2D coordinates, but 2D coordinates are needed for creating chiral smiles");
            }
            atom.setFlag(3, false);
            if ((Long)atom.getProperty("CanonicalLable") != 1L) continue;
            start = atom;
        }
        AllRingsFinder ringFinder = new AllRingsFinder();
        RingSet rings = ringFinder.findAllRings((AtomContainer)molecule);
        new HueckelAromaticityDetector();
        HueckelAromaticityDetector.detectAromaticity((AtomContainer)molecule, (RingSet)rings, (boolean)false);
        if (chiral && rings.size() > 0) {
            Vector v = RingPartitioner.partitionRings((RingSet)rings);
            for (int i = 0; i < v.size(); ++i) {
                int k;
                int counter = 0;
                AtomContainer allrings = RingSetManipulator.getAllInOneContainer((RingSet)v.get(i));
                for (k = 0; k < allrings.getAtomCount(); ++k) {
                    if (this.isStereo(molecule, (Atom)allrings.getAtomAt(k)) || this.hasWedges(molecule, (Atom)allrings.getAtomAt(k)) == null) continue;
                    Bond bond = molecule.getBond((Atom)allrings.getAtomAt(k), this.hasWedges(molecule, (Atom)allrings.getAtomAt(k)));
                    if (bond.getStereo() == 1) {
                        ((ChemObject)((Object)allrings.getAtomAt(k))).setProperty("stereoconfig", "up");
                    } else {
                        ((ChemObject)((Object)allrings.getAtomAt(k))).setProperty("stereoconfig", "down");
                    }
                    ++counter;
                }
                if (counter != true) continue;
                for (k = 0; k < allrings.getAtomCount(); ++k) {
                    ((ChemObject)((Object)allrings.getAtomAt(k))).setProperty("stereoconfig", "up");
                }
            }
        }
        StringBuffer l = new StringBuffer();
        this.createSMILES(start, l, molecule, chiral, doubleBondConfiguration);
        return l.toString();
    }

    private Atom hasWedges(AtomContainer ac, Atom a) {
        int i;
        Atom[] atoms = ac.getConnectedAtoms(a);
        for (i = 0; i < atoms.length; ++i) {
            if (ac.getBond(a, atoms[i]).getStereo() == 0 || atoms[i].getSymbol().equals("H")) continue;
            return atoms[i];
        }
        for (i = 0; i < atoms.length; ++i) {
            if (ac.getBond(a, atoms[i]).getStereo() == 0) continue;
            return atoms[i];
        }
        return null;
    }

    private boolean isEndOfDoubleBond(AtomContainer container, Atom atom, Atom parent, boolean[] doubleBondConfiguration) {
        if (container.getBondNumber(atom, parent) == -1 || doubleBondConfiguration.length <= container.getBondNumber(atom, parent) || !doubleBondConfiguration[container.getBondNumber(atom, parent)]) {
            return false;
        }
        int lengthAtom = container.getConnectedAtoms(atom).length + atom.getHydrogenCount();
        int lengthParent = container.getConnectedAtoms(parent).length + parent.getHydrogenCount();
        if (container.getBond(atom, parent) != null && container.getBond(atom, parent).getOrder() == 2.0 && (lengthAtom == 3 || lengthAtom == 2 && atom.getSymbol().equals("N")) && (lengthParent == 3 || lengthParent == 2 && parent.getSymbol().equals("N"))) {
            Atom[] atoms = container.getConnectedAtoms(atom);
            Atom one = null;
            Atom two = null;
            for (int i = 0; i < atoms.length; ++i) {
                if (atoms[i] != parent && one == null) {
                    one = atoms[i];
                    continue;
                }
                if (atoms[i] == parent || one == null) continue;
                two = atoms[i];
            }
            String[] morgannumbers = MorganNumbersTools.getMorganNumbersWithElementSymbol((AtomContainer)container);
            return one != null && two == null && atom.getSymbol().equals("N") && Math.abs(this.giveAngleBothMethods(parent, atom, one, true)) > 0.3141592653589793 || !atom.getSymbol().equals("N") && one != null && two != null && !morgannumbers[container.getAtomNumber(one)].equals(morgannumbers[container.getAtomNumber(two)]);
        }
        return false;
    }

    private boolean isStartOfDoubleBond(AtomContainer container, Atom a, Atom parent, boolean[] doubleBondConfiguration) {
        int lengthAtom = container.getConnectedAtoms(a).length + a.getHydrogenCount();
        if (lengthAtom != 3 && lengthAtom != 2 && a.getSymbol() != "N") {
            return false;
        }
        Atom[] atoms = container.getConnectedAtoms(a);
        Atom one = null;
        Atom two = null;
        boolean doubleBond = false;
        Atom nextAtom = null;
        for (int i = 0; i < atoms.length; ++i) {
            if (atoms[i] != parent && container.getBond(atoms[i], a).getOrder() == 2.0 && this.isEndOfDoubleBond(container, atoms[i], a, doubleBondConfiguration)) {
                doubleBond = true;
                nextAtom = atoms[i];
            }
            if (atoms[i] != nextAtom && one == null) {
                one = atoms[i];
                continue;
            }
            if (atoms[i] == nextAtom || one == null) continue;
            two = atoms[i];
        }
        String[] morgannumbers = MorganNumbersTools.getMorganNumbersWithElementSymbol((AtomContainer)container);
        return one != null && (!a.getSymbol().equals("N") && two != null && !morgannumbers[container.getAtomNumber(one)].equals(morgannumbers[container.getAtomNumber(two)]) && doubleBond && doubleBondConfiguration[container.getBondNumber(a, nextAtom)] || doubleBond && a.getSymbol().equals("N") && Math.abs(this.giveAngleBothMethods(nextAtom, a, parent, true)) > 0.3141592653589793);
    }

    private int isTetrahedral(AtomContainer container, Atom a) {
        Atom[] atoms = container.getConnectedAtoms(a);
        if (atoms.length != 4) {
            return 0;
        }
        Bond[] bonds = container.getConnectedBonds(a);
        int normal = 0;
        int up = 0;
        int down = 0;
        for (int i = 0; i < bonds.length; ++i) {
            if (bonds[i].getStereo() == 0 || bonds[i].getStereo() == 4) {
                ++normal;
            }
            if (bonds[i].getStereo() == 1) {
                ++up;
            }
            if (bonds[i].getStereo() != -1) continue;
            ++down;
        }
        if (up == 1 && down == 1) {
            return 1;
        }
        if (up == 2 && down == 2) {
            if (this.stereosAreOpposite(container, a)) {
                return 2;
            }
            return 0;
        }
        if (up == 1 && down == 0) {
            return 3;
        }
        if (down == 1 && up == 0) {
            return 4;
        }
        if (down == 2 && up == 1) {
            return 5;
        }
        if (down == 1 && up == 2) {
            return 6;
        }
        return 0;
    }

    private boolean isSquarePlanar(AtomContainer container, Atom a) {
        Atom[] atoms = container.getConnectedAtoms(a);
        if (atoms.length != 4) {
            return false;
        }
        Bond[] bonds = container.getConnectedBonds(a);
        int normal = 0;
        int up = 0;
        int down = 0;
        for (int i = 0; i < bonds.length; ++i) {
            if (bonds[i].getStereo() == 4 || bonds[i].getStereo() == 0) {
                ++normal;
            }
            if (bonds[i].getStereo() == 1) {
                ++up;
            }
            if (bonds[i].getStereo() != -1) continue;
            ++down;
        }
        return up == 2 && down == 2 && !this.stereosAreOpposite(container, a);
    }

    private boolean isTrigonalBipyramidalOrOctahedral(AtomContainer container, Atom a) {
        Atom[] atoms = container.getConnectedAtoms(a);
        if (atoms.length < 5 || atoms.length > 6) {
            return false;
        }
        Bond[] bonds = container.getConnectedBonds(a);
        int normal = 0;
        int up = 0;
        int down = 0;
        for (int i = 0; i < bonds.length; ++i) {
            if (bonds[i].getStereo() == 4 || bonds[i].getStereo() == 0) {
                ++normal;
            }
            if (bonds[i].getStereo() == 1) {
                ++up;
            }
            if (bonds[i].getStereo() != -1) continue;
            ++down;
        }
        return up == 1 && down == 1;
    }

    private boolean isStereo(AtomContainer container, Atom a) {
        Atom[] atoms = container.getConnectedAtoms(a);
        if (atoms.length < 4 || atoms.length > 6) {
            return false;
        }
        Bond[] bonds = container.getConnectedBonds(a);
        int stereo = 0;
        for (int i = 0; i < bonds.length; ++i) {
            if (bonds[i].getStereo() == 0) continue;
            ++stereo;
        }
        if (stereo == 0) {
            return false;
        }
        int differentAtoms = 0;
        for (int i = 0; i < atoms.length; ++i) {
            boolean isDifferent = true;
            for (int k = 0; k < i; ++k) {
                if (!atoms[i].getSymbol().equals(atoms[k].getSymbol())) continue;
                isDifferent = false;
                break;
            }
            if (!isDifferent) continue;
            ++differentAtoms;
        }
        if (differentAtoms != atoms.length) {
            int[] morgannumbers = MorganNumbersTools.getMorganNumbers((AtomContainer)container);
            Vector<String> differentSymbols = new Vector<String>();
            for (int i = 0; i < atoms.length; ++i) {
                if (differentSymbols.contains(atoms[i].getSymbol())) continue;
                differentSymbols.add(atoms[i].getSymbol());
            }
            int[] onlyRelevantIfTwo = new int[2];
            if (differentSymbols.size() == 2) {
                for (int i = 0; i < atoms.length; ++i) {
                    if (differentSymbols.indexOf(atoms[i].getSymbol()) == 0) {
                        onlyRelevantIfTwo[0] = onlyRelevantIfTwo[0] + 1;
                        continue;
                    }
                    onlyRelevantIfTwo[1] = onlyRelevantIfTwo[1] + 1;
                }
            }
            boolean[] symbolsWithDifferentMorganNumbers = new boolean[differentSymbols.size()];
            Vector[] symbolsMorganNumbers = new Vector[differentSymbols.size()];
            for (int i = 0; i < symbolsWithDifferentMorganNumbers.length; ++i) {
                symbolsWithDifferentMorganNumbers[i] = true;
                symbolsMorganNumbers[i] = new Vector();
            }
            for (int k = 0; k < atoms.length; ++k) {
                int elementNumber = differentSymbols.indexOf(atoms[k].getSymbol());
                if (symbolsMorganNumbers[elementNumber].contains(new Integer(morgannumbers[container.getAtomNumber(atoms[k])]))) {
                    symbolsWithDifferentMorganNumbers[elementNumber] = false;
                    continue;
                }
                symbolsMorganNumbers[elementNumber].add(new Integer(morgannumbers[container.getAtomNumber(atoms[k])]));
            }
            int numberOfSymbolsWithDifferentMorganNumbers = 0;
            for (int i = 0; i < symbolsWithDifferentMorganNumbers.length; ++i) {
                if (!symbolsWithDifferentMorganNumbers[i]) continue;
                ++numberOfSymbolsWithDifferentMorganNumbers;
            }
            if (numberOfSymbolsWithDifferentMorganNumbers != differentSymbols.size()) {
                if ((atoms.length == 5 || atoms.length == 6) && (numberOfSymbolsWithDifferentMorganNumbers + differentAtoms > 2 || differentAtoms == 2 && onlyRelevantIfTwo[0] > 1 && onlyRelevantIfTwo[1] > 1)) {
                    return true;
                }
                return this.isSquarePlanar(container, a) && (numberOfSymbolsWithDifferentMorganNumbers + differentAtoms > 2 || differentAtoms == 2 && onlyRelevantIfTwo[0] > 1 && onlyRelevantIfTwo[1] > 1);
            }
        }
        return true;
    }

    private boolean isBondBroken(Atom a1, Atom a2) {
        Iterator it = this.brokenBonds.iterator();
        while (it.hasNext()) {
            BrokenBond bond = (BrokenBond)it.next();
            if (!bond.getA1().equals(a1) && !bond.getA1().equals(a2) || !bond.getA2().equals(a1) && !bond.getA2().equals(a2)) continue;
            return true;
        }
        return false;
    }

    private boolean isLeft(Atom whereIs, Atom viewFrom, Atom viewTo) {
        double angle = this.giveAngleBothMethods(viewFrom, viewTo, whereIs, false);
        return !(angle < 0.0);
    }

    private boolean isRingOpening(Atom a) {
        Iterator it = this.brokenBonds.iterator();
        while (it.hasNext()) {
            BrokenBond bond = (BrokenBond)it.next();
            if (!bond.getA1().equals(a) && !bond.getA2().equals(a)) continue;
            return true;
        }
        return false;
    }

    private boolean isRingOpening(Atom a1, Vector v) {
        Iterator it = this.brokenBonds.iterator();
        while (it.hasNext()) {
            BrokenBond bond = (BrokenBond)it.next();
            for (int i = 0; i < v.size(); ++i) {
                if ((!bond.getA1().equals(a1) || !bond.getA2().equals((Atom)v.get(i))) && (!bond.getA1().equals((Atom)v.get(i)) || !bond.getA2().equals(a1))) continue;
                return true;
            }
        }
        return false;
    }

    private Vector getCanNeigh(Atom a, AtomContainer container) {
        Vector v = container.getConnectedAtomsVector(a);
        if (v.size() > 1) {
            Collections.sort(v, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return (int)((Long)((Atom)o1).getProperty("CanonicalLable") - (Long)((Atom)o2).getProperty("CanonicalLable"));
                }
            });
        }
        return v;
    }

    private Vector getRingOpenings(Atom a, Vector vbonds) {
        Iterator it = this.brokenBonds.iterator();
        Vector<Integer> v = new Vector<Integer>(10);
        while (it.hasNext()) {
            BrokenBond bond = (BrokenBond)it.next();
            if (!bond.getA1().equals(a) && !bond.getA2().equals(a)) continue;
            v.add(new Integer(bond.getMarker()));
            if (vbonds == null) continue;
            vbonds.add(bond.getA1().equals(a) ? bond.getA2() : bond.getA1());
        }
        Collections.sort(v);
        return v;
    }

    private boolean isChiralCenter(Atom atom, AtomContainer container) {
        Bond[] bonds = container.getConnectedBonds(atom);
        for (int i = 0; i < bonds.length; ++i) {
            Bond bond = bonds[i];
            int stereo = bond.getStereo();
            if (stereo != -1 && stereo != 1) continue;
            return true;
        }
        return false;
    }

    private void addAtoms(Vector v, Vector result) {
        for (int i = 0; i < v.size(); ++i) {
            if (v.get(i) instanceof Atom) {
                result.add((Atom)v.get(i));
                continue;
            }
            this.addAtoms((Vector)v.get(i), result);
        }
    }

    private double giveAngle(Atom from, Atom to1, Atom to2) {
        return this.giveAngleBothMethods(from, to1, to2, true);
    }

    private double giveAngleFromMiddle(Atom from, Atom to1, Atom to2) {
        return this.giveAngleBothMethods(from, to1, to2, false);
    }

    private double giveAngleBothMethods(Atom from, Atom to1, Atom to2, boolean bool) {
        double[] A = new double[2];
        from.getPoint2d().get(A);
        double[] B = new double[2];
        to1.getPoint2d().get(B);
        double[] C = new double[2];
        to2.getPoint2d().get(C);
        double angle1 = Math.atan2(B[1] - A[1], B[0] - A[0]);
        double angle2 = Math.atan2(C[1] - A[1], C[0] - A[0]);
        double angle = angle2 - angle1;
        if (angle2 < 0.0 && angle1 > 0.0 && angle2 < -1.5707963267948966) {
            angle = Math.PI + angle2 + Math.PI - angle1;
        }
        if (angle2 > 0.0 && angle1 < 0.0 && angle1 < -1.5707963267948966) {
            angle = -Math.PI + angle2 - Math.PI - angle1;
        }
        if (bool && angle < 0.0) {
            return Math.PI * 2 + angle;
        }
        return angle;
    }

    private boolean stereosAreOpposite(AtomContainer container, Atom a) {
        Vector atoms = container.getConnectedAtomsVector(a);
        TreeMap<Double, Integer> hm = new TreeMap<Double, Integer>();
        for (int i = 1; i < atoms.size(); ++i) {
            hm.put(new Double(this.giveAngle(a, (Atom)atoms.get(0), (Atom)atoms.get(i))), new Integer(i));
        }
        Object[] ohere = hm.values().toArray();
        int stereoOne = container.getBond(a, (Atom)atoms.get(0)).getStereo();
        int stereoOpposite = container.getBond(a, (Atom)atoms.get((Integer)ohere[1])).getStereo();
        return stereoOpposite == stereoOne;
    }

    private void createSMILES(Atom a, StringBuffer line, AtomContainer atomContainer, boolean chiral, boolean[] doubleBondConfiguration) {
        Vector tree = new Vector();
        this.createDFSTree(a, tree, null, atomContainer);
        this.parseChain(tree, line, atomContainer, null, chiral, doubleBondConfiguration, new Vector());
    }

    private void createDFSTree(Atom a, Vector tree, Atom parent, AtomContainer container) {
        tree.add(a);
        Vector neighbours = this.getCanNeigh(a, container);
        neighbours.remove(parent);
        a.setFlag(3, true);
        for (int x = 0; x < neighbours.size(); ++x) {
            Atom next = (Atom)neighbours.elementAt(x);
            if (!next.getFlag(3)) {
                if (x == neighbours.size() - 1) {
                    this.createDFSTree(next, tree, a, container);
                    continue;
                }
                Vector branch = new Vector();
                tree.add(branch);
                this.createDFSTree(next, branch, a, container);
                continue;
            }
            ++this.ringMarker;
            BrokenBond bond = new BrokenBond(a, next, this.ringMarker);
            if (!this.brokenBonds.contains(bond)) {
                this.brokenBonds.add(bond);
                continue;
            }
            --this.ringMarker;
        }
    }

    private void parseChain(Vector v, StringBuffer buffer, AtomContainer container, Atom parent, boolean chiral, boolean[] doubleBondConfiguration, Vector atomsInOrderOfSmiles) {
        int positionInVector = 0;
        for (int h = 0; h < v.size(); ++h) {
            Object o = v.get(h);
            if (o instanceof Atom) {
                Atom atom = (Atom)o;
                if (parent != null) {
                    this.parseBond(buffer, atom, parent, container);
                } else if (chiral && this.isStereo(container, atom)) {
                    parent = (Atom)((Vector)v.get(1)).get(0);
                }
                this.parseAtom(atom, buffer, container, chiral, doubleBondConfiguration, parent, atomsInOrderOfSmiles, v);
                if (chiral && this.isStereo(container, atom) && container.getBond(parent, atom) != null) {
                    int i;
                    Atom atom2;
                    Atom atom1;
                    double angle2;
                    int i2;
                    int i3;
                    Atom[] sorted = null;
                    Vector chiralNeighbours = container.getConnectedAtomsVector(atom);
                    if (this.isTetrahedral(container, atom) > 0) {
                        sorted = new Atom[3];
                    }
                    if (this.isTetrahedral(container, atom) == 1) {
                        if (container.getBond(parent, atom).getStereo() == -1) {
                            for (i3 = 0; i3 < chiralNeighbours.size(); ++i3) {
                                if (chiralNeighbours.get(i3) == parent) continue;
                                if (container.getBond((Atom)chiralNeighbours.get(i3), atom).getStereo() == 0 && this.isLeft((Atom)chiralNeighbours.get(i3), parent, atom) && !this.isBondBroken((Atom)chiralNeighbours.get(i3), atom)) {
                                    sorted[2] = (Atom)chiralNeighbours.get(i3);
                                }
                                if (container.getBond((Atom)chiralNeighbours.get(i3), atom).getStereo() == 0 && !this.isLeft((Atom)chiralNeighbours.get(i3), parent, atom) && !this.isBondBroken((Atom)chiralNeighbours.get(i3), atom)) {
                                    sorted[1] = (Atom)chiralNeighbours.get(i3);
                                }
                                if (container.getBond((Atom)chiralNeighbours.get(i3), atom).getStereo() != 1 || this.isBondBroken((Atom)chiralNeighbours.get(i3), atom)) continue;
                                sorted[0] = (Atom)chiralNeighbours.get(i3);
                            }
                        }
                        if (container.getBond(parent, atom).getStereo() == 1) {
                            for (i3 = 0; i3 < chiralNeighbours.size(); ++i3) {
                                if (chiralNeighbours.get(i3) == parent) continue;
                                if (container.getBond((Atom)chiralNeighbours.get(i3), atom).getStereo() == 0 && this.isLeft((Atom)chiralNeighbours.get(i3), parent, atom) && !this.isBondBroken((Atom)chiralNeighbours.get(i3), atom)) {
                                    sorted[1] = (Atom)chiralNeighbours.get(i3);
                                }
                                if (container.getBond((Atom)chiralNeighbours.get(i3), atom).getStereo() == 0 && !this.isLeft((Atom)chiralNeighbours.get(i3), parent, atom) && !this.isBondBroken((Atom)chiralNeighbours.get(i3), atom)) {
                                    sorted[2] = (Atom)chiralNeighbours.get(i3);
                                }
                                if (container.getBond((Atom)chiralNeighbours.get(i3), atom).getStereo() != -1 || this.isBondBroken((Atom)chiralNeighbours.get(i3), atom)) continue;
                                sorted[0] = (Atom)chiralNeighbours.get(i3);
                            }
                        }
                        if (container.getBond(parent, atom).getStereo() == 4 || container.getBond(parent, atom).getStereo() == 0) {
                            boolean normalBindingIsLeft = false;
                            for (i2 = 0; i2 < chiralNeighbours.size(); ++i2) {
                                if (chiralNeighbours.get(i2) == parent || container.getBond((Atom)chiralNeighbours.get(i2), atom).getStereo() != 0 || !this.isLeft((Atom)chiralNeighbours.get(i2), parent, atom)) continue;
                                normalBindingIsLeft = true;
                                break;
                            }
                            for (i2 = 0; i2 < chiralNeighbours.size(); ++i2) {
                                if (chiralNeighbours.get(i2) == parent) continue;
                                if (normalBindingIsLeft) {
                                    if (container.getBond((Atom)chiralNeighbours.get(i2), atom).getStereo() == 0) {
                                        sorted[0] = (Atom)chiralNeighbours.get(i2);
                                    }
                                    if (container.getBond((Atom)chiralNeighbours.get(i2), atom).getStereo() == 1) {
                                        sorted[2] = (Atom)chiralNeighbours.get(i2);
                                    }
                                    if (container.getBond((Atom)chiralNeighbours.get(i2), atom).getStereo() != -1) continue;
                                    sorted[1] = (Atom)chiralNeighbours.get(i2);
                                    continue;
                                }
                                if (container.getBond((Atom)chiralNeighbours.get(i2), atom).getStereo() == 1) {
                                    sorted[1] = (Atom)chiralNeighbours.get(i2);
                                }
                                if (container.getBond((Atom)chiralNeighbours.get(i2), atom).getStereo() == 0) {
                                    sorted[0] = (Atom)chiralNeighbours.get(i2);
                                }
                                if (container.getBond((Atom)chiralNeighbours.get(i2), atom).getStereo() != -1) continue;
                                sorted[2] = (Atom)chiralNeighbours.get(i2);
                            }
                        }
                    }
                    if (this.isTetrahedral(container, atom) == 2) {
                        if (container.getBond(parent, atom).getStereo() == 1) {
                            for (i3 = 0; i3 < chiralNeighbours.size(); ++i3) {
                                if (chiralNeighbours.get(i3) == parent) continue;
                                if (container.getBond((Atom)chiralNeighbours.get(i3), atom).getStereo() == -1 && this.isLeft((Atom)chiralNeighbours.get(i3), parent, atom) && !this.isBondBroken((Atom)chiralNeighbours.get(i3), atom)) {
                                    sorted[1] = (Atom)chiralNeighbours.get(i3);
                                }
                                if (container.getBond((Atom)chiralNeighbours.get(i3), atom).getStereo() == -1 && !this.isLeft((Atom)chiralNeighbours.get(i3), parent, atom) && !this.isBondBroken((Atom)chiralNeighbours.get(i3), atom)) {
                                    sorted[2] = (Atom)chiralNeighbours.get(i3);
                                }
                                if (container.getBond((Atom)chiralNeighbours.get(i3), atom).getStereo() != 1 || this.isBondBroken((Atom)chiralNeighbours.get(i3), atom)) continue;
                                sorted[0] = (Atom)chiralNeighbours.get(i3);
                            }
                        }
                        if (container.getBond(parent, atom).getStereo() == -1) {
                            double angle1 = 0.0;
                            angle2 = 0.0;
                            atom1 = null;
                            atom2 = null;
                            for (i = 0; i < chiralNeighbours.size(); ++i) {
                                if (chiralNeighbours.get(i) == parent) continue;
                                if (container.getBond((Atom)chiralNeighbours.get(i), atom).getStereo() == 1 && !this.isBondBroken((Atom)chiralNeighbours.get(i), atom)) {
                                    if (angle1 == 0.0) {
                                        angle1 = this.giveAngle(atom, parent, (Atom)chiralNeighbours.get(i));
                                        atom1 = (Atom)chiralNeighbours.get(i);
                                    } else {
                                        angle2 = this.giveAngle(atom, parent, (Atom)chiralNeighbours.get(i));
                                        atom2 = (Atom)chiralNeighbours.get(i);
                                    }
                                }
                                if (container.getBond((Atom)chiralNeighbours.get(i), atom).getStereo() != -1 || this.isBondBroken((Atom)chiralNeighbours.get(i), atom)) continue;
                                sorted[1] = (Atom)chiralNeighbours.get(i);
                            }
                            if (angle1 < angle2) {
                                sorted[0] = atom2;
                                sorted[2] = atom1;
                            } else {
                                sorted[0] = atom1;
                                sorted[2] = atom2;
                            }
                        }
                    }
                    if (this.isTetrahedral(container, atom) == 3) {
                        if (container.getBond(parent, atom).getStereo() == 1) {
                            TreeMap<Double, Integer> hm = new TreeMap<Double, Integer>();
                            for (i2 = 0; i2 < chiralNeighbours.size(); ++i2) {
                                if (chiralNeighbours.get(i2) == parent || this.isBondBroken((Atom)chiralNeighbours.get(i2), atom)) continue;
                                hm.put(new Double(this.giveAngle(atom, parent, (Atom)chiralNeighbours.get(i2))), new Integer(i2));
                            }
                            Object[] ohere = hm.values().toArray();
                            for (int i4 = ohere.length - 1; i4 > -1; --i4) {
                                sorted[i4] = (Atom)chiralNeighbours.get((Integer)ohere[i4]);
                            }
                        }
                        if (container.getBond(parent, atom).getStereo() == 0) {
                            double angle1 = 0.0;
                            angle2 = 0.0;
                            atom1 = null;
                            atom2 = null;
                            for (i = 0; i < chiralNeighbours.size(); ++i) {
                                if (chiralNeighbours.get(i) == parent) continue;
                                if (container.getBond((Atom)chiralNeighbours.get(i), atom).getStereo() == 0 && !this.isBondBroken((Atom)chiralNeighbours.get(i), atom)) {
                                    if (angle1 == 0.0) {
                                        angle1 = this.giveAngle(atom, parent, (Atom)chiralNeighbours.get(i));
                                        atom1 = (Atom)chiralNeighbours.get(i);
                                    } else {
                                        angle2 = this.giveAngle(atom, parent, (Atom)chiralNeighbours.get(i));
                                        atom2 = (Atom)chiralNeighbours.get(i);
                                    }
                                }
                                if (container.getBond((Atom)chiralNeighbours.get(i), atom).getStereo() != 1 || this.isBondBroken((Atom)chiralNeighbours.get(i), atom)) continue;
                                sorted[0] = (Atom)chiralNeighbours.get(i);
                            }
                            if (angle1 < angle2) {
                                sorted[1] = atom2;
                                sorted[2] = atom1;
                            } else {
                                sorted[1] = atom1;
                                sorted[2] = atom2;
                            }
                        }
                    }
                    if (this.isTetrahedral(container, atom) == 4) {
                        if (container.getBond(parent, atom).getStereo() == -1) {
                            TreeMap<Double, Integer> hm = new TreeMap<Double, Integer>();
                            for (int i5 = 0; i5 < chiralNeighbours.size(); ++i5) {
                                if (chiralNeighbours.get(i5) == parent || this.isBondBroken((Atom)chiralNeighbours.get(i5), atom)) continue;
                                hm.put(new Double(this.giveAngle(atom, parent, (Atom)chiralNeighbours.get(i5))), new Integer(i5));
                            }
                            Object[] ohere = hm.values().toArray();
                            for (int i6 = ohere.length - 1; i6 > -1; --i6) {
                                sorted[i6] = (Atom)chiralNeighbours.get((Integer)ohere[i6]);
                            }
                        }
                        if (container.getBond(parent, atom).getStereo() == 0) {
                            double angle1 = 0.0;
                            double angle22 = 0.0;
                            atom1 = null;
                            atom2 = null;
                            for (i = 0; i < chiralNeighbours.size(); ++i) {
                                if (chiralNeighbours.get(i) == parent) continue;
                                if (container.getBond((Atom)chiralNeighbours.get(i), atom).getStereo() == 0 && !this.isBondBroken((Atom)chiralNeighbours.get(i), atom)) {
                                    if (angle1 == 0.0) {
                                        angle1 = this.giveAngle(atom, parent, (Atom)chiralNeighbours.get(i));
                                        atom1 = (Atom)chiralNeighbours.get(i);
                                    } else {
                                        angle22 = this.giveAngle(atom, parent, (Atom)chiralNeighbours.get(i));
                                        atom2 = (Atom)chiralNeighbours.get(i);
                                    }
                                }
                                if (container.getBond((Atom)chiralNeighbours.get(i), atom).getStereo() != -1 || this.isBondBroken((Atom)chiralNeighbours.get(i), atom)) continue;
                                sorted[2] = (Atom)chiralNeighbours.get(i);
                            }
                            if (angle1 < angle22) {
                                sorted[1] = atom2;
                                sorted[0] = atom1;
                            } else {
                                sorted[1] = atom1;
                                sorted[0] = atom2;
                            }
                        }
                    }
                    if (this.isTetrahedral(container, atom) == 5) {
                        if (container.getBond(parent, atom).getStereo() == -1) {
                            for (int i7 = 0; i7 < chiralNeighbours.size(); ++i7) {
                                if (chiralNeighbours.get(i7) == parent) continue;
                                if (container.getBond((Atom)chiralNeighbours.get(i7), atom).getStereo() == 1) {
                                    sorted[0] = (Atom)chiralNeighbours.get(i7);
                                }
                                if (container.getBond((Atom)chiralNeighbours.get(i7), atom).getStereo() == 0) {
                                    sorted[2] = (Atom)chiralNeighbours.get(i7);
                                }
                                if (container.getBond((Atom)chiralNeighbours.get(i7), atom).getStereo() != -1) continue;
                                sorted[1] = (Atom)chiralNeighbours.get(i7);
                            }
                        }
                        if (container.getBond(parent, atom).getStereo() == 1) {
                            for (int i8 = 0; i8 < chiralNeighbours.size(); ++i8) {
                                if (chiralNeighbours.get(i8) == parent) continue;
                                if (container.getBond((Atom)chiralNeighbours.get(i8), atom).getStereo() == -1 && this.isLeft((Atom)chiralNeighbours.get(i8), parent, atom) && !this.isBondBroken((Atom)chiralNeighbours.get(i8), atom)) {
                                    sorted[0] = (Atom)chiralNeighbours.get(i8);
                                }
                                if (container.getBond((Atom)chiralNeighbours.get(i8), atom).getStereo() == -1 && !this.isLeft((Atom)chiralNeighbours.get(i8), parent, atom) && !this.isBondBroken((Atom)chiralNeighbours.get(i8), atom)) {
                                    sorted[2] = (Atom)chiralNeighbours.get(i8);
                                }
                                if (container.getBond((Atom)chiralNeighbours.get(i8), atom).getStereo() != 0) continue;
                                sorted[1] = (Atom)chiralNeighbours.get(i8);
                            }
                        }
                        if (container.getBond(parent, atom).getStereo() == 4 || container.getBond(parent, atom).getStereo() == 0) {
                            for (int i9 = 0; i9 < chiralNeighbours.size(); ++i9) {
                                if (chiralNeighbours.get(i9) == parent) continue;
                                if (container.getBond((Atom)chiralNeighbours.get(i9), atom).getStereo() == -1 && this.isLeft((Atom)chiralNeighbours.get(i9), parent, atom) && !this.isBondBroken((Atom)chiralNeighbours.get(i9), atom)) {
                                    sorted[0] = (Atom)chiralNeighbours.get(i9);
                                }
                                if (container.getBond((Atom)chiralNeighbours.get(i9), atom).getStereo() == -1 && !this.isLeft((Atom)chiralNeighbours.get(i9), parent, atom) && !this.isBondBroken((Atom)chiralNeighbours.get(i9), atom)) {
                                    sorted[2] = (Atom)chiralNeighbours.get(i9);
                                }
                                if (container.getBond((Atom)chiralNeighbours.get(i9), atom).getStereo() != 1) continue;
                                sorted[1] = (Atom)chiralNeighbours.get(i9);
                            }
                        }
                    }
                    if (this.isTetrahedral(container, atom) == 6) {
                        if (container.getBond(parent, atom).getStereo() == 1) {
                            for (int i10 = 0; i10 < chiralNeighbours.size(); ++i10) {
                                if (chiralNeighbours.get(i10) == parent) continue;
                                if (container.getBond((Atom)chiralNeighbours.get(i10), atom).getStereo() == 1) {
                                    sorted[0] = (Atom)chiralNeighbours.get(i10);
                                }
                                if (container.getBond((Atom)chiralNeighbours.get(i10), atom).getStereo() == 0) {
                                    sorted[2] = (Atom)chiralNeighbours.get(i10);
                                }
                                if (container.getBond((Atom)chiralNeighbours.get(i10), atom).getStereo() != -1) continue;
                                sorted[1] = (Atom)chiralNeighbours.get(i10);
                            }
                        }
                        if (container.getBond(parent, atom).getStereo() == -1) {
                            for (int i11 = 0; i11 < chiralNeighbours.size(); ++i11) {
                                if (chiralNeighbours.get(i11) == parent) continue;
                                if (container.getBond((Atom)chiralNeighbours.get(i11), atom).getStereo() == 1 && this.isLeft((Atom)chiralNeighbours.get(i11), parent, atom) && !this.isBondBroken((Atom)chiralNeighbours.get(i11), atom)) {
                                    sorted[2] = (Atom)chiralNeighbours.get(i11);
                                }
                                if (container.getBond((Atom)chiralNeighbours.get(i11), atom).getStereo() == 1 && !this.isLeft((Atom)chiralNeighbours.get(i11), parent, atom) && !this.isBondBroken((Atom)chiralNeighbours.get(i11), atom)) {
                                    sorted[0] = (Atom)chiralNeighbours.get(i11);
                                }
                                if (container.getBond((Atom)chiralNeighbours.get(i11), atom).getStereo() != 0) continue;
                                sorted[1] = (Atom)chiralNeighbours.get(i11);
                            }
                        }
                        if (container.getBond(parent, atom).getStereo() == 4 || container.getBond(parent, atom).getStereo() == 0) {
                            for (int i12 = 0; i12 < chiralNeighbours.size(); ++i12) {
                                if (chiralNeighbours.get(i12) == parent) continue;
                                if (container.getBond((Atom)chiralNeighbours.get(i12), atom).getStereo() == 1 && this.isLeft((Atom)chiralNeighbours.get(i12), parent, atom) && !this.isBondBroken((Atom)chiralNeighbours.get(i12), atom)) {
                                    sorted[2] = (Atom)chiralNeighbours.get(i12);
                                }
                                if (container.getBond((Atom)chiralNeighbours.get(i12), atom).getStereo() == 1 && !this.isLeft((Atom)chiralNeighbours.get(i12), parent, atom) && !this.isBondBroken((Atom)chiralNeighbours.get(i12), atom)) {
                                    sorted[0] = (Atom)chiralNeighbours.get(i12);
                                }
                                if (container.getBond((Atom)chiralNeighbours.get(i12), atom).getStereo() != -1) continue;
                                sorted[1] = (Atom)chiralNeighbours.get(i12);
                            }
                        }
                    }
                    if (this.isSquarePlanar(container, atom)) {
                        sorted = new Atom[3];
                        TreeMap<Double, Integer> hm = new TreeMap<Double, Integer>();
                        for (int i13 = 0; i13 < chiralNeighbours.size(); ++i13) {
                            if (chiralNeighbours.get(i13) == parent || this.isBondBroken((Atom)chiralNeighbours.get(i13), atom)) continue;
                            hm.put(new Double(this.giveAngle(atom, parent, (Atom)chiralNeighbours.get(i13))), new Integer(i13));
                        }
                        Object[] ohere = hm.values().toArray();
                        for (int i14 = 0; i14 < ohere.length; ++i14) {
                            sorted[i14] = (Atom)chiralNeighbours.get((Integer)ohere[i14]);
                        }
                    }
                    if (this.isTrigonalBipyramidalOrOctahedral(container, atom)) {
                        sorted = new Atom[container.getConnectedAtoms(atom).length - 1];
                        TreeMap<Double, Integer> hm = new TreeMap<Double, Integer>();
                        if (container.getBond(parent, atom).getStereo() == 1) {
                            for (int i15 = 0; i15 < chiralNeighbours.size(); ++i15) {
                                if (container.getBond(atom, (Atom)chiralNeighbours.get(i15)).getStereo() == 0) {
                                    hm.put(new Double(this.giveAngle(atom, parent, (Atom)chiralNeighbours.get(i15))), new Integer(i15));
                                }
                                if (container.getBond(atom, (Atom)chiralNeighbours.get(i15)).getStereo() != -1) continue;
                                sorted[sorted.length - 1] = (Atom)chiralNeighbours.get(i15);
                            }
                            Object[] ohere = hm.values().toArray();
                            for (int i16 = 0; i16 < ohere.length; ++i16) {
                                sorted[i16] = (Atom)chiralNeighbours.get((Integer)ohere[i16]);
                            }
                        }
                        if (container.getBond(parent, atom).getStereo() == -1) {
                            for (int i17 = 0; i17 < chiralNeighbours.size(); ++i17) {
                                if (container.getBond(atom, (Atom)chiralNeighbours.get(i17)).getStereo() == 0) {
                                    hm.put(new Double(this.giveAngle(atom, parent, (Atom)chiralNeighbours.get(i17))), new Integer(i17));
                                }
                                if (container.getBond(atom, (Atom)chiralNeighbours.get(i17)).getStereo() != 1) continue;
                                sorted[sorted.length - 1] = (Atom)chiralNeighbours.get(i17);
                            }
                            Object[] ohere = hm.values().toArray();
                            for (int i18 = 0; i18 < ohere.length; ++i18) {
                                sorted[i18] = (Atom)chiralNeighbours.get((Integer)ohere[i18]);
                            }
                        }
                        if (container.getBond(parent, atom).getStereo() == 0) {
                            for (int i19 = 0; i19 < chiralNeighbours.size(); ++i19) {
                                if (chiralNeighbours.get(i19) == parent) continue;
                                if (container.getBond(atom, (Atom)chiralNeighbours.get(i19)).getStereo() == 0) {
                                    hm.put(new Double(this.giveAngleFromMiddle(atom, parent, (Atom)chiralNeighbours.get(i19))), new Integer(i19));
                                }
                                if (container.getBond(atom, (Atom)chiralNeighbours.get(i19)).getStereo() == 1) {
                                    sorted[0] = (Atom)chiralNeighbours.get(i19);
                                }
                                if (container.getBond(atom, (Atom)chiralNeighbours.get(i19)).getStereo() != -1) continue;
                                sorted[sorted.length - 2] = (Atom)chiralNeighbours.get(i19);
                            }
                            Object[] ohere = hm.values().toArray();
                            sorted[sorted.length - 1] = (Atom)chiralNeighbours.get((Integer)ohere[ohere.length - 1]);
                            if (ohere.length == 2) {
                                sorted[sorted.length - 3] = (Atom)chiralNeighbours.get((Integer)ohere[0]);
                                if (this.giveAngleFromMiddle(atom, parent, (Atom)chiralNeighbours.get((Integer)ohere[1])) < 0.0) {
                                    Atom dummy = sorted[sorted.length - 2];
                                    sorted[sorted.length - 2] = sorted[0];
                                    sorted[0] = dummy;
                                }
                            }
                            if (ohere.length == 3) {
                                sorted[sorted.length - 3] = sorted[sorted.length - 2];
                                sorted[sorted.length - 2] = (Atom)chiralNeighbours.get((Integer)ohere[ohere.length - 2]);
                                sorted[sorted.length - 4] = (Atom)chiralNeighbours.get((Integer)ohere[ohere.length - 3]);
                            }
                        }
                    }
                    if (sorted != null) {
                        int k;
                        int numberOfAtoms = 3;
                        if (this.isTrigonalBipyramidalOrOctahedral(container, atom)) {
                            numberOfAtoms = container.getConnectedAtoms(atom).length - 1;
                        }
                        Object[] omy = new Object[numberOfAtoms];
                        Object[] onew = new Object[numberOfAtoms];
                        for (k = this.getRingOpenings(atom, null).size(); k < numberOfAtoms; ++k) {
                            if (positionInVector + 1 + k - this.getRingOpenings(atom, null).size() >= v.size()) continue;
                            omy[k] = v.get(positionInVector + 1 + k - this.getRingOpenings(atom, null).size());
                        }
                        for (k = 0; k < sorted.length; ++k) {
                            if (sorted[k] != null) {
                                for (int m = 0; m < omy.length; ++m) {
                                    if (omy[m] instanceof Atom) {
                                        if (omy[m] != sorted[k]) continue;
                                        onew[k] = omy[m];
                                        continue;
                                    }
                                    if (omy[m] == null) {
                                        onew[k] = null;
                                        continue;
                                    }
                                    if (((Vector)omy[m]).get(0) != sorted[k]) continue;
                                    onew[k] = omy[m];
                                }
                                continue;
                            }
                            onew[k] = null;
                        }
                        boolean doubleentry = false;
                        for (int m = 0; m < onew.length; ++m) {
                            for (int k2 = 0; k2 < onew.length; ++k2) {
                                if (m == k2 || onew[k2] != onew[m]) continue;
                                doubleentry = true;
                            }
                        }
                        if (!doubleentry) {
                            if (positionInVector + 1 < v.size()) {
                                Object atomAfterCenterInOriginalSmiles = v.get(positionInVector + 1);
                                int l = 0;
                                while (onew[0] != atomAfterCenterInOriginalSmiles) {
                                    Object placeholder = onew[onew.length - 1];
                                    for (int k3 = onew.length - 2; k3 > -1; --k3) {
                                        onew[k3 + 1] = onew[k3];
                                    }
                                    onew[0] = placeholder;
                                    if (++l <= onew.length) continue;
                                    break;
                                }
                            }
                            if (this.getRingOpenings(atom, null).size() > 0) {
                                int l = 0;
                                while (onew[0] != null) {
                                    Object placeholder = onew[0];
                                    for (int k4 = 1; k4 < onew.length; ++k4) {
                                        onew[k4 - 1] = onew[k4];
                                    }
                                    onew[onew.length - 1] = placeholder;
                                    if (++l <= onew.length) continue;
                                    break;
                                }
                            }
                            if (onew[numberOfAtoms - 1] instanceof Vector) {
                                for (int i20 = 0; i20 < numberOfAtoms; ++i20) {
                                    int k5;
                                    if (!(onew[i20] instanceof Atom)) continue;
                                    Vector<Object> vtemp = new Vector<Object>();
                                    vtemp.add(onew[i20]);
                                    for (k5 = positionInVector + 1 + numberOfAtoms; k5 < v.size(); ++k5) {
                                        vtemp.add(v.get(k5));
                                    }
                                    onew[i20] = vtemp;
                                    for (k5 = v.size() - 1; k5 > positionInVector + 1 + numberOfAtoms - 1; --k5) {
                                        v.remove(k5);
                                    }
                                    for (k5 = 1; k5 < ((Vector)onew[numberOfAtoms - 1]).size(); ++k5) {
                                        v.add(((Vector)onew[numberOfAtoms - 1]).get(k5));
                                    }
                                    onew[numberOfAtoms - 1] = ((Vector)onew[numberOfAtoms - 1]).get(0);
                                    break;
                                }
                            }
                            int k6 = 0;
                            for (int m = 0; m < onew.length; ++m) {
                                if (onew[m] == null) continue;
                                v.set(positionInVector + 1 + k6, onew[m]);
                                ++k6;
                            }
                        }
                    }
                }
                parent = atom;
            } else {
                boolean brackets = true;
                Vector result = new Vector();
                this.addAtoms((Vector)o, result);
                if (this.isRingOpening(parent, result) && container.getBondCount(parent) < 4) {
                    brackets = false;
                }
                if (brackets) {
                    buffer.append('(');
                }
                this.parseChain((Vector)o, buffer, container, parent, chiral, doubleBondConfiguration, atomsInOrderOfSmiles);
                if (brackets) {
                    buffer.append(')');
                }
            }
            ++positionInVector;
        }
    }

    private void parseBond(StringBuffer line, Atom a1, Atom a2, AtomContainer atomContainer) {
        if (a1.getFlag(4) && a1.getFlag(4)) {
            return;
        }
        if (atomContainer.getBond(a1, a2) == null) {
            return;
        }
        int type = 0;
        type = (int)atomContainer.getBond(a1, a2).getOrder();
        if (type != 1) {
            if (type == 2) {
                line.append("=");
            } else if (type == 3) {
                line.append("#");
            }
        }
    }

    private void parseAtom(Atom a, StringBuffer buffer, AtomContainer container, boolean chiral, boolean[] doubleBondConfiguration, Atom parent, Vector atomsInOrderOfSmiles, Vector currentChain) {
        String symbol = a.getSymbol();
        boolean stereo = this.isStereo(container, a);
        boolean brackets = symbol.equals("B") || symbol.equals("C") || symbol.equals("N") || symbol.equals("O") || symbol.equals("P") || symbol.equals("S") || symbol.equals("F") || symbol.equals("Br") || symbol.equals("I") || symbol.equals("Cl");
        boolean bl = brackets = !brackets;
        if (this.isStartOfDoubleBond(container, a, parent, doubleBondConfiguration)) {
            buffer.append('/');
        }
        if (a instanceof PseudoAtom) {
            buffer.append("[*]");
        } else {
            String mass = this.generateMassString(a);
            brackets |= !mass.equals("");
            String charge = this.generateChargeString(a);
            brackets |= !charge.equals("");
            if (chiral && stereo) {
                brackets = true;
            }
            if (brackets) {
                buffer.append('[');
            }
            buffer.append(mass);
            if (a.getFlag(4)) {
                buffer.append(a.getSymbol().toLowerCase());
            } else if (a.getHybridization() == 2) {
                buffer.append(a.getSymbol().toLowerCase());
            } else {
                buffer.append(symbol);
            }
            if (a.getProperty("stereoconfig") != null && a.getProperty("stereoconfig").equals("up")) {
                buffer.append('/');
            }
            if (a.getProperty("stereoconfig") != null && a.getProperty("stereoconfig").equals("down")) {
                buffer.append('\\');
            }
            if (chiral && stereo && (this.isTrigonalBipyramidalOrOctahedral(container, a) || this.isSquarePlanar(container, a) || this.isTetrahedral(container, a) != 0)) {
                buffer.append('@');
            }
            if (chiral && stereo && this.isSquarePlanar(container, a)) {
                buffer.append("SP1");
            }
            buffer.append(charge);
            if (brackets) {
                buffer.append(']');
            }
        }
        if (this.isEndOfDoubleBond(container, a, parent, doubleBondConfiguration)) {
            boolean secondDirection;
            boolean firstDirection;
            int i;
            Atom viewFrom = null;
            block0: for (i = 0; i < currentChain.size(); ++i) {
                if (currentChain.get(i) != parent) continue;
                for (int k = i - 1; k > -1; --k) {
                    if (!(currentChain.get(k) instanceof Atom)) continue;
                    viewFrom = (Atom)currentChain.get(k);
                    continue block0;
                }
            }
            if (viewFrom == null) {
                for (i = 0; i < atomsInOrderOfSmiles.size(); ++i) {
                    if (atomsInOrderOfSmiles.get(i) != parent) continue;
                    viewFrom = (Atom)atomsInOrderOfSmiles.get(i - 1);
                }
            }
            boolean afterThisAtom = false;
            Atom viewTo = null;
            for (int i2 = 0; i2 < currentChain.size(); ++i2) {
                if (afterThisAtom && currentChain.get(i2) instanceof Atom) {
                    viewTo = (Atom)currentChain.get(i2);
                    break;
                }
                if (afterThisAtom && currentChain.get(i2) instanceof Vector) {
                    viewTo = (Atom)((Vector)currentChain.get(i2)).get(0);
                    break;
                }
                if (a != currentChain.get(i2)) continue;
                afterThisAtom = true;
            }
            if ((firstDirection = this.isLeft(viewFrom, a, parent)) == (secondDirection = this.isLeft(viewTo, parent, a))) {
                buffer.append('\\');
            } else {
                buffer.append('/');
            }
        }
        Vector v = new Vector();
        Iterator it = this.getRingOpenings(a, v).iterator();
        Iterator it2 = v.iterator();
        while (it.hasNext()) {
            Integer integer = (Integer)it.next();
            Bond b = container.getBond((Atom)it2.next(), a);
            int type = (int)b.getOrder();
            if (type == 2 && !b.getFlag(4)) {
                buffer.append("=");
            } else if (type == 3 && !b.getFlag(4)) {
                buffer.append("#");
            }
            buffer.append(integer);
        }
        atomsInOrderOfSmiles.add(a);
    }

    private String generateChargeString(Atom a) {
        int charge = a.getFormalCharge();
        StringBuffer buffer = new StringBuffer(3);
        if (charge > 0) {
            buffer.append('+');
            if (charge > 1) {
                buffer.append(charge);
            }
        } else if (charge < 0) {
            if (charge == -1) {
                buffer.append('-');
            } else {
                buffer.append(charge);
            }
        }
        return buffer.toString();
    }

    private String generateMassString(Atom a) {
        Isotope majorIsotope = this.isotopeFactory.getMajorIsotope(a.getSymbol());
        if (majorIsotope.getExactMass() == a.getExactMass()) {
            return "";
        }
        if (a.getMassNumber() == 0) {
            return "";
        }
        return Integer.toString(a.getMassNumber());
    }

    class BrokenBond {
        private Atom a1;
        private Atom a2;
        private int marker;

        BrokenBond(Atom a1, Atom a2, int marker) {
            this.a1 = a1;
            this.a2 = a2;
            this.marker = marker;
        }

        public Atom getA1() {
            return this.a1;
        }

        public Atom getA2() {
            return this.a2;
        }

        public int getMarker() {
            return this.marker;
        }

        public String toString() {
            return Integer.toString(this.marker);
        }

        public boolean equals(Object o) {
            if (!(o instanceof BrokenBond)) {
                return false;
            }
            BrokenBond bond = (BrokenBond)o;
            return this.a1.equals(bond.getA1()) && this.a2.equals(bond.getA2()) || this.a1.equals(bond.getA2()) && this.a2.equals(bond.getA1());
        }
    }
}

