/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.formats;

import org.openscience.cdk.io.formats.ChemFormatMatcher;

public class MDLFormat
implements ChemFormatMatcher {
    public String getFormatName() {
        return "MDL Mol/SDF";
    }

    public String getReaderClassName() {
        return "org.openscience.cdk.io.MDLReader";
    }

    public String getWriterClassName() {
        return "org.openscience.cdk.io.MDLWriter";
    }

    public boolean matches(int lineNumber, String line) {
        if (lineNumber == 4 && (line.indexOf("v2000") >= 0 || line.indexOf("V2000") >= 0)) {
            return true;
        }
        if (line.startsWith("M  END")) {
            return true;
        }
        if (lineNumber == 4 && line.length() > 7) {
            try {
                String atomCountString = line.substring(0, 3).trim();
                String bondCountString = line.substring(3, 6).trim();
                new Integer(atomCountString);
                new Integer(bondCountString);
                boolean mdlFile = true;
                if (line.length() > 6) {
                    String remainder = line.substring(6).trim();
                    for (int i = 0; i < remainder.length(); ++i) {
                        char c = remainder.charAt(i);
                        if (Character.isDigit(c) || Character.isWhitespace(c)) continue;
                        mdlFile = false;
                    }
                }
                if (mdlFile) {
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }
}

