/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.cml;

import java.util.StringTokenizer;
import org.openscience.cdk.io.cml.CMLCoreModule;
import org.openscience.cdk.io.cml.CMLStack;
import org.openscience.cdk.io.cml.ModuleInterface;
import org.openscience.cdk.io.cml.cdopi.CDOInterface;
import org.xml.sax.Attributes;

public class PMPConvention
extends CMLCoreModule {
    public PMPConvention(CDOInterface cdo) {
        super(cdo);
    }

    public PMPConvention(ModuleInterface conv) {
        super(conv);
        this.logger.debug("New PMP Convention!");
    }

    public CDOInterface returnCDO() {
        return this.cdo;
    }

    public void startDocument() {
        super.startDocument();
        this.cdo.startObject("Frame");
    }

    public void endDocument() {
        this.cdo.endObject("Frame");
        super.endDocument();
    }

    public void startElement(CMLStack xpath, String uri, String local, String raw, Attributes atts) {
        this.logger.debug("PMP element: name");
        super.startElement(xpath, uri, local, raw, atts);
    }

    public void endElement(CMLStack xpath, String uri, String local, String raw) {
        super.endElement(xpath, uri, local, raw);
    }

    public void characterData(CMLStack xpath, char[] ch, int start, int length) {
        String s = new String(ch, start, length).trim();
        this.logger.debug("Start PMP chardata (" + this.CurrentElement + ") :" + s);
        this.logger.debug(" ElTitle: " + this.elementTitle);
        if (xpath.toString().endsWith("string/") && this.BUILTIN.equals("spacegroup")) {
            String sg = "P1";
            if ("P 21 21 21 (1)".equals(s)) {
                sg = "P 2_1 2_1 2_1";
            }
            this.cdo.setObjectProperty("Crystal", "spacegroup", sg);
        } else if (xpath.toString().endsWith("floatArray/") && (this.elementTitle.equals("a") || this.elementTitle.equals("b") || this.elementTitle.equals("c"))) {
            String axis = this.elementTitle + "-axis";
            this.cdo.startObject(axis);
            try {
                StringTokenizer st = new StringTokenizer(s);
                this.logger.debug("Tokens: " + st.countTokens());
                if (st.countTokens() > 2) {
                    String token = st.nextToken();
                    this.logger.debug("FloatArray (Token): " + token);
                    this.cdo.setObjectProperty(axis, "x", token);
                    token = st.nextToken();
                    this.logger.debug("FloatArray (Token): " + token);
                    this.cdo.setObjectProperty(axis, "y", token);
                    token = st.nextToken();
                    this.logger.debug("FloatArray (Token): " + token);
                    this.cdo.setObjectProperty(axis, "z", token);
                } else {
                    this.logger.debug("PMP Convention error: incorrect number of cell axis fractions!\n");
                }
            }
            catch (Exception e) {
                this.logger.debug("PMP Convention error: " + e.toString());
            }
            this.cdo.endObject(axis);
        } else {
            super.characterData(xpath, ch, start, length);
        }
        this.logger.debug("End PMP chardata");
    }
}

