/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.cml;

import java.util.StringTokenizer;
import org.openscience.cdk.io.cml.CMLCoreModule;
import org.openscience.cdk.io.cml.CMLStack;
import org.openscience.cdk.io.cml.ModuleInterface;
import org.openscience.cdk.io.cml.cdopi.CDOInterface;
import org.xml.sax.Attributes;

public class PDBConvention
extends CMLCoreModule {
    private boolean connectionTable;
    private boolean isELSYM;
    private boolean isBond;
    private String connect_root;

    public PDBConvention(CDOInterface cdo) {
        super(cdo);
    }

    public PDBConvention(ModuleInterface conv) {
        super(conv);
    }

    public CDOInterface returnCDO() {
        return this.cdo;
    }

    public void startDocument() {
        super.startDocument();
        this.cdo.startObject("Frame");
        this.cdo.startObject("Molecule");
    }

    public void endDocument() {
        this.storeData();
        this.cdo.endObject("Molecule");
        this.cdo.endObject("Frame");
        super.endDocument();
    }

    public void startElement(CMLStack xpath, String uri, String local, String raw, Attributes atts) {
        String name = raw;
        this.isELSYM = false;
        if ("list".equals(name)) {
            for (int i = 0; i < atts.getLength(); ++i) {
                if (atts.getQName(i).equals("title") && atts.getValue(i).equals("sequence")) continue;
                if (atts.getQName(i).equals("title") && atts.getValue(i).equals("connections")) {
                    this.logger.debug("Assuming that Atom's have been read: storing them");
                    super.storeAtomData();
                    this.connectionTable = true;
                    this.logger.debug("Start Connection Table");
                    continue;
                }
                if (atts.getQName(i).equals("title") && atts.getValue(i).equals("connect")) {
                    this.logger.debug("New connection");
                    this.isBond = true;
                    continue;
                }
                if (!atts.getQName(i).equals("id") || !this.isBond) continue;
                this.connect_root = atts.getValue(i);
            }
        } else {
            super.startElement(xpath, uri, local, raw, atts);
        }
    }

    public void endElement(CMLStack xpath, String uri, String local, String raw) {
        String name = raw;
        if (name.equals("list") && this.connectionTable && !this.isBond) {
            this.logger.debug("End Connection Table");
            this.connectionTable = false;
        }
        this.isELSYM = false;
        this.isBond = false;
        super.endElement(xpath, uri, local, raw);
    }

    public void characterData(CMLStack xpath, char[] ch, int start, int length) {
        String s = new String(ch, start, length).trim();
        if (this.isELSYM) {
            this.elsym.addElement(s);
        } else if (this.isBond) {
            this.logger.debug("CD (bond): " + s);
            if (this.connect_root.length() > 0) {
                StringTokenizer st = new StringTokenizer(s);
                while (st.hasMoreElements()) {
                    String atom = (String)st.nextElement();
                    if (atom.equals("0")) continue;
                    this.logger.debug("new bond: " + this.connect_root + "-" + atom);
                    this.cdo.startObject("Bond");
                    int atom1 = Integer.parseInt(this.connect_root) - 1;
                    int atom2 = Integer.parseInt(atom) - 1;
                    this.cdo.setObjectProperty("Bond", "atom1", new Integer(atom1).toString());
                    this.cdo.setObjectProperty("Bond", "atom2", new Integer(atom2).toString());
                    this.cdo.setObjectProperty("Bond", "order", "1");
                    this.cdo.endObject("Bond");
                }
            }
        } else {
            super.characterData(xpath, ch, start, length);
        }
    }
}

