/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.StringTokenizer;
import javax.vecmath.Point3d;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.geometry.ZMatrixTools;
import org.openscience.cdk.interfaces.ChemFile;
import org.openscience.cdk.interfaces.ChemModel;
import org.openscience.cdk.interfaces.ChemObject;
import org.openscience.cdk.interfaces.ChemSequence;
import org.openscience.cdk.interfaces.Molecule;
import org.openscience.cdk.interfaces.SetOfMolecules;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.formats.ChemFormat;
import org.openscience.cdk.io.formats.ZMatrixFormat;

public class ZMatrixReader
extends DefaultChemObjectReader {
    private BufferedReader input;

    public ZMatrixReader(Reader input) {
        this.input = new BufferedReader(input);
    }

    public ZMatrixReader(InputStream input) {
        this(new InputStreamReader(input));
    }

    public ZMatrixReader() {
        this(new StringReader(""));
    }

    public ChemFormat getFormat() {
        return new ZMatrixFormat();
    }

    public void setReader(Reader input) throws CDKException {
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
    }

    public void setReader(InputStream input) throws CDKException {
        this.setReader(new InputStreamReader(input));
    }

    public ChemObject read(ChemObject object) throws CDKException {
        if (object instanceof ChemFile) {
            return this.readChemFile((ChemFile)object);
        }
        throw new CDKException("Only ChemFile objects can be read.");
    }

    private ChemFile readChemFile(ChemFile file) {
        ChemSequence chemSequence = file.getBuilder().newChemSequence();
        int number_of_atoms = 0;
        try {
            String line = this.input.readLine();
            while (line.startsWith("#")) {
                line = this.input.readLine();
            }
            System.out.println("lauf");
            StringTokenizer tokenizer = new StringTokenizer(line, "\t ,;");
            String token = tokenizer.nextToken();
            number_of_atoms = Integer.parseInt(token);
            String info = this.input.readLine();
            ChemModel chemModel = file.getBuilder().newChemModel();
            SetOfMolecules setOfMolecules = file.getBuilder().newSetOfMolecules();
            Molecule m = file.getBuilder().newMolecule();
            m.setProperty("Title", info);
            String[] types = new String[number_of_atoms];
            double[] d = new double[number_of_atoms];
            int[] d_atom = new int[number_of_atoms];
            double[] a = new double[number_of_atoms];
            int[] a_atom = new int[number_of_atoms];
            double[] da = new double[number_of_atoms];
            int[] da_atom = new int[number_of_atoms];
            Point3d[] pos = new Point3d[number_of_atoms];
            int i = 0;
            while (i < number_of_atoms) {
                line = this.input.readLine();
                System.out.println("line:\"" + line + "\"");
                if (line == null) break;
                if (line.startsWith("#")) continue;
                d[i] = 0.0;
                d_atom[i] = -1;
                a[i] = 0.0;
                a_atom[i] = -1;
                da[i] = 0.0;
                da_atom[i] = -1;
                tokenizer = new StringTokenizer(line, "\t ,;");
                int fields = tokenizer.countTokens();
                if (fields < Math.min(i * 2 + 1, 7)) continue;
                if (i == 0) {
                    types[i] = tokenizer.nextToken();
                    ++i;
                    continue;
                }
                if (i == 1) {
                    types[i] = tokenizer.nextToken();
                    d_atom[i] = new Integer(tokenizer.nextToken()) - 1;
                    d[i] = new Double(tokenizer.nextToken());
                    ++i;
                    continue;
                }
                if (i == 2) {
                    types[i] = tokenizer.nextToken();
                    d_atom[i] = new Integer(tokenizer.nextToken()) - 1;
                    d[i] = new Double(tokenizer.nextToken());
                    a_atom[i] = new Integer(tokenizer.nextToken()) - 1;
                    a[i] = new Double(tokenizer.nextToken());
                    ++i;
                    continue;
                }
                types[i] = tokenizer.nextToken();
                d_atom[i] = new Integer(tokenizer.nextToken()) - 1;
                d[i] = new Double(tokenizer.nextToken());
                a_atom[i] = new Integer(tokenizer.nextToken()) - 1;
                a[i] = new Double(tokenizer.nextToken());
                da_atom[i] = new Integer(tokenizer.nextToken()) - 1;
                da[i] = new Double(tokenizer.nextToken());
                ++i;
            }
            Point3d[] cartCoords = ZMatrixTools.zmatrixToCartesian((double[])d, (int[])d_atom, (double[])a, (int[])a_atom, (double[])da, (int[])da_atom);
            for (i = 0; i < number_of_atoms; ++i) {
                m.addAtom(file.getBuilder().newAtom(types[i], cartCoords[i]));
            }
            System.out.println("molecule:\n" + m);
            setOfMolecules.addMolecule(m);
            chemModel.setSetOfMolecules(setOfMolecules);
            chemSequence.addChemModel(chemModel);
            line = this.input.readLine();
            file.addChemSequence(chemSequence);
        }
        catch (IOException e) {
            file = null;
        }
        return file;
    }

    public void close() throws IOException {
        this.input.close();
    }
}

