/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.vecmath.Point3d;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.Atom;
import org.openscience.cdk.interfaces.ChemObject;
import org.openscience.cdk.interfaces.Molecule;
import org.openscience.cdk.io.DefaultChemObjectWriter;
import org.openscience.cdk.io.formats.ChemFormat;
import org.openscience.cdk.io.formats.XYZFormat;

public class XYZWriter
extends DefaultChemObjectWriter {
    static BufferedWriter writer;

    public XYZWriter(Writer out) {
        writer = new BufferedWriter(out);
    }

    public XYZWriter(OutputStream input) {
        this(new OutputStreamWriter(input));
    }

    public ChemFormat getFormat() {
        return new XYZFormat();
    }

    public void close() throws IOException {
        writer.close();
    }

    public void write(ChemObject object) throws CDKException {
        if (object instanceof Molecule) {
            try {
                this.writeMolecule((Molecule)object);
            }
            catch (Exception ex) {
                throw new CDKException("Error while writing XYZ file: " + ex.getMessage());
            }
        } else {
            throw new CDKException("XYZWriter only supports output of Molecule classes.");
        }
    }

    public void writeMolecule(Molecule mol) throws IOException {
        String st = "";
        boolean writecharge = true;
        String s1 = new Integer(mol.getAtomCount()).toString();
        writer.write(s1, 0, s1.length());
        writer.newLine();
        String s2 = null;
        if (s2 != null) {
            writer.write(s2, 0, s2.length());
        }
        writer.newLine();
        Atom[] atoms = mol.getAtoms();
        for (int i = 0; i < atoms.length; ++i) {
            Atom a = atoms[i];
            st = a.getSymbol();
            Point3d p3 = a.getPoint3d();
            if (p3 != null) {
                st = st + "\t" + new Double(p3.x).toString() + "\t" + new Double(p3.y).toString() + "\t" + new Double(p3.z).toString();
            }
            if (writecharge) {
                double ct = a.getCharge();
                st = st + "\t" + ct;
            }
            writer.write(st, 0, st.length());
            writer.newLine();
        }
    }
}

