/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.StringTokenizer;
import javax.vecmath.Point3d;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.Atom;
import org.openscience.cdk.interfaces.ChemFile;
import org.openscience.cdk.interfaces.ChemModel;
import org.openscience.cdk.interfaces.ChemObject;
import org.openscience.cdk.interfaces.ChemSequence;
import org.openscience.cdk.interfaces.Molecule;
import org.openscience.cdk.interfaces.SetOfMolecules;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.formats.ChemFormat;
import org.openscience.cdk.io.formats.XYZFormat;
import org.openscience.cdk.tools.LoggingTool;

public class XYZReader
extends DefaultChemObjectReader {
    private BufferedReader input;
    private LoggingTool logger;

    public XYZReader(Reader input) {
        this.input = new BufferedReader(input);
        this.logger = new LoggingTool(this);
    }

    public XYZReader(InputStream input) {
        this(new InputStreamReader(input));
    }

    public XYZReader() {
        this(new StringReader(""));
    }

    public ChemFormat getFormat() {
        return new XYZFormat();
    }

    public void setReader(Reader input) throws CDKException {
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
    }

    public void setReader(InputStream input) throws CDKException {
        this.setReader(new InputStreamReader(input));
    }

    public ChemObject read(ChemObject object) throws CDKException {
        if (object instanceof ChemFile) {
            return this.readChemFile((ChemFile)object);
        }
        throw new CDKException("Only supported is reading of ChemFile objects.");
    }

    private ChemFile readChemFile(ChemFile file) {
        ChemSequence chemSequence = file.getBuilder().newChemSequence();
        int number_of_atoms = 0;
        try {
            String line = this.input.readLine();
            while (this.input.ready() && line != null) {
                StringTokenizer tokenizer = new StringTokenizer(line, "\t ,;");
                String token = tokenizer.nextToken();
                number_of_atoms = Integer.parseInt(token);
                String info = this.input.readLine();
                ChemModel chemModel = file.getBuilder().newChemModel();
                SetOfMolecules setOfMolecules = file.getBuilder().newSetOfMolecules();
                Molecule m = file.getBuilder().newMolecule();
                m.setProperty("Title", info);
                for (int i = 0; i < number_of_atoms && (line = this.input.readLine()) != null; ++i) {
                    if (line.startsWith("#") && line.length() > 1) {
                        Object comment = m.getProperty("Comment");
                        if (comment == null) {
                            comment = "";
                        }
                        comment = comment.toString() + line.substring(1).trim();
                        m.setProperty("Comment", comment);
                        this.logger.debug((Object)"Found and set comment: ", comment);
                        continue;
                    }
                    double x = 0.0;
                    double y = 0.0;
                    double z = 0.0;
                    double charge = 0.0;
                    tokenizer = new StringTokenizer(line, "\t ,;");
                    int fields = tokenizer.countTokens();
                    if (fields < 4) continue;
                    String atomtype = tokenizer.nextToken();
                    x = new Double(tokenizer.nextToken());
                    y = new Double(tokenizer.nextToken());
                    z = new Double(tokenizer.nextToken());
                    if (fields == 8) {
                        charge = new Double(tokenizer.nextToken());
                    }
                    Atom atom = file.getBuilder().newAtom(atomtype, new Point3d(x, y, z));
                    atom.setCharge(charge);
                    m.addAtom(atom);
                }
                setOfMolecules.addMolecule(m);
                chemModel.setSetOfMolecules(setOfMolecules);
                chemSequence.addChemModel(chemModel);
                line = this.input.readLine();
            }
            file.addChemSequence(chemSequence);
        }
        catch (IOException e) {
            file = null;
            this.logger.error((Object)"Error while reading file: ", e.getMessage());
            this.logger.debug(e);
        }
        return file;
    }

    public void close() throws IOException {
        this.input.close();
    }
}

