/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.StringTokenizer;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.openscience.cdk.config.IsotopeFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.Atom;
import org.openscience.cdk.interfaces.ChemFile;
import org.openscience.cdk.interfaces.ChemModel;
import org.openscience.cdk.interfaces.ChemObject;
import org.openscience.cdk.interfaces.ChemSequence;
import org.openscience.cdk.interfaces.Crystal;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.formats.ChemFormat;
import org.openscience.cdk.io.formats.VASPFormat;
import org.openscience.cdk.math.FortranFormat;
import org.openscience.cdk.tools.LoggingTool;

public class VASPReader
extends DefaultChemObjectReader {
    private LoggingTool logger = null;
    protected StringTokenizer st = new StringTokenizer("", "");
    protected String fieldVal;
    protected int repVal = 0;
    protected BufferedReader inputBuffer;
    private IsotopeFactory isotopeFac;
    int natom = 1;
    int ntype = 1;
    double[] acell = new double[3];
    double[][] rprim = new double[3][3];
    String info = "";
    String line;
    String[] anames;
    int[] natom_type;
    String representation;

    public VASPReader(Reader input) {
        this.logger = new LoggingTool(this);
        try {
            this.isotopeFac = IsotopeFactory.getInstance();
        }
        catch (Exception exception) {
            this.logger.error("Error while instantiating isotope factory.");
            this.logger.debug(exception);
        }
        this.inputBuffer = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
    }

    public VASPReader(InputStream input) {
        this(new InputStreamReader(input));
    }

    public VASPReader() {
        this(new StringReader(""));
    }

    public ChemFormat getFormat() {
        return new VASPFormat();
    }

    public void setReader(Reader input) throws CDKException {
        this.inputBuffer = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
    }

    public void setReader(InputStream input) throws CDKException {
        this.setReader(new InputStreamReader(input));
    }

    public ChemObject read(ChemObject object) throws CDKException {
        if (object instanceof ChemFile) {
            ChemFile cf = (ChemFile)object;
            try {
                cf = this.readChemFile(cf);
            }
            catch (IOException exception) {
                String error = "Input/Output error while reading from input: " + exception.getMessage();
                this.logger.error(error);
                this.logger.debug(exception);
                throw new CDKException(error);
            }
            return cf;
        }
        throw new CDKException("Only supported is reading of ChemFile.");
    }

    private ChemFile readChemFile(ChemFile file) throws CDKException, IOException {
        ChemSequence seq = this.readChemSequence(file.getBuilder().newChemSequence());
        file.addChemSequence(seq);
        return file;
    }

    private ChemSequence readChemSequence(ChemSequence sequence) throws CDKException, IOException {
        int i;
        ChemModel chemModel = sequence.getBuilder().newChemModel();
        Crystal crystal = null;
        this.inputBuffer.mark(255);
        this.info = this.nextVASPToken(false);
        this.inputBuffer.reset();
        this.inputBuffer.mark(255);
        this.nextVASPTokenFollowing("NCLASS");
        this.ntype = Integer.parseInt(this.fieldVal);
        this.inputBuffer.reset();
        this.anames = new String[this.ntype];
        this.nextVASPTokenFollowing("ATOM");
        for (int i2 = 0; i2 < this.ntype; ++i2) {
            this.anames[i2] = this.fieldVal;
            this.nextVASPToken(false);
        }
        int[] natom_type = new int[this.ntype];
        this.natom = 0;
        for (i = 0; i < this.ntype; ++i) {
            natom_type[i] = Integer.parseInt(this.fieldVal);
            this.nextVASPToken(false);
            this.natom += natom_type[i];
        }
        this.representation = this.fieldVal;
        if (this.representation.equals("Direct")) {
            this.logger.info("Direct representation");
        } else {
            throw new CDKException("This VASP file is not supported. Please contact the Jmol developpers");
        }
        while (this.nextVASPToken(false) != null) {
            int i3;
            this.logger.debug("New crystal started...");
            crystal = sequence.getBuilder().newCrystal();
            chemModel = sequence.getBuilder().newChemModel();
            for (i = 0; i < 3; ++i) {
                this.acell[i] = FortranFormat.atof(this.fieldVal);
            }
            for (i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    this.nextVASPToken(false);
                    this.rprim[i][j] = FortranFormat.atof(this.fieldVal);
                }
            }
            int[] atomType = new int[this.natom];
            double[][] xred = new double[this.natom][3];
            int atomIndex = 0;
            for (i3 = 0; i3 < this.ntype; ++i3) {
                for (int j = 0; j < natom_type[i3]; ++j) {
                    atomType[atomIndex] = this.isotopeFac.getElement(this.anames[i3]).getAtomicNumber();
                    this.logger.debug("aname: " + this.anames[i3]);
                    this.logger.debug("atomType: " + atomType[atomIndex]);
                    this.nextVASPToken(false);
                    xred[atomIndex][0] = FortranFormat.atof(this.fieldVal);
                    this.nextVASPToken(false);
                    xred[atomIndex][1] = FortranFormat.atof(this.fieldVal);
                    this.nextVASPToken(false);
                    xred[atomIndex][2] = FortranFormat.atof(this.fieldVal);
                    ++atomIndex;
                }
            }
            crystal.setA(new Vector3d(this.rprim[0][0] * this.acell[0], this.rprim[0][1] * this.acell[0], this.rprim[0][2] * this.acell[0]));
            crystal.setB(new Vector3d(this.rprim[1][0] * this.acell[1], this.rprim[1][1] * this.acell[1], this.rprim[1][2] * this.acell[1]));
            crystal.setC(new Vector3d(this.rprim[2][0] * this.acell[2], this.rprim[2][1] * this.acell[2], this.rprim[2][2] * this.acell[2]));
            for (i3 = 0; i3 < atomType.length; ++i3) {
                String symbol = this.isotopeFac.getElement(atomType[i3]).getSymbol();
                Atom atom = sequence.getBuilder().newAtom(symbol);
                atom.setAtomicNumber(atomType[i3]);
                double[] frac = new double[]{xred[i3][0], xred[i3][1], xred[i3][2]};
                atom.setFractionalPoint3d(new Point3d(frac[0], frac[1], frac[2]));
                crystal.addAtom(atom);
            }
            crystal.setProperty("Remark", this.info);
            chemModel.setCrystal(crystal);
            this.logger.info("New Frame set!");
            sequence.addChemModel(chemModel);
        }
        return sequence;
    }

    public String nextVASPToken(boolean newLine) throws IOException {
        String line;
        if (newLine && this.inputBuffer.ready()) {
            line = this.inputBuffer.readLine();
            this.st = new StringTokenizer(line, " =\t");
        }
        while (!this.st.hasMoreTokens() && this.inputBuffer.ready()) {
            line = this.inputBuffer.readLine();
            this.st = new StringTokenizer(line, " =\t");
        }
        if (this.st.hasMoreTokens()) {
            this.fieldVal = this.st.nextToken();
            if (this.fieldVal.startsWith("#")) {
                this.nextVASPToken(true);
            }
        } else {
            this.fieldVal = null;
        }
        return this.fieldVal;
    }

    public String nextVASPTokenFollowing(String string) throws IOException {
        while (this.inputBuffer.ready()) {
            String line = this.inputBuffer.readLine();
            int index = line.indexOf(string);
            if (index <= 0) continue;
            line = line.substring(index += string.length());
            this.st = new StringTokenizer(line, " =\t");
            while (!this.st.hasMoreTokens() && this.inputBuffer.ready()) {
                line = this.inputBuffer.readLine();
                this.st = new StringTokenizer(line, " =\t");
            }
            if (this.st.hasMoreTokens()) {
                this.fieldVal = this.st.nextToken();
                break;
            }
            this.fieldVal = null;
            break;
        }
        return this.fieldVal;
    }

    public void close() throws IOException {
        this.inputBuffer.close();
    }
}

