/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.StringTokenizer;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.geometry.CrystalGeometryTools;
import org.openscience.cdk.interfaces.Atom;
import org.openscience.cdk.interfaces.ChemFile;
import org.openscience.cdk.interfaces.ChemModel;
import org.openscience.cdk.interfaces.ChemObject;
import org.openscience.cdk.interfaces.ChemSequence;
import org.openscience.cdk.interfaces.Crystal;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.formats.ChemFormat;
import org.openscience.cdk.io.formats.ShelXFormat;
import org.openscience.cdk.math.FortranFormat;
import org.openscience.cdk.tools.LoggingTool;

public class ShelXReader
extends DefaultChemObjectReader {
    private BufferedReader input;
    private LoggingTool logger;

    public ShelXReader(Reader input) {
        this.input = new BufferedReader(input);
        this.logger = new LoggingTool(this);
    }

    public ShelXReader(InputStream input) {
        this(new InputStreamReader(input));
    }

    public ShelXReader() {
        this(new StringReader(""));
    }

    public ChemFormat getFormat() {
        return new ShelXFormat();
    }

    public void setReader(Reader input) throws CDKException {
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
    }

    public void setReader(InputStream input) throws CDKException {
        this.setReader(new InputStreamReader(input));
    }

    public ChemObject read(ChemObject object) throws CDKException {
        if (object instanceof ChemFile) {
            try {
                return this.readChemFile((ChemFile)object);
            }
            catch (IOException e) {
                this.logger.error("Input/Output error while reading from input: " + e.getMessage());
                throw new CDKException(e.getMessage());
            }
        }
        if (object instanceof Crystal) {
            try {
                return this.readCrystal((Crystal)object);
            }
            catch (IOException e) {
                this.logger.error("Input/Output error while reading from input: " + e.getMessage());
                throw new CDKException(e.getMessage());
            }
        }
        throw new CDKException("Only supported is reading of ChemFile.");
    }

    private ChemFile readChemFile(ChemFile file) throws IOException {
        ChemSequence seq = file.getBuilder().newChemSequence();
        ChemModel model = file.getBuilder().newChemModel();
        Crystal crystal = this.readCrystal(file.getBuilder().newCrystal());
        model.setCrystal(crystal);
        seq.addChemModel(model);
        file.addChemSequence(seq);
        return file;
    }

    private Crystal readCrystal(Crystal crystal) throws IOException {
        String line = this.input.readLine();
        boolean end_found = false;
        while (this.input.ready() && line != null && !end_found) {
            String command;
            if (line.length() > 0 && line.substring(line.length() - 1).equals("=")) {
                line = line + this.input.readLine();
            }
            try {
                command = new String(line.substring(0, 4));
            }
            catch (StringIndexOutOfBoundsException sioobe) {
                break;
            }
            this.logger.debug("command: " + command);
            if (!command.substring(0, 3).equalsIgnoreCase("REM")) {
                if (command.substring(0, 3).equalsIgnoreCase("END")) {
                    end_found = true;
                } else if (!command.equalsIgnoreCase("TITL")) {
                    String sc;
                    String sb;
                    String sa;
                    String command_again;
                    StringTokenizer st;
                    if (command.equalsIgnoreCase("CELL")) {
                        st = new StringTokenizer(line);
                        command_again = st.nextToken();
                        String wavelength = st.nextToken();
                        sa = st.nextToken();
                        sb = st.nextToken();
                        sc = st.nextToken();
                        String salpha = st.nextToken();
                        String sbeta = st.nextToken();
                        String sgamma = st.nextToken();
                        this.logger.debug("a: " + sa);
                        this.logger.debug("b: " + sb);
                        this.logger.debug("c: " + sc);
                        this.logger.debug("alpha: " + salpha);
                        this.logger.debug("beta : " + sbeta);
                        this.logger.debug("gamma: " + sgamma);
                        double a = FortranFormat.atof(sa);
                        double b = FortranFormat.atof(sb);
                        double c = FortranFormat.atof(sc);
                        double alpha = FortranFormat.atof(salpha);
                        double beta = FortranFormat.atof(sbeta);
                        double gamma = FortranFormat.atof(sgamma);
                        Vector3d[] axes = CrystalGeometryTools.notionalToCartesian(a, b, c, alpha, beta, gamma);
                        crystal.setA(axes[0]);
                        crystal.setB(axes[1]);
                        crystal.setC(axes[2]);
                    } else if (!(command.equalsIgnoreCase("ZERR") || command.equalsIgnoreCase("LATT") || command.equalsIgnoreCase("SYMM") || command.equalsIgnoreCase("SFAC") || command.equalsIgnoreCase("DISP") || command.equalsIgnoreCase("UNIT") || command.equalsIgnoreCase("LAUE") || command.equalsIgnoreCase("REM ") || command.equalsIgnoreCase("MORE") || command.equalsIgnoreCase("TIME") || command.equalsIgnoreCase("HKLF") || command.equalsIgnoreCase("OMIT") || command.equalsIgnoreCase("SHEL") || command.equalsIgnoreCase("BASF") || command.equalsIgnoreCase("TWIN") || command.equalsIgnoreCase("EXTI") || command.equalsIgnoreCase("SWAT") || command.equalsIgnoreCase("HOPE") || command.equalsIgnoreCase("MERG") || command.equalsIgnoreCase("SPEC") || command.equalsIgnoreCase("RESI") || command.equalsIgnoreCase("MOVE") || command.equalsIgnoreCase("ANIS") || command.equalsIgnoreCase("AFIX") || command.equalsIgnoreCase("HFIX") || command.equalsIgnoreCase("FRAG") || command.equalsIgnoreCase("FEND") || command.equalsIgnoreCase("EXYZ") || command.equalsIgnoreCase("EXTI") || command.equalsIgnoreCase("EADP") || command.equalsIgnoreCase("EQIV") || command.equalsIgnoreCase("CONN") || command.equalsIgnoreCase("PART") || command.equalsIgnoreCase("BIND") || command.equalsIgnoreCase("FREE") || command.equalsIgnoreCase("DFIX") || command.equalsIgnoreCase("DANG") || command.equalsIgnoreCase("BUMP") || command.equalsIgnoreCase("SAME") || command.equalsIgnoreCase("SADI") || command.equalsIgnoreCase("CHIV") || command.equalsIgnoreCase("FLAT") || command.equalsIgnoreCase("DELU") || command.equalsIgnoreCase("SIMU") || command.equalsIgnoreCase("DEFS") || command.equalsIgnoreCase("ISOR") || command.equalsIgnoreCase("NCSY") || command.equalsIgnoreCase("SUMP") || command.equalsIgnoreCase("L.S.") || command.equalsIgnoreCase("CGLS") || command.equalsIgnoreCase("BLOC") || command.equalsIgnoreCase("DAMP") || command.equalsIgnoreCase("STIR") || command.equalsIgnoreCase("WGHT") || command.equalsIgnoreCase("FVAR") || command.equalsIgnoreCase("BOND") || command.equalsIgnoreCase("CONF") || command.equalsIgnoreCase("MPLA") || command.equalsIgnoreCase("RTAB") || command.equalsIgnoreCase("HTAB") || command.equalsIgnoreCase("LIST") || command.equalsIgnoreCase("ACTA") || command.equalsIgnoreCase("SIZE") || command.equalsIgnoreCase("TEMP") || command.equalsIgnoreCase("WPDB") || command.equalsIgnoreCase("FMAP") || command.equalsIgnoreCase("GRID") || command.equalsIgnoreCase("PLAN") || command.equalsIgnoreCase("MOLE"))) {
                        if (command.equalsIgnoreCase("SPGR")) {
                            st = new StringTokenizer(line);
                            command_again = st.nextToken();
                            String spacegroup = st.nextToken();
                            crystal.setSpaceGroup(spacegroup);
                        } else if (command.equalsIgnoreCase("    ")) {
                            System.out.println("Disrgarding line assumed to be added by PLATON: " + line);
                        } else {
                            st = new StringTokenizer(line);
                            String atype = st.nextToken();
                            String scatt_factor = st.nextToken();
                            sa = st.nextToken();
                            sb = st.nextToken();
                            sc = st.nextToken();
                            if (Character.isDigit(atype.charAt(1))) {
                                atype = atype.substring(0, 1);
                            } else {
                                StringBuffer sb2 = new StringBuffer();
                                sb2.append(atype.charAt(1));
                                atype = atype.substring(0, 1) + sb2.toString().toLowerCase();
                            }
                            double[] frac = new double[]{FortranFormat.atof(sa), FortranFormat.atof(sb), FortranFormat.atof(sc)};
                            this.logger.debug("fa,fb,fc: " + frac[0] + ", " + frac[1] + ", " + frac[2]);
                            if (!atype.equalsIgnoreCase("Q")) {
                                this.logger.info("Adding atom: " + atype + ", " + frac[0] + ", " + frac[1] + ", " + frac[2]);
                                Atom atom = crystal.getBuilder().newAtom(atype);
                                atom.setFractionalPoint3d(new Point3d(frac[0], frac[1], frac[2]));
                                crystal.addAtom(atom);
                                this.logger.debug((Object)"Atom added: ", atom);
                            }
                        }
                    }
                }
            }
            line = this.input.readLine();
        }
        return crystal;
    }

    public void close() throws IOException {
        this.input.close();
    }
}

