/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import org.openscience.cdk.Molecule;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.ChemFile;
import org.openscience.cdk.interfaces.ChemModel;
import org.openscience.cdk.interfaces.ChemObject;
import org.openscience.cdk.interfaces.ChemSequence;
import org.openscience.cdk.interfaces.SetOfMolecules;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.formats.ChemFormat;
import org.openscience.cdk.io.formats.SMILESFormat;
import org.openscience.cdk.smiles.SmilesParser;
import org.openscience.cdk.tools.LoggingTool;

public class SMILESReader
extends DefaultChemObjectReader {
    private BufferedReader input = null;
    private SmilesParser sp = null;
    private LoggingTool logger = new LoggingTool(this);

    public SMILESReader(Reader input) {
        this.input = new BufferedReader(input);
        this.sp = new SmilesParser();
    }

    public SMILESReader(InputStream input) {
        this(new InputStreamReader(input));
    }

    public SMILESReader() {
        this(new StringReader(""));
    }

    public ChemFormat getFormat() {
        return new SMILESFormat();
    }

    public void setReader(Reader input) throws CDKException {
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
    }

    public void setReader(InputStream input) throws CDKException {
        this.setReader(new InputStreamReader(input));
    }

    public ChemObject read(ChemObject object) throws CDKException {
        if (object instanceof SetOfMolecules) {
            return this.readSetOfMolecules((SetOfMolecules)object);
        }
        if (object instanceof ChemFile) {
            ChemFile file = (ChemFile)object;
            ChemSequence sequence = file.getBuilder().newChemSequence();
            ChemModel chemModel = file.getBuilder().newChemModel();
            chemModel.setSetOfMolecules(this.readSetOfMolecules(file.getBuilder().newSetOfMolecules()));
            sequence.addChemModel(chemModel);
            file.addChemSequence(sequence);
            return file;
        }
        throw new CDKException("Only supported is reading of SetOfMolecules objects.");
    }

    private SetOfMolecules readSetOfMolecules(SetOfMolecules som) {
        try {
            String line = this.input.readLine().trim();
            while (line != null) {
                this.logger.debug((Object)"Line: ", line);
                int indexSpace = line.indexOf(" ");
                String SMILES = line;
                String name = null;
                if (indexSpace != -1) {
                    this.logger.debug((Object)"Space found at index: ", indexSpace);
                    SMILES = line.substring(0, indexSpace);
                    name = line.substring(indexSpace + 1);
                    this.logger.debug("Line contains SMILES and name: ", SMILES, " + ", name);
                }
                try {
                    Molecule molecule = this.sp.parseSmiles(SMILES);
                    som.addMolecule(molecule);
                    if (name != null) {
                        molecule.setProperty("SMIdbNAME", name);
                    }
                }
                catch (Exception exception) {
                    this.logger.warn((Object)"This SMILES could not be parsed: ", SMILES);
                    this.logger.warn((Object)"Because of: ", exception.getMessage());
                    this.logger.debug(exception);
                }
                if (this.input.ready()) {
                    line = this.input.readLine();
                    continue;
                }
                line = null;
            }
        }
        catch (Exception exception) {
            this.logger.error((Object)"Error while reading SMILES line: ", exception.getMessage());
            this.logger.debug(exception);
        }
        return som;
    }

    public void close() throws IOException {
        this.input.close();
    }
}

