/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import org.openscience.cdk.Molecule;
import org.openscience.cdk.io.ChemObjectReader;
import org.openscience.cdk.io.formats.ChemFormat;
import org.openscience.cdk.io.formats.ChemFormatMatcher;
import org.openscience.cdk.io.formats.SMILESFormat;
import org.openscience.cdk.io.formats.XYZFormat;
import org.openscience.cdk.smiles.SmilesParser;
import org.openscience.cdk.tools.LoggingTool;

public class ReaderFactory {
    private static final String IO_FORMATS_LIST = "io-formats.set";
    private int headerLength;
    private LoggingTool logger = new LoggingTool(this);
    private static Vector formats = null;

    public ReaderFactory() {
        this(65536);
    }

    public ReaderFactory(int headerLength) {
        this.headerLength = headerLength;
        this.loadReaders();
    }

    public void registerFormat(ChemFormatMatcher format) {
        formats.addElement(format);
    }

    private void loadReaders() {
        if (formats == null) {
            formats = new Vector();
            try {
                this.logger.debug("Starting loading Readers...");
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(IO_FORMATS_LIST)));
                int formatCount = 0;
                while (reader.ready()) {
                    String formatName = reader.readLine();
                    ++formatCount;
                    try {
                        ChemFormatMatcher format = (ChemFormatMatcher)this.getClass().getClassLoader().loadClass(formatName).newInstance();
                        formats.addElement(format);
                        this.logger.info("Loaded IO format: " + format.getClass().getName());
                    }
                    catch (ClassNotFoundException exception) {
                        this.logger.error((Object)"Could not find this ChemObjectReader: ", formatName);
                        this.logger.debug(exception);
                    }
                    catch (Exception exception) {
                        this.logger.error((Object)"Could not load this ChemObjectReader: ", formatName);
                        this.logger.debug(exception);
                    }
                }
                this.logger.info((Object)"Number of loaded formats used in detection: ", formatCount);
            }
            catch (Exception exception) {
                this.logger.error((Object)"Could not load this io format list: ", IO_FORMATS_LIST);
                this.logger.debug(exception);
            }
        }
    }

    public ChemFormat guessFormat(BufferedReader input) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("input cannot be null");
        }
        char[] header = new char[this.headerLength];
        if (!input.markSupported()) {
            this.logger.error("Mark not supported");
            throw new IllegalArgumentException("input must support mark");
        }
        input.mark(this.headerLength);
        input.read(header, 0, this.headerLength);
        input.reset();
        BufferedReader buffer = new BufferedReader(new CharArrayReader(header));
        String line = buffer.readLine();
        int lineNumber = 1;
        while (buffer.ready() && line != null) {
            this.logger.debug((Object)(lineNumber + ": "), line);
            for (int i = 0; i < formats.size(); ++i) {
                ChemFormatMatcher cfMatcher = (ChemFormatMatcher)formats.elementAt(i);
                if (!cfMatcher.matches(lineNumber, line)) continue;
                this.logger.info((Object)"Detected format: ", cfMatcher.getFormatName());
                return cfMatcher;
            }
            line = buffer.readLine();
            ++lineNumber;
        }
        this.logger.warn("Now comes the tricky and more difficult ones....");
        buffer = new BufferedReader(new CharArrayReader(header));
        line = buffer.readLine();
        StringTokenizer tokenizer = new StringTokenizer(line.trim());
        try {
            int tokenCount = tokenizer.countTokens();
            if (tokenCount == 1) {
                new Integer(tokenizer.nextToken());
                return new XYZFormat();
            }
            if (tokenCount == 2) {
                new Integer(tokenizer.nextToken());
                if ("Bohr".equalsIgnoreCase(tokenizer.nextToken())) {
                    return new XYZFormat();
                }
            }
        }
        catch (NumberFormatException exception) {
            this.logger.info("No, it's not a XYZ file");
        }
        try {
            SmilesParser sp = new SmilesParser();
            Molecule m = sp.parseSmiles(line);
            return new SMILESFormat();
        }
        catch (Exception ise) {
            this.logger.info("No, it's not a SMILES file");
            this.logger.warn("File format undetermined");
            return null;
        }
    }

    public ChemFormat guessFormat(InputStream input) throws IOException {
        BufferedInputStream bistream;
        FilterInputStream istreamToRead = bistream = new BufferedInputStream(input, 8192);
        bistream.mark(5);
        int countRead = 0;
        try {
            byte[] abMagic = new byte[4];
            countRead = bistream.read(abMagic, 0, 4);
            bistream.reset();
            if (countRead == 4 && abMagic[0] == 31 && abMagic[1] == -117) {
                istreamToRead = new GZIPInputStream(bistream);
            }
        }
        catch (IOException exception) {
            this.logger.error(exception.getMessage());
            this.logger.debug(exception);
        }
        return this.guessFormat(new BufferedReader(new InputStreamReader(istreamToRead)));
    }

    public ChemObjectReader createReader(InputStream input) throws IOException {
        BufferedInputStream bistream;
        FilterInputStream istreamToRead = bistream = new BufferedInputStream(input, 8192);
        bistream.mark(5);
        int countRead = 0;
        try {
            byte[] abMagic = new byte[4];
            countRead = bistream.read(abMagic, 0, 4);
            bistream.reset();
            if (countRead == 4 && abMagic[0] == 31 && abMagic[1] == -117) {
                istreamToRead = new GZIPInputStream(bistream);
            }
        }
        catch (IOException exception) {
            this.logger.error(exception.getMessage());
            this.logger.debug(exception);
        }
        return this.createReader(new InputStreamReader(istreamToRead));
    }

    public ChemObjectReader createReader(Reader input) throws IOException {
        ChemFormat chemFormat;
        if (!(input instanceof BufferedReader)) {
            input = new BufferedReader(input);
        }
        if ((chemFormat = this.guessFormat((BufferedReader)input)) != null) {
            String readerClassName = chemFormat.getReaderClassName();
            if (readerClassName != null) {
                try {
                    ChemObjectReader coReader = (ChemObjectReader)this.getClass().getClassLoader().loadClass(readerClassName).newInstance();
                    coReader.setReader(input);
                    return coReader;
                }
                catch (ClassNotFoundException exception) {
                    this.logger.error((Object)"Could not find this ChemObjectReader: ", readerClassName);
                    this.logger.debug(exception);
                }
                catch (Exception exception) {
                    this.logger.error((Object)"Could not create this ChemObjectReader: ", readerClassName);
                    this.logger.debug(exception);
                }
            } else {
                this.logger.warn("ChemFormat is recognized, but no reader is available.");
            }
        } else {
            this.logger.warn("ChemFormat is not recognized.");
        }
        return null;
    }
}

