/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.vecmath.Vector3d;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.Atom;
import org.openscience.cdk.interfaces.AtomContainer;
import org.openscience.cdk.interfaces.Bond;
import org.openscience.cdk.interfaces.ChemFile;
import org.openscience.cdk.interfaces.ChemModel;
import org.openscience.cdk.interfaces.ChemObject;
import org.openscience.cdk.interfaces.ChemObjectBuilder;
import org.openscience.cdk.interfaces.ChemSequence;
import org.openscience.cdk.interfaces.Crystal;
import org.openscience.cdk.interfaces.Molecule;
import org.openscience.cdk.interfaces.SetOfMolecules;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.formats.ChemFormat;
import org.openscience.cdk.io.formats.PMPFormat;
import org.openscience.cdk.tools.LoggingTool;
import org.openscience.cdk.tools.manipulator.ChemModelManipulator;

public class PMPReader
extends DefaultChemObjectReader {
    private BufferedReader input;
    private LoggingTool logger;
    private SetOfMolecules som;
    private ChemModel modelModel;
    private Molecule molecule;
    private ChemObject chemObject;
    private Hashtable atomids = new Hashtable();
    private Hashtable bondids = new Hashtable();
    Pattern objHeader;
    Pattern objCommand;
    Pattern atomTypePattern;

    public PMPReader(Reader input) {
        this.input = new BufferedReader(input);
        this.logger = new LoggingTool(this);
        this.objHeader = Pattern.compile(".*\\((\\d+)\\s(\\w+)$");
        this.objCommand = Pattern.compile(".*\\(A\\s(C|F|D|I|O)\\s(\\w+)\\s+\"?(.*?)\"?\\)$");
        this.atomTypePattern = Pattern.compile("^(\\d+)\\s+(\\w+)$");
    }

    public PMPReader(InputStream input) {
        this(new InputStreamReader(input));
    }

    public PMPReader() {
        this(new StringReader(""));
    }

    public ChemFormat getFormat() {
        return new PMPFormat();
    }

    public void setReader(Reader input) throws CDKException {
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
    }

    public void setReader(InputStream input) throws CDKException {
        this.setReader(new InputStreamReader(input));
    }

    public ChemObject read(ChemObject object) throws CDKException {
        if (object instanceof ChemFile) {
            return this.readChemFile((ChemFile)object);
        }
        throw new CDKException("Only supported is reading of ChemFile objects.");
    }

    private ChemFile readChemFile(ChemFile chemFile) {
        ChemSequence chemSequence = chemFile.getBuilder().newChemSequence();
        ChemModel chemModel = chemFile.getBuilder().newChemModel();
        Crystal crystal = chemFile.getBuilder().newCrystal();
        try {
            String line = this.input.readLine();
            while (this.input.ready() && line != null) {
                if (line.startsWith("%%Header Start")) {
                    while (this.input.ready() && line != null && !line.startsWith("%%Header End")) {
                        String version;
                        if (line.startsWith("%%Version Number") && !(version = this.input.readLine().trim()).equals("3.00")) {
                            this.logger.error("The PMPReader only supports PMP files with version 3.00");
                            return null;
                        }
                        line = this.input.readLine();
                    }
                } else if (line.startsWith("%%Model Start")) {
                    while (this.input.ready() && line != null && !line.startsWith("%%Model End")) {
                        Matcher objHeaderMatcher = this.objHeader.matcher(line);
                        if (objHeaderMatcher.matches()) {
                            String object = objHeaderMatcher.group(2);
                            this.constructObject(chemFile.getBuilder(), object);
                            int id = Integer.parseInt(objHeaderMatcher.group(1));
                            line = this.input.readLine();
                            while (this.input.ready() && line != null && !line.trim().equals(")")) {
                                Matcher objCommandMatcher = this.objCommand.matcher(line);
                                objHeaderMatcher = this.objHeader.matcher(line);
                                if (objHeaderMatcher.matches()) {
                                    object = objHeaderMatcher.group(2);
                                    id = Integer.parseInt(objHeaderMatcher.group(1));
                                    this.constructObject(chemFile.getBuilder(), object);
                                } else if (objCommandMatcher.matches()) {
                                    String format = objCommandMatcher.group(1);
                                    String command = objCommandMatcher.group(2);
                                    String field = objCommandMatcher.group(3);
                                    this.processModelCommand(object, command, format, field);
                                } else {
                                    this.logger.warn("Skipping line: " + line);
                                }
                                line = this.input.readLine();
                            }
                            if (this.chemObject instanceof Atom) {
                                this.atomids.put(new Integer(id), new Integer(this.molecule.getAtomCount()));
                                this.molecule.addAtom((Atom)this.chemObject);
                            } else if (this.chemObject instanceof Bond) {
                                this.bondids.put(new Integer(id), new Integer(this.molecule.getAtomCount()));
                                this.molecule.addBond((Bond)this.chemObject);
                            } else {
                                this.logger.error("chemObject is not initialized or of bad class type");
                            }
                        }
                        line = this.input.readLine();
                    }
                    this.som.addMolecule(this.molecule);
                    this.modelModel.setSetOfMolecules(this.som);
                } else if (line.startsWith("%%Traj Start")) {
                    chemSequence = chemFile.getBuilder().newChemSequence();
                    while (this.input.ready() && line != null && !line.startsWith("%%Traj End")) {
                        if (line.startsWith("%%Start Frame")) {
                            chemModel = chemFile.getBuilder().newChemModel();
                            crystal = chemFile.getBuilder().newCrystal();
                            AtomContainer atomC = ChemModelManipulator.getAllInOneContainer((ChemModel)this.modelModel);
                            while (this.input.ready() && line != null && !line.startsWith("%%End Frame")) {
                                if (line.startsWith("%%Atom Coords")) {
                                    crystal.add((AtomContainer)atomC.clone());
                                    int expatoms = atomC.getAtomCount();
                                    for (int i = 0; i < expatoms; ++i) {
                                        line = this.input.readLine();
                                        Atom a = crystal.getAtomAt(i);
                                        StringTokenizer st = new StringTokenizer(line, " ");
                                        a.setX3d(Double.parseDouble(st.nextToken()));
                                        a.setY3d(Double.parseDouble(st.nextToken()));
                                        a.setZ3d(Double.parseDouble(st.nextToken()));
                                    }
                                } else if (line.startsWith("%%Lat Vects")) {
                                    line = this.input.readLine();
                                    StringTokenizer st = new StringTokenizer(line, " ");
                                    crystal.setA(new Vector3d(Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken())));
                                    line = this.input.readLine();
                                    st = new StringTokenizer(line, " ");
                                    crystal.setB(new Vector3d(Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken())));
                                    line = this.input.readLine();
                                    st = new StringTokenizer(line, " ");
                                    crystal.setC(new Vector3d(Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken())));
                                } else if (line.startsWith("%%Space Group")) {
                                    line = this.input.readLine().trim();
                                    if ("P 21 21 21 (1)".equals(line)) {
                                        crystal.setSpaceGroup("P 2_1 2_1 2_1");
                                    } else {
                                        crystal.setSpaceGroup("P1");
                                    }
                                }
                                line = this.input.readLine();
                            }
                            chemModel.setCrystal(crystal);
                            chemSequence.addChemModel(chemModel);
                        }
                        line = this.input.readLine();
                    }
                    chemFile.addChemSequence(chemSequence);
                }
                line = this.input.readLine();
            }
        }
        catch (IOException e) {
            chemFile = null;
        }
        return chemFile;
    }

    private void processModelCommand(String object, String command, String format, String field) {
        this.logger.debug(object + "->" + command + " (" + format + "): " + field);
        if ("Model".equals(object)) {
            this.logger.warn("Unkown PMP Model command: " + command);
        } else if ("Atom".equals(object)) {
            if ("ACL".equals(command)) {
                Matcher atomTypeMatcher = this.atomTypePattern.matcher(field);
                if (atomTypeMatcher.matches()) {
                    int atomicnum = Integer.parseInt(atomTypeMatcher.group(1));
                    String type = atomTypeMatcher.group(2);
                    ((Atom)this.chemObject).setAtomicNumber(atomicnum);
                    ((Atom)this.chemObject).setSymbol(type);
                } else {
                    this.logger.error("Incorrectly formated field value: " + field + ".");
                }
            } else if ("Charge".equals(command)) {
                try {
                    double charge = Double.parseDouble(field);
                    ((Atom)this.chemObject).setCharge(charge);
                }
                catch (NumberFormatException e) {
                    this.logger.error("Incorrectly formated float field: " + field + ".");
                }
            } else if (!("CMAPPINGS".equals(command) || "FFType".equals(command) || "Id".equals(command) || "Mass".equals(command) || "XYZ".equals(command) || "ZOrder".equals(command))) {
                this.logger.warn("Unkown PMP Atom command: " + command);
            }
        } else if ("Bond".equals(object)) {
            if ("Atom1".equals(command)) {
                int atomid = Integer.parseInt(field);
                int realatomid = (Integer)this.atomids.get(new Integer(atomid));
                Atom a = this.molecule.getAtomAt(realatomid);
                ((Bond)this.chemObject).setAtomAt(a, 0);
            } else if ("Atom2".equals(command)) {
                int atomid = Integer.parseInt(field);
                int realatomid = (Integer)this.atomids.get(new Integer(atomid));
                Atom a = this.molecule.getAtomAt(realatomid);
                ((Bond)this.chemObject).setAtomAt(a, 1);
            } else if ("Order".equals(command)) {
                double order = Double.parseDouble(field);
                ((Bond)this.chemObject).setOrder(order);
            } else if (!("Id".equals(command) || "Label".equals(command) || "3DGridOrigin".equals(command) || "3DGridMatrix".equals(command) || "3DGridDivision".equals(command))) {
                this.logger.warn("Unkown PMP Bond command: " + command);
            }
        } else {
            this.logger.warn("Unkown PMP object: " + object);
        }
    }

    private void constructObject(ChemObjectBuilder builder, String object) {
        if ("Atom".equals(object)) {
            this.chemObject = builder.newAtom("C");
        } else if ("Bond".equals(object)) {
            this.chemObject = builder.newBond();
        } else if ("Model".equals(object)) {
            this.modelModel = builder.newChemModel();
            this.som = builder.newSetOfMolecules();
            this.molecule = builder.newMolecule();
        } else {
            this.logger.error("Cannot construct PMP object type: " + object);
        }
    }

    public void close() throws IOException {
        this.input.close();
    }
}

