/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Point3d;
import org.openscience.cdk.PDBAtom;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.Atom;
import org.openscience.cdk.interfaces.BioPolymer;
import org.openscience.cdk.interfaces.Bond;
import org.openscience.cdk.interfaces.ChemFile;
import org.openscience.cdk.interfaces.ChemModel;
import org.openscience.cdk.interfaces.ChemObject;
import org.openscience.cdk.interfaces.ChemSequence;
import org.openscience.cdk.interfaces.Monomer;
import org.openscience.cdk.interfaces.SetOfMolecules;
import org.openscience.cdk.interfaces.Strand;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.formats.ChemFormat;
import org.openscience.cdk.io.formats.PDBFormat;
import org.openscience.cdk.templates.AminoAcids;
import org.openscience.cdk.tools.LoggingTool;

public class PDBReader
extends DefaultChemObjectReader {
    private LoggingTool logger = new LoggingTool(this.getClass().getName());
    private BufferedReader _oInput;

    public PDBReader(InputStream oIn) {
        this(new InputStreamReader(oIn));
    }

    public PDBReader(Reader oIn) {
        this._oInput = new BufferedReader(oIn);
    }

    public PDBReader() {
        this(new StringReader(""));
    }

    public ChemFormat getFormat() {
        return new PDBFormat();
    }

    public void setReader(Reader input) throws CDKException {
        this._oInput = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
    }

    public void setReader(InputStream input) throws CDKException {
        this.setReader(new InputStreamReader(input));
    }

    public ChemObject read(ChemObject oObj) throws CDKException {
        if (oObj instanceof ChemFile) {
            return this.readChemFile((ChemFile)oObj);
        }
        throw new CDKException("Only supported is reading of ChemFile objects.");
    }

    private ChemFile readChemFile(ChemFile oFile) {
        ChemSequence oSeq = oFile.getBuilder().newChemSequence();
        ChemModel oModel = oFile.getBuilder().newChemModel();
        SetOfMolecules oSet = oFile.getBuilder().newSetOfMolecules();
        BioPolymer oBP = oFile.getBuilder().newBioPolymer();
        char chain = 'A';
        try {
            do {
                Strand oStrand;
                PDBAtom oAtom;
                String cRead = this._oInput.readLine();
                this.logger.debug(cRead);
                if (cRead == null) continue;
                StringBuffer cLine = new StringBuffer(cRead);
                while (cLine.length() < 6) {
                    cLine.append(" ");
                }
                String cCol = cLine.substring(0, 6).toUpperCase();
                if (cCol.equals("ATOM  ")) {
                    Monomer oMonomer;
                    oAtom = this.readAtom(cLine.toString());
                    StringBuffer cResidue = new StringBuffer(8);
                    String oObj = oAtom.getResName();
                    if (oObj != null) {
                        cResidue = cResidue.append(oObj.trim());
                    }
                    if ((oObj = oAtom.getChainID()) != null) {
                        cResidue = cResidue.append(String.valueOf(chain));
                    }
                    if ((oObj = oAtom.getResSeq()) != null) {
                        cResidue = cResidue.append(oObj.trim());
                    }
                    if ((oStrand = oBP.getStrand(String.valueOf(chain))) == null) {
                        oStrand = oFile.getBuilder().newStrand();
                        oStrand.setStrandName(String.valueOf(chain));
                    }
                    if ((oMonomer = oBP.getMonomer(cResidue.toString(), String.valueOf(chain))) == null) {
                        oMonomer = oFile.getBuilder().newMonomer();
                        oMonomer.setMonomerName(cResidue.toString());
                        oMonomer.setMonomerType(oAtom.getResName());
                    }
                    oBP.addAtom((Atom)oAtom, oMonomer, oStrand);
                    this.logger.debug((Object)"Added ATOM: ", oAtom);
                    continue;
                }
                if (cCol.equals("HETATM")) {
                    oAtom = this.readAtom(cLine.toString());
                    oBP.addAtom((Atom)oAtom);
                    this.logger.debug((Object)"Added HETATM: ", oAtom);
                    continue;
                }
                if (cCol.equals("TER   ")) {
                    chain = (char)(chain + 1);
                    oStrand = oFile.getBuilder().newStrand();
                    oStrand.setStrandName(String.valueOf(chain));
                    this.logger.debug("Added new STRAND");
                    continue;
                }
                if (cCol.equals("END   ")) {
                    if (oBP.getAtomCount() == 0) continue;
                    if (!this.createBonds(oBP)) {
                        this.logger.info("Bonds could not be created when PDB file was read.");
                        oBP.removeAllBonds();
                    }
                    oSet.addMolecule(oBP);
                    continue;
                }
                if (cCol.equals("REMARK")) {
                    Object comment = oFile.getProperty("Comment");
                    if (comment == null) {
                        comment = "";
                    }
                    comment = comment.toString() + cLine.substring(11).trim() + "\n";
                    oFile.setProperty("Comment", comment);
                    continue;
                }
                if (cCol.equals("COMPND")) {
                    String title = cLine.substring(10).trim();
                    oFile.setProperty("Title", title);
                    continue;
                }
                if (cCol.equals("CONECT")) {
                    String pdbLine = cLine.toString();
                    pdbLine = pdbLine.trim();
                    String bondAtom = pdbLine.substring(7, 11);
                    bondAtom = bondAtom.trim();
                    int bondAtomNo = Integer.parseInt(bondAtom);
                    String bondedAtom = pdbLine.substring(12, 16);
                    bondedAtom = bondedAtom.trim();
                    int bondedAtomNo = -1;
                    try {
                        bondedAtomNo = Integer.parseInt(bondedAtom);
                    }
                    catch (Exception e) {
                        bondedAtomNo = -1;
                    }
                    if (bondedAtomNo != -1) {
                        oBP.addBond(bondAtomNo - 1, bondedAtomNo - 1, 1.0);
                    }
                    if (pdbLine.length() > 17) {
                        bondedAtom = pdbLine.substring(17, 21);
                        bondedAtom = bondedAtom.trim();
                        try {
                            bondedAtomNo = Integer.parseInt(bondedAtom);
                        }
                        catch (Exception e) {
                            bondedAtomNo = -1;
                        }
                        if (bondedAtomNo != -1) {
                            oBP.addBond(bondAtomNo - 1, bondedAtomNo - 1, 1.0);
                        }
                    }
                    if (pdbLine.length() > 22) {
                        bondedAtom = pdbLine.substring(22, 26);
                        bondedAtom = bondedAtom.trim();
                        try {
                            bondedAtomNo = Integer.parseInt(bondedAtom);
                        }
                        catch (Exception e) {
                            bondedAtomNo = -1;
                        }
                        if (bondedAtomNo != -1) {
                            oBP.addBond(bondAtomNo - 1, bondedAtomNo - 1, 1.0);
                        }
                    }
                    if (pdbLine.length() <= 27) continue;
                    bondedAtom = pdbLine.substring(27, 31);
                    bondedAtom = bondedAtom.trim();
                    try {
                        bondedAtomNo = Integer.parseInt(bondedAtom);
                    }
                    catch (Exception e) {
                        bondedAtomNo = -1;
                    }
                    if (bondedAtomNo == -1) continue;
                    oBP.addBond(bondAtomNo - 1, bondedAtomNo - 1, 1.0);
                    continue;
                }
                if (!cCol.equals("HELIX ") && !cCol.equals("SHEET ") && !cCol.equals("TURN  ")) continue;
                Vector<String> t = (Vector<String>)oModel.getProperty("pdb.structure.records");
                if (t == null) {
                    t = new Vector<String>();
                    oModel.setProperty("pdb.structure.records", t);
                }
                t.add("" + cLine);
            } while (this._oInput.ready());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this._oInput.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        oModel.setSetOfMolecules(oSet);
        oSeq.addChemModel(oModel);
        oFile.addChemSequence(oSeq);
        return oFile;
    }

    public boolean createBonds(BioPolymer pol) {
        HashMap AAs = AminoAcids.getHashMapByThreeLetterCode();
        int[][] AABondInfo = AminoAcids.aaBondInfo();
        Hashtable strands = pol.getStrands();
        Enumeration strandKeys = strands.keys();
        while (strandKeys.hasMoreElements()) {
            Strand strand = (Strand)strands.get(strandKeys.nextElement());
            int atoms = 0;
            int atomsInLastResidue = 0;
            int atomsInPresentResidue = 0;
            while (atoms < strand.getAtomCount() - 1) {
                PDBAtom anAtom = (PDBAtom)strand.getAtomAt(atoms);
                boolean residue = false;
                if (!AAs.containsKey(anAtom.getResName())) {
                    return false;
                }
                Monomer monomer = (Monomer)AAs.get(anAtom.getResName());
                atomsInPresentResidue = Integer.parseInt((String)monomer.getProperty("noOfAtoms"));
                int counter = 1;
                while (atoms + counter < strand.getAtomCount() && anAtom.getResName().equals(strand.getAtomAt(atoms + counter).getProperty("residueName"))) {
                    ++counter;
                }
                if (counter % atomsInPresentResidue != 0 && atoms + counter == strand.getAtomCount() && counter % atomsInPresentResidue != 1) {
                    return false;
                }
                int bondID = Integer.parseInt((String)monomer.getProperty("id"));
                for (int l = 0; l < Integer.parseInt((String)monomer.getProperty("noOfBonds")); ++l) {
                    Bond bond = pol.getBuilder().newBond(strand.getAtomAt(AABondInfo[bondID + l][1] + atoms), strand.getAtomAt(AABondInfo[bondID + l][2] + atoms), AABondInfo[bondID + l][3]);
                    pol.addBond(bond);
                }
                if (atomsInLastResidue != 0) {
                    Bond bond = pol.getBuilder().newBond(strand.getAtomAt(atoms - atomsInLastResidue + 2), strand.getAtomAt(atoms), 1.0);
                    pol.addBond(bond);
                }
                atomsInLastResidue = atomsInPresentResidue;
                if (strand.getAtomCount() >= (atoms += atomsInPresentResidue) || !((PDBAtom)strand.getAtomAt(atoms)).getOxt()) continue;
                Bond bond = pol.getBuilder().newBond(strand.getAtomAt(atoms - atomsInLastResidue + 2), strand.getAtomAt(atoms), 1.0);
                pol.addBond(bond);
            }
        }
        return true;
    }

    private PDBAtom readAtom(String cLine) {
        String oxt;
        String frag;
        if (cLine.length() < 59) {
            throw new RuntimeException("PDBReader error during readAtom(): line too short");
        }
        String elementSymbol = cLine.substring(12, 14).trim();
        if (elementSymbol.length() == 2) {
            elementSymbol = elementSymbol.charAt(0) + elementSymbol.substring(1).toLowerCase();
        }
        String rawAtomName = cLine.substring(12, 16).trim();
        PDBAtom oAtom = new PDBAtom(elementSymbol, new Point3d(new Double(cLine.substring(30, 38)), new Double(cLine.substring(38, 46)), new Double(cLine.substring(46, 54))));
        oAtom.setAtomTypeName(rawAtomName);
        oAtom.setRecord(cLine);
        oAtom.setSerial(Integer.parseInt(cLine.substring(6, 11).trim()));
        oAtom.setName(new String(cLine.substring(12, 16)).trim());
        oAtom.setAltLoc(new String(cLine.substring(16, 17)).trim());
        oAtom.setResName(new String(cLine.substring(17, 20)).trim());
        oAtom.setChainID(new String(cLine.substring(21, 22)).trim());
        oAtom.setResSeq(new String(cLine.substring(22, 26)).trim());
        oAtom.setICode(new String(cLine.substring(26, 27)).trim());
        if (cLine.length() >= 59 && (frag = cLine.substring(54, 60).trim()).length() > 0) {
            oAtom.setOccupancy(Double.parseDouble(frag));
        }
        if (cLine.length() >= 65 && (frag = cLine.substring(60, 66).trim()).length() > 0) {
            oAtom.setTempFactor(Double.parseDouble(frag));
        }
        if (cLine.length() >= 75) {
            oAtom.setSegID(new String(cLine.substring(72, 76)).trim());
        }
        if (cLine.length() >= 79 && (frag = cLine.substring(78, 80).trim()).length() > 0) {
            oAtom.setCharge(Double.parseDouble(frag));
        }
        if ((oxt = cLine.substring(13, 16).trim()).equals("OXT")) {
            oAtom.setOxt(true);
        } else {
            oAtom.setOxt(false);
        }
        if (cLine.substring(0, 6).toUpperCase().equals("HETATM")) {
            oAtom.setHetAtom(true);
        } else {
            oAtom.setHetAtom(false);
        }
        return oAtom;
    }

    public void close() throws IOException {
        this._oInput.close();
    }
}

