/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import org.jmol.adapter.smarter.SmarterJmolAdapter;
import org.jmol.api.JmolAdapter;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.ChemObject;
import org.openscience.cdk.interfaces.Molecule;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.formats.ChemFormat;
import org.openscience.cdk.io.formats.MOPAC97Format;
import org.openscience.cdk.io.setting.IOSetting;
import org.openscience.cdk.libio.jmol.Convertor;
import org.openscience.cdk.tools.LoggingTool;

public class MOPAC97Reader
extends DefaultChemObjectReader {
    BufferedReader input = null;
    private LoggingTool logger = new LoggingTool(this);

    public MOPAC97Reader() {
        this(new StringReader(""));
    }

    public MOPAC97Reader(InputStream in) {
        this(new BufferedReader(new InputStreamReader(in)));
    }

    public MOPAC97Reader(Reader in) {
        this.input = this.input instanceof BufferedReader ? this.input : new BufferedReader(this.input);
    }

    public ChemFormat getFormat() {
        return new MOPAC97Format();
    }

    public void setReader(Reader input) throws CDKException {
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
    }

    public void setReader(InputStream input) throws CDKException {
        this.setReader(new InputStreamReader(input));
    }

    public ChemObject read(ChemObject object) throws CDKException {
        if (object instanceof Molecule) {
            return this.readMolecule((Molecule)object);
        }
        throw new CDKException("Only supported are Molecule.");
    }

    private Molecule readMolecule(Molecule molecule) throws CDKException {
        SmarterJmolAdapter adapter = new SmarterJmolAdapter(null);
        Object model = ((JmolAdapter)adapter).openBufferedReader("", this.input);
        molecule.add(new Convertor().convert(model));
        return molecule;
    }

    public void close() throws IOException {
        this.input.close();
    }

    public IOSetting[] getIOSettings() {
        IOSetting[] settings = new IOSetting[]{};
        return settings;
    }
}

