/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.StringTokenizer;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.openscience.cdk.PseudoAtom;
import org.openscience.cdk.config.IsotopeFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.Atom;
import org.openscience.cdk.interfaces.AtomContainer;
import org.openscience.cdk.interfaces.Bond;
import org.openscience.cdk.interfaces.ChemFile;
import org.openscience.cdk.interfaces.ChemModel;
import org.openscience.cdk.interfaces.ChemObject;
import org.openscience.cdk.interfaces.ChemSequence;
import org.openscience.cdk.interfaces.Isotope;
import org.openscience.cdk.interfaces.Molecule;
import org.openscience.cdk.interfaces.SetOfMolecules;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.formats.ChemFormat;
import org.openscience.cdk.io.formats.MDLFormat;
import org.openscience.cdk.io.setting.BooleanIOSetting;
import org.openscience.cdk.io.setting.IOSetting;
import org.openscience.cdk.tools.LoggingTool;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class MDLReader
extends DefaultChemObjectReader {
    BufferedReader input = null;
    private LoggingTool logger = new LoggingTool(this);
    private IsotopeFactory isotopeFactory = null;
    private BooleanIOSetting forceReadAs3DCoords;

    public MDLReader() {
        this(new StringReader(""));
    }

    public MDLReader(InputStream in) {
        this(new InputStreamReader(in));
    }

    public ChemFormat getFormat() {
        return new MDLFormat();
    }

    public void setReader(Reader input) throws CDKException {
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
    }

    public void setReader(InputStream input) throws CDKException {
        this.setReader(new InputStreamReader(input));
    }

    public MDLReader(Reader in) {
        this.input = new BufferedReader(in);
        this.initIOSettings();
        try {
            this.isotopeFactory = IsotopeFactory.getInstance();
        }
        catch (Exception exception) {
            this.logger.error((Object)"Failed to initiate isotope factory: ", exception.getMessage());
            this.logger.debug(exception);
        }
    }

    public ChemObject read(ChemObject object) throws CDKException {
        if (object instanceof ChemFile) {
            return this.readChemFile((ChemFile)object);
        }
        if (object instanceof ChemModel) {
            return this.readChemModel((ChemModel)object);
        }
        if (object instanceof Molecule) {
            return this.readMolecule((Molecule)object);
        }
        throw new CDKException("Only supported are ChemFile and Molecule.");
    }

    private ChemModel readChemModel(ChemModel chemModel) throws CDKException {
        Molecule m;
        SetOfMolecules setOfMolecules = chemModel.getSetOfMolecules();
        if (setOfMolecules == null) {
            setOfMolecules = chemModel.getBuilder().newSetOfMolecules();
        }
        if ((m = this.readMolecule(chemModel.getBuilder().newMolecule())) != null) {
            setOfMolecules.addMolecule(m);
        }
        chemModel.setSetOfMolecules(setOfMolecules);
        return chemModel;
    }

    private ChemFile readChemFile(ChemFile chemFile) throws CDKException {
        ChemSequence chemSequence = chemFile.getBuilder().newChemSequence();
        ChemModel chemModel = chemFile.getBuilder().newChemModel();
        SetOfMolecules setOfMolecules = chemFile.getBuilder().newSetOfMolecules();
        Molecule m = this.readMolecule(chemFile.getBuilder().newMolecule());
        if (m != null) {
            setOfMolecules.addMolecule(m);
        }
        chemModel.setSetOfMolecules(setOfMolecules);
        chemSequence.addChemModel(chemModel);
        setOfMolecules = chemFile.getBuilder().newSetOfMolecules();
        chemModel = chemFile.getBuilder().newChemModel();
        try {
            String line;
            while ((line = this.input.readLine()) != null) {
                this.logger.debug((Object)"line: ", line);
                String str = new String(line);
                if (str.equals("$$$$")) {
                    m = this.readMolecule(chemFile.getBuilder().newMolecule());
                    if (m == null) continue;
                    setOfMolecules.addMolecule(m);
                    chemModel.setSetOfMolecules(setOfMolecules);
                    chemSequence.addChemModel(chemModel);
                    setOfMolecules = chemFile.getBuilder().newSetOfMolecules();
                    chemModel = chemFile.getBuilder().newChemModel();
                    continue;
                }
                if (m == null) continue;
                String fieldName = null;
                if (str.startsWith("> ")) {
                    int index2;
                    String content = str.substring(2);
                    int index = str.indexOf("<");
                    if (index != -1 && (index2 = str.substring(index).indexOf(">")) != -1) {
                        fieldName = str.substring(index + 1, index + index2);
                    }
                    while ((line = this.input.readLine()) != null && line.startsWith(">")) {
                        this.logger.debug((Object)"data header line: ", line);
                    }
                }
                if (line == null) {
                    throw new CDKException("Expecting data line here, but found null!");
                }
                String data = line;
                while ((line = this.input.readLine()) != null && line.trim().length() > 0) {
                    this.logger.debug((Object)"data line: ", line);
                    data = data + line;
                }
                if (fieldName == null) continue;
                this.logger.info("fieldName, data: ", fieldName, ", ", data);
                m.setProperty(fieldName, data);
            }
        }
        catch (CDKException cdkexc) {
            throw cdkexc;
        }
        catch (Exception exception) {
            String error = "Error while parsing SDF";
            this.logger.error(error);
            this.logger.debug(exception);
            throw new CDKException(error);
        }
        try {
            this.input.close();
        }
        catch (Exception exc) {
            String error = "Error while closing file: " + exc.getMessage();
            this.logger.error(error);
            throw new CDKException(error);
        }
        chemFile.addChemSequence(chemSequence);
        return chemFile;
    }

    private Molecule readMolecule(Molecule molecule) throws CDKException {
        this.logger.debug("Reading new molecule");
        int linecount = 0;
        int atoms = 0;
        int bonds = 0;
        int atom1 = 0;
        int atom2 = 0;
        int order = 0;
        int stereo = 0;
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double totalZ = 0.0;
        int[][] conMat = new int[0][0];
        String line = "";
        try {
            int f;
            this.logger.info("Reading header");
            line = this.input.readLine();
            ++linecount;
            if (line == null) {
                return molecule;
            }
            this.logger.debug("Line " + linecount + ": " + line);
            if (line.startsWith("$$$$")) {
                this.logger.debug("File is empty, returning empty molecule");
                return molecule;
            }
            if (line.length() > 0) {
                molecule.setProperty("Title", line);
            }
            line = this.input.readLine();
            this.logger.debug("Line " + ++linecount + ": " + line);
            line = this.input.readLine();
            this.logger.debug("Line " + ++linecount + ": " + line);
            if (line.length() > 0) {
                molecule.setProperty("Remark", line);
            }
            this.logger.info("Reading rest of file");
            line = this.input.readLine();
            this.logger.debug("Line " + ++linecount + ": " + line);
            atoms = Integer.valueOf(line.substring(0, 3).trim());
            this.logger.debug("Atomcount: " + atoms);
            bonds = Integer.valueOf(line.substring(3, 6).trim());
            this.logger.debug("Bondcount: " + bonds);
            this.logger.info("Reading atom block");
            for (f = 0; f < atoms; ++f) {
                Atom atom;
                line = this.input.readLine();
                ++linecount;
                x = new Double(line.substring(0, 10).trim());
                y = new Double(line.substring(10, 20).trim());
                z = new Double(line.substring(20, 30).trim());
                totalZ += Math.abs(z);
                this.logger.debug("Coordinates: " + x + "; " + y + "; " + z);
                String element = line.substring(31, 34).trim();
                this.logger.debug((Object)"Atom type: ", element);
                if (this.isotopeFactory.isElement(element)) {
                    atom = this.isotopeFactory.configure(molecule.getBuilder().newAtom(element));
                } else {
                    this.logger.debug("Atom ", element, " is not an regular element. Creating a PseudoAtom.");
                    atom = new PseudoAtom(element);
                }
                atom.setPoint3d(new Point3d(x, y, z));
                String massDiffString = line.substring(34, 36).trim();
                this.logger.debug((Object)"Mass difference: ", massDiffString);
                if (!(atom instanceof PseudoAtom)) {
                    try {
                        int massDiff = Integer.parseInt(massDiffString);
                        if (massDiff != 0) {
                            Isotope major = this.isotopeFactory.getMajorIsotope(element);
                            atom.setAtomicNumber(major.getAtomicNumber() + massDiff);
                        }
                    }
                    catch (Exception exception) {
                        this.logger.error("Could not parse mass difference field");
                    }
                } else {
                    this.logger.error("Cannot set mass difference for a non-element!");
                }
                String chargeCodeString = line.substring(36, 39).trim();
                this.logger.debug((Object)"Atom charge code: ", chargeCodeString);
                int chargeCode = Integer.parseInt(chargeCodeString);
                if (chargeCode != 0) {
                    if (chargeCode == 1) {
                        atom.setFormalCharge(3);
                    } else if (chargeCode == 2) {
                        atom.setFormalCharge(2);
                    } else if (chargeCode == 3) {
                        atom.setFormalCharge(1);
                    } else if (chargeCode != 4) {
                        if (chargeCode == 5) {
                            atom.setFormalCharge(-1);
                        } else if (chargeCode == 6) {
                            atom.setFormalCharge(-2);
                        } else if (chargeCode == 7) {
                            atom.setFormalCharge(-3);
                        }
                    }
                }
                try {
                    String reactionAtomIDString = line.substring(60, 63).trim();
                    this.logger.debug((Object)"Parsing mapping id: ", reactionAtomIDString);
                    try {
                        int reactionAtomID = Integer.parseInt(reactionAtomIDString);
                        if (reactionAtomID != 0) {
                            atom.setID(reactionAtomIDString);
                        }
                    }
                    catch (Exception exception) {
                        this.logger.error("Mapping number ", reactionAtomIDString, " is not an integer.");
                        this.logger.debug(exception);
                    }
                }
                catch (Exception exception) {
                    this.logger.warn("A few fields are missing. Older MDL MOL file?");
                }
                molecule.addAtom(atom);
            }
            if (totalZ == 0.0 && !this.forceReadAs3DCoords.isSet()) {
                this.logger.info("Total 3D Z is 0.0, interpreting it as a 2D structure");
                Atom[] atomsToUpdate = molecule.getAtoms();
                for (int f2 = 0; f2 < atomsToUpdate.length; ++f2) {
                    Atom atomToUpdate = atomsToUpdate[f2];
                    Point3d p3d = atomToUpdate.getPoint3d();
                    atomToUpdate.setPoint2d(new Point2d(p3d.x, p3d.y));
                    atomToUpdate.setPoint3d(null);
                }
            }
            this.logger.info("Reading bond block");
            for (f = 0; f < bonds; ++f) {
                Bond bond;
                line = this.input.readLine();
                ++linecount;
                atom1 = Integer.valueOf(line.substring(0, 3).trim());
                atom2 = Integer.valueOf(line.substring(3, 6).trim());
                order = Integer.valueOf(line.substring(6, 9).trim());
                stereo = Integer.valueOf(line.substring(9, 12).trim());
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Bond: " + atom1 + " - " + atom2 + "; order " + order);
                }
                if (stereo == 1) {
                    stereo = 1;
                } else if (stereo == 6) {
                    stereo = -1;
                } else if (stereo == 4) {
                    stereo = 4;
                }
                Atom a1 = molecule.getAtomAt(atom1 - 1);
                Atom a2 = molecule.getAtomAt(atom2 - 1);
                if (order == 4) {
                    bond = molecule.getBuilder().newBond(a1, a2, 1.5, stereo);
                    bond.setFlag(4, true);
                    a1.setFlag(4, true);
                    a2.setFlag(4, true);
                    molecule.addBond(bond);
                    continue;
                }
                bond = molecule.getBuilder().newBond(a1, a2, order, stereo);
                molecule.addBond(bond);
            }
            this.logger.info("Reading property block");
            while (true) {
                line = this.input.readLine();
                ++linecount;
                if (line == null) {
                    throw new CDKException("The expected property block is missing!");
                }
                if (line.startsWith("M  END")) break;
                boolean lineRead = false;
                if (line.startsWith("M  CHG")) {
                    int infoCount = Integer.parseInt(line.substring(6, 9).trim());
                    StringTokenizer st = new StringTokenizer(line.substring(9));
                    for (int i = 1; i <= infoCount; ++i) {
                        String token = st.nextToken();
                        int atomNumber = Integer.parseInt(token.trim());
                        token = st.nextToken();
                        int charge = Integer.parseInt(token.trim());
                        molecule.getAtomAt(atomNumber - 1).setFormalCharge(charge);
                    }
                } else {
                    if (line.startsWith("M  ISO")) {
                        try {
                            String countString = line.substring(6, 9).trim();
                            int infoCount = Integer.parseInt(countString);
                            StringTokenizer st = new StringTokenizer(line.substring(9));
                            for (int i = 1; i <= infoCount; ++i) {
                                int atomNumber = Integer.parseInt(st.nextToken().trim());
                                int absMass = Integer.parseInt(st.nextToken().trim());
                                if (absMass == 0) continue;
                                Atom isotope = molecule.getAtomAt(atomNumber - 1);
                                isotope.setMassNumber(absMass);
                            }
                        }
                        catch (NumberFormatException exception) {
                            String error = "Error (" + exception.getMessage() + ") while parsing line " + linecount + ": " + line + " in property block.";
                            this.logger.error(error);
                            throw new CDKException("NumberFormatException in isotope information on line: " + line);
                        }
                    }
                    if (line.startsWith("M  RAD")) {
                        try {
                            String countString = line.substring(6, 9).trim();
                            int infoCount = Integer.parseInt(countString);
                            StringTokenizer st = new StringTokenizer(line.substring(9));
                            for (int i = 1; i <= infoCount; ++i) {
                                int atomNumber = Integer.parseInt(st.nextToken().trim());
                                int spinMultiplicity = Integer.parseInt(st.nextToken().trim());
                                if (spinMultiplicity <= 1) continue;
                                Atom radical = molecule.getAtomAt(atomNumber - 1);
                                for (int j = 2; j <= spinMultiplicity; ++j) {
                                    molecule.addElectronContainer(molecule.getBuilder().newSingleElectron(radical));
                                }
                            }
                        }
                        catch (NumberFormatException exception) {
                            String error = "Error (" + exception.getMessage() + ") while parsing line " + linecount + ": " + line + " in property block.";
                            this.logger.error(error);
                            throw new CDKException("NumberFormatException in radical information on line: " + line);
                        }
                    }
                    if (line.startsWith("G  ")) {
                        try {
                            String atomNumberString = line.substring(3, 6).trim();
                            int atomNumber = Integer.parseInt(atomNumberString);
                            String whatIsThisString = line.substring(6, 9).trim();
                            String atomName = this.input.readLine();
                            Atom prevAtom = molecule.getAtomAt(atomNumber - 1);
                            PseudoAtom pseudoAtom = new PseudoAtom(atomName);
                            if (prevAtom.getPoint2d() != null) {
                                pseudoAtom.setPoint2d(prevAtom.getPoint2d());
                            }
                            if (prevAtom.getPoint3d() != null) {
                                pseudoAtom.setPoint3d(prevAtom.getPoint3d());
                            }
                            AtomContainerManipulator.replaceAtomByAtom((AtomContainer)molecule, (Atom)prevAtom, (Atom)pseudoAtom);
                        }
                        catch (NumberFormatException exception) {
                            String error = "Error (" + exception.toString() + ") while parsing line " + linecount + ": " + line + " in property block.";
                            this.logger.error(error);
                            throw new CDKException("NumberFormatException in group information on line: " + line);
                        }
                    }
                }
                if (lineRead) continue;
                this.logger.warn((Object)"Skipping line in property block: ", line);
            }
        }
        catch (CDKException exception) {
            String error = "Error while parsing line " + linecount + ": " + line + " in property block: " + exception.getMessage();
            throw exception;
        }
        catch (Exception exception) {
            String error = "Error while parsing line " + linecount + ": " + line + " in property block: " + exception.getMessage();
            this.logger.error(error);
            this.logger.debug(exception);
            throw new CDKException(error);
        }
        return molecule;
    }

    public void close() throws IOException {
        this.input.close();
    }

    private void initIOSettings() {
        this.forceReadAs3DCoords = new BooleanIOSetting("ForceReadAs3DCoordinates", 2, "Should coordinates always be read as 3D?", "no");
    }

    private void customizeJob() {
        this.fireIOSettingQuestion(this.forceReadAs3DCoords);
    }

    public IOSetting[] getIOSettings() {
        IOSetting[] settings = new IOSetting[]{this.forceReadAs3DCoords};
        return settings;
    }
}

