/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.StringTokenizer;
import javax.vecmath.Point3d;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.config.IsotopeFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.Atom;
import org.openscience.cdk.interfaces.ChemModel;
import org.openscience.cdk.interfaces.ChemObject;
import org.openscience.cdk.interfaces.SetOfMolecules;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.formats.ChemFormat;
import org.openscience.cdk.io.formats.GhemicalMMFormat;
import org.openscience.cdk.tools.LoggingTool;

public class GhemicalMMReader
extends DefaultChemObjectReader {
    private LoggingTool logger = new LoggingTool(this);
    private BufferedReader input = null;

    public GhemicalMMReader(Reader input) {
        this.input = new BufferedReader(input);
    }

    public GhemicalMMReader(InputStream input) {
        this(new InputStreamReader(input));
    }

    public GhemicalMMReader() {
        this(new StringReader(""));
    }

    public ChemFormat getFormat() {
        return new GhemicalMMFormat();
    }

    public boolean accepts(ChemObject object) {
        return object instanceof ChemModel;
    }

    public void setReader(Reader input) throws CDKException {
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
    }

    public void setReader(InputStream input) throws CDKException {
        this.setReader(new InputStreamReader(input));
    }

    public void close() {
    }

    public ChemObject read(ChemObject object) throws CDKException {
        if (object instanceof ChemModel) {
            return this.readChemModel((ChemModel)object);
        }
        throw new CDKException("Only supported is ChemModel.");
    }

    private ChemModel readChemModel(ChemModel model) throws CDKException {
        int[] atoms = new int[1];
        double[] atomxs = new double[1];
        double[] atomys = new double[1];
        double[] atomzs = new double[1];
        double[] atomcharges = new double[1];
        int[] bondatomid1 = new int[1];
        int[] bondatomid2 = new int[1];
        int[] bondorder = new int[1];
        int numberOfAtoms = 0;
        int numberOfBonds = 0;
        try {
            String line = this.input.readLine();
            while (line != null) {
                int atomID;
                StringTokenizer atomInfoFields;
                StringTokenizer st = new StringTokenizer(line);
                String command = st.nextToken();
                if ("!Header".equals(command)) {
                    this.logger.warn("Ignoring header");
                } else if ("!Info".equals(command)) {
                    this.logger.warn("Ignoring info");
                } else if ("!Atoms".equals(command)) {
                    this.logger.info("Reading atom block");
                    try {
                        numberOfAtoms = Integer.parseInt(st.nextToken());
                        this.logger.debug("  #atoms: " + numberOfAtoms);
                        atoms = new int[numberOfAtoms];
                        atomxs = new double[numberOfAtoms];
                        atomys = new double[numberOfAtoms];
                        atomzs = new double[numberOfAtoms];
                        atomcharges = new double[numberOfAtoms];
                        for (int i = 0; i < numberOfAtoms; ++i) {
                            line = this.input.readLine();
                            atomInfoFields = new StringTokenizer(line);
                            atomID = Integer.parseInt(atomInfoFields.nextToken());
                            atoms[atomID] = Integer.parseInt(atomInfoFields.nextToken());
                            this.logger.debug("Set atomic number of atom (" + atomID + ") to: " + atoms[atomID]);
                        }
                    }
                    catch (Exception exception) {
                        this.logger.error("Error while reading Atoms block");
                        this.logger.debug(exception);
                    }
                } else if ("!Bonds".equals(command)) {
                    this.logger.info("Reading bond block");
                    try {
                        numberOfBonds = Integer.parseInt(st.nextToken());
                        bondatomid1 = new int[numberOfAtoms];
                        bondatomid2 = new int[numberOfAtoms];
                        bondorder = new int[numberOfAtoms];
                        for (int i = 0; i < numberOfBonds; ++i) {
                            line = this.input.readLine();
                            StringTokenizer bondInfoFields = new StringTokenizer(line);
                            bondatomid1[i] = Integer.parseInt(bondInfoFields.nextToken());
                            bondatomid2[i] = Integer.parseInt(bondInfoFields.nextToken());
                            String order = bondInfoFields.nextToken();
                            if ("D".equals(order)) {
                                bondorder[i] = 2;
                                continue;
                            }
                            if ("S".equals(order)) {
                                bondorder[i] = 1;
                                continue;
                            }
                            if ("T".equals(order)) {
                                bondorder[i] = 3;
                                continue;
                            }
                            this.logger.warn("Unrecognized bond order, using single bond instead. Found: " + order);
                            bondorder[i] = 1;
                        }
                    }
                    catch (Exception exception) {
                        this.logger.error("Error while reading Bonds block");
                        this.logger.debug(exception);
                    }
                } else if ("!Coord".equals(command)) {
                    this.logger.info("Reading coordinate block");
                    try {
                        for (int i = 0; i < numberOfAtoms; ++i) {
                            line = this.input.readLine();
                            atomInfoFields = new StringTokenizer(line);
                            atomID = Integer.parseInt(atomInfoFields.nextToken());
                            double x = Double.valueOf(atomInfoFields.nextToken());
                            double y = Double.valueOf(atomInfoFields.nextToken());
                            double z = Double.valueOf(atomInfoFields.nextToken());
                            atomxs[atomID] = x;
                            atomys[atomID] = y;
                            atomzs[atomID] = z;
                        }
                    }
                    catch (Exception exception) {
                        this.logger.error("Error while reading Coord block");
                        this.logger.debug(exception);
                    }
                } else if ("!Charges".equals(command)) {
                    this.logger.info("Reading charges block");
                    try {
                        for (int i = 0; i < numberOfAtoms; ++i) {
                            double charge;
                            line = this.input.readLine();
                            atomInfoFields = new StringTokenizer(line);
                            atomID = Integer.parseInt(atomInfoFields.nextToken());
                            atomcharges[atomID] = charge = Double.valueOf(atomInfoFields.nextToken()).doubleValue();
                        }
                    }
                    catch (Exception exception) {
                        this.logger.error("Error while reading Charges block");
                        this.logger.debug(exception);
                    }
                } else {
                    if ("!End".equals(command)) {
                        int i;
                        this.logger.info("Found end of file");
                        AtomContainer container = new AtomContainer();
                        for (i = 0; i < numberOfAtoms; ++i) {
                            try {
                                Atom atom = model.getBuilder().newAtom(IsotopeFactory.getInstance().getElementSymbol(atoms[i]));
                                atom.setAtomicNumber(atoms[i]);
                                atom.setPoint3d(new Point3d(atomxs[i], atomys[i], atomzs[i]));
                                atom.setCharge(atomcharges[i]);
                                container.addAtom(atom);
                                this.logger.debug("Stored atom: " + atom);
                                continue;
                            }
                            catch (Exception exception) {
                                this.logger.error("Cannot create an atom with atomic number: " + atoms[i]);
                                this.logger.debug(exception);
                            }
                        }
                        for (i = 0; i < numberOfBonds; ++i) {
                            container.addBond(bondatomid1[i], bondatomid2[i], bondorder[i]);
                        }
                        SetOfMolecules moleculeSet = model.getBuilder().newSetOfMolecules();
                        moleculeSet.addMolecule(model.getBuilder().newMolecule(container));
                        model.setSetOfMolecules(moleculeSet);
                        return model;
                    }
                    this.logger.warn("Skipping line: " + line);
                }
                line = this.input.readLine();
            }
        }
        catch (Exception exception) {
            this.logger.error("Error while reading file");
            this.logger.debug(exception);
        }
        return null;
    }
}

