/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.geometry.CrystalGeometryTools;
import org.openscience.cdk.interfaces.Atom;
import org.openscience.cdk.interfaces.ChemFile;
import org.openscience.cdk.interfaces.ChemModel;
import org.openscience.cdk.interfaces.ChemObject;
import org.openscience.cdk.interfaces.ChemSequence;
import org.openscience.cdk.interfaces.Crystal;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.formats.ChemFormat;
import org.openscience.cdk.io.formats.CrystClustFormat;
import org.openscience.cdk.math.FortranFormat;
import org.openscience.cdk.tools.LoggingTool;

public class CrystClustReader
extends DefaultChemObjectReader {
    private BufferedReader input;
    private LoggingTool logger = new LoggingTool(this);

    public CrystClustReader() {
    }

    public CrystClustReader(Reader input) {
        this();
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
    }

    public CrystClustReader(InputStream input) {
        this(new InputStreamReader(input));
    }

    public ChemFormat getFormat() {
        return new CrystClustFormat();
    }

    public void setReader(Reader reader) throws CDKException {
        this.input = this.input instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public void setReader(InputStream input) throws CDKException {
        this.setReader(new InputStreamReader(input));
    }

    public ChemObject read(ChemObject object) throws CDKException {
        if (object instanceof ChemFile) {
            ChemFile cf = this.readChemFile((ChemFile)object);
            return cf;
        }
        throw new CDKException("Only supported is reading of ChemFile.");
    }

    private ChemFile readChemFile(ChemFile file) throws CDKException {
        ChemSequence seq = file.getBuilder().newChemSequence();
        ChemModel model = file.getBuilder().newChemModel();
        Crystal crystal = null;
        int lineNumber = 0;
        try {
            String line = this.input.readLine();
            while (this.input.ready() && line != null) {
                this.logger.debug((Object)(lineNumber++ + ": "), line);
                if (line.startsWith("frame:")) {
                    this.logger.debug("found new frame");
                    model = file.getBuilder().newChemModel();
                    crystal = file.getBuilder().newCrystal();
                    this.logger.debug("reading spacegroup");
                    line = this.input.readLine();
                    this.logger.debug((Object)(lineNumber++ + ": "), line);
                    crystal.setSpaceGroup(line);
                    this.logger.debug("reading unit cell axes");
                    Vector3d axis = new Vector3d();
                    this.logger.debug("parsing A: ");
                    line = this.input.readLine();
                    this.logger.debug((Object)(lineNumber++ + ": "), line);
                    axis.x = FortranFormat.atof(line);
                    line = this.input.readLine();
                    this.logger.debug((Object)(lineNumber++ + ": "), line);
                    axis.y = FortranFormat.atof(line);
                    line = this.input.readLine();
                    this.logger.debug((Object)(lineNumber++ + ": "), line);
                    axis.z = FortranFormat.atof(line);
                    crystal.setA(axis);
                    axis = new Vector3d();
                    this.logger.debug("parsing B: ");
                    line = this.input.readLine();
                    this.logger.debug((Object)(lineNumber++ + ": "), line);
                    axis.x = FortranFormat.atof(line);
                    line = this.input.readLine();
                    this.logger.debug((Object)(lineNumber++ + ": "), line);
                    axis.y = FortranFormat.atof(line);
                    line = this.input.readLine();
                    this.logger.debug((Object)(lineNumber++ + ": "), line);
                    axis.z = FortranFormat.atof(line);
                    crystal.setB(axis);
                    axis = new Vector3d();
                    this.logger.debug("parsing C: ");
                    line = this.input.readLine();
                    this.logger.debug((Object)(lineNumber++ + ": "), line);
                    axis.x = FortranFormat.atof(line);
                    line = this.input.readLine();
                    this.logger.debug((Object)(lineNumber++ + ": "), line);
                    axis.y = FortranFormat.atof(line);
                    line = this.input.readLine();
                    this.logger.debug((Object)(lineNumber++ + ": "), line);
                    axis.z = FortranFormat.atof(line);
                    crystal.setC(axis);
                    this.logger.debug((Object)"Crystal: ", crystal);
                    Vector3d a = crystal.getA();
                    Vector3d b = crystal.getB();
                    Vector3d c = crystal.getC();
                    this.logger.debug("Reading number of atoms");
                    line = this.input.readLine();
                    this.logger.debug((Object)(lineNumber++ + ": "), line);
                    int atomsToRead = Integer.parseInt(line);
                    this.logger.debug("Reading no molecules in assym unit cell");
                    line = this.input.readLine();
                    this.logger.debug((Object)(lineNumber++ + ": "), line);
                    int Z = Integer.parseInt(line);
                    crystal.setZ(Z);
                    for (int i = 1; i <= atomsToRead; ++i) {
                        Point3d cart = new Point3d();
                        line = this.input.readLine();
                        this.logger.debug((Object)(lineNumber++ + ": "), line);
                        String symbol = line.substring(0, line.indexOf(":"));
                        double charge = Double.parseDouble(line.substring(line.indexOf(":") + 1));
                        line = this.input.readLine();
                        this.logger.debug((Object)(lineNumber++ + ": "), line);
                        cart.x = Double.parseDouble(line);
                        line = this.input.readLine();
                        this.logger.debug((Object)(lineNumber++ + ": "), line);
                        cart.y = Double.parseDouble(line);
                        line = this.input.readLine();
                        this.logger.debug((Object)(lineNumber++ + ": "), line);
                        cart.z = Double.parseDouble(line);
                        Atom atom = file.getBuilder().newAtom(symbol);
                        atom.setCharge(charge);
                        Point3d frac = CrystalGeometryTools.cartesianToFractional(a, b, c, cart);
                        atom.setFractionalPoint3d(frac);
                        crystal.addAtom(atom);
                        this.logger.debug((Object)"Added atom: ", atom);
                    }
                    model.setCrystal(crystal);
                    seq.addChemModel(model);
                    continue;
                }
                this.logger.debug("Format seems broken. Skipping these lines:");
                while (!line.startsWith("frame:") && this.input.ready() && line != null) {
                    line = this.input.readLine();
                    this.logger.debug((Object)(lineNumber++ + ": "), line);
                }
                this.logger.debug("Ok, resynched: found new frame");
            }
            file.addChemSequence(seq);
        }
        catch (Exception exception) {
            String message = "Error while parsing CrystClust file: " + exception.getMessage();
            this.logger.error(message);
            this.logger.debug(exception);
            throw new CDKException(message);
        }
        return file;
    }

    public void close() throws IOException {
        this.input.close();
    }
}

