/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.ChemFile;
import org.openscience.cdk.interfaces.ChemObject;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.cml.CMLErrorHandler;
import org.openscience.cdk.io.cml.CMLHandler;
import org.openscience.cdk.io.cml.CMLResolver;
import org.openscience.cdk.io.cml.ChemFileCDO;
import org.openscience.cdk.io.formats.CMLFormat;
import org.openscience.cdk.io.formats.ChemFormat;
import org.openscience.cdk.tools.LoggingTool;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class CMLReader
extends DefaultChemObjectReader {
    private XMLReader parser;
    private Reader input;
    private String url;
    private LoggingTool logger;

    public CMLReader(Reader input) {
        this.init();
        this.input = input;
    }

    public CMLReader(InputStream input) {
        this(new InputStreamReader(input));
    }

    public CMLReader() {
        this(new StringReader(""));
    }

    public CMLReader(String url) {
        this.init();
        this.url = url;
    }

    public ChemFormat getFormat() {
        return new CMLFormat();
    }

    public void setReader(Reader reader) throws CDKException {
        this.input = reader;
    }

    public void setReader(InputStream input) throws CDKException {
        this.setReader(new InputStreamReader(input));
    }

    private void init() {
        this.logger = new LoggingTool(this);
        this.url = "";
        boolean success = false;
        if (!success) {
            try {
                SAXParserFactory spf = SAXParserFactory.newInstance();
                spf.setNamespaceAware(true);
                SAXParser saxParser = spf.newSAXParser();
                this.parser = saxParser.getXMLReader();
                this.logger.info("Using JAXP/SAX XML parser.");
                success = true;
            }
            catch (Exception e) {
                this.logger.warn((Object)"Could not instantiate JAXP/SAX XML reader: ", e.getMessage());
                this.logger.debug(e);
            }
        }
        if (!success) {
            try {
                this.parser = (XMLReader)this.getClass().getClassLoader().loadClass("gnu.xml.aelfred2.XmlReader").newInstance();
                this.logger.info("Using Aelfred2 XML parser.");
                success = true;
            }
            catch (Exception e) {
                this.logger.warn("Could not instantiate Aelfred2 XML reader!");
                this.logger.debug(e);
            }
        }
        if (!success) {
            try {
                this.parser = (XMLReader)this.getClass().getClassLoader().loadClass("org.apache.xerces.parsers.SAXParser").newInstance();
                this.logger.info("Using Xerces XML parser.");
                success = true;
            }
            catch (Exception e) {
                this.logger.warn("Could not instantiate Xerces XML reader!");
                this.logger.debug(e);
            }
        }
        if (!success) {
            this.logger.error("Could not instantiate any XML parser!");
        }
    }

    public ChemObject read(ChemObject object) throws CDKException {
        if (object instanceof ChemFile) {
            return this.readChemFile();
        }
        throw new CDKException("Only supported is reading of ChemFile objects.");
    }

    private ChemFile readChemFile() throws CDKException {
        this.logger.debug("Started parsing from input...");
        ChemFileCDO cdo = new ChemFileCDO();
        try {
            this.parser.setFeature("http://xml.org/sax/features/validation", false);
            this.logger.info("Deactivated validation");
        }
        catch (SAXException e) {
            this.logger.warn("Cannot deactivate validation.");
            return cdo;
        }
        this.parser.setContentHandler(new CMLHandler(cdo));
        this.parser.setEntityResolver(new CMLResolver());
        this.parser.setErrorHandler(new CMLErrorHandler());
        try {
            if (this.input == null) {
                this.logger.debug((Object)"Parsing from URL: ", this.url);
                this.parser.parse(this.url);
            } else {
                this.logger.debug("Parsing from Reader");
                this.parser.parse(new InputSource(this.input));
            }
        }
        catch (IOException e) {
            String error = "Error while reading file: " + e.getMessage();
            this.logger.error(error);
            this.logger.debug(e);
            throw new CDKException(error);
        }
        catch (SAXParseException saxe) {
            SAXParseException spe = saxe;
            String error = "Found well-formedness error in line " + spe.getLineNumber();
            this.logger.error(error);
            this.logger.debug(saxe);
            throw new CDKException(error);
        }
        catch (SAXException saxe) {
            String error = "Error while parsing XML: " + saxe.getMessage();
            this.logger.error(error);
            this.logger.debug(saxe);
            throw new CDKException(error);
        }
        return cdo;
    }

    public void close() throws IOException {
        this.input.close();
    }

    public boolean accepts(ChemObject object) {
        return object instanceof ChemFile;
    }
}

