/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.geometry;

import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.openscience.cdk.interfaces.Atom;
import org.openscience.cdk.interfaces.AtomContainer;
import org.openscience.cdk.interfaces.Crystal;

public class CrystalGeometryTools {
    public static Vector3d[] calcInvertedAxes(Vector3d aAxis, Vector3d bAxis, Vector3d cAxis) {
        double det = aAxis.x * bAxis.y * cAxis.z - aAxis.x * bAxis.z * cAxis.y - aAxis.y * bAxis.x * cAxis.z + aAxis.y * bAxis.z * cAxis.x + aAxis.z * bAxis.x * cAxis.y - aAxis.z * bAxis.y * cAxis.x;
        Vector3d[] invaxes = new Vector3d[3];
        invaxes[0] = new Vector3d();
        invaxes[0].x = (bAxis.y * cAxis.z - bAxis.z * cAxis.y) / det;
        invaxes[0].y = (bAxis.z * cAxis.x - bAxis.x * cAxis.z) / det;
        invaxes[0].z = (bAxis.x * cAxis.y - bAxis.y * cAxis.x) / det;
        invaxes[1] = new Vector3d();
        invaxes[1].x = (aAxis.z * cAxis.y - aAxis.y * cAxis.z) / det;
        invaxes[1].y = (aAxis.x * cAxis.z - aAxis.z * cAxis.x) / det;
        invaxes[1].z = (aAxis.y * cAxis.x - aAxis.x * cAxis.y) / det;
        invaxes[2] = new Vector3d();
        invaxes[2].x = (aAxis.y * bAxis.z - aAxis.z * bAxis.y) / det;
        invaxes[2].y = (aAxis.z * bAxis.x - aAxis.x * bAxis.z) / det;
        invaxes[2].z = (aAxis.x * bAxis.y - aAxis.y * bAxis.x) / det;
        return invaxes;
    }

    public static double[] cartesianToFractional(double[] aAxis, double[] bAxis, double[] cAxis, double[] cart) {
        double[] fractCoords = new double[3];
        Point3d fract = CrystalGeometryTools.cartesianToFractional(new Vector3d(aAxis[0], aAxis[1], aAxis[2]), new Vector3d(bAxis[0], bAxis[1], bAxis[2]), new Vector3d(cAxis[0], cAxis[1], cAxis[2]), new Point3d(cart[0], cart[1], cart[2]));
        fractCoords[0] = fract.x;
        fractCoords[1] = fract.y;
        fractCoords[2] = fract.z;
        return fractCoords;
    }

    public static Point3d cartesianToFractional(Vector3d aAxis, Vector3d bAxis, Vector3d cAxis, Point3d cartPoint) {
        Vector3d[] invaxis = CrystalGeometryTools.calcInvertedAxes(aAxis, bAxis, cAxis);
        Point3d frac = new Point3d();
        frac.x = invaxis[0].x * cartPoint.x + invaxis[0].y * cartPoint.y + invaxis[0].z * cartPoint.z;
        frac.y = invaxis[1].x * cartPoint.x + invaxis[1].y * cartPoint.y + invaxis[1].z * cartPoint.z;
        frac.z = invaxis[2].x * cartPoint.x + invaxis[2].y * cartPoint.y + invaxis[2].z * cartPoint.z;
        return frac;
    }

    public static double[] fractionalToCartesian(double[] aAxis, double[] bAxis, double[] cAxis, double[] frac) {
        double[] cart = new double[]{frac[0] * aAxis[0] + frac[1] * bAxis[0] + frac[2] * cAxis[0], frac[0] * aAxis[1] + frac[1] * bAxis[1] + frac[2] * cAxis[1], frac[0] * aAxis[2] + frac[1] * bAxis[2] + frac[2] * cAxis[2]};
        return cart;
    }

    public static Point3d fractionalToCartesian(Vector3d aAxis, Vector3d bAxis, Vector3d cAxis, Point3d frac) {
        Point3d cart = new Point3d();
        cart.x = frac.x * aAxis.x + frac.y * bAxis.x + frac.z * cAxis.x;
        cart.y = frac.x * aAxis.y + frac.y * bAxis.y + frac.z * cAxis.y;
        cart.z = frac.x * aAxis.z + frac.y * bAxis.z + frac.z * cAxis.z;
        return cart;
    }

    public static Point3d fractionalToCartesian(double[] aAxis, double[] bAxis, double[] cAxis, Point3d fracPoint) {
        double[] frac = new double[]{fracPoint.x, fracPoint.y, fracPoint.z};
        double[] cart = CrystalGeometryTools.fractionalToCartesian(aAxis, bAxis, cAxis, frac);
        return new Point3d(cart[0], cart[1], cart[2]);
    }

    public static Vector3d[] notionalToCartesian(double alength, double blength, double clength, double alpha, double beta, double gamma) {
        Vector3d[] axes = new Vector3d[3];
        axes[0] = new Vector3d();
        axes[0].x = alength;
        axes[0].y = 0.0;
        axes[0].z = 0.0;
        double toRadians = Math.PI / 180;
        double cosalpha = Math.cos(toRadians * alpha);
        double cosbeta = Math.cos(toRadians * beta);
        double cosgamma = Math.cos(toRadians * gamma);
        double singamma = Math.sin(toRadians * gamma);
        axes[1] = new Vector3d();
        axes[1].x = blength * cosgamma;
        axes[1].y = blength * singamma;
        axes[1].z = 0.0;
        axes[2] = new Vector3d();
        double volume = alength * blength * clength * Math.sqrt(1.0 - cosalpha * cosalpha - cosbeta * cosbeta - cosgamma * cosgamma + 2.0 * cosalpha * cosbeta * cosgamma);
        axes[2].x = clength * cosbeta;
        axes[2].y = clength * (cosalpha - cosbeta * cosgamma) / singamma;
        axes[2].z = volume / (alength * blength * singamma);
        return axes;
    }

    public static double[] cartesianToNotional(Vector3d aAxis, Vector3d bAxis, Vector3d cAxis) {
        double[] notionalCoords = new double[]{aAxis.length(), bAxis.length(), cAxis.length(), bAxis.angle(cAxis) * 180.0 / Math.PI, aAxis.angle(cAxis) * 180.0 / Math.PI, aAxis.angle(bAxis) * 180.0 / Math.PI};
        return notionalCoords;
    }

    public static boolean hasCrystalCoordinates(AtomContainer container) {
        Atom[] atoms = container.getAtoms();
        for (int i = 0; i < atoms.length; ++i) {
            if (atoms[i].getFractionalPoint3d() != null) continue;
            return false;
        }
        return true;
    }

    public static void fractionalToCartesian(Crystal crystal) {
        Atom[] atoms = crystal.getAtoms();
        Vector3d aAxis = crystal.getA();
        Vector3d bAxis = crystal.getB();
        Vector3d cAxis = crystal.getC();
        for (int i = 0; i < atoms.length; ++i) {
            Point3d fracPoint = atoms[i].getFractionalPoint3d();
            if (fracPoint == null) continue;
            atoms[i].setPoint3d(CrystalGeometryTools.fractionalToCartesian(aAxis, bAxis, cAxis, fracPoint));
        }
    }
}

