/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.geometry;

import java.util.TreeMap;
import java.util.Vector;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.invariant.MorganNumbersTools;
import org.openscience.cdk.interfaces.Atom;
import org.openscience.cdk.interfaces.AtomContainer;
import org.openscience.cdk.interfaces.Bond;

public class BondTools {
    public static boolean isValidDoubleBondConfiguration(AtomContainer container, Bond bond) {
        Atom[] atoms = bond.getAtoms();
        Atom[] connectedAtoms = container.getConnectedAtoms(atoms[0]);
        Atom from = null;
        for (int i = 0; i < connectedAtoms.length; ++i) {
            if (connectedAtoms[i] == atoms[1]) continue;
            from = connectedAtoms[i];
        }
        boolean[] array = new boolean[container.getBonds().length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = true;
        }
        return BondTools.isStartOfDoubleBond(container, atoms[0], from, array) && BondTools.isEndOfDoubleBond(container, atoms[1], atoms[0], array) && !bond.getFlag(4);
    }

    public static boolean isCisTrans(Atom firstOuterAtom, Atom firstInnerAtom, Atom secondInnerAtom, Atom secondOuterAtom, AtomContainer ac) throws CDKException {
        boolean secondDirection;
        if (!BondTools.isValidDoubleBondConfiguration(ac, ac.getBond(firstInnerAtom, secondInnerAtom))) {
            throw new CDKException("There is no valid double bond configuration between your inner atoms!");
        }
        boolean firstDirection = BondTools.isLeft(firstOuterAtom, firstInnerAtom, secondInnerAtom);
        return firstDirection == (secondDirection = BondTools.isLeft(secondOuterAtom, secondInnerAtom, firstInnerAtom));
    }

    public static boolean isLeft(Atom whereIs, Atom viewFrom, Atom viewTo) {
        double angle = BondTools.giveAngleBothMethods(viewFrom, viewTo, whereIs, false);
        return !(angle < 0.0);
    }

    public static boolean closeEnoughToBond(Atom atom1, Atom atom2, double distanceFudgeFactor) {
        double bondingDistance;
        double distanceBetweenAtoms;
        return atom1 != atom2 && (distanceBetweenAtoms = atom1.getPoint3d().distance(atom2.getPoint3d())) <= distanceFudgeFactor * (bondingDistance = atom1.getCovalentRadius() + atom2.getCovalentRadius());
    }

    public static double giveAngleBothMethods(Atom from, Atom to1, Atom to2, boolean bool) {
        double[] A = new double[2];
        from.getPoint2d().get(A);
        double[] B = new double[2];
        to1.getPoint2d().get(B);
        double[] C = new double[2];
        to2.getPoint2d().get(C);
        double angle1 = Math.atan2(B[1] - A[1], B[0] - A[0]);
        double angle2 = Math.atan2(C[1] - A[1], C[0] - A[0]);
        double angle = angle2 - angle1;
        if (angle2 < 0.0 && angle1 > 0.0 && angle2 < -1.5707963267948966) {
            angle = Math.PI + angle2 + Math.PI - angle1;
        }
        if (angle2 > 0.0 && angle1 < 0.0 && angle1 < -1.5707963267948966) {
            angle = -Math.PI + angle2 - Math.PI - angle1;
        }
        if (bool && angle < 0.0) {
            return Math.PI * 2 + angle;
        }
        return angle;
    }

    private static boolean isEndOfDoubleBond(AtomContainer container, Atom atom, Atom parent, boolean[] doubleBondConfiguration) {
        if (container.getBondNumber(atom, parent) == -1 || doubleBondConfiguration.length <= container.getBondNumber(atom, parent) || !doubleBondConfiguration[container.getBondNumber(atom, parent)]) {
            return false;
        }
        int lengthAtom = container.getConnectedAtoms(atom).length + atom.getHydrogenCount();
        int lengthParent = container.getConnectedAtoms(parent).length + parent.getHydrogenCount();
        if (container.getBond(atom, parent) != null && container.getBond(atom, parent).getOrder() == 2.0 && (lengthAtom == 3 || lengthAtom == 2 && atom.getSymbol().equals("N")) && (lengthParent == 3 || lengthParent == 2 && parent.getSymbol().equals("N"))) {
            Atom[] atoms = container.getConnectedAtoms(atom);
            Atom one = null;
            Atom two = null;
            for (int i = 0; i < atoms.length; ++i) {
                if (atoms[i] != parent && one == null) {
                    one = atoms[i];
                    continue;
                }
                if (atoms[i] == parent || one == null) continue;
                two = atoms[i];
            }
            String[] morgannumbers = MorganNumbersTools.getMorganNumbersWithElementSymbol((AtomContainer)container);
            return one != null && two == null && atom.getSymbol().equals("N") && Math.abs(BondTools.giveAngleBothMethods(parent, atom, one, true)) > 0.3141592653589793 || !atom.getSymbol().equals("N") && one != null && two != null && !morgannumbers[container.getAtomNumber(one)].equals(morgannumbers[container.getAtomNumber(two)]);
        }
        return false;
    }

    private static boolean isStartOfDoubleBond(AtomContainer container, Atom a, Atom parent, boolean[] doubleBondConfiguration) {
        int lengthAtom = container.getConnectedAtoms(a).length + a.getHydrogenCount();
        if (lengthAtom != 3 && lengthAtom != 2 && a.getSymbol() != "N") {
            return false;
        }
        Atom[] atoms = container.getConnectedAtoms(a);
        Atom one = null;
        Atom two = null;
        boolean doubleBond = false;
        Atom nextAtom = null;
        for (int i = 0; i < atoms.length; ++i) {
            if (atoms[i] != parent && container.getBond(atoms[i], a).getOrder() == 2.0 && BondTools.isEndOfDoubleBond(container, atoms[i], a, doubleBondConfiguration)) {
                doubleBond = true;
                nextAtom = atoms[i];
            }
            if (atoms[i] != nextAtom && one == null) {
                one = atoms[i];
                continue;
            }
            if (atoms[i] == nextAtom || one == null) continue;
            two = atoms[i];
        }
        String[] morgannumbers = MorganNumbersTools.getMorganNumbersWithElementSymbol((AtomContainer)container);
        return one != null && (!a.getSymbol().equals("N") && two != null && !morgannumbers[container.getAtomNumber(one)].equals(morgannumbers[container.getAtomNumber(two)]) && doubleBond && doubleBondConfiguration[container.getBondNumber(a, nextAtom)] || doubleBond && a.getSymbol().equals("N") && Math.abs(BondTools.giveAngleBothMethods(nextAtom, a, parent, true)) > 0.3141592653589793);
    }

    public static int isTetrahedral(AtomContainer container, Atom a, boolean strict) {
        Atom[] atoms = container.getConnectedAtoms(a);
        if (atoms.length != 4) {
            return 0;
        }
        Bond[] bonds = container.getConnectedBonds(a);
        int normal = 0;
        int up = 0;
        int down = 0;
        for (int i = 0; i < bonds.length; ++i) {
            if (bonds[i].getStereo() == 0 || bonds[i].getStereo() == 4) {
                ++normal;
            }
            if (bonds[i].getStereo() == 1) {
                ++up;
            }
            if (bonds[i].getStereo() != -1) continue;
            ++down;
        }
        if (up == 1 && down == 1) {
            return 1;
        }
        if (up == 2 && down == 2) {
            if (BondTools.stereosAreOpposite(container, a)) {
                return 2;
            }
            return 0;
        }
        if (up == 1 && down == 0 && !strict) {
            return 3;
        }
        if (down == 1 && up == 0 && !strict) {
            return 4;
        }
        if (down == 2 && up == 1 && !strict) {
            return 5;
        }
        if (down == 1 && up == 2 && !strict) {
            return 6;
        }
        return 0;
    }

    public static int isTrigonalBipyramidalOrOctahedral(AtomContainer container, Atom a) {
        Atom[] atoms = container.getConnectedAtoms(a);
        if (atoms.length < 5 || atoms.length > 6) {
            return 0;
        }
        Bond[] bonds = container.getConnectedBonds(a);
        int normal = 0;
        int up = 0;
        int down = 0;
        for (int i = 0; i < bonds.length; ++i) {
            if (bonds[i].getStereo() == 4 || bonds[i].getStereo() == 0) {
                ++normal;
            }
            if (bonds[i].getStereo() == 1) {
                ++up;
            }
            if (bonds[i].getStereo() != -1) continue;
            ++down;
        }
        if (up == 1 && down == 1) {
            if (atoms.length == 5) {
                return 1;
            }
            return 2;
        }
        return 0;
    }

    public static boolean isStereo(AtomContainer container, Atom a) {
        Atom[] atoms = container.getConnectedAtoms(a);
        if (atoms.length < 4 || atoms.length > 6) {
            return false;
        }
        Bond[] bonds = container.getConnectedBonds(a);
        int stereo = 0;
        for (int i = 0; i < bonds.length; ++i) {
            if (bonds[i].getStereo() == 0) continue;
            ++stereo;
        }
        if (stereo == 0) {
            return false;
        }
        int differentAtoms = 0;
        for (int i = 0; i < atoms.length; ++i) {
            boolean isDifferent = true;
            for (int k = 0; k < i; ++k) {
                if (!atoms[i].getSymbol().equals(atoms[k].getSymbol())) continue;
                isDifferent = false;
                break;
            }
            if (!isDifferent) continue;
            ++differentAtoms;
        }
        if (differentAtoms != atoms.length) {
            int[] morgannumbers = MorganNumbersTools.getMorganNumbers((AtomContainer)container);
            Vector<String> differentSymbols = new Vector<String>();
            for (int i = 0; i < atoms.length; ++i) {
                if (differentSymbols.contains(atoms[i].getSymbol())) continue;
                differentSymbols.add(atoms[i].getSymbol());
            }
            int[] onlyRelevantIfTwo = new int[2];
            if (differentSymbols.size() == 2) {
                for (int i = 0; i < atoms.length; ++i) {
                    if (differentSymbols.indexOf(atoms[i].getSymbol()) == 0) {
                        onlyRelevantIfTwo[0] = onlyRelevantIfTwo[0] + 1;
                        continue;
                    }
                    onlyRelevantIfTwo[1] = onlyRelevantIfTwo[1] + 1;
                }
            }
            boolean[] symbolsWithDifferentMorganNumbers = new boolean[differentSymbols.size()];
            Vector[] symbolsMorganNumbers = new Vector[differentSymbols.size()];
            for (int i = 0; i < symbolsWithDifferentMorganNumbers.length; ++i) {
                symbolsWithDifferentMorganNumbers[i] = true;
                symbolsMorganNumbers[i] = new Vector();
            }
            for (int k = 0; k < atoms.length; ++k) {
                int elementNumber = differentSymbols.indexOf(atoms[k].getSymbol());
                if (symbolsMorganNumbers[elementNumber].contains(new Integer(morgannumbers[container.getAtomNumber(atoms[k])]))) {
                    symbolsWithDifferentMorganNumbers[elementNumber] = false;
                    continue;
                }
                symbolsMorganNumbers[elementNumber].add(new Integer(morgannumbers[container.getAtomNumber(atoms[k])]));
            }
            int numberOfSymbolsWithDifferentMorganNumbers = 0;
            for (int i = 0; i < symbolsWithDifferentMorganNumbers.length; ++i) {
                if (!symbolsWithDifferentMorganNumbers[i]) continue;
                ++numberOfSymbolsWithDifferentMorganNumbers;
            }
            if (numberOfSymbolsWithDifferentMorganNumbers != differentSymbols.size()) {
                if ((atoms.length == 5 || atoms.length == 6) && (numberOfSymbolsWithDifferentMorganNumbers + differentAtoms > 2 || differentAtoms == 2 && onlyRelevantIfTwo[0] > 1 && onlyRelevantIfTwo[1] > 1)) {
                    return true;
                }
                return BondTools.isSquarePlanar(container, a) && (numberOfSymbolsWithDifferentMorganNumbers + differentAtoms > 2 || differentAtoms == 2 && onlyRelevantIfTwo[0] > 1 && onlyRelevantIfTwo[1] > 1);
            }
        }
        return true;
    }

    public static boolean isSquarePlanar(AtomContainer container, Atom a) {
        Atom[] atoms = container.getConnectedAtoms(a);
        if (atoms.length != 4) {
            return false;
        }
        Bond[] bonds = container.getConnectedBonds(a);
        int normal = 0;
        int up = 0;
        int down = 0;
        for (int i = 0; i < bonds.length; ++i) {
            if (bonds[i].getStereo() == 4 || bonds[i].getStereo() == 0) {
                ++normal;
            }
            if (bonds[i].getStereo() == 1) {
                ++up;
            }
            if (bonds[i].getStereo() != -1) continue;
            ++down;
        }
        return up == 2 && down == 2 && !BondTools.stereosAreOpposite(container, a);
    }

    public static boolean stereosAreOpposite(AtomContainer container, Atom a) {
        Vector atoms = container.getConnectedAtomsVector(a);
        TreeMap<Double, Integer> hm = new TreeMap<Double, Integer>();
        for (int i = 1; i < atoms.size(); ++i) {
            hm.put(new Double(BondTools.giveAngle(a, (Atom)atoms.get(0), (Atom)atoms.get(i))), new Integer(i));
        }
        Object[] ohere = hm.values().toArray();
        int stereoOne = container.getBond(a, (Atom)atoms.get(0)).getStereo();
        int stereoOpposite = container.getBond(a, (Atom)atoms.get((Integer)ohere[1])).getStereo();
        return stereoOpposite == stereoOne;
    }

    public static double giveAngle(Atom from, Atom to1, Atom to2) {
        return BondTools.giveAngleBothMethods(from, to1, to2, true);
    }

    public static double giveAngleFromMiddle(Atom from, Atom to1, Atom to2) {
        return BondTools.giveAngleBothMethods(from, to1, to2, false);
    }

    public static void makeUpDownBonds(AtomContainer container) {
        for (int i = 0; i < container.getAtomCount(); ++i) {
            Atom a = container.getAtomAt(i);
            if (container.getConnectedAtoms(a).length != 4) continue;
            int up = 0;
            int down = 0;
            int hs = 0;
            Atom h = null;
            for (int k = 0; k < 4; ++k) {
                if (container.getBond(a, container.getConnectedAtoms(a)[k]).getStereo() == 1) {
                    ++up;
                }
                if (container.getBond(a, container.getConnectedAtoms(a)[k]).getStereo() == -1) {
                    ++down;
                }
                if (container.getBond(a, container.getConnectedAtoms(a)[k]).getStereo() != 0 || !container.getConnectedAtoms(a)[k].getSymbol().equals("H")) continue;
                h = container.getConnectedAtoms(a)[k];
                ++hs;
            }
            if (up == 0 && down == 1 && h != null && hs == 1) {
                container.getBond(a, h).setStereo(1);
            }
            if (up != true || down != 0 || h == null || hs != true) continue;
            container.getBond(a, h).setStereo(-1);
        }
    }
}

