/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.config.isotopes;

import java.io.IOException;
import java.io.Reader;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.openscience.cdk.config.isotopes.IsotopeHandler;
import org.openscience.cdk.tools.LoggingTool;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class IsotopeReader {
    private XMLReader parser;
    private Reader input;
    private LoggingTool logger;

    public IsotopeReader(Reader input) {
        this.init();
        this.input = input;
    }

    private void init() {
        this.logger = new LoggingTool(this);
        boolean success = false;
        if (!success) {
            try {
                SAXParserFactory spf = SAXParserFactory.newInstance();
                spf.setNamespaceAware(true);
                SAXParser saxParser = spf.newSAXParser();
                this.parser = saxParser.getXMLReader();
                this.logger.info("Using JAXP/SAX XML parser.");
                success = true;
            }
            catch (Exception exception) {
                this.logger.warn("Could not instantiate JAXP/SAX XML reader!");
                this.logger.debug(exception);
            }
        }
        if (!success) {
            try {
                this.parser = (XMLReader)this.getClass().getClassLoader().loadClass("gnu.xml.aelfred2.XmlReader").newInstance();
                this.logger.info("Using Aelfred2 XML parser.");
                success = true;
            }
            catch (Exception e) {
                this.logger.warn("Could not instantiate Aelfred2 XML reader!");
                this.logger.debug(e);
            }
        }
        if (!success) {
            try {
                this.parser = (XMLReader)this.getClass().getClassLoader().loadClass("org.apache.xerces.parsers.SAXParser").newInstance();
                this.logger.info("Using Xerces XML parser.");
                success = true;
            }
            catch (Exception e) {
                this.logger.warn("Could not instantiate Xerces XML reader!");
                this.logger.debug(e);
            }
        }
        if (!success) {
            this.logger.error("Could not instantiate any XML parser!");
        }
    }

    public Vector readIsotopes() {
        Vector isotopes = new Vector();
        try {
            this.parser.setFeature("http://xml.org/sax/features/validation", false);
            this.logger.info("Deactivated validation");
        }
        catch (SAXException exception) {
            this.logger.warn((Object)"Cannot deactivate validation: ", exception.getMessage());
            this.logger.debug(exception);
        }
        IsotopeHandler handler = new IsotopeHandler();
        this.parser.setContentHandler(handler);
        try {
            this.parser.parse(new InputSource(this.input));
            isotopes = handler.getIsotopes();
        }
        catch (IOException exception) {
            this.logger.error((Object)"IOException: ", exception.getMessage());
            this.logger.debug(exception);
        }
        catch (SAXException saxe) {
            this.logger.error((Object)"SAXException: ", saxe.getClass().getName());
            this.logger.error(saxe.getMessage());
            this.logger.debug(saxe);
        }
        return isotopes;
    }
}

